/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.undo;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.Validation;
import io.keikai.ui.impl.undo.AbstractUndoableAction;
import java.util.List;

public class DataValidationAction
extends AbstractUndoableAction {
    private static final long serialVersionUID = -1030348652602783447L;
    private Validation.ValidationType _validationType;
    private Validation.OperatorType _operatorType;
    private boolean _ignoreBlank;
    private boolean _inCellDropDown;
    private String _param1;
    private String _param2;
    private boolean _isShowInput;
    private String _inputTitle;
    private String _inputMessage;
    private boolean _isShowError;
    private Validation.AlertStyle _alertStyle;
    private String _errorTitle;
    private String _errorMessage;
    private Validation.ValidationType _oldValidationType;
    private Validation.OperatorType _oldOperatorType;
    private boolean _oldIgnoreBlank;
    private boolean _oldInCellDropDown;
    private String _oldParam1;
    private String _oldParam2;
    private boolean _oldIsShowInput;
    private String _oldInputTitle;
    private String _oldInputMessage;
    private boolean _oldIsShowError;
    private Validation.AlertStyle _oldAlertStyle;
    private String _oldErrorTitle;
    private String _oldErrorMessage;
    private boolean _doFlag;
    private boolean _isNew;

    public DataValidationAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Validation.ValidationType validationType, boolean ignoreBlank, Validation.OperatorType operatorType, boolean inCellDropDown, String param1, String param2, boolean showInput, String inputTitle, String inputMessage, boolean showError, Validation.AlertStyle alertStyle, String errorTitle, String errorMessage) {
        super(label, sheet, row, column, lastRow, lastColumn);
        this._validationType = validationType;
        this._operatorType = operatorType;
        this._ignoreBlank = ignoreBlank;
        this._inCellDropDown = inCellDropDown;
        this._param1 = param1;
        this._param2 = param2;
        this._isShowInput = showInput;
        this._inputTitle = inputTitle;
        this._inputMessage = inputMessage;
        this._isShowError = showError;
        this._alertStyle = alertStyle;
        this._errorTitle = errorTitle;
        this._errorMessage = errorMessage;
    }

    public void doAction() {
        if (!this.isSheetProtected()) {
            Range r = Ranges.range((Sheet)this._sheet, (int)this._row, (int)this._column, (int)this._lastRow, (int)this._lastColumn);
            List validations = r.getValidations();
            if (validations.size() > 0) {
                Validation v = (Validation)validations.get(0);
                this._oldValidationType = v.getValidationType();
                this._oldOperatorType = v.getOperatorType();
                this._oldIgnoreBlank = v.isIgnoreBlank();
                this._oldInCellDropDown = v.isInCellDropdown();
                this._oldParam1 = v.getFormula1();
                this._oldParam2 = v.getFormula2();
                this._oldIsShowInput = v.isShowInput();
                this._oldInputTitle = v.getInputTitle();
                this._oldInputMessage = v.getInputMessage();
                this._oldIsShowError = v.isShowError();
                this._oldAlertStyle = v.getAlertStyle();
                this._oldErrorTitle = v.getErrorTitle();
                this._oldErrorMessage = v.getErrorMessage();
                this._isNew = false;
            } else {
                this._isNew = true;
            }
            r.setValidation(this._validationType, this._ignoreBlank, this._operatorType, this._inCellDropDown, this._param1, this._param2, this._isShowInput, this._inputTitle, this._inputMessage, this._isShowError, this._alertStyle, this._errorTitle, this._errorMessage);
            this._doFlag = true;
        }
    }

    public boolean isUndoable() {
        return this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    public boolean isRedoable() {
        return !this._doFlag && this.isSheetAvailable() && !this.isSheetProtected();
    }

    public void undoAction() {
        Range r = Ranges.range((Sheet)this._sheet, (int)this._row, (int)this._column, (int)this._lastRow, (int)this._lastColumn);
        if (this._isNew) {
            r.deleteValidation();
        } else {
            r.setValidation(this._oldValidationType, this._oldIgnoreBlank, this._oldOperatorType, this._oldInCellDropDown, this._oldParam1, this._oldParam2, this._oldIsShowInput, this._oldInputTitle, this._oldInputMessage, this._oldIsShowError, this._oldAlertStyle, this._oldErrorTitle, this._oldErrorMessage);
        }
        this._doFlag = false;
    }

    protected boolean isSheetProtected() {
        Range range = Ranges.range((Sheet)this._sheet);
        return super.isSheetProtected();
    }
}

