/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractBookHandler;
import io.keikaiex.ui.dialog.UnhideSheetCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class UnhideSheetHandler
extends AbstractBookHandler {
    private static final long serialVersionUID = 4133139451894267942L;

    public boolean isEnabled(Book book, Sheet sheet) {
        if (book == null) {
            return false;
        }
        int length = book.getNumberOfSheets();
        for (int i = 0; i < length; ++i) {
            if (!book.getSheetAt(i).isHidden()) continue;
            return true;
        }
        return false;
    }

    protected boolean processAction(final UserActionContext ctx) {
        Book book = ctx.getBook();
        int len = book.getNumberOfSheets();
        ArrayList<String> names = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            Sheet sheet = book.getSheetAt(i);
            if (!sheet.isHidden()) continue;
            names.add(sheet.getSheetName());
        }
        UnhideSheetCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = 8416857558958915359L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                List nameList;
                int size;
                Object data = event.getData();
                if (data != null && (size = (nameList = (List)data.get(UnhideSheetCtrl.ARG_SHEET_NAMES)).size()) > 0) {
                    for (String name : nameList) {
                        Ranges.range((Sheet)ctx.getBook().getSheet(name)).setSheetVisible(Range.SheetVisible.VISIBLE);
                    }
                    ctx.getSpreadsheet().setSelectedSheet((String)nameList.get(size - 1));
                }
            }
        }, names);
        return true;
    }
}

