/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.model.SSheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.CellFormatHelper;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.CellRichTextAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikaiex.ui.dialog.RichTextEditCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class RichTextEditHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = 4621843841374312965L;

    protected boolean processAction(final UserActionContext ctx) {
        int column;
        final Sheet sheet = ctx.getSheet();
        SSheet internalSheet = ctx.getSheet().getInternalSheet();
        AreaRef selection = ctx.getSelection();
        final int row = selection.getRow();
        Range range = Ranges.range((Sheet)sheet, (int)row, (int)(column = selection.getColumn()));
        if (range.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        RichTextEditCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -213431772127471055L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (RichTextEditCtrl.ON_OK.equals(event.getName())) {
                    String content = (String)event.getData(RichTextEditCtrl.ARG_CONTENT);
                    UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
                    uam.doAction((UndoableAction)new CellRichTextAction(Labels.getLabel((String)"zss.undo.editText"), sheet, row, column, row, column, content));
                }
            }
        }, "Rich Text Edit", CellFormatHelper.getRichTextEditCellHtml((SSheet)internalSheet, (int)row, (int)column), ctx.getSpreadsheet());
        return true;
    }
}

