/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikaiex.ui.dialog.PasteSpecialCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.impl.ua.AbstractPasteSpecialHandler;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class PasteSpecialDialogHandler
extends AbstractPasteSpecialHandler {
    private static final long serialVersionUID = -2036949560737545806L;

    protected boolean processAction(final UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)(selection = ctx.getSelection()));
        if (range.isProtected()) {
            return true;
        }
        UserActionContext.Clipboard cb = ctx.getClipboard();
        if (cb == null) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.cant_find_thing_to_paste"));
            return true;
        }
        if (cb.isCutMode()) {
            throw new IllegalOpArgumentException("Cannot support paste special for cut");
        }
        PasteSpecialCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = 587632547836191154L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (PasteSpecialCtrl.ON_OK.equals(event.getName())) {
                    Range.PasteType type = (Range.PasteType)event.getData(PasteSpecialCtrl.ARG_PASTE_TYPE);
                    Range.PasteOperation operation = (Range.PasteOperation)event.getData(PasteSpecialCtrl.ARG_PASTE_OP);
                    boolean skipBlank = (Boolean)event.getData(PasteSpecialCtrl.ARG_SKIP_BLANK);
                    boolean transpose = (Boolean)event.getData(PasteSpecialCtrl.ARG_TRANSPOSE);
                    PasteSpecialDialogHandler.this.doPaste(ctx, type, operation, skipBlank, transpose);
                }
            }
        }, sheet.getBook().getType(), ctx.getSpreadsheet());
        return true;
    }
}

