/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalFormulaException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.ZSMessagebox;
import io.keikai.ui.impl.ua.AbstractProtectedHandler;
import io.keikaiex.ui.dialog.InsertFormulaCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class InsertFunctionHandler
extends AbstractProtectedHandler {
    private static final long serialVersionUID = 555113506918283081L;

    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        final Range selectedCell = Ranges.range((Sheet)sheet, (int)selection.getRow(), (int)selection.getColumn());
        InsertFormulaCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -6203591694383610317L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (InsertFormulaCtrl.ON_OK.equals(event.getName())) {
                    String formula = (String)event.getData(InsertFormulaCtrl.FORMULA);
                    try {
                        selectedCell.setCellEditText(formula);
                    }
                    catch (IllegalFormulaException x) {
                        InsertFunctionHandler.this.showFormulaError(x);
                    }
                }
            }
        });
        return true;
    }

    protected void showFormulaError(IllegalFormulaException ex) {
        String title = Labels.getLabel((String)"zss.msg.warn_title");
        String msg = Labels.getLabel((String)"zss.msg.formula_error", (Object[])new Object[]{ex.getMessage()});
        ZSMessagebox.show((String)msg, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-exclamation", null);
    }
}

