/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Color;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.model.CellStyleHolder;
import io.keikai.model.SBook;
import io.keikai.model.SFill;
import io.keikai.model.SSheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.StyleUtil;
import io.keikai.range.impl.WholeStyleUtil;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.CellStyleAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikaiex.ui.dialog.FormatCellCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class FormatCellHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = -7929818996569565554L;

    protected boolean processAction(final UserActionContext ctx) {
        final Sheet sheet = ctx.getSheet();
        final AreaRef selection = ctx.getSelection();
        Range range = Ranges.range((Sheet)sheet, (int)selection.getRow(), (int)selection.getColumn());
        String format = range.getCellDataFormat();
        Color backColor = range.getCellStyle().getBackColor();
        Color fillColor = range.getCellStyle().getFillColor();
        CellStyle.FillPattern pattern = range.getCellStyle().getFillPattern();
        int rotation = range.getInternalRange().getCellStyle().getRotation();
        FormatCellCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -7538418046002248163L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (FormatCellCtrl.ON_OK.equals(event.getName())) {
                    final String format = (String)event.getData(FormatCellCtrl.ARG_FORMAT_CODE);
                    final String backColor = (String)event.getData(FormatCellCtrl.ARG_BACKGROUND_CODE);
                    final String fillColor = (String)event.getData(FormatCellCtrl.ARG_FILL_COLOR_CODE);
                    final CellStyle.FillPattern pattern = (CellStyle.FillPattern)event.getData(FormatCellCtrl.ARG_FILL_PATTERN_CODE);
                    final int rotation = (Integer)event.getData(FormatCellCtrl.ARG_ROTATION_CODE);
                    CellOperationUtil.CellStyleApplierEx applier = new CellOperationUtil.CellStyleApplierEx(){

                        public void apply(Range range) {
                            SSheet sheet = range.getSheet().getInternalSheet();
                            if (format != null) {
                                StyleUtil.setDataFormat((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)format);
                            }
                            StyleUtil.setFillOptions((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (String)backColor, (String)fillColor, (SFill.FillPattern)EnumUtil.toStyleFillPattern((CellStyle.FillPattern)pattern));
                            StyleUtil.setTextRotation((SBook)sheet.getBook(), (CellStyleHolder)sheet.getCell(range.getRow(), range.getColumn()), (int)rotation);
                        }

                        public void applyWhole(Range wholeRange) {
                            if (format != null) {
                                WholeStyleUtil.setDataFormat((SRange)wholeRange.getInternalRange(), (String)format);
                            }
                            WholeStyleUtil.setFillOptions((SRange)wholeRange.getInternalRange(), (String)backColor, (String)fillColor, (SFill.FillPattern)EnumUtil.toStyleFillPattern((CellStyle.FillPattern)pattern));
                            WholeStyleUtil.setTextRotation((SRange)wholeRange.getInternalRange(), (int)rotation);
                        }

                        public void notifyChange(Range range) {
                            range.notifyChange(Range.CellAttribute.ALL);
                        }
                    };
                    UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
                    uam.doAction((UndoableAction)new CellStyleAction(Labels.getLabel((String)"zss.undo.cellFormat"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), (CellOperationUtil.CellStyleApplier)applier));
                }
            }
        }, format, backColor, fillColor, pattern, rotation, ctx.getSpreadsheet());
        return true;
    }
}

