/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.SheetOperationUtil;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.model.STable;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractProtectedHandler;
import org.zkoss.util.resource.Labels;

public class CleanFilterHandler
extends AbstractProtectedHandler {
    private static final long serialVersionUID = -7576345518460858743L;

    public boolean isEnabled(Book book, Sheet sheet) {
        return book != null && sheet != null && !sheet.isProtected() && book.getType() != Book.BookType.XLS;
    }

    protected boolean processAction(UserActionContext ctx) {
        Range filterRange;
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)selection);
        STable table = ((AbstractSheetAdv)sheet.getInternalSheet()).getTableByRowCol(range.getRow(), range.getColumn());
        if (table != null) {
            if (table.getAutoFilter() == null) {
                this.showInfoMessage(Labels.getLabel((String)"zssex.actionhandler.msg.cant_clear_filter"));
                return true;
            }
        } else if (!range.isAutoFilterEnabled() && (filterRange = range.findAutoFilterRange()) == null) {
            this.showInfoMessage(Labels.getLabel((String)"zssex.actionhandler.msg.cant_find_filter_range"));
            return true;
        }
        SheetOperationUtil.resetAutoFilter((Range)range);
        ctx.clearClipboard();
        return true;
    }
}

