/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.event.ClipboardPasteEvent;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.PasteSpecialCellAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public abstract class AbstractPasteSpecialHandler
extends AbstractHandler {
    private static final long serialVersionUID = -1531153605054648412L;

    protected boolean doPaste(UserActionContext ctx, Range.PasteType pasteType, Range.PasteOperation pasteOperation, boolean skipBlank, boolean transpose) {
        try {
            return this.doPaste0(ctx, pasteType, pasteOperation, skipBlank, transpose);
        }
        catch (IllegalOpArgumentException x) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_range_operation") + " : " + x.getMessage());
            return true;
        }
    }

    protected boolean doPaste0(UserActionContext ctx, Range.PasteType pasteType, Range.PasteOperation pasteOperation, boolean skipBlank, boolean transpose) {
        AreaRef pastedRange;
        UserActionContext.Clipboard cb = ctx.getClipboard();
        if (cb == null) {
            return false;
        }
        if (cb.isCutMode()) {
            throw new IllegalOpArgumentException("Cannot support paste special for cut");
        }
        Book book = ctx.getBook();
        Sheet destSheet = ctx.getSheet();
        Sheet srcSheet = cb.getSheet();
        if (srcSheet == null) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.cant_find_sheet_to_paste"));
            ctx.clearClipboard();
            return true;
        }
        AreaRef src = cb.getSelection();
        AreaRef selection = ctx.getSelection();
        Range srcRange = Ranges.range((Sheet)srcSheet, (int)src.getRow(), (int)src.getColumn(), (int)src.getLastRow(), (int)src.getLastColumn());
        Range destRange = Ranges.range((Sheet)destSheet, (int)selection.getRow(), (int)selection.getColumn(), (int)selection.getLastRow(), (int)selection.getLastColumn());
        if (destRange.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        if (cb.isCutMode() && srcRange.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        PasteSpecialCellAction action = new PasteSpecialCellAction(Labels.getLabel((String)"zss.undo.paste"), srcSheet, src.getRow(), src.getColumn(), src.getLastRow(), src.getLastColumn(), destSheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), pasteType, pasteOperation, skipBlank, transpose);
        uam.doAction((UndoableAction)action);
        if (srcSheet.equals(destSheet) && src.overlap(selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn())) {
            ctx.clearClipboard();
        }
        if ((pastedRange = action.getPastedRange()) != null) {
            Spreadsheet comp = ctx.getSpreadsheet();
            Events.postEvent((Event)new ClipboardPasteEvent((Component)comp, destSheet, pastedRange.getRow(), pastedRange.getColumn(), pastedRange.getLastRow(), pastedRange.getLastColumn()));
        }
        return true;
    }
}

