/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.model.Book;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Sheet;
import io.keikai.model.SName;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.RefocusDialogCtrlBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.SheetNameFormatter;
import org.apache.poi.ss.util.AreaReference;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class InsertHyperlinkCtrl
extends RefocusDialogCtrlBase {
    private static final long serialVersionUID = -5670705789890002388L;
    public static String URI = "~./zssex/dlg/insertHyperlink.zul";
    public static String ARG_DISPLAY = "headerSize";
    public static String ARG_LINKTYPE = "linktype";
    public static String ARG_ADDRESS = "address";
    protected final String mailPreAppend = "mailto:";
    @Wire
    protected Button webBtn;
    @Wire
    protected Button docBtn;
    @Wire
    protected Button mailBtn;
    @Wire
    protected Textbox displayBox;
    @Wire
    protected Component webContent;
    @Wire
    protected Component mailContent;
    @Wire
    protected Component docContent;
    protected String linkDisplay;
    protected String webAddress;
    protected String mailAddress;
    protected String subject;
    protected Hyperlink.HyperlinkType linkType;
    protected boolean autoDisplay = true;
    protected String docAddress;
    protected Spreadsheet ss;
    protected Book book;
    protected DocItem docSelectedItem;
    protected String cellReference = "A1";

    public static void show(EventListener<DialogCallbackEvent> callback, Hyperlink.HyperlinkType type, String address, String display, Spreadsheet ss) {
        Map arg = InsertHyperlinkCtrl.newArg(callback);
        arg.put(ARG_DISPLAY, display);
        arg.put(ARG_ADDRESS, address);
        arg.put(ARG_LINKTYPE, type);
        arg.put("spreadsheet", ss);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        this.linkDisplay = (String)arg.get(ARG_DISPLAY);
        String linkAddress = (String)arg.get(ARG_ADDRESS);
        this.linkType = (Hyperlink.HyperlinkType)arg.get(ARG_LINKTYPE);
        this.ss = (Spreadsheet)arg.get("spreadsheet");
        this.book = this.ss.getBook();
        comp.setTitle(Labels.getLabel((String)(Strings.isBlank((String)linkAddress) ? "zssex.dlg.hyperlink.insert" : "zssex.dlg.hyperlink.edit")));
        if (!Strings.isBlank((String)this.linkDisplay)) {
            this.displayBox.setValue(this.linkDisplay);
            this.autoDisplay = false;
        }
        if (this.linkType == Hyperlink.HyperlinkType.EMAIL) {
            String[] linkData = linkAddress.split("\\?subject=");
            this.mailAddress = linkData[0].substring("mailto:".length()).trim();
            if (linkData.length > 1) {
                this.subject = linkData[1].trim();
            }
            this.setLinkType(Hyperlink.HyperlinkType.EMAIL);
        } else if (this.linkType == Hyperlink.HyperlinkType.DOCUMENT) {
            this.docAddress = linkAddress;
            Object[] objs = Spreadsheet.parseLinkAddress((Book)this.book, (String)linkAddress);
            String sheetScope = (String)objs[1];
            String ref = (String)objs[2];
            SName docSelectedName = (SName)objs[0];
            if (docSelectedName != null) {
                this.docSelectedItem = new DocItem(DocItemType.NAME, this.docAddress, docSelectedName.getRefersToFormula());
                this.cellReference = "A1";
            } else if (!Strings.isBlank((String)ref)) {
                this.docSelectedItem = new DocItem(DocItemType.SHEET, sheetScope, "");
                try {
                    this.cellReference = new AreaReference(ref, SpreadsheetVersion.EXCEL2007).formatAsString();
                }
                catch (IllegalArgumentException ex) {
                    this.docSelectedItem = null;
                    this.cellReference = "A1";
                }
            } else {
                this.docSelectedItem = null;
                this.cellReference = "";
            }
            this.setLinkType(Hyperlink.HyperlinkType.DOCUMENT);
        } else {
            this.webAddress = linkAddress;
            this.setLinkType(Hyperlink.HyperlinkType.URL);
        }
    }

    @Listen(value="onChange=#displayBox")
    public void onChange$displayBox() {
        this.autoDisplay = false;
    }

    @Listen(value="onClick=#webBtn")
    public void onClick$webBtn() {
        this.setLinkType(Hyperlink.HyperlinkType.URL);
    }

    @Listen(value="onClick=#docBtn")
    public void onClick$docBtn() {
        this.setLinkType(Hyperlink.HyperlinkType.DOCUMENT);
    }

    @Listen(value="onClick=#mailBtn")
    public void onClick$mailBtn() {
        this.setLinkType(Hyperlink.HyperlinkType.EMAIL);
    }

    @Listen(value="onOK=window; onClick=#okBtn;")
    public void onClick$okBtn() {
        String addr = this.getAddress();
        if (Strings.isBlank((String)addr)) {
            ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.hyperlink.input_address"));
            return;
        }
        String display = this.displayBox.getValue();
        if (Strings.isBlank((String)display) || this.linkType == Hyperlink.HyperlinkType.DOCUMENT && this.autoDisplay) {
            display = addr;
        }
        this.detach();
        this.postCallback(ON_OK, InsertHyperlinkCtrl.newMap(InsertHyperlinkCtrl.newEntry(ARG_DISPLAY, display), InsertHyperlinkCtrl.newEntry(ARG_ADDRESS, addr), InsertHyperlinkCtrl.newEntry(ARG_LINKTYPE, this.linkType)));
    }

    @Listen(value="onCancel=window; onClick=#cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    protected String getAddress() {
        if (this.linkType == Hyperlink.HyperlinkType.EMAIL) {
            return this.getMailAddress();
        }
        if (this.linkType == Hyperlink.HyperlinkType.DOCUMENT) {
            return this.getDocAddress();
        }
        return this.getWebAddress();
    }

    protected void setLinkType(Hyperlink.HyperlinkType type) {
        this.linkType = type;
        this.mailBtn.setDisabled(false);
        this.mailContent.setVisible(false);
        this.webBtn.setDisabled(false);
        this.webContent.setVisible(false);
        this.docBtn.setDisabled(false);
        this.docContent.setVisible(false);
        if (this.linkType == Hyperlink.HyperlinkType.EMAIL) {
            this.initMail();
        } else if (this.linkType == Hyperlink.HyperlinkType.DOCUMENT) {
            this.initDoc();
        } else {
            this.initWeb();
        }
    }

    protected void initMail() {
        this.mailContent.setVisible(true);
        this.mailBtn.setDisabled(true);
        final Textbox mailAddr = (Textbox)this.mailContent.getFellow("mailAddr");
        final Textbox mailSubject = (Textbox)this.mailContent.getFellow("mailSubject");
        if (this.autoDisplay) {
            mailAddr.addEventListener("onChanging", (EventListener)new SerializableEventListener(){
                private static final long serialVersionUID = 359865890436191154L;

                public void onEvent(Event evt) throws Exception {
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    String mail = mailSubject.getValue();
                    String val = "mailto:" + ((InputEvent)evt).getValue() + (String)(mail != null && mail != "" ? "?subject=" + mailSubject.getValue() : "");
                    InsertHyperlinkCtrl.this.displayBox.setValue(val);
                }
            });
            mailSubject.addEventListener("onChanging", (EventListener)new SerializableEventListener(){
                private static final long serialVersionUID = 578268550436191154L;

                public void onEvent(Event evt) throws Exception {
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    String mail = mailAddr.getValue();
                    if (mail != null && mail != "") {
                        InsertHyperlinkCtrl.this.displayBox.setValue("mailto:" + mailAddr.getValue() + "?subject=" + ((InputEvent)evt).getValue());
                    }
                }
            });
        }
        if (Strings.isBlank((String)mailAddr.getValue())) {
            mailAddr.setValue(this.mailAddress);
        }
        if (Strings.isBlank((String)mailSubject.getValue())) {
            mailSubject.setValue(this.subject);
        }
        mailAddr.focus();
    }

    protected void initWeb() {
        this.webContent.setVisible(true);
        this.webBtn.setDisabled(true);
        final Combobox addr = (Combobox)this.webContent.getFellow("addrCombobox");
        if (this.autoDisplay) {
            addr.addEventListener("onChanging", (EventListener)new SerializableEventListener(){
                private static final long serialVersionUID = 337106550436789524L;

                public void onEvent(Event evt) {
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    InsertHyperlinkCtrl.this.displayBox.setValue(((InputEvent)evt).getValue());
                }
            });
            addr.addEventListener("onBlur", (EventListener)new SerializableEventListener(){
                private static final long serialVersionUID = 337106550436191154L;

                public void onEvent(Event evt) {
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    InsertHyperlinkCtrl.this.displayBox.setValue(addr.getValue());
                }
            });
            addr.addEventListener("onSelect", (EventListener)new SerializableEventListener(){
                private static final long serialVersionUID = -1070888525728585266L;

                public void onEvent(Event evt) throws Exception {
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    Comboitem seld = addr.getSelectedItem();
                    if (seld != null) {
                        InsertHyperlinkCtrl.this.displayBox.setValue(seld.getLabel());
                    }
                }
            });
        }
        if (Strings.isBlank((String)addr.getValue())) {
            addr.setValue(this.webAddress);
        }
        addr.focus();
    }

    protected String getWebAddress() {
        Combobox address = (Combobox)this.webContent.getFellow("addrCombobox");
        String val = address.getValue();
        return val == null ? "" : val;
    }

    protected String getDocAddress() {
        if (this.docSelectedItem.type == DocItemType.NAME) {
            return this.docSelectedItem.name;
        }
        Textbox cellRef = (Textbox)this.docContent.getFellow("cellRef");
        String cellRefText = cellRef.getValue();
        if (Strings.isBlank((String)cellRefText)) {
            return null;
        }
        String refText0 = this.docSelectedItem.name + "!" + cellRefText;
        String refText = SheetNameFormatter.unformat((String)this.docSelectedItem.name) + "!" + cellRefText;
        try {
            AreaReference areaRef = new AreaReference(refText, SpreadsheetVersion.EXCEL2007);
            String result = areaRef.formatAsString();
            return result.equalsIgnoreCase(refText0) ? result : null;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    protected String getMailAddress() {
        String mailAddr = ((Textbox)this.mailContent.getFellow("mailAddr")).getValue();
        if ("".equals(mailAddr)) {
            return "";
        }
        String subject = ((Textbox)this.mailContent.getFellow("mailSubject")).getValue();
        return "mailto:" + mailAddr + (String)("".equals(subject) ? "" : "?subject=" + subject);
    }

    protected void initDoc() {
        this.docContent.setVisible(true);
        this.docBtn.setDisabled(true);
        Combobox refSheet = (Combobox)this.docContent.getFellow("refSheet");
        Textbox cellRef = (Textbox)this.docContent.getFellow("cellRef");
        this.buildDocumentListbox(refSheet, cellRef, this.book);
        cellRef.addEventListener("onChanging", new EventListener(){

            public void onEvent(Event evt) throws Exception {
                if (!InsertHyperlinkCtrl.this.autoDisplay) {
                    return;
                }
                InsertHyperlinkCtrl.this.displayBox.setValue(InsertHyperlinkCtrl.this.docSelectedItem.name + "!" + ((InputEvent)evt).getValue());
            }
        });
        cellRef.focus();
    }

    protected DocItem prepareSheetItems(List<DocItem> docItems) {
        DocItemType type = DocItemType.SHEET;
        int s = this.book.getNumberOfSheets();
        DocItem target = null;
        for (int i = 0; i < s; ++i) {
            Sheet sheet = this.book.getSheetAt(i);
            if (sheet.isHidden()) continue;
            DocItem x = new DocItem(type, SheetNameFormatter.format((String)sheet.getSheetName()), "");
            docItems.add(x);
            if (!x.equals(this.docSelectedItem)) continue;
            target = x;
        }
        return target;
    }

    protected DocItem prepareDefinedNameItems(List<DocItem> docItems) {
        DocItemType type = DocItemType.NAME;
        DocItem target = null;
        for (SName name : this.book.getInternalBook().getNames()) {
            if (name.getRefersToSheetName() == null) continue;
            String namename = (String)(name.getApplyToSheetName() != null ? SheetNameFormatter.format((String)name.getApplyToSheetName()) + "!" : "") + name.getName();
            String extra = name.getRefersToFormula();
            DocItem x = new DocItem(type, namename, extra);
            docItems.add(x);
            if (!x.equals(this.docSelectedItem)) continue;
            target = x;
        }
        return target;
    }

    protected void buildDocumentListbox(Combobox refSheet, final Textbox cellRef, Book book) {
        if (refSheet != null) {
            if (book == null) {
                return;
            }
            ArrayList<DocItem> docItems = new ArrayList<DocItem>();
            DocItem selectedSheet = this.prepareSheetItems(docItems);
            DocItem selectedName = this.prepareDefinedNameItems(docItems);
            if (selectedSheet != null) {
                this.docSelectedItem = selectedSheet;
            } else if (selectedName != null) {
                this.docSelectedItem = selectedName;
                cellRef.setDisabled(true);
            } else {
                String rawSheetName = this.ss.getSelectedSheetName();
                String sheetName = SheetNameFormatter.format((String)rawSheetName);
                this.docSelectedItem = new DocItem(DocItemType.SHEET, sheetName, "");
            }
            final ListModelList model = new ListModelList(docItems);
            if (this.docSelectedItem != null) {
                model.addToSelection((Object)this.docSelectedItem);
                refSheet.setValue(this.docSelectedItem.toString());
            }
            refSheet.setModel((ListModel)model);
            cellRef.setValue(this.cellReference);
            if (this.autoDisplay) {
                this.displayBox.setValue(this.getDocAddress());
            }
            refSheet.addEventListener("onSelect", new EventListener(){

                public void onEvent(Event evt) throws Exception {
                    Set selecteds = model.getSelection();
                    if (selecteds.isEmpty()) {
                        return;
                    }
                    InsertHyperlinkCtrl.this.docSelectedItem = (DocItem)selecteds.iterator().next();
                    cellRef.setDisabled(InsertHyperlinkCtrl.this.docSelectedItem.type == DocItemType.NAME);
                    if (!InsertHyperlinkCtrl.this.autoDisplay) {
                        return;
                    }
                    InsertHyperlinkCtrl.this.displayBox.setValue(InsertHyperlinkCtrl.this.getDocAddress());
                }
            });
        }
    }

    public class DocItem {
        private final DocItemType type;
        private final String name;
        private final String extra;

        DocItem(DocItemType t, String n, String ext) {
            this.type = t;
            this.name = n;
            this.extra = ext;
        }

        public String toString() {
            return this.name + (String)(this.type == DocItemType.NAME ? " ( " + this.extra + " )" : "");
        }

        public int hashCode() {
            return (this.type.hashCode() * 31 + this.name.hashCode()) * 31 + this.extra.hashCode();
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof DocItem)) {
                return false;
            }
            DocItem o = (DocItem)other;
            return o.type == this.type && o.name.equals(this.name) && o.extra.equals(this.extra);
        }
    }

    public static enum DocItemType {
        SHEET,
        NAME;

    }
}

