/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.ui.sys.FormulaInfosLoader;
import io.keikaiex.ui.dialog.FormulaMetaInfo;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Formulas
implements FormulaInfosLoader {
    public static String FINANCIAL = "Financial";
    public static String DATE_TIME = "Date & Time";
    public static String MATH_TRIG = "Math & Trig";
    public static String STATISTICAL = "Statistical";
    public static String LOOKUP_REF = "Lookup & Reference";
    public static String DATABASE = "Database";
    public static String TEXT = "Text";
    public static String LOGICAL = "Logical";
    public static String INFOMATION = "Information";
    public static String ENGINEERING = "Engineering";
    public static LinkedHashMap<String, List<FormulaMetaInfo>> formulaInfosByCategory = new LinkedHashMap();

    public TreeMap<String, Map<String, String>> getFormulaInfos() {
        TreeMap<String, Map<String, String>> formulaInfos = new TreeMap<String, Map<String, String>>();
        formulaInfosByCategory.forEach((c, infos) -> infos.forEach(info -> {
            HashMap<String, String> map = new HashMap<String, String>();
            formulaInfos.put(info.getFunction(), map);
            map.put("expression", info.getExpression());
            map.put("description", info.getDescription());
        }));
        return formulaInfos;
    }

    public static LinkedHashMap<String, List<FormulaMetaInfo>> getFormulaInfosByCategory() {
        return formulaInfosByCategory;
    }

    static {
        LinkedList<FormulaMetaInfo> financeAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(FINANCIAL, financeAry);
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "ACCRINT", "ACCRINT(issue, first_interest, settlement, rate, par, frequency, [basis], [calc_method])", "Returns the accrued interest for a security that pays periodic interest.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "ACCRINTM", "ACCRINTM(issue, settlement, rate, par, [basis])", "Returns the accrued interest for a security that pays interest at maturity.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "AMORDEGRC", "AMORDEGRC(cost, date_purchased, first_period, salvage, period, rate, [basis])", "Returns the prorated linear depreciation of an asset for each accounting period.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "AMORLINC", "AMORLINC(cost, date_purchased, first_period, salvage, period, rate, [basis])", "Returns the prorated linear depreciation of an asset for each accounting period.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPDAYBS", "COUPDAYBS(settlement, maturity, frequency, [basis])", "Returns the number of days from the beginning of the coupon period to the settlement date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPDAYS", "COUPDAYS(settlement, maturity, frequency, [basis])", "Returns the number of days in the coupon period that contains the settlement date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPDAYSNC", "COUPDAYSNC(settlement, maturity, frequency, [basis])", "Returns the number of days from the settlement date to the next coupon date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPNCD", "COUPNCD(settlement, maturity, frequency, [basis])", "Returns the next coupon date after the settlement date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPNUM", "COUPNUM(settlement, maturity, frequency, [basis])", "Returns the number of coupons payable between the settlement date and maturity date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "COUPPCD", "COUPPCD(settlement, maturity, frequency, [basis])", "Returns the previous coupon date before the settlement date.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "CUMIPMT", "CUMIPMT(rate, nper, pv, start_period, end_period, type)", "Returns the cumulative interest paid between two periods.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "CUMPRINC", "CUMPRINC(rate, nper, pv, start_period, end_period, type)", "Returns the cumulative principal paid on a loan between two periods.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DB", "DB(cost, salvage, life, period, [month])", "Returns the depreciation of an asset for a specified period using the fixed-declining balance method", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DDB", "DDB(cost, salvage, life, period, [factor])", "Returns the depreciation of an asset for a specified period using the double-declining balance method or some other method you specify.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DISC", "DISC(settlement, maturity, pr, redemption, [basis])", "Returns the discount rate for a security", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DOLLARDE", "DOLLARDE(fractional_dollar, fraction)", "Converts a dollar price, expressed as a fraction, into a dollar price, expressed as a decimal number", 2, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DOLLARFR", "DOLLARFR(decimal_dollar, fraction)", "Converts a dollar price, expressed as a decimal number, into a dollar price, expressed as a fraction", 2, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "DURATION", "DURATION(settlement, maturity, coupon, yld, frequency, [basis])", "Returns the annual duration of a security with periodic interest payments.", 5, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "EFFECT", "EFFECT(nominal_rate, npery)", "Returns the effective annual interest rate.", 2, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "FV", "FV(rate, nper, pmt, [pv], [type])", "Returns the future value of an investment based on periodic, constant payments and a constant interset rate.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "FVSCHEDULE", "FVSCHEDULE(principal, schedule)", "Returns the future value of an initial principal after applying a series of compound interest rates.", 2, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "INTRATE", "INTRATE(settlement, maturity, investment, redemption, [basis])", "Returns the interest rate for a fully invested security.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "IPMT", "IPMT(rate, per, nper, pv, [fv], [type])", "Returns the interest payment for a given period for an investment, based on periodic, constant payments and a constant interest rate.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "IRR", "IRR(values, [guess])", "Returns the internal rate of return for a series of cash flows.", 1, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "MIRR", "MIRR(values, finance_rate, reinvest_rate)", "Returns the modified internal rate of return for a series of periodic cash flows. MIRR considers both the cost of the investment and the interest received on reinvestment of cash.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "NOMINAL", "NOMINAL(effect_rate, npery)", "Returns the nominal annual interest rate, given the effective rate and the number of compounding periods per year.", 2, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "NPER", "NPER(rate, pmt, pv, [fv], [type])", "Returns the number of periods for an investment based on periodic, constant payments and a constant interest rate.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "NPV", "NPV(rate, value1, [value2], ...)", "Returns the net present value of an investment based on a discount rate and a series of future payments (negative values) and income (positive values).", 2, "value"));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PMT", "PMT(rate, nper, pv, [fv], [type])", "Calculates the payment for a loan based on constant payments and a constant interest rate.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PPMT", "PPMT(rate, per, nper, pv, [fv], [type])", "Returns the payment on the principal for a given investment based on periodic, constant payments and a constant interest rate.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PRICE", "PRICE(settlement, maturity, rate, yld, redemption, frequency, [basis])", "Returns the price per $100 face value of a security that pays periodic interest.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PRICEDISC", "PRICEDISC(settlement, maturity, discount, redemption, [basis])", "Returns the price per $100 face value of a discounted security.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PRICEMAT", "PRICEMAT(settlement, maturity, issue, rate, yld, [basis])", "Returns the price per $100 face value of a security that pays interest at maturity.", 5, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "PV", "PV(rate, nper, pmt, [fv], [type])", "Returns the present value of an investment: the total amount that a series of future payments is worth now.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "RATE", "RATE(nper, pmt, pv, [fv], [type], [guess])", "Returns the interest rate per period of a loan or an investment.For example, use 6%/4 for quartely payments at 6% APR.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "RECEIVED", "RECEIVED(settlement, maturity, investment, discount, [basis])", "Returns the amount received at maturity for a fully invested security.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "SLN", "SLN(cost, salvage, life)", "Returns the straight-line depreciation of an asset for one period.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "SYD", "SYD(cost, salvage, life, per)", "Returns the sum-of-years' digits depreciation of an asset for a specified period.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "TBILLEQ", "TBILLEQ(settlement, maturity, discount)", "Returns the bond-equivalent yield for a treasury bill.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "TBILLPRICE", "TBILLPRICE(settlement, maturity, discount)", "Returns the price per $100 face value for a treasury bill.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "TBILLYIELD", "TBILLYIELD(settlement, maturity, pr)", "Returns the yield for a treasury bill", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "XNPV", "XNPV(rate, values, dates)", "Returns the net present value for a schedule of case flows.", 3, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "YIELD", "YIELD(settlement, maturity, rate, pr, redemption, frequency, [basis])", "Returns the yield on a security that pays periodic interest.", 6, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "YIELDDISC", "YIELDDISC(settlement, maturity, pr, redemption, [basis])", "Returns the annual yield for a discounted security. For example, a treasury bill.", 4, null));
        financeAry.add(new FormulaMetaInfo(FINANCIAL, "YIELDMAT", "YIELDMAT(settlement, maturity, issue, rate, pr, [basis])", "Returns the annual yield of a security that pays interest at maturity", 5, null));
        LinkedList<FormulaMetaInfo> statAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(STATISTICAL, statAry);
        statAry.add(new FormulaMetaInfo(STATISTICAL, "AVEDEV", "AVEDEV(number1, [number2], ...)", "Returns the average of the absolute deviations of data points from their mean. AVEDEV is a measure of the variability in a data set.", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "AVERAGE", "AVERAGE(number1, [number2], ...)", "Returns the average of its arguments", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "AVERAGEA", "AVERAGEA(value1, [value2], ...)", "Returns the average of its arguments, including numbers, text, and logical values", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BETADIST", "BETADIST(x, alpha, beta, [lower_bound], [upper_bound])", "Returns the cumulative beta probability density function", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BETA.DIST", "BETA.DIST(x, alpha, beta, cumulative, [lower_bound], [upper_bound])", "Returns the beta distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BETAINV", "BETAINV(probability, alpha, beta, [lower_bound], [upper_bound])", "Returns the inverse of the cumulative beta probability density function for a specified beta distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BETA.INV", "BETA.INV(probability, alpha, beta, [lower_bound], [upper_bound])", "Returns the inverse of the beta cumulative probability density function", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BINOMDIST", "BINOMDIST(number_s, trials, probability_s, cumulative)", "Returns the individual term binomial distribution probability", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BINOM.DIST", "BINOM.DIST(number_s, trials, probability_s, cumulative)", "Returns the individual term binomial distribution probability", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CRITBINOM", "CRITBINOM(trials, probability_s, alpha)", "Returns the smallest value for which the cumulative binomial distribution is greater than or equal to a criterion value", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "BINOM.INV", "BINOM.INV(trials, probability_s, alpha)", "Returns the smallest value for which the cumulative binomial distribution is greater than or equal to a criterion value", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COVAR", "COVAR(array1, array2)", "Returns covariance, the average of the products of paired deviations", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHIDIST", "CHIDIST(x, degrees_freedom)", "Returns the one-tailed probability of the chi-squared distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHISQ.DIST", "CHISQ.DIST(x, deg_freedom, cumulative)", "Returns the chi-squared distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHISQ.DIST.RT", "CHISQ.DIST.RT(x, deg_freedom)", "Returns the right-tailed probability of the chi-squared distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHIINV", "CHIINV(probability, degrees_freedom)", "Returns the inverse of the one-tailed probability of the chi-squared distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHISQ.INV", "CHISQ.INV(probability, deg_freedom)", "Returns the inverse of the left-tailed probability of the chi-squared distribution", 2, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CHISQ.INV.RT", "CHISQ.INV.RT(probability, deg_freedom)", "Returns the inverse of the right-tailed probability of the chi-squared distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "CORREL", "CORREL(array1, array2)", "Returns the correlation coefficient of two cell ranges. Use the correlation coefficient to determine the relationship between two properties", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COUNT", "COUNT(value1, [value2], ...)", "Counts how many numbers are in the list of arguments", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COUNTA", "COUNTA(value1, [value2], ...)", "Counts how many values are in the list of arguments", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COUNTBLANK", "COUNTBLANK(range)", "Count the number of empty cells in a range of cells", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COUNTIF", "COUNTIF(range, criterion)", "Count the number of cells that meet a criterion", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "COUNTIFS", "COUNTIFS(range1, criterion1, [range2, criterion2], ...)", "Applies criteria to cells across multiple ranges and counts the number of times all criteria are met.", 2, "range, criterion"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "DEVSQ", "DEVSQ(number1, [number2], ...)", "Returns the sum of squares of deviations of data points from their sample mean", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "EXPONDIST", "EXPONDIST(x, lambda, cumulative)", "Returns the exponential distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "EXPON.DIST", "EXPON.DIST(x, lambda, cumulative)", "Returns the exponential distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "FDIST", "FDIST(x, degrees_freedom1, degrees_freedom2)", "Returns the F probability distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "F.DIST", "F.DIST(x, degrees_freedom1, degrees_freedom2, cumulative)", "Returns the F probability distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "F.DIST.RT", "F.DIST.RT(x, degrees_freedom1, degrees_freedom2)", "Returns the F probability distribution for two data sets", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "FINV", "FINV(probability, degrees_freedom1, degrees_freedom2)", "Returns the inverse of the F probability distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "F.INV", "F.INV(probability, degrees_freedom1, degrees_freedom2)", "Returns the inverse of the F probability distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "F.INV.RT", "F.INV.RT(probability, degrees_freedom1, degrees_freedom2)", "Returns the inverse of the F probability distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "FORECAST", "FORECAST(x, known_y's, known_x's)", "Returns a value along a linear trend", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "FREQUENCY", "FREQUENCY(data_array, bins_array)", "Returns a frequency distribution as a vertical array", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GAMMADIST", "GAMMADIST(x, alpha, beta, cumulative)", "Returns the gamma distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GAMMA.DIST", "GAMMA.DIST(x, alpha, beta, cumulative)", "Returns the gamma distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GAMMAINV", "GAMMAINV(probability, alpha, beta)", "Returns the inverse of the gamma cumulative distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GAMMA.INV", "GAMMA.INV(probability, alpha, beta)", "Returns the inverse of the gamma cumulative distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GAMMALN", "GAMMALN(x)", "Returns the natural logarithm of the gamma function", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "GEOMEAN", "GEOMEAN(number1, [number2], ...)", "Returns the geometric mean", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "HARMEAN", "HARMEAN(number1, [number2], ...)", "Returns the harmonic mean of a data set", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "HYPGEOMDIST", "HYPGEOMDIST(sample_s, number_sample, population_s, number_population)", "Returns the hypergeometric distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "HYPGEOM.DIST", "HYPGEOM.DIST(sample_s, number_sample, population_s, number_population, cumulative)", "Returns the hypergeometric distribution", 5, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "INTERCEPT", "INTERCEPT(known_y's, known_x's)", "Returns the intercept of the linear regression line.", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "LINEST", "LINEST(known_y's, [known_x's], [const], [stats])", "Given partial data about a linear trend, calculates various parameters about the ideal linear trend using the least-squares method.", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "KURT", "KURT(number1, [number2], ...)", "Returns the kurtosis of a data set", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "LARGE", "LARGE(array, k)", "Returns the k-th largest value in a data set", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "LOGNORM.INV", "LOGNORM.INV(probability, mean, standard_dev)", "Returns the inverse of the lognormal cumulative distribution function of x, where ln(x) is normally distributed with parameters mean and standard_dev", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "LOGNORM.DIST", "LOGNORM.DIST(x, mean, standard_dev, cumulative)", "Returns the lognormal distribution of x, where ln(x) is normally distributed with parameters mean and standard_dev", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MAX", "MAX(number1, [number2], ...)", "Returns the maximum value in a list of arguments", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MAXA", "MAXA(value1, [value2], ...)", "Returns the largest value in a list of arguments", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MAXIFS", "MAXIFS(max_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...)", "Returns the maximum value among cells specified by a given set of conditions or criteria", 3, ""));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MEDIAN", "MEDIAN(number1, [number2], ...)", "Returns the median of the given numbers", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MIN", "MIN(number1, [number2], ...)", "Returns the minimum value in a list of arguments", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MINA", "MINA(value1, [value2], ...)", "Returns the smallest value in the list of arguments", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MINIFS", "MINIFS(min_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...)", "Returns the minimum value among cells specified by a given set of conditions or criteria", 3, ""));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MODE", "MODE(number1, [number2], ...)", "Returns the most frequently occurring, or repetitive, value in an array or range of data", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "MODE.SNGL", "MODE.SNGL(number1, [number2], ...)", "Returns the most frequently occurring, or repetitive, value in an array or range of data", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NEGBINOM.DIST", "NEGBINOM.DIST(number_f, number_s, probability_s, cumulative)", "Returns the negative binomial distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NORM.DIST", "NORM.DIST(x, mean, standard_dev, cumulative)", "Returns the normal distribution for the specified mean and standard deviation", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NORM.INV", "NORM.INV(probability, mean, standard_dev)", "Returns the inverse of the normal cumulative distribution for the specified mean and standard deviation", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NORM.S.DIST", "NORM.S.DIST(z, cumulative)", "Returns the standard normal distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NORMSINV", "NORMSINV(probability)", "Returns the inverse of the standard normal cumulative distribution", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "NORM.S.INV", "NORM.S.INV(probability)", "Returns the inverse of the standard normal cumulative distribution", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "PEARSON", "PEARSON(array1, array2)", "Returns the Pearson product moment correlation coefficient", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "PERCENTILE", "PERCENTILE(array, k)", "Returns the k-th percentile of values in a range", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "PERCENTRANK", "PERCENTRANK(array, x, [significance])", "Returns the percentage rank of a value in a data set", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "PERCENTRANK.EXC", "PERCENTRANK.EXC(array, x, [significance])", "Returns the rank of a value in a data set as a percentage (0..1, exclusive) of the data set", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "PERCENTRANK.INC", "PERCENTRANK.INC(array, x, [significance])", "Returns the percentage rank of a value in a data set", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "POISSON.DIST", "POISSON.DIST(x, mean, cumulative)", "Returns the Poisson distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "RANK", "RANK(number, ref, [order])", "Returns the rank of a number in a list of numbers", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "RANK.EQ", "RANK.EQ(number, ref, [order])", "Returns the rank of a number in a list of numbers", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "SKEW", "SKEW(number1, [number2], ...)", "Returns the skewness of a distribution", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "SLOPE", "SLOPE(known_y's, known_x's)", "Returns the slope of the linear regression line", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STDEVA", "STDEVA(value1, [value2], ...)", "Estimates standard deviation based on a sample, including numbers, text, and logical values", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STDEV", "STDEV(number1, [number2], ...)", "Estimates standard deviation based on a sample", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STDEV.S", "STDEV.S(number1, [number2], ...)", "Estimates standard deviation based on a sample", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "SMALL", "SMALL(array, k)", "Returns the k-th smallest value in a data set", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STANDARDIZE", "STANDARDIZE(x, mean, standard_dev)", "Returns a normalized value", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STDEV.P", "STDEV.P(number1, [number2], ...)", "Calculates standard deviation based on the entire population", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "STDEVPA", "STDEVPA(value1, [value2], ...)", "Calculates standard deviation based on the entire population, including numbers, text, and logical values", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "TDIST", "TDIST(x, degrees_freedom, tails)", "Returns the Student's t-distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "T.DIST", "T.DIST(x, degrees_freedom, cumulative)", "Returns the Student's t-distribution", 3, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "T.DIST.2T", "T.DIST.2T(x, deg_freedom)", "Returns the two-tailed Student's t-distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "T.DIST.RT", "T.DIST.RT(x, deg_freedom)", "Returns the right-tailed Student's t-distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "TINV", "TINV(probability, degrees_freedom)", "Returns the inverse of the Student's t-distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "T.INV.2T", "T.INV.2T(probability, degrees_freedom)", "Returns the inverse of the Student's t-distribution", 2, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "TREND", "TREND(known_y's, [known_x's], [new_x's], [const])", "Returns values along a linear trend", 1, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VAR", "VAR(number1, [number2], ...)", "Estimates variance based on a sample", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VAR.S", "VAR.S(number1, [number2], ...)", "Estimates variance based on a sample", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VARP", "VARP(number1, [number2], ...)", "Calculates variance based on the entire population", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VAR.P", "VAR.P(number1, [number2], ...)", "Calculates variance based on the entire population", 1, "number"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VARA", "VARA(value1, [value2], ...)", "Estimates variance based on a sample, including numbers, text, and logical values", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "VARPA", "VARPA(value1, [value2], ...)", "Calculates variance based on the entire population, including numbers, text, and logical values", 1, "value"));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "WEIBULL", "WEIBULL(x, alpha, beta, cumulative)", "Returns the Weibull distribution", 4, null));
        statAry.add(new FormulaMetaInfo(STATISTICAL, "WEIBULL.DIST", "WEIBULL.DIST(x, alpha, beta, cumulative)", "Returns the Weibull distribution", 4, null));
        LinkedList<FormulaMetaInfo> lookupAndRefAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(LOOKUP_REF, lookupAndRefAry);
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "ADDRESS", "ADDRESS(row_num, column_num, [abs_num], [a1], [sheet_text])", "Obtains the address of a cell in a worksheet, given specified row and column numbers", 2, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "AREAS", "AREAS(reference)", "Returns the number of areas in a reference. An area is a range of contiguous cells or a single cell.", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "CHOOSE", "CHOOSE(index_num, value1, [value2], ...)", "Uses index_num to return a value from the list of value arguments", 2, "value"));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "COLUMN", "COLUMN(reference)", "Returns the column number of the given cell reference", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "COLUMNS", "COLUMNS(array)", "Returns the number of columns in an array or reference", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "HLOOKUP", "HLOOKUP(lookup_value, table_array, row_index_num, [range_lookup])", "Searches for a value in the top row of a table or an array of values, and then returns a value in the same column from a row you specify in the table or array.", 3, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "HYPERLINK", "HYPERLINK(link_location, [friendly_name])", "Creates a shortcut that jumps to another location in the current workbook, or opens a document stored on a network server, an intranet, or the Internet", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "INDEX", "INDEX(array, row_num, [column_num])", "Returns a value or the reference to a value from within a table or range", 2, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "INDIRECT", "INDIRECT(ref_text, [a1])", "Returns the reference specified by a text string", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "LOOKUP", "LOOKUP(lookup_value, lookup_vector, [result_vector])", "Searches one row or column, or to search multiple rows and columns", 2, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "MATCH", "MATCH(lookup_value, lookup_array, [match_type])", "Searches for a specified item in a range of cells, and then returns the relative position of that item in the range", 2, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "OFFSET", "OFFSET(reference, rows, cols, [height], [width])", "Returns a reference to a range that is a specified number of rows and columns from a cell or range of cells", 3, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "ROW", "ROW(reference)", "Returns the row number of a reference", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "ROWS", "ROWS(array)", "Returns the number of rows in a reference or array", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "TRANSPOSE", "TRANSPOSE(array)", "Returns the transpose of an array", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "UNIQUE", "UNIQUE(range, [by_col], [occurs_once])", "Returns unique rows in the provided source range, discarding duplicates. Rows are returned in the order in which they first appear in the source range.", 1, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "VLOOKUP", "VLOOKUP(lookup_value, table_array, col_index_num, [range_lookup])", "Searches for a value in the first column of a table array and returns a value in the same row from another column in the table array.", 3, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "XLOOKUP", "XLOOKUP(lookup_value, lookup_array, return_array, [if_not_found], [match_mode], [search_mode])", "Searches a range or an array, and returns an item corresponding to the first match it finds. If a match doesn't exist, then XLOOKUP can return the closest (approximate) match.", 3, null));
        lookupAndRefAry.add(new FormulaMetaInfo(LOOKUP_REF, "XMATCH", "XMATCH(lookup_value, lookup_array, [match_mode], [search_mode])", "Returns the relative position of an item in an array or range of cells", 2, null));
        LinkedList<FormulaMetaInfo> databaseAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(DATABASE, databaseAry);
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DAVERAGE", "DAVERAGE(database, field, criteria)", "Returns the average of selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DCOUNT", "DCOUNT(database, field, criteria)", "Counts the cells that contain numbers in a database.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DCOUNTA", "DCOUNTA(database, field, criteria)", "Counts nonblank cells in a database.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DGET", "DGET(database, field, criteria)", "Extracts from a database a single record that matches the specified criteria.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DMAX", "DMAX(database, field, criteria)", "Returns the maximum value from selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DMIN", "DMIN(database, field, criteria)", "Returns the minimum value from selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DPRODUCT", "DPRODUCT(database, field, criteria)", "Multiplies the values in a particular field of records that match the criteria in a database.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DSTDEV", "DSTDEV(database, field, criteria)", "Estimates the standard deviation based on a sample of selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DSTDEVP", "DSTDEVP(database, field, criteria)", "Calculates the standard deviation based on the entire population of selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DSUM", "DSUM(database, field, criteria)", "Adds the numbers in the field column of records in the database that match the criteria.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DVAR", "DVAR(database, field, criteria)", "Estimates variance based on a sample from selected database entries.", 3, null));
        databaseAry.add(new FormulaMetaInfo(DATABASE, "DVARP", "DVARP(database, field, criteria)", "Calculates variance based on the entire population of selected database entries.", 3, null));
        LinkedList<FormulaMetaInfo> mathAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(MATH_TRIG, mathAry);
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ABS", "ABS(number)", "Returns the absolute value of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ACOS", "ACOS(number)", "Returns the arccosine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ACOSH", "ACOSH(number)", "Returns the inverse hyperbolic cosine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ASIN", "ASIN(number)", "Returns the arcsine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ASINH", "ASINH(number)", "Returns the inverse hyperbolic sine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ATAN", "ATAN(number)", "Returns the arctangent of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ATAN2", "ATAN2(x_num, y_num)", "Returns the arctangent from x- and y-coordinates", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ATANH", "ATANH(number)", "Returns the inverse hyperbolic tangent of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "CEILING", "CEILING(number, significance)", "Rounds a number to the nearest integer or to the nearest multiple of significance", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "CEILING.MATH", "CEILING.MATH(number, [significance], [mode])", "Rounds a number up to the nearest integer or to the nearest multiple of significance", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "CEILING.PRECISE", "CEILING.PRECISE(number, [significance])", "Returns a number that is rounded up to the nearest integer or to the nearest multiple of significance. Regardless of the sign of the number, the number is rounded up. However, if the number or the significance is zero, zero is returned.", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "COMBIN", "COMBIN(number, number_chosen)", "Returns the number of combinations for a given number of objects", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "COS", "COS(number)", "Returns the cosine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "COSH", "COSH(number)", "Returns the hyperbolic cosine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "DEGREES", "DEGREES(angle)", "Converts radians to degrees", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "EVEN", "EVEN(number)", "Rounds a number up to the nearest even integer", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "EXP", "EXP(number)", "Returns e raised to the power of a given number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "FACT", "FACT(number)", "Returns the factorial of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "FACTDOUBLE", "FACTDOUBLE(number)", "Returns the double factorial of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "FLOOR", "FLOOR(number, significance)", "Rounds a number down, toward zero", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "FLOOR.MATH", "FLOOR.MATH(number, significance, mode)", "Rounds a number down, to the nearest integer or to the nearest multiple of significance", 3, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "FLOOR.PRECISE", "FLOOR.PRECISE(number, [significance])", "Rounds a number down to the nearest integer or to the nearest multiple of significance. Regardless of the sign of the number, the number is rounded down.", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "GCD", "GCD(number1, [number2], ...)", "Returns the greatest common divisor", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "INT", "INT(number)", "Rounds a number down to the nearest integer", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "LCM", "LCM(number1, [number2], ...)", "Returns the least common multiple", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "LN", "LN(number)", "Returns the natural logarithm of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "LOG", "LOG(number, [base])", "Returns the logarithm of a number to a specified base", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "LOG10", "LOG10(number)", "Returns the base-10 logarithm of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MDETERM", "MDETERM(array)", "Returns the matrix determinant of an array", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MINVERSE", "MINVERSE(array)", "Returns the matrix inverse of an array", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MMULT", "MMULT(array1, array2)", "Returns the matrix product of two arrays", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MOD", "MOD(number, divisor)", "Returns the remainder from division", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MROUND", "MROUND(number, multiple)", "Returns a number rounded to the desired multiple", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "MULTINOMIAL", "MULTINOMIAL(number1, [number2], ...)", "Returns the multinomial of a set of numbers", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ODD", "ODD(number)", "Rounds a number up to the nearest odd integer", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "PI", "PI( )", "Returns the value of pi", 0, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "POWER", "POWER(number, power)", "Returns the result of a number raised to a power", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "PRODUCT", "PRODUCT(number1, [number2], ...)", "Multiplies its arguments", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "QUOTIENT", "QUOTIENT(numerator, denominator)", "Returns the integer portion of a division", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "RADIANS", "RADIANS(angle)", "Converts degrees to radians", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "RAND", "RAND( )", "Returns a random number between 0 and 1", 0, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "RANDBETWEEN", "RANDBETWEEN(bottom, top)", "Returns a random number between the numbers you specify", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ROMAN", "ROMAN(number, [form])", "Converts an arabic numeral to roman, as text", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ROUND", "ROUND(number, num_digits)", "Rounds a number to a specified number of digits", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ROUNDDOWN", "ROUNDDOWN(number, num_digits)", "Rounds a number down, toward zero", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "ROUNDUP", "ROUNDUP(number,num_digits)", "Rounds a number up, away from zero", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SIGN", "SIGN(number)", "Returns the sign of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SIN", "SIN(number)", "Returns the sine of the given angle", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SINH", "SINH(number)", "Returns the hyperbolic sine of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SQRT", "SQRT(number)", "Returns a positive square root", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SQRTPI", "SQRTPI(number)", "Returns the square root of (number * pi)", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUBTOTAL", "SUBTOTAL(function_num, ref1, [ref2], ...)", "Returns a subtotal in a list or database", 2, "ref"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUM", "SUM(number1, [number2], ...)", "Adds its arguments", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMIF", "SUMIF(range, criteria, [sum_range])", "Adds the cells specified by a given criteria", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMIFS", "SUMIFS(sum_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...)", "Adds all of its arguments that meet multiple criteria", 3, ""));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMPRODUCT", "SUMPRODUCT(array1, [array2], ...)", "Returns the sum of the products of corresponding array components", 1, "array"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMSQ", "SUMSQ(number1, [number2], ...)", "Returns the sum of the squares of the arguments", 1, "number"));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMX2MY2", "SUMX2MY2(array_x, array_y)", "Returns the sum of the difference of squares of corresponding values in two arrays", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMX2PY2", "SUMX2PY2(array_x, array_y)", "Returns the sum of the sum of squares of corresponding values in two arrays", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "SUMXMY2", "SUMXMY2(array_x, array_y)", "Returns the sum of squares of differences of corresponding values in two arrays", 2, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "TAN", "TAN(number)", "Returns the tangent of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "TANH", "TANH(number)", "Returns the hyperbolic tangent of a number", 1, null));
        mathAry.add(new FormulaMetaInfo(MATH_TRIG, "TRUNC", "TRUNC(number, [num_digits])", "Truncates a number to an integer", 1, null));
        LinkedList<FormulaMetaInfo> dateAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(DATE_TIME, dateAry);
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DATE", "DATE(year, month, day)", "Returns the serial number of a particular date", 3, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DATEDIF", "DATEDIF(start_date, end_date, unit)", "Calculates the number of days, months, or years between two dates", 3, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DATEVALUE", "DATEVALUE(date_text)", "Converts a date in the form of text to a serial number", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DAY", "DAY(serial_number)", "Converts a serial number to a day of the month", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DAYS", "DAYS(end_date, start_date)", "Returns the number of days between two dates", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "DAYS360", "DAYS360(start_date, end_date, [method])", "Calculates the number of days between two dates based on a 360-day year", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "EDATE", "EDATE(start_date, months)", "Returns the serial number of the date that is the indicated number of months before or after the start date", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "EOMONTH", "EOMONTH(start_date, months)", "Returns the serial number for the last day of the month that is the indicated number of months before or after start_date", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "HOUR", "HOUR(serial_number)", "Converts a serial number to an hour", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "MINUTE", "MINUTE(serial_number)", "Converts a serial number to a minute", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "MONTH", "MONTH(serial_number)", "Converts a serial number to a month", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "NETWORKDAYS", "NETWORKDAYS(start_date, end_date, [holidays])", "Returns the serial number for the last day of the month that is the indicated number of months before or after start_date", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "NOW", "NOW()", "Returns the serial number of the current date and time", 0, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "SECOND", "SECOND(serial_number)", "Converts a serial number to a second", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "TIME", "TIME(hour, minute, second)", "Returns the serial number of a particular time", 3, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "TIMEVALUE", "TIMEVALUE(time_text)", "Converts a time in the form of text to a serial number", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "TODAY", "TODAY( )", "Returns the serial number of today's date", 0, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "WEEKDAY", "WEEKDAY(serial_number, [return_type])", "Converts a serial number to a day of the week", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "WEEKNUM", "WEEKNUM(serial_number, [return_type])", "Converts a serial number to a number representing where the week falls numerically with a year", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "WORKDAY", "WORKDAY(start_date, days, [holidays])", "Returns a number that represents a date that is the indicated number of working days before or after a date", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "WORKDAY.INTL", "WORKDAY.INTL(start_date, days, [weekend], [holidays])", "Returns the serial number of the date before or after a specified number of workdays using parameters to indicate which and how many days are weekend days", 2, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "YEAR", "YEAR(serial_number)", "Converts a serial number to a year", 1, null));
        dateAry.add(new FormulaMetaInfo(DATE_TIME, "YEARFRAC", "YEARFRAC(start_date, end_date, [basis])", "Calculates the fraction of the year represented by the number of whole days between two dates", 2, null));
        LinkedList<FormulaMetaInfo> textAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(TEXT, textAry);
        textAry.add(new FormulaMetaInfo(TEXT, "CHAR", "CHAR(number)", "Returns the character specified by the code number", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "CLEAN", "CLEAN(text)", "Removes all nonprintable characters from text", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "CODE", "CODE(text)", "Returns a numeric code for the first character in a text string", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "CONCAT", "CONCAT(text1, [text2], ...)", "Combines the text from multiple ranges and/or strings, but it doesn't provide the delimiter or IgnoreEmpty arguments", 1, "text"));
        textAry.add(new FormulaMetaInfo(TEXT, "CONCATENATE", "CONCATENATE(text1, [text2], ...)", "Joins several text items into one text item", 1, "text"));
        textAry.add(new FormulaMetaInfo(TEXT, "DOLLAR", "DOLLAR(number, [decimals])", "Converts a number to text, using the $ (dollar) currency format", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "EXACT", "EXACT(text1, text2)", "Checks to see if two text values are identical", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "FIND", "FIND(find_text, within_text, [start_num])", "Finds one text value within another (case-sensitive)", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "FINDB", "FINDB(find_text, within_text, [start_num])", "Finds one text value within another (case-sensitive)", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "FIXED", "FIXED(number, [decimals], [no_commas])", "Formats a number as text with a fixed number of decimals", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "LEFT", "LEFT(text, [num_chars])", "Returns the leftmost characters from a text value", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "LEN", "LEN(text)", "Returns the number of characters in a text string", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "LOWER", "LOWER(text)", "Converts text to lowercase", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "MID", "MID(text, start_num, num_chars)", "Returns a specific number of characters from a text string starting at the position you specify", 3, null));
        textAry.add(new FormulaMetaInfo(TEXT, "NUMBERVALUE", "NUMBERVALUE(text, [decimal_separator], [group_separator])", "Converts text to number in a locale-independent manner", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "PROPER", "PROPER(text)", "Capitalizes the first letter in each word of a text value", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "REPLACE", "REPLACE(old_text, start_num, num_chars, new_text)", "Replaces characters within text", 4, null));
        textAry.add(new FormulaMetaInfo(TEXT, "REPT", "REPT(text, number_times)", "Repeats text a given number of times", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "RIGHT", "RIGHT(text, [num_chars])", "Returns the rightmost characters from a text value", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "SEARCH", "SEARCH(find_text, within_text, [start_num])", "Finds one text value within another (not case-sensitive)", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "SUBSTITUTE", "SUBSTITUTE(text, old_text, new_text, [instance_num])", "Substitutes new text for old text in a text string", 3, null));
        textAry.add(new FormulaMetaInfo(TEXT, "T", "T(value)", "Converts its arguments to text", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "TEXT", "TEXT(value, format_text)", "Formats a number and converts it to text", 2, null));
        textAry.add(new FormulaMetaInfo(TEXT, "TEXTJOIN", "TEXTJOIN(delimiter, ignore_empty, text1, [text2], ...)", "Combines the text from multiple ranges and/or strings", 3, "text"));
        textAry.add(new FormulaMetaInfo(TEXT, "TRIM", "TRIM(text)", "Removes spaces from text", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "UPPER", "UPPER(text)", "Converts text to uppercase", 1, null));
        textAry.add(new FormulaMetaInfo(TEXT, "VALUE", "VALUE(text)", "Converts a text argument to a number", 1, null));
        LinkedList<FormulaMetaInfo> logAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(LOGICAL, logAry);
        logAry.add(new FormulaMetaInfo(LOGICAL, "AND", "AND(logical1, [logical2], ...)", "Returns TRUE if all of its arguments are TRUE", 1, "logical"));
        logAry.add(new FormulaMetaInfo(LOGICAL, "AVERAGEIF", "AVERAGEIF(range, criteria, [average_range])", "Returns the average (arithmetic mean) of all the cells in a range that meet a given criteria", 2, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "AVERAGEIFS", "AVERAGEIFS(average_range, criteria_range1, criteria1, [criteria_range2, criteria2], ...)", "Returns the average (arithmetic mean) of all cells that meet multiple criteria", 3, ""));
        logAry.add(new FormulaMetaInfo(LOGICAL, "FALSE", "FALSE( )", "Returns the logical value FALSE", 0, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "IF", "IF(logical_test, value_if_true, [value_if_false])", "Specifies a logical test to perform", 2, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "IFERROR", "IFERROR(value, value_if_error)", "Specifies a logical test to perform", 2, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "IFNA", "IFNA(value, value_if_na)", "Returns the value you specify if the expression resolves to #N/A, otherwise returns the result of the expression", 2, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "IFS", "IFS(logical_test1, value_if_true1, [logical_test2, value_if_true2], ...)", "Checks whether one or more conditions are met and returns a value that corresponds to the first TRUE condition", 2, ""));
        logAry.add(new FormulaMetaInfo(LOGICAL, "NOT", "NOT(logical)", "Reverses the logic of its argument", 1, null));
        logAry.add(new FormulaMetaInfo(LOGICAL, "OR", "OR(logical1, [logical2], ...)", "Returns TRUE if any argument is TRUE", 1, "logical"));
        logAry.add(new FormulaMetaInfo(LOGICAL, "SWITCH", "SWITCH(expression, value1, result1, [default or value2, result2], ...)", "Evaluates an expression against a list of values and returns the result corresponding to the first matching value. If there is no match, an optional default value may be returned.", 3, ""));
        logAry.add(new FormulaMetaInfo(LOGICAL, "TRUE", "TRUE( )", "Returns the logical value TRUE", 0, null));
        LinkedList<FormulaMetaInfo> infoAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(INFOMATION, infoAry);
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISBLANK", "ISBLANK(value)", "Returns TRUE if the value is blank", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISLOGICAL", "ISLOGICAL(value)", "Returns TRUE if the value is a logical value", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISEVEN", "ISEVEN(number)", "Returns TRUE if the number is even", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISODD", "ISODD(number)", "Returns TRUE if the number is odd", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "N", "N(value)", "Returns a value converted to a number", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "NA", "NA( )", "Returns the error value #N/A", 0, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISNUMBER", "ISNUMBER(value)", "Returns TRUE if the value is a number", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISREF", "ISREF(value)", "Returns TRUE if the value is a reference", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISTEXT", "ISTEXT(value)", "Returns TRUE if the value is text", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISNONTEXT", "ISNONTEXT(value)", "Returns TRUE if the value is not text", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISERR", "ISERR(value)", "Returns TRUE if the value is any error value except #N/A", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISERROR", "ISERROR(value)", "Returns TRUE if the value is any error value", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ISNA", "ISNA(value)", "Returns TRUE if the value is the #N/A error value", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "TYPE", "TYPE(value)", "Returns a number indicating the data type of a value", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "ERROR.TYPE", "ERROR.TYPE(error_val)", "Returns a number corresponding to an error type", 1, null));
        infoAry.add(new FormulaMetaInfo(INFOMATION, "CELL", "CELL(value, [reference])", "Returns information about the formatting, location, or contents of a cell", 1, null));
        LinkedList<FormulaMetaInfo> engAry = new LinkedList<FormulaMetaInfo>();
        formulaInfosByCategory.put(ENGINEERING, engAry);
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BESSELI", "BESSELI(x, n)", "Returns the modified Bessel function In(x)", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BESSELJ", "BESSELJ(x, n)", "Returns the Bessel function Jn(x)", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BESSELK", "BESSELK(x, n)", "Returns the modified Bessel function Kn(x)", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BESSELY", "BESSELY(x, n)", "Returns the Bessel function Yn(x)", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BIN2DEC", "BIN2DEC(number)", "Converts a binary number to decimal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BIN2HEX", "BIN2HEX(number, [places])", "Converts a binary number to hexadecimal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "BIN2OCT", "BIN2OCT(number, [places])", "Converts a binary number to octal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "COMPLEX", "COMPLEX(real_num, i_num, [suffix])", "Converts real and imaginary coefficients into a complex number", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "DEC2BIN", "DEC2BIN(number, [places])", "Converts a decimal number to binary", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "DEC2HEX", "DEC2HEX(number, [places])", "Converts a decimal number to hexadecimal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "DEC2OCT", "DEC2OCT(number, [places])", "Converts a decimal number to octal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "DELTA", "DELTA(number1, [number2])", "Tests whether two values are equal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "ERF", "ERF(lower_limit, [upper_limit])", "Returns the error function", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "ERFC", "ERFC(x)", "Returns the complementary error function", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "GESTEP", "GESTEP(number, [step])", "Tests whether a number is greater than a threshold value", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "HEX2BIN", "HEX2BIN(number, [places])", "Converts a hexadecimal number to binary", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "HEX2DEC", "HEX2DEC(number)", "Converts a hexadecimal number to decimal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "HEX2OCT", "HEX2OCT(number, [places])", "Converts a hexadecimal number to octal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMABS", "IMABS(inumber)", "Returns the absolute value (modulus) of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMAGINARY", "IMAGINARY(inumber)", "Returns the imaginary coefficient of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMARGUMENT", "IMARGUMENT(inumber)", "Returns the argument theta, an angle expressed in radians", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMCONJUGATE", "IMCONJUGATE(inumber)", "Returns the complex conjugate of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMCOS", "IMCOS(inumber)", "Returns the cosine of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMDIV", "IMDIV(inumber1, inumber2)", "Returns the quotient of two complex numbers", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMEXP", "IMEXP(inumber)", "Returns the exponential of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMLN", "IMLN(inumber)", "Returns the natural logarithm of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMLOG10", "IMLOG10(inumber)", "Returns the base-10 logarithm of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMLOG2", "IMLOG2(inumber)", "Returns the base-2 logarithm of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMPOWER", "IMPOWER(inumber, number)", "Returns a complex number raised to an integer power", 2, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMPRODUCT", "IMPRODUCT(inumber1, [inumber2], ...)", "Returns the product of complex numbers", 1, "inumber"));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMREAL", "IMREAL(inumber)", "Returns the real coefficient of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMSIN", "IMSIN(inumber)", "Returns the sine of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMSQRT", "IMSQRT(inumber)", "Returns the square root of a complex number", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMSUB", "IMSUB(inumber1, inumber2)", "Returns the difference between two complex numbers", 2, "inumber"));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "IMSUM", "IMSUM(inumber1, [inumber2], ...)", "Returns the sum of complex numbers", 1, "inumber"));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "OCT2BIN", "OCT2BIN(number, [places])", "Converts an octal number to binary", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "OCT2DEC", "OCT2DEC(number)", "Converts an octal number to decimal", 1, null));
        engAry.add(new FormulaMetaInfo(ENGINEERING, "OCT2HEX", "OCT2HEX(number, [places])", "Converts an octal number to hexadecimal", 1, null));
    }
}

