/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Color;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.RefocusDialogCtrlBase;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SelectEvent;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zkex.zul.Colorbox;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;
import org.zkoss.zul.event.ListDataEvent;
import org.zkoss.zul.event.ListDataListener;

public class FormatCellCtrl
extends RefocusDialogCtrlBase {
    private static final long serialVersionUID = 1L;
    public static String ARG_FORMAT_CODE = "formatCode";
    public static String ARG_BACKGROUND_CODE = "backgroundCode";
    public static String ARG_FILL_COLOR_CODE = "fillColorCode";
    public static String ARG_FILL_PATTERN_CODE = "fillPatternCode";
    public static String ARG_ROTATION_CODE = "rotationCode";
    public static String URI = "~./zssex/dlg/formatNumber.zul";
    public static Map<String, FormatItem> FORMAT_ITEMS = new HashMap<String, FormatItem>();
    protected String formatCode;
    protected Color backColor;
    protected Color fillColor;
    protected CellStyle.FillPattern pattern;
    protected int rotation;
    protected String[] categories = new String[]{"mfn_general", "mfn_number", "mfn_currency", "mfn_accounting", "mfn_date", "mfn_time", "mfn_percentage", "mfn_fraction", "mfn_scientific", "mfn_text", "mfn_special", "mfn_custom"};
    protected ListModelList<InnerFillPattern> patternListmodel = new ListModelList((Object[])InnerFillPattern.values());
    protected boolean patternChanged = false;
    protected ListModelList<InnerRotation> rotationListmodel = new ListModelList((Object[])InnerRotation.values());
    @Wire
    protected Listbox mfn_category;
    @Wire
    protected Listbox mfn_general;
    @Wire
    protected Component mfn_custom_box;
    @Wire
    protected Textbox mfn_custom_value;
    @Wire
    protected Listbox selectedCategory;
    @Wire
    protected Colorbox backColorbox;
    @Wire
    protected Colorbox fillColorbox;
    @Wire
    protected Combobox patternCombobox;
    @Wire
    protected Combobox rotationCombobox;

    public static void show(EventListener<DialogCallbackEvent> callback, String formatCode, Color backColor, Color fillColor, CellStyle.FillPattern fillPattern, int rotation, Spreadsheet ss) {
        Map arg = FormatCellCtrl.newArg(callback);
        arg.put(ARG_FORMAT_CODE, formatCode);
        arg.put(ARG_BACKGROUND_CODE, backColor);
        arg.put(ARG_FILL_COLOR_CODE, fillColor);
        arg.put(ARG_FILL_PATTERN_CODE, fillPattern);
        arg.put(ARG_ROTATION_CODE, rotation);
        arg.put("spreadsheet", ss);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        this.formatCode = (String)arg.get(ARG_FORMAT_CODE);
        this.backColor = (Color)arg.get(ARG_BACKGROUND_CODE);
        this.fillColor = (Color)arg.get(ARG_FILL_COLOR_CODE);
        this.pattern = (CellStyle.FillPattern)arg.get(ARG_FILL_PATTERN_CODE);
        this.rotation = (Integer)arg.get(ARG_ROTATION_CODE);
        this.backColorbox.setColor(this.backColor.getHtmlColor());
        this.fillColorbox.setColor(this.fillColor.getHtmlColor());
        this.patternListmodel.addToSelection((Object)InnerFillPattern.values()[this.pattern.ordinal()]);
        this.patternListmodel.sort((Comparator)new Comparator<InnerFillPattern>(){

            @Override
            public int compare(InnerFillPattern o1, InnerFillPattern o2) {
                return o1.order - o2.order;
            }
        }, true);
        this.patternListmodel.addListDataListener(new ListDataListener(){

            public void onChange(ListDataEvent arg0) {
                FormatCellCtrl.this.patternChanged = true;
            }
        });
        this.patternCombobox.setModel(this.patternListmodel);
        this.rotationListmodel.addToSelection((Object)InnerRotation.getRotation(this.rotation));
        this.rotationCombobox.setModel(this.rotationListmodel);
        this.mfn_custom_value.setValue(this.formatCode);
        FormatItem fi = FORMAT_ITEMS.get(this.formatCode);
        if (fi == null) {
            this.openFormatList("mfn_custom", -1);
        } else {
            this.openFormatList(fi.category, fi.categoryIndex);
        }
    }

    @Listen(value="onSelect=Listbox[id^=mfn_")
    public void onSelect$mfn_category(SelectEvent event) {
        if ("mfn_category".equals(event.getTarget().getId())) {
            String cat = (String)this.mfn_category.getSelectedItem().getValue();
            FormatItem fi = FORMAT_ITEMS.get(this.formatCode);
            int index = -1;
            index = "mfn_custom".equals(cat) ? (fi == null ? -1 : fi.customIndex) : (fi == null ? 0 : (fi.category.equals(cat) ? fi.categoryIndex : 0));
            this.openFormatList(cat, index);
        } else {
            this.selectOption((Listbox)event.getTarget());
        }
    }

    protected void selectOption(Listbox lb) {
        Listitem li;
        if (lb != null && (li = lb.getSelectedItem()) != null) {
            li.setZclass("zss-listitem");
            this.formatCode = (String)li.getValue();
            this.mfn_custom_value.setValue(this.formatCode);
            Clients.scrollIntoView((Component)li);
        }
    }

    protected void openFormatList(String category, int index) {
        this.mfn_custom_box.setVisible("mfn_custom".equals(category));
        for (int i = 0; i < this.categories.length; ++i) {
            Listitem catli = this.mfn_category.getItemAtIndex(i);
            String cat0 = (String)catli.getValue();
            Listbox lb = (Listbox)((Window)this.getSelf()).getFellow(cat0);
            if (lb == null) continue;
            if (category.equals(cat0)) {
                lb.setSelectedIndex(index);
                this.selectedCategory = lb;
                this.mfn_category.setSelectedItem(catli);
                this.selectOption(lb);
                lb.setVisible(true);
                continue;
            }
            lb.setVisible(false);
        }
    }

    @Listen(value="onOK=window; onClick=#okBtn")
    public void onClick$okBtn() {
        Listitem seldItem = this.mfn_category.getSelectedItem();
        if (seldItem == null) {
            this.showSelectFormatDialog();
            return;
        }
        if (this.selectedCategory == null) {
            this.showSelectFormatDialog();
            return;
        }
        String formatCodes = this.mfn_custom_value.getValue();
        String backColor = this.backColorbox.getColor();
        String fillColor = this.fillColorbox.getColor();
        CellStyle.FillPattern fillPattern = CellStyle.FillPattern.values()[((InnerFillPattern)((Object)this.patternListmodel.getSelection().iterator().next())).ordinal()];
        int rotation = ((InnerRotation)((Object)this.rotationListmodel.getSelection().iterator().next())).getRotation();
        this.detach();
        this.postCallback(ON_OK, FormatCellCtrl.newMap(FormatCellCtrl.newEntry(ARG_FORMAT_CODE, formatCodes), FormatCellCtrl.newEntry(ARG_BACKGROUND_CODE, backColor), FormatCellCtrl.newEntry(ARG_FILL_COLOR_CODE, fillColor), FormatCellCtrl.newEntry(ARG_FILL_PATTERN_CODE, fillPattern), FormatCellCtrl.newEntry(ARG_ROTATION_CODE, rotation)));
    }

    protected void showSelectFormatDialog() {
        ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.format.select_format_code"));
    }

    @Listen(value="onChange=#backColorbox")
    public void onBackColorChange() {
        if (!this.patternChanged && this.patternListmodel.getSelection().iterator().next() == InnerFillPattern.NONE) {
            this.patternListmodel.clearSelection();
            this.patternListmodel.addToSelection((Object)InnerFillPattern.SOLID);
        }
    }

    @Listen(value="onCancel=window; onClick=#cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    public static void putFormatItem(String c, int i, String f, int ci) {
        FORMAT_ITEMS.put(f, new FormatItem(c, i, f, ci));
    }

    static {
        FormatCellCtrl.putFormatItem("mfn_custom", 0, "General", 0);
        FormatCellCtrl.putFormatItem("mfn_custom", 1, "0", 1);
        FormatCellCtrl.putFormatItem("mfn_custom", 2, "0.00", 2);
        FormatCellCtrl.putFormatItem("mfn_custom", 3, "#,##0", 3);
        FormatCellCtrl.putFormatItem("mfn_custom", 4, "#,##0.00", 4);
        FormatCellCtrl.putFormatItem("mfn_custom", 5, "#,##0_);(#,##0)", 5);
        FormatCellCtrl.putFormatItem("mfn_custom", 6, "#,##0_);[Red](#,##0)", 6);
        FormatCellCtrl.putFormatItem("mfn_custom", 7, "#,##0.00_);(#,##0.00)", 7);
        FormatCellCtrl.putFormatItem("mfn_custom", 8, "#,##0.00_);[Red](#,##0.00)", 8);
        FormatCellCtrl.putFormatItem("mfn_custom", 9, "$#,##0_);($#,##0)", 9);
        FormatCellCtrl.putFormatItem("mfn_custom", 10, "$#,##0_);[Red]($#,##0)", 10);
        FormatCellCtrl.putFormatItem("mfn_custom", 11, "$#,##0.00_);($#,##0.00)", 11);
        FormatCellCtrl.putFormatItem("mfn_custom", 12, "$#,##0.00_);[Red]($#,##0.00)", 12);
        FormatCellCtrl.putFormatItem("mfn_custom", 13, "0%", 13);
        FormatCellCtrl.putFormatItem("mfn_custom", 14, "0.00%", 14);
        FormatCellCtrl.putFormatItem("mfn_custom", 15, "0.00E+00", 15);
        FormatCellCtrl.putFormatItem("mfn_custom", 16, "##0.0E+0", 16);
        FormatCellCtrl.putFormatItem("mfn_custom", 17, "# ?/?", 17);
        FormatCellCtrl.putFormatItem("mfn_custom", 18, "# ??/??", 18);
        FormatCellCtrl.putFormatItem("mfn_custom", 19, "m/d/yyyy", 19);
        FormatCellCtrl.putFormatItem("mfn_custom", 20, "d-mmm-yy", 20);
        FormatCellCtrl.putFormatItem("mfn_custom", 21, "d-mmm", 21);
        FormatCellCtrl.putFormatItem("mfn_custom", 22, "mmm-yy", 22);
        FormatCellCtrl.putFormatItem("mfn_custom", 23, "h:mm AM/PM", 23);
        FormatCellCtrl.putFormatItem("mfn_custom", 24, "h:mm:ss AM/PM", 24);
        FormatCellCtrl.putFormatItem("mfn_custom", 25, "h:mm", 25);
        FormatCellCtrl.putFormatItem("mfn_custom", 26, "h:mm:ss", 26);
        FormatCellCtrl.putFormatItem("mfn_custom", 27, "m/d/yyyy h:mm", 27);
        FormatCellCtrl.putFormatItem("mfn_custom", 28, "mm:ss", 28);
        FormatCellCtrl.putFormatItem("mfn_custom", 29, "mm:ss.0", 29);
        FormatCellCtrl.putFormatItem("mfn_custom", 30, "@", 30);
        FormatCellCtrl.putFormatItem("mfn_custom", 31, "[h]:mm:ss", 31);
        FormatCellCtrl.putFormatItem("mfn_custom", 32, "_($* #,##0_);_($* (#,##0);_($* \"-\"_);_(@_)", 32);
        FormatCellCtrl.putFormatItem("mfn_custom", 33, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)", 33);
        FormatCellCtrl.putFormatItem("mfn_custom", 34, "_($* #,##0.00_);_($* (#,##0.00);_($* \"-\"??_);_(@_)", 34);
        FormatCellCtrl.putFormatItem("mfn_custom", 35, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)", 35);
        FormatCellCtrl.putFormatItem("mfn_general", 0, "General", 0);
        FormatCellCtrl.putFormatItem("mfn_number", 0, "0.00", 2);
        FormatCellCtrl.putFormatItem("mfn_number", 1, "0.00;[Red]0.00", -1);
        FormatCellCtrl.putFormatItem("mfn_number", 2, "0.00_);(0.00)", -1);
        FormatCellCtrl.putFormatItem("mfn_number", 3, "0.00_);[Red](0.00)", -1);
        FormatCellCtrl.putFormatItem("mfn_currency", 0, "$#,##0.00", -1);
        FormatCellCtrl.putFormatItem("mfn_currency", 1, "$#,##0.00;[Red]$#,##0.00", -1);
        FormatCellCtrl.putFormatItem("mfn_currency", 2, "$#,##0.00_);($#,##0.00)", 11);
        FormatCellCtrl.putFormatItem("mfn_currency", 3, "$#,##0.00_);[Red]($#,##0.00)", 12);
        FormatCellCtrl.putFormatItem("mfn_accounting", 0, "_($* #,##0.00_);_($* (#,##0.00);_($* \"-\"??_);_(@_)", 34);
        FormatCellCtrl.putFormatItem("mfn_date", 0, "m/d/yyyy", 19);
        FormatCellCtrl.putFormatItem("mfn_date", 1, "dddd, mmmm dd, yyyy", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 2, "m/d;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 3, "m/d/yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 4, "mm/dd/yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 5, "d-mmm;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 6, "d-mmm-yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 7, "dd-mmm-yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 8, "mmm-yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 9, "mmmm-yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 10, "mmmm d, yyyy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 11, "m/d/yy h:mm AM/PM;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 12, "m/d/yy h:mm;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 13, "mmmmm;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 14, "mmmmm-yy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 15, "m/d/yyyy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_date", 16, "d-mmm-yyyy;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 0, "h:mm:ss AM/PM", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 1, "h:mm;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 2, "h:mm AM/PM;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 3, "h:mm:ss;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 4, "h:mm:ss AM/PM;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 5, "mm:ss.0;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 6, "[h]:mm:ss;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 7, "m/d/yy h:mm AM/PM;@", -1);
        FormatCellCtrl.putFormatItem("mfn_time", 8, "m/d/yy h:mm;@", -1);
        FormatCellCtrl.putFormatItem("mfn_percentage", 0, "0.00%", 14);
        FormatCellCtrl.putFormatItem("mfn_fraction", 0, "# ?/?", 17);
        FormatCellCtrl.putFormatItem("mfn_fraction", 1, "# ??/??", 18);
        FormatCellCtrl.putFormatItem("mfn_fraction", 2, "# ???/???", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 3, "# ?/2", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 4, "# ?/4", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 5, "# ?/8", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 6, "# ??/16", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 7, "# ?/10", -1);
        FormatCellCtrl.putFormatItem("mfn_fraction", 8, "# ??/100", -1);
        FormatCellCtrl.putFormatItem("mfn_scientific", 0, "0.00E+00", 15);
        FormatCellCtrl.putFormatItem("mfn_text", 0, "@", 30);
        FormatCellCtrl.putFormatItem("mfn_special", 0, "00000", -1);
        FormatCellCtrl.putFormatItem("mfn_special", 1, "00000-0000", -1);
        FormatCellCtrl.putFormatItem("mfn_special", 2, "[<=9999999]###-####;(###)###-####", -1);
        FormatCellCtrl.putFormatItem("mfn_special", 3, "000-00-0000", -1);
    }

    public static class FormatItem {
        protected final String category;
        protected final int categoryIndex;
        protected final String format;
        protected final int customIndex;

        FormatItem(String c, int i, String f, int ci) {
            this.category = c;
            this.categoryIndex = i;
            this.format = f;
            this.customIndex = ci;
        }
    }

    public static enum InnerRotation {
        HORIZONTAL(Labels.getLabel((String)"zssex.dlg.format.alignment.horizontal"), 0),
        VERTIACAL(Labels.getLabel((String)"zssex.dlg.format.alignment.vertical"), 255),
        NINETY_DEGREE(Labels.getLabel((String)"zssex.dlg.format.alignment.ninetydeg"), 90),
        NEGATIVE_NINETY_DEGREE(Labels.getLabel((String)"zssex.dlg.format.alignment.negativeninetydeg"), -90);

        String label;
        int rotation;

        private InnerRotation(String label, int rotation) {
            this.label = label;
            this.rotation = rotation;
        }

        public static InnerRotation getRotation(int rotation) {
            for (InnerRotation r : InnerRotation.values()) {
                if (r.rotation != rotation) continue;
                return r;
            }
            return null;
        }

        public int getRotation() {
            return this.rotation;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum InnerFillPattern {
        NONE(Labels.getLabel((String)"zssex.dlg.format.fill.none"), 0),
        SOLID(Labels.getLabel((String)"zssex.dlg.format.fill.solid"), 1),
        MEDIUM_GRAY(Labels.getLabel((String)"zssex.dlg.format.fill.mediumGray"), 3),
        DARK_GRAY(Labels.getLabel((String)"zssex.dlg.format.fill.darkGray"), 2),
        LIGHT_GRAY(Labels.getLabel((String)"zssex.dlg.format.fill.lightGray"), 4),
        DARK_HORIZONTAL(Labels.getLabel((String)"zssex.dlg.format.fill.darkHorizontal"), 11),
        DARK_VERTICAL(Labels.getLabel((String)"zssex.dlg.format.fill.darkVertical"), 12),
        DARK_DOWN(Labels.getLabel((String)"zssex.dlg.format.fill.darkDown"), 13),
        DARK_UP(Labels.getLabel((String)"zssex.dlg.format.fill.darkUp"), 14),
        DARK_GRID(Labels.getLabel((String)"zssex.dlg.format.fill.darkGrid"), 15),
        DARK_TRELLIS(Labels.getLabel((String)"zssex.dlg.format.fill.darkTrellis"), 16),
        LIGHT_HORIZONTAL(Labels.getLabel((String)"zssex.dlg.format.fill.lightHorizontal"), 21),
        LIGHT_VERTICAL(Labels.getLabel((String)"zssex.dlg.format.fill.lightVertical"), 22),
        LIGHT_DOWN(Labels.getLabel((String)"zssex.dlg.format.fill.lightDown"), 23),
        LIGHT_UP(Labels.getLabel((String)"zssex.dlg.format.fill.lightUp"), 24),
        LIGHT_GRID(Labels.getLabel((String)"zssex.dlg.format.fill.lightGrid"), 25),
        LIGHT_TRELLIS(Labels.getLabel((String)"zssex.dlg.format.fill.lightTrellis"), 26),
        GRAY125(Labels.getLabel((String)"zssex.dlg.format.fill.gray125"), 5),
        GRAY0625(Labels.getLabel((String)"zssex.dlg.format.fill.gray0625"), 6);

        String label;
        int order;

        private InnerFillPattern(String label, int order) {
            this.label = label;
            this.order = order;
        }

        public String toString() {
            return this.label;
        }
    }
}

