/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.FormulaMetaInfo;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.select.SelectorComposer;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Label;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.impl.InputElement;

public class ComposeFormulaCtrl
extends SelectorComposer<Component> {
    private static final long serialVersionUID = 1L;
    @Wire
    protected Label formulaStart;
    @Wire
    protected Textbox composeFormulaTextbox;
    @Wire
    protected Listbox argsListbox;
    @Wire
    protected Label description;
    protected FormulaMetaInfo metaInfo;
    protected int focusToIndex = -1;
    protected List<ArgWrapper> args;
    protected List<InputElement> inputs = new LinkedList<InputElement>();
    protected boolean movedToNext = false;
    protected InputElement focusComponent;

    public void doAfterCompose(Component comp) throws Exception {
        super.doAfterCompose(comp);
        this.composeFormulaTextbox.setZclass("zss-textbox");
        this.composeFormulaTextbox.addEventListener("onChange", (EventListener)new SerializableEventListener(){
            private static final long serialVersionUID = -8155889223889099793L;

            public void onEvent(Event event) throws Exception {
                ComposeFormulaCtrl.this.decomposeFormula();
            }
        });
        this.argsListbox.setItemRenderer(new ListitemRenderer(){

            public void render(Listitem item, Object data) throws Exception {
                final ArgWrapper arg = (ArgWrapper)data;
                item.setValue((Object)arg);
                item.setZclass("zss-listitem");
                Listcell cell = new Listcell(arg.getName());
                cell.setZclass("zss-listcell");
                item.appendChild((Component)cell);
                final Textbox tb = new Textbox(arg.getValue());
                tb.setZclass("zss-textbox");
                ComposeFormulaCtrl.this.inputs.add((InputElement)tb);
                tb.addEventListener("onChange", (EventListener)new SerializableEventListener(){
                    private static final long serialVersionUID = 1L;

                    public void onEvent(Event event) throws Exception {
                        arg.setValue(tb.getValue());
                        ComposeFormulaCtrl.this.composeFormula();
                        ComposeFormulaCtrl.this.moveFocusToNext((HtmlBasedComponent)tb);
                        ComposeFormulaCtrl.this.movedToNext = false;
                    }
                });
                tb.addEventListener("onFocus", (EventListener)new SerializableEventListener(){
                    private static final long serialVersionUID = 1L;

                    public void onEvent(Event event) throws Exception {
                        ArgWrapper last = ComposeFormulaCtrl.this.args.get(ComposeFormulaCtrl.this.args.size() - 1);
                        if (last.equals(arg) && ComposeFormulaCtrl.this.metaInfo.isMultipleParameter()) {
                            ComposeFormulaCtrl.this.focusToIndex = ComposeFormulaCtrl.this.args.size() - 1;
                            ComposeFormulaCtrl.this.args.add(ComposeFormulaCtrl.this.createNextArg());
                            ComposeFormulaCtrl.this.argsListbox.setModel(ComposeFormulaCtrl.this.newListModelInstance(ComposeFormulaCtrl.this.args));
                        } else {
                            ComposeFormulaCtrl.this.focusComponent = tb;
                        }
                        if (ComposeFormulaCtrl.this.movedToNext && ComposeFormulaCtrl.this.focusComponent != null) {
                            ComposeFormulaCtrl.this.focusComponent.focus();
                        }
                        ComposeFormulaCtrl.this.movedToNext = false;
                    }
                });
                cell = new Listcell();
                cell.setZclass("zss-listcell");
                cell.appendChild((Component)tb);
                item.appendChild((Component)cell);
            }

            public void render(Listitem item, Object data, int index) throws Exception {
                this.render(item, data);
            }
        });
        this.argsListbox.addEventListener("onAfterRender", (EventListener)new SerializableEventListener(){

            public void onEvent(Event event) throws Exception {
                int focusIdx = -1;
                if (ComposeFormulaCtrl.this.focusToIndex >= 0 && ComposeFormulaCtrl.this.focusToIndex < ComposeFormulaCtrl.this.inputs.size()) {
                    focusIdx = ComposeFormulaCtrl.this.focusToIndex;
                } else if (ComposeFormulaCtrl.this.inputs.size() > 1) {
                    focusIdx = 0;
                }
                if (focusIdx >= 0) {
                    ComposeFormulaCtrl.this.inputs.get(focusIdx).focus();
                    ComposeFormulaCtrl.this.focusComponent = ComposeFormulaCtrl.this.inputs.get(focusIdx);
                }
            }
        });
    }

    @Listen(value="onOpen = #_composeFormulaDialog")
    public void onOpen$_composeFormulaDialog(Event evt) {
        this.metaInfo = (FormulaMetaInfo)evt.getData();
        this.formulaStart.setValue("=" + this.metaInfo.getFunction() + "(");
        this.description.setValue(this.metaInfo.getDescription());
        this.composeFormulaTextbox.setText(null);
        this.args = this.createArgs(this.metaInfo.getRequiredParameter(), this.metaInfo.getParameterNames());
        this.argsListbox.setModel(this.newListModelInstance(this.args));
        this.composeFormulaTextbox.focus();
    }

    protected SimpleListModel<ArgWrapper> newListModelInstance(List<ArgWrapper> functionArguments) {
        this.inputs.clear();
        this.focusComponent = null;
        return new SimpleListModel(functionArguments);
    }

    protected void moveFocusToNext(HtmlBasedComponent current) {
        for (int i = 0; i < this.inputs.size(); ++i) {
            InputElement c = this.inputs.get(i);
            if (c != current || i + 1 >= this.inputs.size()) continue;
            InputElement next = this.inputs.get(i + 1);
            next.focus();
            this.focusComponent = next;
            this.movedToNext = true;
            break;
        }
    }

    protected void composeFormula() {
        StringBuilder strBuilder = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.args.size(); ++i) {
            ArgWrapper curArg = this.args.get(i);
            String arg = curArg.getValue();
            if (first) {
                first = false;
            } else if (!first) {
                if (!"".equals(arg)) {
                    strBuilder.append(",");
                } else {
                    for (int j = i + 1; j < this.args.size(); ++j) {
                        String val = this.args.get(j).getValue();
                        if ("".equals(val)) continue;
                        strBuilder.append(",");
                        break;
                    }
                }
            }
            if ("".equals(arg)) continue;
            strBuilder.append(arg);
        }
        this.composeFormulaTextbox.setText(strBuilder.toString());
    }

    protected ArgWrapper createNextArg() {
        Integer num = null;
        String argName = this.metaInfo.getMultipleParameter();
        ArgWrapper last = this.args.get(this.args.size() - 1);
        try {
            Integer n = num = Integer.valueOf(Integer.parseInt(last.getName().replace(argName, "")));
            Integer n2 = num = Integer.valueOf(num + 1);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return new ArgWrapper(this.args.size(), this.metaInfo.getMultipleParameter() + (Serializable)(num != null ? num : ""), "");
    }

    protected void decomposeFormula() {
        String input = this.composeFormulaTextbox.getText();
        String[] arg = input.split(",");
        if (arg.length > this.args.size()) {
            if (this.metaInfo.isMultipleParameter()) {
                int diff = arg.length - this.args.size();
                for (int i = 0; i < diff; ++i) {
                    this.args.add(this.createNextArg());
                }
            } else {
                ZSMessagebox.show((String)"You've entered too many arguments for this function");
                return;
            }
        }
        for (int i = 0; i < this.args.size() && i < arg.length; ++i) {
            String val = arg[i].trim();
            this.args.get(i).setValue(val);
        }
        this.argsListbox.setModel(this.newListModelInstance(this.args));
    }

    protected List<ArgWrapper> createArgs(int numArg, String[] argNames) {
        LinkedList<ArgWrapper> ary = new LinkedList<ArgWrapper>();
        for (int i = 0; i < numArg; ++i) {
            ary.add(new ArgWrapper(i, argNames[i], ""));
        }
        return ary;
    }

    protected class ArgWrapper {
        Integer index;
        String name;
        String value;

        public ArgWrapper(Integer index, String name, String value) {
            this.index = index;
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

