/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.Validation;
import io.keikai.ui.ZSMessagebox;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class ValidationHelper {
    private boolean isEventThreadEnabled() {
        return Executions.getCurrent().getDesktop().getWebApp().getConfiguration().isEventThreadEnabled();
    }

    public boolean validate(Sheet sheet, int row, int col, String editText, final EventListener callback) {
        block9: {
            block11: {
                block10: {
                    Range range = Ranges.range((Sheet)sheet, (int)row, (int)col);
                    Validation dv = range.validate(editText);
                    if (dv == null) break block9;
                    if (!dv.isShowError() || callback == null) break block10;
                    String errTitle = dv.getErrorTitle();
                    Object errText = dv.getErrorMessage();
                    if (errTitle == null || errTitle.length() == 0) {
                        errTitle = Labels.getLabel((String)"zss.validation.warn_title");
                    }
                    if (errText == null || ((String)errText).length() == 0) {
                        errText = Labels.getLabel((String)"zss.validation.msg.invalid_value");
                    }
                    Validation.AlertStyle errStyle = dv.getAlertStyle();
                    switch (errStyle) {
                        case STOP: {
                            int n = ZSMessagebox.show((String)errText, (String)errTitle, (int)514, (String)"z-messagebox-icon z-messagebox-error", (int)512, (EventListener)new EventListener(){

                                public void onEvent(Event event) throws Exception {
                                    String evtname = event.getName();
                                    if ("onRetry".equals(evtname)) {
                                        ValidationHelper.this.retry(callback);
                                    } else if ("onCancel".equals(evtname)) {
                                        ValidationHelper.this.cancel(callback);
                                    }
                                }
                            });
                            break;
                        }
                        case WARNING: {
                            errText = (String)errText + "\n\nContinue?";
                            int btn = ZSMessagebox.show((String)errText, (String)errTitle, (int)50, (String)"z-messagebox-icon z-messagebox-exclamation", (int)32, (EventListener)new SerializableEventListener(){
                                private static final long serialVersionUID = -190628368458891084L;

                                public void onEvent(Event event) throws Exception {
                                    String evtname = event.getName();
                                    if ("onNo".equals(evtname)) {
                                        ValidationHelper.this.retry(callback);
                                    } else if ("onCancel".equals(evtname)) {
                                        ValidationHelper.this.cancel(callback);
                                    } else if ("onYes".equals(evtname)) {
                                        ValidationHelper.this.ok(callback);
                                    }
                                }
                            });
                            if (this.isEventThreadEnabled() && btn == 16) {
                                return true;
                            }
                            break block11;
                        }
                        case INFO: {
                            int btn = ZSMessagebox.show((String)errText, (String)errTitle, (int)3, (String)"z-messagebox-icon z-messagebox-information", (int)1, (EventListener)new SerializableEventListener(){
                                private static final long serialVersionUID = 631067465723387202L;

                                public void onEvent(Event event) throws Exception {
                                    String evtname = event.getName();
                                    if ("onCancel".equals(evtname)) {
                                        ValidationHelper.this.cancel(callback);
                                    } else if ("onOK".equals(evtname)) {
                                        ValidationHelper.this.ok(callback);
                                    }
                                }
                            });
                            if (!this.isEventThreadEnabled() || btn != 1) break;
                            return true;
                        }
                    }
                    break block11;
                }
                if (callback != null) {
                    this.cancel(callback);
                }
            }
            return false;
        }
        return true;
    }

    private void errorBoxCallback(EventListener callback, String eventname) {
        if (!this.isEventThreadEnabled() && callback != null) {
            try {
                callback.onEvent(new Event(eventname, null));
            }
            catch (Exception e) {
                throw UiException.Aide.wrap((Throwable)e);
            }
        }
    }

    private void ok(EventListener callback) {
        this.errorBoxCallback(callback, "onOK");
    }

    private void retry(EventListener callback) {
        this.errorBoxCallback(callback, "onRetry");
    }

    private void cancel(EventListener callback) {
        this.errorBoxCallback(callback, "onCancel");
    }
}

