/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.rt;

import io.keikai.model.SBook;
import io.keikai.ui.Spreadsheet;
import io.keikaiex.license.LicenseContent;
import io.keikaiex.rt.Runtime;
import io.keikaiex.rt.RuntimeLicenseManager;
import io.keikaiex.util.ObfuscatedString;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URL;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.util.Dates;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zk.ui.util.DesktopInit;
import org.zkoss.zk.ui.util.EventInterceptor;
import org.zkoss.zk.ui.util.ExecutionInit;
import org.zkoss.zul.Window;

public final class SpreadsheetRuntime
extends Runtime {
    private static final String KEIKAI_SPREADSHEET = new ObfuscatedString(new long[]{3492045200476335616L, 7717980393200929659L, -5112061581507660908L, 4482153153239237402L}).toString();
    public static final String WARNING_EVALUATION = new ObfuscatedString(new long[]{6474417859144188937L, -79630867819981082L, -2352615356916913353L, -4665805703836279514L, 8398584646328453736L, -439266808184147732L, -1444031853405758646L, 1842014563486720175L, -122768890121946648L, -8213074304132094556L, 6072787997629083505L, -821392785569179434L, -4124933100554687472L, 5054840766485315857L, 7992903148166748896L, 6044587195064631975L, -6441784025247379389L, -5790161064072639979L, -1502375441262579700L, 8517357617189814197L, 6446013189220730022L, 6292152553166066626L, 6905370552351686999L, 5669795191026614893L, 7732079101224498364L, -1068323923358030020L, -465436783832050953L, -5162477392386321949L, -3965910906166337235L, -5965898153125715553L, -9002724234313418898L, 6844805868326393448L, -6809063663897871355L, -3184036866345274969L, -1912992238507740853L, -2765321451561733483L, -5940585072251153255L, -7628599241705452859L, 3818753120161681624L, -915541275845379549L, -522801737256123582L, -5201329559400164281L, 4539793303027742885L, 3167017128177201538L, 4571028288672676024L, -329812782300967616L, -8105289638881295850L}).toString();
    public static final String WARNING_INVALID_FILE = new ObfuscatedString(new long[]{485018505826941665L, -8287466788076412611L, -7489107168967723771L, 4053347836355534074L, -6597642572800619853L, 2750774101148970376L, -680587721395206770L, 8705402038749261939L, -601426957874671892L, 7855003904695883421L, 6496267665050414733L, 3005942882678639167L, 1928830378064181738L, -710714871600333227L, 7070429624300325874L, 5611639121551310663L, -452482665008998020L, -1198627335812037753L, -8661864954420739072L, 8075404165277640306L, 3442087085821187058L, -1664813163795944852L, 608048881764915666L, 8415598803887245325L, -8573801289885407269L, -3476284742020531995L, -2804817643210669983L}).toString();
    private static final String PROPRIETARY_GENERIAL_LICENSE_MESSAGE = new ObfuscatedString(new long[]{-5553493411414923332L, -7313052943753991587L, 5700120888683411338L, -785715105224949036L, 5216353639891330162L, -3545779667079278115L, 2434761381750680559L, -1764179466641465060L, 5842770572186259036L, 2529549534127742974L, -522203529390476593L, -5949894917737070900L, -5828661509486491439L, -85237194638728785L, 3000940008225144333L, 8479262343758868027L, -8272256120720180772L, 4899321052808235893L, -8209225430693385816L, 2313111741546516323L, 3141546184292609944L, 8553321555480188938L, -4647613885928642906L, -2499413895251342404L, 3839292801354688790L, 1537563975080366318L, 8016018497913880074L, 5153256263753600947L, -4192522156053312915L, 1608741622877503652L, -5988327854149336922L, 3875549626866930522L, -4061280508751629563L, -3371894252058552703L, -4873494299394821698L, 1839049157956607822L, -7874416535143730960L, 1990165322886295214L, -350654778302852771L, 4716623622602362359L, 5551287202942340249L, -9209650497269799112L, -7439905252039640085L, -4805239643105068540L, -7346847183337497063L, 6028779839909854602L, 1290215395347605049L, -522606693104503100L, -7888211248080321848L, -4910521188704555530L, 8148371733257370833L, -7019604763736849313L}).toString();
    private static WebApp _wapp;

    public static final Object init(Object obj) {
        SpreadsheetRuntime.init0((Object)obj);
        return null;
    }

    protected void refresh(List content) {
        SpreadsheetRuntime.init1().init2(content);
    }

    protected Class getInitClass() {
        return Init.class;
    }

    private static Init1 init1() {
        return Init1._init1;
    }

    protected boolean init1(WebApp wapp) throws Exception {
        _wapp = wapp;
        wapp.getConfiguration().addListener(Init.class);
        String dir = Library.getProperty((String)LICENSE_DIRECTORY_PROPERTY);
        boolean isScheduled = false;
        URL url = dir != null ? SpreadsheetRuntime.getURLFromString((String)dir) : LOCATOR.getResource(DEFAULT_LICENSE_DIRECTORY);
        RuntimeLicenseManager licenseManager = SpreadsheetRuntime.getLicenseManager();
        if (url != null) {
            isScheduled = licenseManager.install(url);
        }
        if (isScheduled) {
            licenseManager.setWapp(wapp);
            licenseManager.startScheduler();
            return true;
        }
        SpreadsheetRuntime.init1().init2(null);
        return false;
    }

    protected String getEvalNotice(WebApp wapp) {
        StringBuffer sb = new StringBuffer();
        Object o = wapp.getAttribute(ZK_NOTICE);
        if (o != null) {
            sb.append(o);
        }
        sb.append(" -->\n").append("<!-- ").append(KEIKAI_SPREADSHEET).append(" ").append("7.0.0.FL.20250124").append(" EE ");
        sb.append(EVAL_ONLY);
        return sb.toString();
    }

    public boolean isTargetSubject(String subject) {
        return super.isTargetSubject(subject) || KEIKAI_SPREADSHEET.equals(subject);
    }

    private static final class Init1 {
        private static final int FREQ = 3;
        private static final String WIN = new ObfuscatedString(new long[]{5321153595986820916L, 6399668227042605266L, -5602491487233658872L, 2066377234886365691L, 203726272017906087L, -3409963818121804467L, -290525610284193589L, 5360349214446654186L, 7126235572874868104L, 6443646263932522040L, -2888496393462639896L}).toString() + new ObfuscatedString(new long[]{6921657600520372678L, -4575948870782774696L, 4221580251685570411L, -510563537050951539L, 8456565494816058089L, -6930610067922344473L, 4629707553130722019L, 191145924686274079L, 3411837546479170530L, -1932732916072241919L, 5686494521924525806L, 5528865032055765232L, 6466144439614722608L, 8296865573287296149L, -3165502347254575780L, -9006723350381131858L, -3299584661174396972L, -4973390557733357431L}).toString();
        private static final String FORMULA_ENGINE = new ObfuscatedString(new long[]{-6131476020187046753L, -8268802152593966790L, -7439850476515704791L, 6604881965127523665L, -8455313925777508778L, 8734122636353765665L}).toString();
        private static final String FORMULA_ENGINE_IMPL = new ObfuscatedString(new long[]{6108920021672579085L, -5740063295444972586L, 3037959855215467867L, -3886132953806305564L, -791939017134557770L, 3521973135808996050L}).toString();
        private static final String FUNCTION_RESOLVER = new ObfuscatedString(new long[]{-786830587436030691L, 6213157560452306044L, 8950305048121883936L, 1708603164212547111L, -5004492509794470974L, -4718998614656722699L}).toString();
        private static final String FUNCTION_RESOLVER_IMPL = new ObfuscatedString(new long[]{4620429927157195829L, -3180228976728250854L, 7850308316324301137L, 2523184151368293491L, 8597891033134053112L, 1184881626616748004L}).toString();
        private static final String INPUT_ENGINE = new ObfuscatedString(new long[]{6841380360457158316L, -1824686442535407091L, 7302277737679605526L, 1904499141868746141L, 2468704016641561190L, 83217363078101444L}).toString();
        private static final String INPUT_ENGINE_IMPL = new ObfuscatedString(new long[]{6871140834786488794L, -4737832696920811583L, 2408571797660082328L, 9021763325960975594L, 8924315879439396577L, 3446312332439344509L}).toString();
        private static final String FORMAT_ENGINE = new ObfuscatedString(new long[]{490225798753773099L, 7395078584154927541L, -8387807653529481577L, -1937598314987840407L, 8759276434657239188L, 7661071970596189926L}).toString();
        private static final String FORMAT_ENGINE_IMPL = new ObfuscatedString(new long[]{-7068885365691304440L, -2678048486213769241L, 7489414946215478538L, 4685210538310695684L, -1709106819787307778L, -7281723262545167886L}).toString();
        private static final String DEPENDENCY_TABLE = new ObfuscatedString(new long[]{-6320807108257430112L, -8147455023094683927L, -6025622075706238420L, -3276233211945661452L, 9216748586802002157L, -8822498688478469455L}).toString();
        private static final String DEPENDENCY_TABLE_IMPL = new ObfuscatedString(new long[]{8763165127264652314L, 1109577603035088858L, -479213934034187588L, -6657448911425939973L, 2808013277152888178L, -2841011168674596452L}).toString();
        private static final String BOOK_SERIES_BUILDER = new ObfuscatedString(new long[]{2505675289678714284L, 7060403217348981720L, 4873006613630408278L, -2387943394255144583L, -9083602605769743093L, 4855689089149744857L}).toString();
        private static final String BOOK_SERIES_BUILDER_IMPL = new ObfuscatedString(new long[]{724327199028060210L, -8286164492331689481L, -4784746272186733529L, 693826202676066742L, -4538661178650722804L, -5093241818872992953L, 1995644540461407497L}).toString();
        private static final String EXPORTER_FACTORY = new ObfuscatedString(new long[]{3586507011103761902L, 8693556607047408592L, 4363889743548637222L, 5119576262902423520L, 4146613084141956785L, 2336420004092411714L, -1694150254454317442L}).toString();
        private static final String EXPORTER_FACTORY_IMPL = new ObfuscatedString(new long[]{-6074409127634753799L, 809945425853171130L, -7607602411260436887L, 7637124899657102419L, 3847928165382374801L, 3456410121323983308L, 6629998812323595621L}).toString();
        private static final String FUNCTIONS = new ObfuscatedString(new long[]{6568550159507488578L, 54690525497190339L, -1893228893017433375L, 7883574809824165453L, -4963498694827771314L, -3842222316993220450L}).toString();
        private static final String FUNCTIONS_IMPL = new ObfuscatedString(new long[]{6581805006174430532L, -4031259957359849067L, 2162646447898873795L, -3394868670089915495L, 3981239501322637289L, -622429275255017198L, 8374122384753499602L, -661684930601083595L, -7513344239799222602L, -1504401621631217279L, -5013193990667311866L, -580037556757677245L}).toString();
        private static final String WIDGET_HANDLER = new ObfuscatedString(new long[]{6491034391775744676L, 4596198467483379840L, -8936392666001984481L, -7011522195634475261L, -8363170176670102114L, 3749458265683220063L}).toString();
        private static final String WIDGET_HANDLER_IMPL = new ObfuscatedString(new long[]{-4523261798449597426L, -1751362051689400568L, -80004863137134817L, -7060706843747870486L, 1103194503959886443L, -6576031878853388661L, 3405917418062252981L}).toString();
        private static final String WIDGET_LOADER = new ObfuscatedString(new long[]{3465780624263577954L, 8755506324744715042L, -4952905214478111910L, -1713343135106120635L, 8388419988126112725L, -726287567023470801L}).toString();
        private static final String WIDGET_LOADER_IMPL = new ObfuscatedString(new long[]{1862171262473033204L, -3925159010099579995L, 4249132581379010290L, 4450098164799642248L, -3480826638317228638L, -6693319882349086039L, -1891512696633584115L}).toString();
        private static final String COLLABORATION_INFO = new ObfuscatedString(new long[]{-2372594633273168953L, -5683706986475841834L, 4145831438542450736L, -5172633351141066763L, -4206299107808277831L, 2796521143873681405L}).toString();
        private static final String COLLABORATION_INFO_IMPL = new ObfuscatedString(new long[]{-8320746905711319444L, 6394689063088599130L, -9093727858472694085L, 6568371981804206406L, -5646470901294989226L, -4891051880608466177L}).toString();
        private static final String BOOK_MANAGER = new ObfuscatedString(new long[]{-4492036932993872662L, -7936844024543334909L, -8990740045249330254L, -8316239870549361821L, 497333884653340434L}).toString();
        private static final String BOOK_MANAGER_IMPL = new ObfuscatedString(new long[]{7039295775789350411L, -6050563348985028854L, 1075549696772583293L, 4013975703136770449L, -640933264515726128L, 5138791150373960965L}).toString();
        private static final String ZSS_FORMULA_ENGINE = new ObfuscatedString(new long[]{-6946940861330031386L, -8200137308179568909L, 5015398788645700413L, -6979074645241798869L, 6586954149477648878L, -5741372767674611000L}).toString();
        private static final String ZSS_FORMULA_ENGINE_IMPL = new ObfuscatedString(new long[]{-2418284299785054334L, 1479105741032879169L, 2328236503429654979L, 7851089442375934165L, -5116229586923382654L, 6258337476103361659L}).toString();
        private static final String ZSS_FUNCTION_RESOLVER = new ObfuscatedString(new long[]{3650953078381263648L, -7978655657373329998L, -7486081239882828487L, -956655162816755011L, 4587601644781096426L, -2328435719969713472L, 583188415702729932L}).toString();
        private static final String ZSS_FUNCTION_RESOLVER_IMPL = new ObfuscatedString(new long[]{1648457497419151688L, 8456168057038146110L, 2205843546792627726L, -8038274678378822470L, -3972581075115221739L, 8469001692587560038L, -8519618469700958897L}).toString();
        private static final String ZSS_INPUT_ENGINE = new ObfuscatedString(new long[]{-931412080651447429L, -2055834186773257475L, -8011132451221589479L, 5555998867388127954L, -3161772536799947629L, 3635875618518348542L}).toString();
        private static final String ZSS_INPUT_ENGINE_IMPL = new ObfuscatedString(new long[]{-8959061905895715875L, -2265342681464092655L, 260510642187775533L, -2252386011354313474L, -4171484185930598836L, 2539947456575506063L}).toString();
        private static final String ZSS_FORMAT_ENGINE = new ObfuscatedString(new long[]{-2401652482032534366L, -3046938802125867004L, 1278639711772216543L, 3676625948132157593L, -5779895277431052001L, 2945745365308467258L}).toString();
        private static final String ZSS_FORMAT_ENGINE_IMPL = new ObfuscatedString(new long[]{2058533714989388999L, 1240462844075496329L, -3827825748625893749L, 9214539179771015984L, -2489687719096603335L, 2041604616195072328L}).toString();
        private static final String ZSS_DEPENDENCY_TABLE = new ObfuscatedString(new long[]{-8145808397458727123L, 7625417198796453223L, 9192041283260267711L, -6461281780926281457L, 2443594485959161007L, -4013849357635972074L, 5658558958552972669L}).toString();
        private static final String ZSS_DEPENDENCY_TABLE_IMPL = new ObfuscatedString(new long[]{2025156744566483326L, -2859139903578907317L, 5070673593399870370L, -1696396763022181727L, -3785486508994960809L, -4461020806979579057L, 3713786845604742609L}).toString();
        private static final String ZSS_BOOK_SERIES_BUILDER = new ObfuscatedString(new long[]{4400999526834038266L, 6680169581966688822L, -824020121173969257L, -2005943408017573892L, -3284079652096457332L, 5855883971906819748L, -5857099058607209459L}).toString();
        private static final String ZSS_BOOK_SERIES_BUILDER_IMPL = new ObfuscatedString(new long[]{-5726508211724793893L, 8569992118082504769L, 9181478058935831292L, 7086305829456764418L, 7742005198616659484L, -6440406587327967888L, 1624927702067762223L}).toString();
        private static final String ZSS_EXPORTER_FACTORY = new ObfuscatedString(new long[]{-4472343079140613160L, 7867973633219393851L, -5503447674221945233L, -262016254903301586L, 2049687033864576615L, -3887098640313149202L, 6848988432547480775L, -7221212047718775950L}).toString();
        private static final String ZSS_EXPORTER_FACTORY_IMPL = new ObfuscatedString(new long[]{3590763058016225734L, 493700663196015039L, 6092765942829109086L, -145160051114152404L, 8687165099806515870L, -9142161292280721010L, -1683109134765802500L, 3298554575513285863L, 3369350718315707033L, -7298225110369326910L, -4824650480167033094L, 572408024759060548L, 2590476670503222817L, -3780751709081089808L, -4269615409217637680L}).toString();
        private static final String ZSS_FUNCTIONS = new ObfuscatedString(new long[]{-9107950682079466537L, 6044098016258491637L, 4752071218608557149L, -1415194819165792974L, 1037012558002603534L, -286936863091228478L}).toString();
        private static final String ZSS_FUNCTIONS_IMPL = new ObfuscatedString(new long[]{4840889417712456605L, -932238802067396981L, 1643890773373654566L, -4649133848658165041L, 5968888824247950491L, -7413278661051192632L, 2152792200966762843L, -7577240830758492503L, -6433816155231039363L, 8826133207976952688L}).toString();
        private static final String ZSS_WIDGET_HANDLER = new ObfuscatedString(new long[]{-4996559347472087276L, -7766264256509841091L, 4421449018288163029L, 1989371856569290729L, 6120813221538358633L, -4795921775128256392L}).toString();
        private static final String ZSS_WIDGET_HANDLER_IMPL = new ObfuscatedString(new long[]{7936749289072989851L, 8075841980845954183L, 3847322226299015273L, 6066080613497293258L, 1620474641933788511L, -1548118456145909793L, -1418230738701484438L}).toString();
        private static final String ZSS_WIDGET_LOADER = new ObfuscatedString(new long[]{5817538321180584438L, 8865508355996080707L, 4886347968546669731L, 435526161500103674L, -8511131547026821770L, 5742632421264337498L}).toString();
        private static final String ZSS_WIDGET_LOADER_IMPL = new ObfuscatedString(new long[]{-933027784286545804L, -6380004711020883432L, -8028339963317745976L, 1225777306763359407L, 7409495186831786856L, -241248085354424324L, -5246784403500936783L, 2337188762834458524L}).toString();
        private static final String ZSS_COLLABORATION_INFO = new ObfuscatedString(new long[]{6609985539045913517L, -7806509702042079265L, -7985430971696696309L, 169649755274334333L, 7220989136668860432L, -775303611877889185L, -1158252024843988159L}).toString();
        private static final String ZSS_COLLABORATION_INFO_IMPL = new ObfuscatedString(new long[]{-1930734336736684125L, -8532538895801731713L, 1562440231182499454L, 374758613200881930L, -4879103419565109702L, 2463192263093190843L, -3146948788344009429L}).toString();
        private static final String ZSS_BOOK_MANAGER = new ObfuscatedString(new long[]{540039779476135912L, -6887844160691566879L, -7526819903489713807L, 7876950768159910948L, -7748166478087260388L, -4082959779201688241L}).toString();
        private static final String ZSS_BOOK_MANAGER_IMPL = new ObfuscatedString(new long[]{-7792783928435753781L, -1967690361683164696L, 6372868219684568579L, 1429518277699547683L, 1039044593504860453L, 6736897398345129332L}).toString();
        private static final Init1 _init1 = new Init1();
        private boolean _stoplicense;
        private boolean _stopuptime;
        private int _inModal;
        private final long _uptime = new Date().getTime();
        private final Init2 _init2;
        private static final String TITLE = new ObfuscatedString(new long[]{6290325967589686282L, 5925669707962544096L}).toString();
        private static final String BORDER = new ObfuscatedString(new long[]{1517003640222100403L, -5881717338632855477L}).toString();
        private static final String MODE = new ObfuscatedString(new long[]{2063230648775789892L, -7765346573662599107L, -3183841938540764871L}).toString();
        private static final String WIDTH = new ObfuscatedString(new long[]{-2028303217529921622L, 6478417485293582031L}).toString();
        private static final String HEIGHT = new ObfuscatedString(new long[]{2974696421778732584L, -3701582788618461277L}).toString();
        private static final String ARG = new ObfuscatedString(new long[]{3689490926743112102L, -8583085698292004623L}).toString();
        private static final String UPTIME_EXP = new ObfuscatedString(new long[]{-2495880839348045988L, 3758354321540840170L, -3315965715483925116L, -4776589253426448994L, -4912530410303730838L, 904718296569634775L, 3451987661542177886L, -9012396269328658718L}).toString();
        private static final String TRIAL_EXP = new ObfuscatedString(new long[]{-7339619207810516640L, 3977507256170363151L, 6227813766300052990L, 6717748079053216432L, -6989758167627231511L, -4248622340795042932L, -7088995007697574950L}).toString();
        private static final String SESSION_EXP = new ObfuscatedString(new long[]{-4083799257044144854L, 3974096633588144702L, 6008831202399225401L, -8934204754208770612L, 9009274603031364021L, -4564384023597405357L, 2718955806787985501L, -1053847287775614812L}).toString();
        private static final String UPTIME_INFO = new ObfuscatedString(new long[]{-140629977948033438L, 8411039821423448906L, -3474650949739896324L, 2772224587032503194L}).toString();
        private static final String SESSION_INFO = new ObfuscatedString(new long[]{-282132617423556107L, 2757430579228438986L, -2300236627084260024L, 5486533064596330289L}).toString();
        private static final String LIC_INFO = new ObfuscatedString(new long[]{-1327671782532263310L, 840490956016971870L, 3061901067660749900L}).toString();
        private static final String MASK_HEAD = new ObfuscatedString(new long[]{2610432342261686015L, 2813741495629532862L, -1181939021078443460L, -7375419926652952589L}).toString();
        private static final String MASK_BODY = new ObfuscatedString(new long[]{-776441849887137687L, -9143613716996647403L, 4380415369023607826L, 1307662236470395652L, -689297554901065354L, -4590698981075227578L, 8398261592963428925L, -2272630810702424214L, 5009103648726399196L, -176307024327010546L}).toString();
        private static final String MASK_FOOT = new ObfuscatedString(new long[]{-803157185601949932L, 266945924523900789L, -1437607448989205798L}).toString();

        private Init1() {
            if (Classes.existsByThread((String)FORMULA_ENGINE_IMPL)) {
                Library.setProperty((String)FORMULA_ENGINE, (String)FORMULA_ENGINE_IMPL);
                Library.setProperty((String)FUNCTION_RESOLVER, (String)FUNCTION_RESOLVER_IMPL);
                Library.setProperty((String)INPUT_ENGINE, (String)INPUT_ENGINE_IMPL);
                Library.setProperty((String)FORMAT_ENGINE, (String)FORMAT_ENGINE_IMPL);
                Library.setProperty((String)DEPENDENCY_TABLE, (String)DEPENDENCY_TABLE_IMPL);
                Library.setProperty((String)BOOK_SERIES_BUILDER, (String)BOOK_SERIES_BUILDER_IMPL);
                Library.setProperty((String)EXPORTER_FACTORY, (String)EXPORTER_FACTORY_IMPL);
                Library.setProperty((String)FUNCTIONS, (String)FUNCTIONS_IMPL);
                Library.setProperty((String)WIDGET_HANDLER, (String)WIDGET_HANDLER_IMPL);
                Library.setProperty((String)WIDGET_LOADER, (String)WIDGET_LOADER_IMPL);
                Library.setProperty((String)BOOK_MANAGER, (String)BOOK_MANAGER_IMPL);
                Library.setProperty((String)COLLABORATION_INFO, (String)COLLABORATION_INFO_IMPL);
            } else {
                Library.setProperty((String)ZSS_FORMULA_ENGINE, (String)ZSS_FORMULA_ENGINE_IMPL);
                Library.setProperty((String)ZSS_FUNCTION_RESOLVER, (String)ZSS_FUNCTION_RESOLVER_IMPL);
                Library.setProperty((String)ZSS_INPUT_ENGINE, (String)ZSS_INPUT_ENGINE_IMPL);
                Library.setProperty((String)ZSS_FORMAT_ENGINE, (String)ZSS_FORMAT_ENGINE_IMPL);
                Library.setProperty((String)ZSS_DEPENDENCY_TABLE, (String)ZSS_DEPENDENCY_TABLE_IMPL);
                Library.setProperty((String)ZSS_BOOK_SERIES_BUILDER, (String)ZSS_BOOK_SERIES_BUILDER_IMPL);
                Library.setProperty((String)ZSS_EXPORTER_FACTORY, (String)ZSS_EXPORTER_FACTORY_IMPL);
                Library.setProperty((String)ZSS_FUNCTIONS, (String)ZSS_FUNCTIONS_IMPL);
                Library.setProperty((String)ZSS_WIDGET_HANDLER, (String)ZSS_WIDGET_HANDLER_IMPL);
                Library.setProperty((String)ZSS_WIDGET_LOADER, (String)ZSS_WIDGET_LOADER_IMPL);
                Library.setProperty((String)ZSS_BOOK_MANAGER, (String)ZSS_BOOK_MANAGER_IMPL);
                Library.setProperty((String)ZSS_COLLABORATION_INFO, (String)ZSS_COLLABORATION_INFO_IMPL);
            }
            this._init2 = new Init2();
        }

        private void init2(List contents) {
            this._init2.init2(contents);
            Runtime._pass.set(!this._init2._keys.isEmpty());
        }

        private final void init2(Execution exec, Execution parent) {
            Runtime.token0((Object)exec, (Object)exec);
        }

        private final void afterProcessEvent0(Event event) {
            if (!this.validate(event)) {
                ++this._inModal;
            }
        }

        private final Event beforePostEvent0(Event event) {
            return event;
        }

        private final Event beforeProcessEvent0(Event event) {
            Component comp = event.getTarget();
            if (comp instanceof Spreadsheet) {
                if (this._stopuptime) {
                    this.maskSheetUptime(comp.getUuid());
                    return null;
                }
                if (this._stoplicense) {
                    this.maskSheetLicense(comp.getUuid());
                    return null;
                }
            }
            return event;
        }

        private final Event beforeSendEvent0(Event event) {
            return event;
        }

        private final void init0(Desktop desktop, Object request) {
            Runtime.initToken((Desktop)desktop);
            Init init = new Init();
            desktop.setAttribute(Runtime.token1((Object)desktop), (Object)init);
            desktop.addListener((Object)init);
        }

        private final void cleanup0(Desktop desktop) {
            Object init = desktop.getAttribute(Runtime.token1((Object)desktop));
            desktop.removeListener(init);
        }

        private final boolean validate(Event event) {
            return !this.validUptime(event) || !this.validLicense(event);
        }

        private final boolean validLicense(Event event) {
            if (this._init2._keys.isEmpty()) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (((Date)this._init2._validbegin).getTime() > time || time > ((Date)this._init2._validend).getTime()) {
                this.complainLicense(event);
                return false;
            }
            return true;
        }

        private final boolean validUptime(Event event) {
            if (this._init2._keys.isEmpty() || this._init2._uptime == null) {
                this.complainLicense(event);
                return false;
            }
            long time = new Date().getTime();
            if (this._uptime > time || time > this._uptime + (Long)this._init2._uptime) {
                this.complainUptime(event);
                return false;
            }
            return true;
        }

        private final void showWin(Page pg, String message) {
            Window win = new Window(TITLE, BORDER, true);
            win.setMode(MODE);
            win.setWidth(WIDTH);
            win.setHeight(HEIGHT);
            win.setPage(pg);
            HashMap<String, String> arg = new HashMap<String, String>();
            arg.put(ARG, message);
            Component[] comps = Executions.getCurrent().createComponentsDirectly(WIN, "zul", arg);
            for (int j = 0; j < comps.length; ++j) {
                comps[j].setParent((Component)win);
            }
        }

        private final void complainLicense(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stoplicense && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Spreadsheet && (pg = comp.getPage()) != null) {
                this.showWin(pg, TRIAL_EXP);
                this._stoplicense = true;
                this.maskSheetLicense(comp.getUuid());
                SBook book = ((Spreadsheet)comp).getSBook();
                if (book != null) {
                    book.setShareScope("disable");
                }
            }
        }

        private final void complainUptime(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if (!this._stopuptime && (this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Spreadsheet && (pg = comp.getPage()) != null) {
                this.showWin(pg, UPTIME_EXP);
                this._stopuptime = true;
                this.maskSheetUptime(comp.getUuid());
                SBook book = ((Spreadsheet)comp).getSBook();
                if (book != null) {
                    book.setShareScope("disable");
                }
            }
        }

        private final void complainSession(Event event) {
            Page pg;
            Component comp;
            ++this._inModal;
            if ((this._inModal & 3) == 0 && (comp = event.getTarget()) instanceof Spreadsheet && (pg = comp.getPage()) != null) {
                this.showWin(pg, SESSION_EXP);
                this.maskSheetSession(comp.getUuid());
            }
        }

        private final void maskSheetUptime(String uuid) {
            this.maskSheet(uuid, UPTIME_INFO);
        }

        private final void maskSheetSession(String uuid) {
            this.maskSheet(uuid, SESSION_INFO);
        }

        private final void maskSheetLicense(String uuid) {
            this.maskSheet(uuid, LIC_INFO);
        }

        private final void maskSheet(String uuid, String txt) {
            Clients.evalJavaScript((String)("zk.afterMount(function(){" + MASK_HEAD + uuid + MASK_BODY + txt + MASK_FOOT + "});"));
        }
    }

    private static final class Init2 {
        private static final BigInteger _pkey = new BigInteger("123");
        private static final String EVAL_LIC_ID = new ObfuscatedString(new long[]{-2799362229550136139L, -8991339801923478651L, 2054766831045471090L}).toString();
        private static final String EVAL_LIC_VER = new ObfuscatedString(new long[]{4515837249784318634L, -483965117545718936L}).toString();
        private static final String EVAL_USER_NAME = new ObfuscatedString(new long[]{6700787382705499563L, 2359114071391082446L, 1949693015831576717L}).toString();
        private static final String EVAL_COMPANY_ID = new ObfuscatedString(new long[]{8997629646135421336L, -7459597106373371040L, 3324566901651534592L}).toString();
        private static final String EVAL_COMPANY_NAME = new ObfuscatedString(new long[]{-7105953592593293452L, -8116579615415252408L, -3117127378177258899L, 9036340616621476990L}).toString();
        private static final Long EVAL_SESSION_COUNT = Long.MAX_VALUE;
        private SimpleDateFormat _dateFormat = new SimpleDateFormat("MMMM dd, yyyy", Locale.US);
        private Calendar _calendar = Calendar.getInstance();
        private Map _keys = new HashMap();
        private Object _licid;
        private Object _licversion;
        private Object _username;
        private Object _companyid;
        private Object _companyname;
        private Object _validbegin;
        private Object _validend;
        private Object _sessioncount;
        private Object _zssversion;
        private Object _uptime;

        private Init2() {
        }

        private Date getNotBefore(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(Runtime.ISSUE_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MAX_VALUE);
            }
        }

        private Date getExpiryDate(Map map) {
            try {
                return this._dateFormat.parse((String)map.get(Runtime.EXPIRY_DATE));
            }
            catch (ParseException e) {
                return new Date(Long.MIN_VALUE);
            }
        }

        private long getSessionCount(LicenseContent lc) {
            return "Session".equalsIgnoreCase(lc.getConsumerType()) ? (long)lc.getConsumerAmount() : 0L;
        }

        private long getUpTime(Map map) {
            Long utime = (Long)map.get(Runtime.UP_TIME);
            return utime == null ? 0L : utime;
        }

        private void init2(List contents) {
            if (contents == null) {
                this.installEval();
                return;
            }
            String zssuid = "7.0.0.FL.20250124";
            Date today = Dates.today();
            boolean valid = false;
            Date mindate = new Date(Long.MAX_VALUE);
            Date maxdate = new Date(Long.MIN_VALUE);
            Date maxIssueDate = new Date(Long.MIN_VALUE);
            long sessionCount = 0L;
            long uptime = 0L;
            String machine = (String)_wapp.getAttribute(Runtime.ACTIVE_CODE);
            for (LicenseContent lc : contents) {
                Object mapobj = lc.getExtra();
                if (!(mapobj instanceof Map)) continue;
                Map map = (Map)mapobj;
                Date bdate = this.getNotBefore(map);
                Date edate = this.getExpiryDate(map);
                if (today.before(bdate) || today.after(edate)) continue;
                if (bdate.before(mindate)) {
                    mindate = bdate;
                }
                if (edate.after(maxdate)) {
                    maxdate = edate;
                }
                String activecode = (String)map.get(Runtime.ACTIVE_CODE);
                Date issueDate = lc.getIssued();
                if (!issueDate.after(maxIssueDate) || !Runtime.UNIVERSAL_ACTIVE_CODE.equals(activecode) && (machine == null || !machine.equals(activecode))) continue;
                valid = true;
                maxIssueDate = issueDate;
                this._zssversion = map.get(Runtime.VERSION);
                this._username = map.get(Runtime.USER_NAME);
                this._companyid = map.get(Runtime.COMPANY_ID);
                this._companyname = map.get(Runtime.COMPANY_NAME);
                this._keys = map;
                this._licid = map.get(Runtime.VERIFICATION_NUMBER);
                this._licversion = map.get(Runtime.LICENSE_VERSION);
                sessionCount += this.getSessionCount(lc);
                long utime = this.getUpTime(map);
                if (uptime >= utime) continue;
                uptime = utime;
            }
            if (valid) {
                this._validbegin = mindate;
                this._validend = maxdate;
                this._uptime = uptime <= 0L ? Long.valueOf(maxdate.getTime() - mindate.getTime() + (long)new SecureRandom(Runtime.longToByteArray((long)new Date().getTime())).nextInt(1800000)) : uptime;
                Object object = this._sessioncount = sessionCount > 0L ? Long.valueOf(sessionCount) : EVAL_SESSION_COUNT;
            }
            if (!valid || !this.validateLicenseFile()) {
                this.installEval();
            }
        }

        private final void installEval() {
            this._username = EVAL_USER_NAME;
            this._companyid = EVAL_COMPANY_ID;
            this._companyname = EVAL_COMPANY_NAME;
            this._validbegin = new Date();
            this._uptime = (long)(43200000 + new SecureRandom(Runtime.longToByteArray((long)new Date().getTime())).nextInt(1800000));
            this._validend = new Date(((Date)this._validbegin).getTime() + (Long)this._uptime + 3600000L);
            this._sessioncount = EVAL_SESSION_COUNT;
            this._keys = new HashMap();
            this._keys.put(Runtime.COMPANY_ID, this._companyid);
        }

        private final boolean validateLicenseFile() {
            return this._licid != null && this._licversion != null && this._username != null && this._companyid != null && this._companyname != null && this._validbegin != null && this._validend != null && this._sessioncount != null && this._zssversion != null && this._uptime != null;
        }

        private final String encode(byte[] lic) {
            try {
                return new String(lic, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }

        private final byte[] decryption(byte[] lic) {
            return lic;
        }
    }

    protected static abstract class Init0
    implements ExecutionInit,
    DesktopInit,
    DesktopCleanup,
    EventInterceptor {
        private Init0() {
            this.init1();
        }

        private final void init0(Desktop desktop, Object request) throws Exception {
            this.init1().init0(desktop, request);
        }

        private final void cleanup0(Desktop desktop) throws Exception {
            this.init1().cleanup0(desktop);
        }

        private final void init2(Execution exec, Execution parent) throws Exception {
            this.init1().init2(exec, parent);
        }

        private final Init1 init1() {
            return Init1._init1;
        }

        private final void afterProcessEvent0(Event event) {
            this.init1().afterProcessEvent0(event);
        }

        private final Event beforePostEvent0(Event event) {
            return this.init1().beforePostEvent0(event);
        }

        private final Event beforeProcessEvent0(Event event) {
            return this.init1().beforeProcessEvent0(event);
        }

        private final Event beforeSendEvent0(Event event) {
            return this.init1().beforeSendEvent0(event);
        }
    }

    public static final class Init
    extends Init0 {
        public void init(Desktop desktop, Object request) throws Exception {
            super.init0(desktop, request);
        }

        public void init(Execution exec, Execution parent) throws Exception {
            super.init2(exec, parent);
        }

        public void cleanup(Desktop desktop) throws Exception {
            super.cleanup0(desktop);
        }

        public void afterProcessEvent(Event event) {
            super.afterProcessEvent0(event);
        }

        public Event beforePostEvent(Event event) {
            return super.beforePostEvent0(event);
        }

        public Event beforeProcessEvent(Event event) {
            return super.beforeProcessEvent0(event);
        }

        public Event beforeSendEvent(Event event) {
            return super.beforeSendEvent0(event);
        }
    }
}

