/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.model.sys;

import io.keikai.model.sys.dependency.Ref;
import io.keikaiex.model.sys.ColTracker;
import io.keikaiex.util.Interval;
import io.keikaiex.util.IntervalTree;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashSet;

class RowTracker
implements Serializable {
    private static final long serialVersionUID = 1624759978398776608L;
    private final IntervalTree<ColTracker> _rowIntervalTree;
    private final int _maxRowLimit;
    private final int _maxColLimit;

    RowTracker(int maxRowLimit, int maxColLimit) {
        this._rowIntervalTree = new IntervalTree(maxRowLimit);
        this._maxRowLimit = maxRowLimit;
        this._maxColLimit = maxColLimit;
    }

    Interval<Ref> insertRef(Ref ref) {
        Interval<ColTracker> interval = this.prepareKeyInterval(ref, new ColTracker(this._maxColLimit));
        Interval<ColTracker> intv = this._rowIntervalTree.insertInterval(interval, null);
        ColTracker colTracker = intv.getPayload();
        return colTracker.insertRef(ref);
    }

    Interval<Ref> deleteRef(Ref ref) {
        Interval<ColTracker> intv = this.searchColTracker(ref);
        if (intv == null) {
            return null;
        }
        ColTracker colTracker = intv.getPayload();
        Interval<Ref> refIntv = colTracker.deleteRef(ref);
        if (colTracker.isEmpty()) {
            this._rowIntervalTree.deleteInterval(intv, null);
        }
        return refIntv;
    }

    Interval<Ref> searchRef(Ref ref) {
        Interval<ColTracker> intv = this.searchColTracker(ref);
        if (intv == null) {
            return null;
        }
        ColTracker colTracker = intv.getPayload();
        return colTracker.searchRef(ref);
    }

    Collection<Interval<Ref>> overlaps(Ref ref) {
        Interval<ColTracker> interval = this.prepareKeyInterval(ref, null);
        Collection<Interval<ColTracker>> intervals = this._rowIntervalTree.overlaps(interval);
        LinkedHashSet<Interval<Ref>> results = new LinkedHashSet<Interval<Ref>>();
        for (Interval<ColTracker> intv : intervals) {
            ColTracker colTracker = intv.getPayload();
            results.addAll(colTracker.overlaps(ref));
        }
        return results;
    }

    Collection<Interval<Ref>> contained(Ref ref) {
        Interval<ColTracker> interval = this.prepareKeyInterval(ref, null);
        Collection<Interval<ColTracker>> intervals = this._rowIntervalTree.contained(interval);
        LinkedHashSet<Interval<Ref>> results = new LinkedHashSet<Interval<Ref>>();
        for (Interval<ColTracker> intv : intervals) {
            ColTracker colTracker = intv.getPayload();
            results.addAll(colTracker.overlaps(ref));
        }
        return results;
    }

    boolean isEmpty() {
        return this._rowIntervalTree.isEmpty();
    }

    private Interval<ColTracker> searchColTracker(Ref ref) {
        Interval<ColTracker> interval = this.prepareKeyInterval(ref, null);
        return this._rowIntervalTree.searchInterval(interval);
    }

    private Interval<ColTracker> prepareKeyInterval(Ref ref, ColTracker payload) {
        int row1 = ref.getRow();
        int row2 = ref.getLastRow();
        return row1 <= 0 && row2 < 0 ? new Interval.InfiniteInterval<ColTracker>(this._maxRowLimit, payload) : new Interval(row1, row2, payload);
    }
}

