/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.model.sys;

import io.keikai.model.SCell;
import io.keikai.model.sys.input.NumberInputMask;
import java.util.Locale;
import org.apache.poi.ss.format.Formatters;
import org.apache.poi.ss.util.ToExcelNumberConverter;

public class NumberInputMaskImpl
implements NumberInputMask {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object[] parseNumberInput(String txt, Locale locale) {
        int k;
        Object[] aStringResult = new Object[]{txt, null};
        String txt0 = txt.trim();
        int len = txt0.length();
        if (txt == null || len == 0) {
            return aStringResult;
        }
        char dot = Formatters.getDecimalSeparator((Locale)locale);
        char comma = Formatters.getGroupingSeparator((Locale)locale);
        String currency = Formatters.getCurrencySymbol((Locale)locale);
        StringBuilder sb = new StringBuilder(len);
        int commaPos = -17;
        boolean percent = false;
        int parenPos = -1;
        boolean digit = false;
        int decimalPos = -1;
        boolean withCurrency = false;
        int expPos = -1;
        int sbexpPos = -1;
        boolean negative = false;
        int signPos = -1;
        int j = 0;
        char c = txt0.charAt(j);
        if (c == '(') {
            k = txt0.lastIndexOf(41, len - 1);
            if (k == len - 1) {
                parenPos = 0;
                --len;
                negative = true;
            } else {
                if (k <= 0 || !"%".equals(txt0.substring(k + 1, len).trim())) return aStringResult;
                parenPos = 0;
                len = k;
                negative = true;
                percent = true;
            }
        } else if (c == '+' || c == '-') {
            signPos = 0;
            if (c == '-') {
                negative = !negative;
            }
        } else if (txt0.startsWith(currency)) {
            withCurrency = true;
            j += currency.length() - 1;
        } else if (c == '$') {
            withCurrency = true;
        } else if (Character.isDigit(c)) {
            sb.append(c);
            digit = true;
        } else if (c == dot) {
            decimalPos = sb.length();
            sb.append('.');
        } else {
            if (c != '%') return aStringResult;
            percent = true;
        }
        if (len > j + 1) {
            c = txt0.charAt(++j);
            if (parenPos >= 0) {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    digit = true;
                } else if (txt0.startsWith(currency, j)) {
                    withCurrency = true;
                    j += currency.length() - 1;
                } else if (c == '$') {
                    withCurrency = true;
                } else {
                    if (c != '%') return aStringResult;
                    percent = true;
                }
            } else if (digit) {
                if (c == comma) {
                    commaPos = j;
                } else if (c == dot) {
                    decimalPos = sb.length();
                    sb.append('.');
                } else if (Character.isDigit(c)) {
                    sb.append(c);
                } else if ('e' == c || 'E' == c) {
                    sbexpPos = sb.length();
                    sb.append(c);
                    expPos = 1;
                } else {
                    if ('%' != c) return aStringResult;
                    percent = true;
                }
            } else if (decimalPos >= 0) {
                if (!Character.isDigit(c)) return aStringResult;
                sb.append(c);
                digit = true;
            } else if (signPos >= 0) {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    digit = true;
                } else if (c == '(') {
                    k = txt0.lastIndexOf(41, len - 1);
                    if (k == len - 1) {
                        parenPos = j;
                        --len;
                    } else {
                        if (k <= 0 || !"%".equals(txt0.substring(k + 1, len).trim())) return aStringResult;
                        parenPos = j;
                        len = k;
                        percent = true;
                    }
                } else if (c == '+' || c == '-') {
                    signPos = j;
                    if (c == '-') {
                        negative = !negative;
                    }
                } else if (txt0.startsWith(currency, j)) {
                    withCurrency = true;
                    j += currency.length() - 1;
                } else {
                    if (c != '$') return aStringResult;
                    withCurrency = true;
                }
            } else if (withCurrency) {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    digit = true;
                } else if (c == dot) {
                    decimalPos = sb.length();
                    sb.append('.');
                } else if (c == '(' && txt0.charAt(len - 1) == ')') {
                    parenPos = j;
                    --len;
                    negative = true;
                } else {
                    if (c != '+' && c != '-') return aStringResult;
                    signPos = j;
                    if (c == '-') {
                        negative = !negative;
                    }
                }
            } else if (percent) {
                if (Character.isDigit(c)) {
                    sb.append(c);
                    digit = true;
                } else if (c == dot) {
                    decimalPos = sb.length();
                    sb.append('.');
                } else if (c == '(' && txt0.charAt(len - 1) == ')') {
                    parenPos = j;
                    --len;
                    negative = true;
                } else {
                    if (c != '-' && c != '+') return aStringResult;
                    signPos = j;
                    if (c == '-') {
                        negative = true;
                    }
                }
            }
        }
        ++j;
        while (j < len) {
            c = txt0.charAt(j);
            if (Character.isDigit(c)) {
                sb.append(c);
                digit = true;
            } else if (c == '(') {
                if (digit || parenPos != j - 1 && signPos != j - 1 || signPos < 0) {
                    return aStringResult;
                }
                k = txt0.lastIndexOf(41, len - 1);
                if (k == len - 1) {
                    parenPos = j;
                    --len;
                } else {
                    if (k <= 0 || percent || !"%".equals(txt0.substring(k + 1, len).trim())) return aStringResult;
                    parenPos = j;
                    len = k;
                    percent = true;
                }
            } else if (c == dot) {
                if (decimalPos >= 0 || expPos >= 0 || j - commaPos <= 3) return aStringResult;
                decimalPos = sb.length();
                sb.append('.');
            } else if (c == 'E' || c == 'e') {
                if (!digit || expPos >= 0 || j - commaPos <= 3) return aStringResult;
                sbexpPos = sb.length();
                expPos = j;
                sb.append(c);
            } else if (c == '%') {
                if (percent || !digit || withCurrency) return aStringResult;
                percent = true;
            } else if (c == comma) {
                if (!digit || j - commaPos <= 3 || expPos >= 0 || parenPos >= 0 && !withCurrency && signPos >= 0) return aStringResult;
                commaPos = j;
            } else {
                if (c != '-' && c != '+') return aStringResult;
                if (expPos == j - 1) {
                    sb.append(c);
                } else {
                    if (parenPos >= 0 || signPos != j - 1) return aStringResult;
                    signPos = j;
                    if (c == '-') {
                        negative = !negative;
                    }
                }
            }
            ++j;
        }
        if (len - commaPos < 4) {
            return aStringResult;
        }
        if (percent && digit) {
            int pos = decimalPos < 0 ? (sbexpPos < 0 ? sb.length() : sbexpPos) : decimalPos;
            switch (pos) {
                case 0: {
                    if (pos == decimalPos) {
                        sb.replace(0, 1, "0");
                    }
                    sb.insert(0, ".0");
                    break;
                }
                case 1: {
                    if (pos == decimalPos) {
                        sb.delete(1, 2);
                    }
                    sb.insert(0, ".0");
                    break;
                }
                default: {
                    if (pos == decimalPos) {
                        sb.delete(pos, pos + 1);
                    }
                    sb.insert(pos - 2, ".");
                }
            }
        }
        try {
            Object[] objectArray;
            Double val = Double.parseDouble(sb.toString());
            String format = null;
            if (expPos > 0) {
                format = "0.00E+00";
            } else if (percent) {
                format = decimalPos >= 0 ? "0.00%" : "0%";
            } else if (withCurrency) {
                format = decimalPos >= 0 ? "$#,##0.00_);[Red]($#,##0.00)" : "$#,##0_);[Red]($#,##0)";
            } else if (commaPos > 0) {
                String string = format = decimalPos >= 0 ? "#,##0.00" : "#,##0";
            }
            if (negative) {
                val = -val.doubleValue();
            }
            val = ToExcelNumberConverter.toExcelNumber((double)val, (boolean)false);
            if (format == null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = SCell.CellType.NUMBER;
                objectArray = objectArray2;
                objectArray2[1] = val;
                return objectArray;
            } else {
                Object[] objectArray3 = new Object[3];
                objectArray3[0] = SCell.CellType.NUMBER;
                objectArray3[1] = val;
                objectArray = objectArray3;
                objectArray3[2] = format;
            }
            return objectArray;
        }
        catch (NumberFormatException ex) {
            return aStringResult;
        }
    }
}

