/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import io.keikai.model.SCell;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.TextFunctionHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ZssContext;
import org.zkoss.xel.fn.CommonFns;

public class TextFunctionImpl {
    public static final Function CHAR = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int arg = TextFunctionHelper.evaluateIntArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return new StringEval(Character.toString((char)arg));
        }
    };
    public static final Function CODE = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String arg = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            return arg.charAt(0);
        }
    };
    public static final Function FIXED = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            BigDecimal number = new BigDecimal(TextFunctionHelper.evaluateDoubleArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex));
            int scale = 2;
            String s = "#,##0";
            if (args.length == 2) {
                scale = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            } else if (args.length == 3) {
                scale = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
                ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
                Boolean noCommas = OperandResolver.coerceValueToBoolean((ValueEval)ve, (boolean)false);
                if (noCommas.booleanValue()) {
                    s = "###";
                }
            }
            StringBuffer formatText = new StringBuffer(s);
            if (scale > 0) {
                formatText.append(".");
            }
            for (int i = 1; i < scale + 1; ++i) {
                formatText.append("0");
            }
            return new StringEval(new DecimalFormat(formatText.toString()).format(number.setScale(scale, 4)));
        }
    };
    public static final Function PROPER = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            StringBuffer text = new StringBuffer(TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex));
            text.setCharAt(0, Character.toUpperCase(text.charAt(0)));
            for (int i = 1; i < text.length(); ++i) {
                if (!Character.isLetter(text.charAt(i))) continue;
                if (!Character.isLetter(text.charAt(i - 1))) {
                    text.setCharAt(i, Character.toUpperCase(text.charAt(i)));
                    continue;
                }
                if (!Character.isUpperCase(text.charAt(i))) continue;
                text.setCharAt(i, Character.toLowerCase(text.charAt(i)));
            }
            return new StringEval(text.toString());
        }
    };
    public static final Function REPLACE = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            StringBuffer text = new StringBuffer(TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex));
            int start = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex) - 1;
            int end = TextFunctionHelper.evaluateIntArg((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex) + start;
            String newChar = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return new StringEval(text.replace(start, end, newChar).toString());
        }
    };
    public static final Function REPT = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String text = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            String result = "";
            int ntimes = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            for (int i = 0; i < ntimes; ++i) {
                result = result.concat(text);
            }
            return new StringEval(result);
        }
    };
    public static final Function SUBSTITUTE = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            StringBuffer text = new StringBuffer(TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex));
            String oldText = TextFunctionHelper.evaluateStringArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            String newText = TextFunctionHelper.evaluateStringArg((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            int start = text.indexOf(oldText);
            String result = text.toString();
            if (start != -1) {
                int end = start + oldText.length();
                if (args.length == 4) {
                    for (int i = 0; i < CommonFns.toInt((Object)args[3]) - 1; ++i) {
                        start = text.indexOf(oldText, end);
                        end = start + oldText.length();
                    }
                }
                result = text.replace(start, end, newText).toString();
            }
            return new StringEval(result);
        }
    };
    public static final Function LEFTB = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String text = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int num_bytes = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (num_bytes < 0) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return new StringEval(Arrays.stream(text.split("\\b|\\B+")).limit(num_bytes).collect(Collectors.joining()));
        }
    };
    public static final Function REPLACEB = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String text = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int start_num = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            int num_bytes = TextFunctionHelper.evaluateIntArg((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            String new_text = TextFunctionHelper.evaluateStringArg((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (start_num <= 0 || num_bytes < 0) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            if (text.equals("")) {
                return new StringEval(new_text);
            }
            StringBuilder result = new StringBuilder();
            char[] old_chars = text.toCharArray();
            int byteCount = 0;
            int startByte = start_num;
            int endByte = start_num + num_bytes - 1;
            boolean cutEnd = false;
            boolean cutStart = false;
            for (int i = 0; i < old_chars.length; ++i) {
                ++byteCount;
                if (old_chars[i] < '\u0100') {
                    if (startByte == byteCount) {
                        result.append(new_text);
                    }
                } else {
                    if (startByte == byteCount) {
                        result.append(new_text);
                    }
                    if (endByte == byteCount) {
                        if (endByte >= startByte) {
                            result.append(" ");
                        }
                        cutEnd = true;
                    }
                    if (startByte == ++byteCount) {
                        result.append(" ").append(new_text);
                        cutStart = true;
                    }
                }
                if (byteCount < startByte) {
                    result.append(old_chars[i]);
                    continue;
                }
                if (byteCount <= endByte) continue;
                if (cutEnd) {
                    cutEnd = false;
                    continue;
                }
                if (num_bytes != 0) {
                    result.append(old_chars[i]);
                    continue;
                }
                if (num_bytes != 0 || cutStart ^ cutEnd) continue;
                result.append(old_chars[i]);
            }
            return new StringEval(result.toString());
        }
    };
    public static final Function VALUE = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (ve instanceof BlankEval) {
                return NumberEval.ZERO;
            }
            Locale locale = ZssContext.getCurrent().getLocale();
            InputEngine ie = EngineFactory.getInstance().createInputEngine();
            String editText = OperandResolver.coerceValueToString((ValueEval)ve);
            InputResult result = ie.parseInput(editText, "General", new InputParseContext(locale));
            Object resultVal = result.getValue();
            if (result.getType() == SCell.CellType.NUMBER) {
                if (resultVal instanceof Date) {
                    return new NumberEval(DateUtil.getExcelDate((Date)((Date)resultVal), (boolean)false));
                }
                return new NumberEval(((Double)resultVal).doubleValue());
            }
            if (result.getType() == SCell.CellType.ERROR) {
                return ErrorEval.valueOf((int)((Byte)resultVal).byteValue());
            }
            return ErrorEval.VALUE_INVALID;
        }
    };
}

