/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import java.security.SecureRandom;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ArrayMode;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.TextFunctionHelper;
import org.apache.poi.ss.formula.functions.UtilFns;
import org.zkoss.xel.fn.CommonFns;

public class MathFunctionImpl {
    public static final Function FACTDOUBLE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double n = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (n < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return MathFunctionImpl.doubleFactorial((int)n);
        }
    };
    public static final Function GCD = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int m = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            for (int i = 1; i < args.length; ++i) {
                int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[i], (int)srcRowIndex, (int)srcColumnIndex);
                m = MathFunctionImpl.gcd(m, n);
            }
            return m;
        }
    };
    public static final Function LCM = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int m = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            for (int i = 1; i < args.length; ++i) {
                int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[i], (int)srcRowIndex, (int)srcColumnIndex);
                m = m * n / MathFunctionImpl.gcd(m, n);
            }
            return m;
        }
    };
    public static final Function MDETERM = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double[][] d = UtilFns.toDoubleMatrix((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (d.length != d[0].length) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            Array2DRowRealMatrix m = new Array2DRowRealMatrix(d);
            double result = new LUDecomposition((RealMatrix)m).getDeterminant();
            return UtilFns.toDouble15((double)result, (int)4);
        }
    };
    public static final Function MINVERSE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double[][] array = UtilFns.toDoubleMatrix((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (array.length != array[0].length) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            Array2DRowRealMatrix m = new Array2DRowRealMatrix(array);
            RealMatrix invM = new LUDecomposition((RealMatrix)m).getSolver().getInverse();
            Double[][] result = new Double[invM.getRowDimension()][invM.getColumnDimension()];
            for (int row = 0; row < invM.getRowDimension(); ++row) {
                for (int column = 0; column < invM.getColumnDimension(); ++column) {
                    result[row][column] = UtilFns.toDouble15((double)invM.getEntry(row, column), (int)4);
                }
            }
            return result[0][0];
        }
    };
    public static final Function MMULT = new NumericArrayModeFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double[][] array2;
            double[][] array1 = UtilFns.toDoubleMatrix((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (array1[0].length != (array2 = UtilFns.toDoubleMatrix((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex)).length) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            Array2DRowRealMatrix m1 = new Array2DRowRealMatrix(array1);
            Array2DRowRealMatrix m2 = new Array2DRowRealMatrix(array2);
            RealMatrix mmultResult = m1.multiply((RealMatrix)m2);
            Double[][] result = new Double[mmultResult.getRowDimension()][mmultResult.getColumnDimension()];
            for (int row = 0; row < mmultResult.getRowDimension(); ++row) {
                for (int column = 0; column < mmultResult.getColumnDimension(); ++column) {
                    result[row][column] = UtilFns.toDouble15((double)mmultResult.getEntry(row, column), (int)4);
                }
            }
            return result[0][0];
        }
    };
    public static final Function MROUND = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double number = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double multiple = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (number > 0.0 && multiple < 0.0 || number < 0.0 && multiple > 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (multiple == 0.0) {
                return 0.0;
            }
            return multiple * Math.floor(number / multiple + 0.5);
        }
    };
    public static final Function MULTINOMIAL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int[] number = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] instanceof ErrorEval) {
                    throw new EvaluationException((ErrorEval)args[i]);
                }
                number[i] = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[i], (int)srcRowIndex, (int)srcColumnIndex);
            }
            int sum = 0;
            int product = 1;
            for (int i = 0; i < number.length; ++i) {
                if (number[i] < 0 || number[i] >= 255) {
                    throw new EvaluationException(ErrorEval.NUM_ERROR);
                }
                sum += number[i];
                product *= MathFunctionImpl.factorial(number[i]);
            }
            return MathFunctionImpl.factorial(sum) / product;
        }
    };
    public static final Function QUOTIENT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double n2 = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (n2 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            double n1 = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return Math.rint(n1 / n2);
        }
    };
    public static final Function RANDBETWEEN = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double top;
            double bottom = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (bottom > (top = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return Math.floor(bottom + (top - bottom) * new SecureRandom().nextDouble());
        }
    };
    public static final Function ROMAN = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            int numberHA = TextFunctionHelper.evaluateIntArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int form = 0;
            int paraNum = args.length;
            if (paraNum == 2) {
                form = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            if (numberHA < 0 || numberHA > 3999 || form < 0 || form > 4) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            char[] unit = new char[]{'I', 'X', 'C', 'M'};
            char[] five = new char[]{'V', 'L', 'D'};
            char[] result = new char[16];
            int resultPosn = 15;
            int posn = 0;
            while (numberHA > 0) {
                short digit = (short)(numberHA % 10);
                if (digit == 9) {
                    int n = resultPosn;
                    resultPosn = (short)(resultPosn - 1);
                    result[n] = unit[posn + 1];
                    digit = 1;
                } else if (digit == 4) {
                    int n = resultPosn;
                    resultPosn = (short)(resultPosn - 1);
                    result[n] = five[posn];
                    digit = 1;
                }
                boolean five_sw = digit >= 5;
                digit = (short)(digit % 5);
                while (true) {
                    short s = digit;
                    digit = (short)(digit - 1);
                    if (s <= 0) break;
                    int n = resultPosn;
                    resultPosn = (short)(resultPosn - 1);
                    result[n] = unit[posn];
                }
                if (five_sw) {
                    int n = resultPosn;
                    resultPosn = (short)(resultPosn - 1);
                    result[n] = five[posn];
                }
                posn = (short)(posn + 1);
                numberHA /= 10;
            }
            String numberRoman = new String(result).substring(resultPosn + 1);
            if (paraNum == 1 || form == 0) {
                return new StringEval(numberRoman);
            }
            if (numberRoman.contains("XLV")) {
                numberRoman = numberRoman.replaceAll("XLV", "VL");
            }
            if (numberRoman.contains("XCV")) {
                numberRoman = numberRoman.replaceAll("XCV", "VC");
            }
            if (numberRoman.contains("CDL")) {
                numberRoman = numberRoman.replaceAll("CDL", "LD");
            }
            if (numberRoman.contains("CML")) {
                numberRoman = numberRoman.replaceAll("CML", "LM");
            }
            if (numberRoman.contains("CMVC")) {
                numberRoman = numberRoman.replaceAll("CMVC", "LMVL");
            }
            if (form == 1) {
                if (numberRoman.contains("CDXC")) {
                    numberRoman = numberRoman.replaceAll("CDXC", "LDXL");
                }
                if (numberRoman.contains("CDVC")) {
                    numberRoman = numberRoman.replaceAll("CDVC", "LDVL");
                }
                if (numberRoman.contains("CMXC")) {
                    numberRoman = numberRoman.replaceAll("CMXC", "LMXL");
                }
                if (numberRoman.contains("XCIX")) {
                    numberRoman = numberRoman.replaceAll("XCIX", "VCIV");
                }
                if (numberRoman.contains("XLIX")) {
                    numberRoman = numberRoman.replaceAll("XLIX", "VLIV");
                }
            }
            if (form > 1) {
                if (numberRoman.contains("XLIX")) {
                    numberRoman = numberRoman.replaceAll("XLIX", "IL");
                }
                if (numberRoman.contains("XCIX")) {
                    numberRoman = numberRoman.replaceAll("XCIX", "IC");
                }
                if (numberRoman.contains("CDXC")) {
                    numberRoman = numberRoman.replaceAll("CDXC", "XD");
                }
                if (numberRoman.contains("CDVC")) {
                    numberRoman = numberRoman.replaceAll("CDVC", "XDV");
                }
                if (numberRoman.contains("CDIC")) {
                    numberRoman = numberRoman.replaceAll("CDIC", "XDIX");
                }
                if (numberRoman.contains("LMVL")) {
                    numberRoman = numberRoman.replaceAll("LMVL", "XMV");
                }
                if (numberRoman.contains("CMIC")) {
                    numberRoman = numberRoman.replaceAll("CMIC", "XMIX");
                }
                if (numberRoman.contains("CMXC")) {
                    numberRoman = numberRoman.replaceAll("CMXC", "XM");
                }
            }
            if (form > 2) {
                if (numberRoman.contains("XDV")) {
                    numberRoman = numberRoman.replaceAll("XDV", "VD");
                }
                if (numberRoman.contains("XDIX")) {
                    numberRoman = numberRoman.replaceAll("XDIX", "VDIV");
                }
                if (numberRoman.contains("XMV")) {
                    numberRoman = numberRoman.replaceAll("XMV", "VM");
                }
                if (numberRoman.contains("XMIX")) {
                    numberRoman = numberRoman.replaceAll("XMIX", "VMIV");
                }
            }
            if (form == 4 || !CommonFns.toBoolean((Object)args[1])) {
                if (numberRoman.contains("VDIV")) {
                    numberRoman = numberRoman.replaceAll("VDIV", "ID");
                }
                if (numberRoman.contains("VMIV")) {
                    numberRoman = numberRoman.replaceAll("VMIV", "IM");
                }
            }
            return new StringEval(numberRoman);
        }
    };
    public static final Function SQRTPI = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double number = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (number < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return Math.sqrt(number * Math.PI);
        }
    };

    private static int doubleFactorial(int n) {
        if (n <= 1) {
            return 1;
        }
        if (n == 2) {
            return 2;
        }
        return n * MathFunctionImpl.doubleFactorial(n - 2);
    }

    public static int gcd(int m, int n) throws EvaluationException {
        if (m < 0 || n < 0) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        return ArithmeticUtils.gcd((int)m, (int)n);
    }

    private static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * MathFunctionImpl.factorial(n - 1);
    }

    private static abstract class NumericArrayModeFunction
    extends NumericFunction
    implements ArrayMode {
        private NumericArrayModeFunction() {
        }
    }
}

