/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.impl.sys.formula.EvalBook;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.format.CellFormatPart;
import org.apache.poi.ss.formula.EvaluationWorkbook;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.MissingArgEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.util.CellReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfoFunctionImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoFunctionImpl.class);
    public static final Function ISERR = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            try {
                ValueEval vEval = OperandResolver.getSingleValue((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
                return BoolEval.valueOf((vEval instanceof ErrorEval && vEval != ErrorEval.NA ? 1 : 0) != 0);
            }
            catch (Exception e) {
                return BoolEval.valueOf((boolean)true);
            }
        }
    };
    public static final Function N = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            if (ve instanceof NumberEval) {
                return args[0];
            }
            if (ve instanceof StringEval) {
                return new NumberEval(0.0);
            }
            if (ve instanceof BoolEval) {
                return new NumberEval(((BoolEval)ve).getNumberValue());
            }
            return new NumberEval(0.0);
        }
    };
    public static final Function TYPE = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            ValueEval ve = args[0];
            if (!(ve instanceof ErrorEval)) {
                ve = OperandResolver.getSingleValue((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            }
            if (ve instanceof NumberEval) {
                return 1.0;
            }
            if (ve instanceof StringEval) {
                return 2.0;
            }
            if (ve instanceof BoolEval) {
                return 4.0;
            }
            if (ve instanceof ErrorEval) {
                return 16.0;
            }
            if (ve instanceof AreaEval) {
                return 64.0;
            }
            return 0.0;
        }
    };
    public static final Function CELL = new Fixed2ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
            if (arg1 instanceof MissingArgEval) {
                return ErrorEval.VALUE_INVALID;
            }
            String infoType = OperandResolver.coerceValueToString((ValueEval)arg0).toLowerCase();
            if (!"|address|col|color|contents|filename|format|parentheses|prefix|protect|row|type|width".contains(infoType)) {
                return ErrorEval.VALUE_INVALID;
            }
            RefEval ref = (RefEval)arg1;
            OperationEvaluationContext context = OperationEvaluationContext.getContext();
            EvaluationWorkbook workbook = context != null ? context.getWorkbook() : null;
            switch (infoType) {
                case "address": {
                    return new StringEval(new CellReference(ref.getRow(), ref.getColumn(), true, true).formatAsString());
                }
                case "col": {
                    return new NumberEval((double)(ref.getColumn() + 1));
                }
                case "color": {
                    String dataFormat;
                    CellFormat instance;
                    CellFormatPart negativeNum;
                    if (workbook instanceof EvalBook && (negativeNum = (instance = CellFormat.getInstance((String)(dataFormat = ((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getCell(ref.getRow(), ref.getColumn()).getCellStyle().getDataFormat()))).getNegNumFmt()) != null) {
                        return new NumberEval(negativeNum.apply((Object)Integer.valueOf((int)-1)).textColor != null ? 1.0 : 0.0);
                    }
                    return new NumberEval(0.0);
                }
                case "contents": {
                    try {
                        return OperandResolver.getSingleValue((ValueEval)ref, (int)srcRowIndex, (int)srcColumnIndex);
                    }
                    catch (EvaluationException e) {
                        return e.getErrorEval();
                    }
                }
                case "filename": {
                    return new StringEval("");
                }
                case "format": {
                    if (workbook instanceof EvalBook) {
                        String dataFormat = ((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getCell(ref.getRow(), ref.getColumn()).getCellStyle().getDataFormat();
                        if (dataFormat == null || "@".equals(dataFormat) || "general".equalsIgnoreCase(dataFormat)) {
                            return new StringEval("G");
                        }
                        LOGGER.warn("Not implemented yet for Cell(\"format\")");
                        return ErrorEval.VALUE_INVALID;
                    }
                }
                case "parentheses": {
                    if (workbook instanceof EvalBook) {
                        String dataFormat = ((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getCell(ref.getRow(), ref.getColumn()).getCellStyle().getDataFormat();
                        CellFormat instance = CellFormat.getInstance((String)dataFormat);
                        CellFormatPart positiveNum = instance.getPosNumFmt();
                        String text = positiveNum.apply((Object)Double.valueOf((double)1.0)).text;
                        int startIdx = text.indexOf("(");
                        if (startIdx >= 0 && text.indexOf(")", startIdx) >= 0) {
                            return new NumberEval(1.0);
                        }
                    }
                    return new NumberEval(0.0);
                }
                case "prefix": {
                    try {
                        Double aDouble;
                        ValueEval singleValue = OperandResolver.getSingleValue((ValueEval)ref, (int)srcRowIndex, (int)srcColumnIndex);
                        if (singleValue instanceof StringEval && (aDouble = OperandResolver.parseDouble((String)((StringEval)singleValue).getStringValue())) == null) {
                            SCell cell = ((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getCell(ref.getRow(), ref.getColumn());
                            SCellStyle.Alignment alignment = cell.getCellStyle().getAlignment();
                            switch (alignment) {
                                case LEFT: {
                                    return new StringEval("'");
                                }
                                case CENTER: {
                                    return new StringEval("^");
                                }
                                case RIGHT: {
                                    return new StringEval("\"");
                                }
                                case GENERAL: {
                                    return new StringEval("'");
                                }
                            }
                        }
                    }
                    catch (EvaluationException e) {
                        return e.getErrorEval();
                    }
                    return new StringEval("");
                }
                case "protect": {
                    if (workbook instanceof EvalBook && !((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getCell(ref.getRow(), ref.getColumn()).getCellStyle().isLocked()) {
                        return new NumberEval(0.0);
                    }
                    return new NumberEval(1.0);
                }
                case "row": {
                    return new NumberEval((double)(ref.getRow() + 1));
                }
                case "type": {
                    try {
                        ValueEval singleValue = OperandResolver.getSingleValue((ValueEval)ref, (int)srcRowIndex, (int)srcColumnIndex);
                        if (singleValue instanceof StringEval) {
                            Double aDouble = OperandResolver.parseDouble((String)((StringEval)singleValue).getStringValue());
                            if (aDouble == null) {
                                return new StringEval("l");
                            }
                        } else if (singleValue instanceof BlankEval) {
                            return new StringEval("b");
                        }
                        return new StringEval("v");
                    }
                    catch (EvaluationException e) {
                        return e.getErrorEval();
                    }
                }
                case "width": {
                    if (workbook instanceof EvalBook) {
                        return new NumberEval((double)((EvalBook)workbook).getNBook().getSheet(ref.getFirstSheetIndex()).getColumn(ref.getColumn()).getWidth());
                    }
                    return new NumberEval(0.0);
                }
            }
            return ErrorEval.VALUE_INVALID;
        }
    };
}

