/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.poi.ss.formula.AreaEvalHelper;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FinanceFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.UtilFns;
import org.apache.poi.ss.usermodel.DateUtil;
import org.jfree.date.SerialDate;
import org.jfree.date.SerialDateUtilities;

public class FinanceFunctionImpl {
    public static final Function ACCRINT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dissue = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date issue = DateUtil.getJavaDate((double)dissue);
            double dFirI = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date firI = DateUtil.getJavaDate((double)dFirI);
            double dSettlement = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Date settlement = DateUtil.getJavaDate((double)dSettlement);
            if (settlement.before(issue)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double rate = args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double par = args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            int freq = (int)(args[5] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex));
            int basis = 0;
            if (args.length == 7) {
                basis = FinanceFunctionImpl.basis((int)(args[6] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[6], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            if (basis < 0 || basis > 4) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            boolean method = true;
            if (args.length == 8) {
                method = UtilFns.stringToBoolean((ValueEval)args[7]);
            }
            if (freq != 1 && freq != 2 && freq != 4) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (rate <= 0.0 || par <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double result = 0.0;
            result = method ? par * rate * FinanceFunctionImpl.getYearDiff(issue, settlement, basis) : par * rate * FinanceFunctionImpl.getYearDiff(firI, settlement, basis);
            return result;
        }
    };
    public static final Function ACCRINTM = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double par;
            double rate = args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double d = par = args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (rate <= 0.0 || par <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double dissue = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date issue = DateUtil.getJavaDate((double)dissue);
            double dSettlement = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date settlement = DateUtil.getJavaDate((double)dSettlement);
            if (settlement.before(issue)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            int A = UtilFns.dsm((Date)issue, (Date)settlement, (int)basis);
            double D = UtilFns.basisToDouble((int)basis, (Date)issue, (Date)settlement, (int)A);
            double accrintm = par * rate * ((double)A / D);
            return new Double(accrintm);
        }
    };
    public static final Function AMORDEGRC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double usePeriod;
            double cost = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double dPurDate = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date purDate = DateUtil.getJavaDate((double)dPurDate);
            double dFirDate = args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Date firDate = DateUtil.getJavaDate((double)dFirDate);
            double salvage = args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            int period = (int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            double rate = args[5] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 7) {
                basis = FinanceFunctionImpl.basis((int)(args[6] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[6], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            double coeff = (usePeriod = 1.0 / rate) < 3.0 ? 1.0 : (usePeriod < 5.0 ? 1.5 : (usePeriod <= 6.0 ? 2.0 : 2.5));
            double nRate = Math.round(FinanceFunctionImpl.yearFraction(purDate, firDate, basis) * (rate *= coeff) * cost);
            double rest = (cost -= nRate) - salvage;
            for (int n = 0; n < period; ++n) {
                nRate = Math.round(rate * cost);
                if ((rest -= nRate) < 0.0) {
                    switch (period - n) {
                        case 0: 
                        case 1: {
                            return Math.round(cost * 0.5);
                        }
                    }
                    return 0.0;
                }
                cost -= nRate;
            }
            return nRate;
        }
    };
    public static final Function AMORLINC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double cost = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double dPurDate = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date purDate = DateUtil.getJavaDate((double)dPurDate);
            double dFirDate = args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Date firDate = DateUtil.getJavaDate((double)dFirDate);
            double salvage = args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            int period = (int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            double rate = args[5] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 7) {
                basis = FinanceFunctionImpl.basis((int)(args[6] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[6], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            double T0 = cost * rate;
            double T1 = FinanceFunctionImpl.yearFraction(purDate, firDate, basis) * T0;
            int numPeriods = (int)((cost - salvage - T1) / T0);
            if (period == 0) {
                return new Double(T1);
            }
            if (period <= numPeriods) {
                return new Double(T0);
            }
            if (period == numPeriods + 1) {
                return cost - salvage - T0 * (double)numPeriods - T1;
            }
            return 0.0;
        }
    };
    public static final Function COUPDAYBS = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return FinanceFunctionImpl.coupdaybs(settle, maturi, frequency, basis);
        }
    };
    public static final Function COUPDAYS = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return FinanceFunctionImpl.coupdays(settle, maturi, frequency, basis);
        }
    };
    public static final Function COUPDAYSNC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return FinanceFunctionImpl.coupdaysnc(settle, maturi, frequency, basis);
        }
    };
    public static final Function COUPNCD = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            Date couppcd = FinanceFunctionImpl.couppcd(settle, maturi, frequency, basis);
            Date coupncd = FinanceFunctionImpl.coupncd(couppcd, frequency);
            return DateUtil.getExcelDate((Date)coupncd);
        }
    };
    public static final Function COUPNUM = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return FinanceFunctionImpl.coupnum(settle, maturi, frequency, basis);
        }
    };
    public static final Function COUPPCD = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dMaturi;
            Date maturi;
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            if (settle.after(maturi = DateUtil.getJavaDate((double)(dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex))))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int frequency = FinanceFunctionImpl.frequency((int)(args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)));
            int basis = 0;
            if (args.length == 4) {
                basis = FinanceFunctionImpl.basis((int)(args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return DateUtil.getExcelDate((Date)FinanceFunctionImpl.couppcd(settle, maturi, frequency, basis));
        }
    };
    public static final Function CUMIPMT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int nper = (int)Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex));
            double pv = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            int startPer = (int)Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex));
            int endPer = (int)Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            if (rate == 0.0 || nper == 0 || pv == 0.0 || startPer < 1 || endPer < 1 || startPer > endPer) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int type = 0;
            if (args.length > 5) {
                type = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            }
            if (type != 0 && type != 1) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double cumipmt = 0.0;
            double pmt = FinanceFunctionImpl.pmt(rate, nper, pv, 0.0, type);
            if (startPer == 1) {
                if (type <= 0) {
                    cumipmt = -pv;
                }
                ++startPer;
            }
            for (int i = startPer; i <= endPer; ++i) {
                if (type > 0) {
                    cumipmt += FinanceFunctionImpl.GetZw(rate, i - 2, pmt, pv, 1) - pv;
                    continue;
                }
                cumipmt += FinanceFunctionImpl.GetZw(rate, i - 1, pmt, pv, 0);
            }
            return cumipmt *= rate;
        }
    };
    public static final Function CUMPRINC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double nper = Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex));
            double pv = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            int startPer = (int)Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex));
            int endPer = (int)Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            if (rate == 0.0 || nper == 0.0 || pv == 0.0 || startPer < 1 || endPer < 1 || startPer > endPer) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int type = 0;
            if (args.length > 5) {
                type = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            }
            if (type != 0 && type != 1) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double cumppmt = 0.0;
            double pmt = FinanceFunctionImpl.pmt(rate, nper, pv, 0.0, type);
            if (startPer == 1) {
                cumppmt = type <= 0 ? pmt + pv * rate : pmt;
            }
            int n = ++startPer;
            ++startPer;
            for (int i = v47066; i <= endPer; ++i) {
                if (type > 0) {
                    cumppmt += pmt - (FinanceFunctionImpl.GetZw(rate, i - 2, pmt, pv, 1) - pmt) * rate;
                    continue;
                }
                cumppmt += pmt - FinanceFunctionImpl.GetZw(rate, i - 1, pmt, pv, 0) * rate;
            }
            return cumppmt;
        }
    };
    public static final Function DISC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double pr = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double redemption = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (pr <= 0.0 || redemption <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settlement = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturity = DateUtil.getJavaDate((double)dMaturi);
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            int DSM = UtilFns.dsm((Date)settlement, (Date)maturity, (int)basis);
            double B = UtilFns.basisToDouble((int)basis, (Date)settlement, (Date)maturity, (int)DSM);
            double disc = (redemption - pr) / redemption * (B / (double)DSM);
            return disc;
        }
    };
    public static final Function DOLLARDE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double fraction;
            double dollar = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double d = fraction = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (fraction < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (fraction >= 0.0 && fraction < 1.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return Math.floor(dollar) + dollar % 1.0 * 100.0 / fraction;
        }
    };
    public static final Function DOLLARFR = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double fraction;
            double dollar = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double d = fraction = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (fraction < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (fraction == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return Math.floor(dollar) + dollar % 1.0 * fraction / 100.0;
        }
    };
    public static final Function DURATION = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double yld;
            double dMaturi;
            Date maturi;
            double dSettle = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            if (settle.after(maturi = DateUtil.getJavaDate((double)(dMaturi = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex))))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double coupon = args[2] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double d = yld = args[3] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (!(yld > 0.0) && !(coupon > 0.0)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int freq = (int)(args[4] == null ? 1.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            if (freq != 1 && freq != 2 && freq != 4) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int basis = 0;
            if (args.length == 6) {
                basis = FinanceFunctionImpl.basis((int)(args[5] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            double yearFrac = FinanceFunctionImpl.yearFraction(settle, maturi, basis);
            double coupNs = FinanceFunctionImpl.coupnum(settle, maturi, 12 / freq, basis);
            double dura = 0.0;
            coupon *= 100.0 / (double)freq;
            yld /= (double)freq;
            yld += 1.0;
            double nDiff = yearFrac * (double)freq - coupNs;
            int t = 1;
            while ((double)t < coupNs) {
                dura += ((double)t + nDiff) * coupon / Math.pow(yld, (double)t + nDiff);
                ++t;
            }
            dura += (coupNs + nDiff) * (coupon + 100.0) / Math.pow(yld, coupNs + nDiff);
            double p = 0.0;
            int t2 = 1;
            while ((double)t2 < coupNs) {
                p += coupon / Math.pow(yld, (double)t2 + nDiff);
                ++t2;
            }
            dura /= (p += (coupon + 100.0) / Math.pow(yld, coupNs + nDiff));
            return dura /= (double)freq;
        }
    };
    public static final Function EFFECT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double npery = Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex));
            if (rate <= 0.0 || npery < 1.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return Math.pow(1.0 + rate / npery, npery) - 1.0;
        }
    };
    public static final Function FVSCHEDULE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double principal = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            List l0 = AreaEvalHelper.toDoubleList((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double[] schedule = UtilFns.toDoubleArray((List)l0);
            for (int i = 0; i < schedule.length; ++i) {
                principal *= 1.0 + schedule[i];
            }
            return new Double(principal);
        }
    };
    public static final Function INTRATE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double investment = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double redemption = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (investment <= 0.0 || redemption <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            int dsm = UtilFns.dsm((Date)settle, (Date)maturi, (int)basis);
            double B = UtilFns.basisToDouble((int)basis, (Date)settle, (Date)maturi, (int)dsm);
            return (redemption - investment) / investment * (B / (double)dsm);
        }
    };
    public static final Function NOMINAL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double npery = Math.floor(NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex));
            if (rate <= 0.0 || npery < 1.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return (Math.pow(rate + 1.0, 1.0 / npery) - 1.0) * npery;
        }
    };
    public static final Function NPV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double d = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            List l0 = AreaEvalHelper.toDoubleList((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double[] values = UtilFns.toDoubleArray((List)l0);
            return FinanceFunctionImpl.npv(d, values);
        }
    };
    public static final Function PRICE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dMaturi;
            Date maturi;
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            if (settle.after(maturi = DateUtil.getJavaDate((double)(dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex))))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double yld = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double redemption = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            if (!(yld > 0.0 || rate > 0.0 || redemption > 0.0)) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int freq = (int)(args[5] == null ? 1.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex));
            if (freq != 1 && freq != 2 && freq != 4) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int basis = 0;
            if (args.length == 7) {
                basis = FinanceFunctionImpl.basis((int)(args[6] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[6], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            return FinanceFunctionImpl.price(settle, maturi, rate, yld, redemption, freq, basis);
        }
    };
    public static final Function PRICEDISC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double discount = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double redemption = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (discount <= 0.0 || redemption <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)(args[4] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            int dsm = UtilFns.dsm((Date)settle, (Date)maturi, (int)basis);
            double B = UtilFns.basisToDouble((int)basis, (Date)settle, (Date)maturi, (int)dsm);
            return redemption - discount * redemption * ((double)dsm / B);
        }
    };
    public static final Function PRICEMAT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double dissue = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Date issue = DateUtil.getJavaDate((double)dissue);
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double yld = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 6) {
                basis = FinanceFunctionImpl.basis((int)(args[5] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex)));
            }
            if (rate < 0.0 || yld < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int dsm = UtilFns.dsm((Date)settle, (Date)maturi, (int)basis);
            int dim = UtilFns.dsm((Date)issue, (Date)maturi, (int)basis);
            int A = UtilFns.dsm((Date)issue, (Date)settle, (int)basis);
            double B = UtilFns.basisToDouble((int)basis, (Date)issue, (Date)settle, (int)A);
            return (100.0 + (double)dim / B * rate * 100.0) / (1.0 + (double)dsm / B * yld) - (double)A / B * rate * 100.0;
        }
    };
    public static final Function RECEIVED = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double investment = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double discount = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (investment <= 0.0 || discount <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            }
            int dim = UtilFns.dsm((Date)settle, (Date)maturi, (int)basis);
            double B = UtilFns.basisToDouble((int)basis, (Date)settle, (Date)maturi, (int)dim);
            return investment / (1.0 - discount * ((double)dim / B));
        }
    };
    public static final Function TBILLEQ = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double discount = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            if (discount <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int DSM = UtilFns.dsm((Date)settle, (Date)maturi, (int)2);
            return 365.0 * discount / (360.0 - discount * (double)DSM);
        }
    };
    public static final Function TBILLPRICE = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double discount = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            if (discount <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int DSM = UtilFns.dsm((Date)settle, (Date)maturi, (int)2);
            return 100.0 * (1.0 - discount * (double)DSM / 360.0);
        }
    };
    public static final Function TBILLYIELD = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double pr = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            if (pr <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            int DSM = UtilFns.dsm((Date)settle, (Date)maturi, (int)2);
            double p1 = (100.0 - pr) / pr;
            double p2 = 360.0 / (double)DSM;
            return p1 * p2;
        }
    };
    public static final Function XNPV = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            List l1;
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            List l0 = AreaEvalHelper.toDoubleList((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            double[] values = UtilFns.toDoubleArray((List)l0);
            if (values.length != (l1 = AreaEvalHelper.toDoubleList((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex)).size()) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double[] dates = UtilFns.toDoubleArray((List)l1);
            double xnpv = 0.0;
            for (int i = 0; i < dates.length; ++i) {
                double di = dates[i];
                double d1 = dates[0];
                double firstArg = 1.0 + rate;
                double secondArg = (di - d1) / 365.0;
                double pow = Math.pow(firstArg, secondArg);
                xnpv += values[i] / pow;
            }
            return xnpv;
        }
    };
    public static final Function YIELD = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double result;
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double pr = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double redemp = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            int freq = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 7) {
                basis = FinanceFunctionImpl.basis((int)NumericFunction.singleOperandEvaluate((ValueEval)args[6], (int)srcRowIndex, (int)srcColumnIndex));
            }
            if (FinanceFunctionImpl.coupnum(settle, maturi, FinanceFunctionImpl.frequency(freq), basis) <= 1.0) {
                double A = FinanceFunctionImpl.coupdaybs(settle, maturi, FinanceFunctionImpl.frequency(freq), basis);
                double DSR = FinanceFunctionImpl.coupdaysnc(settle, maturi, FinanceFunctionImpl.frequency(freq), basis);
                double E = FinanceFunctionImpl.coupdays(settle, maturi, FinanceFunctionImpl.frequency(freq), basis);
                double term = rate / (double)freq;
                double coeff = (double)freq * E / DSR;
                double num = redemp / 100.0 + term - (pr / 100.0 + A / E * term);
                double den = pr / 100.0 + A / E * term;
                result = num / den * coeff;
            } else {
                result = FinanceFunctionImpl.getYld(settle, maturi, rate, pr, redemp, freq, basis);
            }
            return result;
        }
    };
    public static final Function YIELDDISC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double price = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double redemp = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 5) {
                basis = FinanceFunctionImpl.basis((int)NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex));
            }
            double result = redemp / price - 1.0;
            return result /= FinanceFunctionImpl.yearFraction(settle, maturi, basis);
        }
    };
    public static final Function YIELDMAT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double dSettle = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            Date settle = DateUtil.getJavaDate((double)dSettle);
            double dMaturi = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            Date maturi = DateUtil.getJavaDate((double)dMaturi);
            double dIssue = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            Date issue = DateUtil.getJavaDate((double)dIssue);
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double price = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            int basis = 0;
            if (args.length == 6) {
                basis = FinanceFunctionImpl.basis((int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex));
            }
            double fIssMat = FinanceFunctionImpl.yearFraction(issue, maturi, basis);
            double fIssSet = FinanceFunctionImpl.yearFraction(issue, settle, basis);
            double fSetMat = FinanceFunctionImpl.yearFraction(settle, maturi, basis);
            double y = 1.0 + fIssMat * rate;
            y /= price / 100.0 + fIssSet * rate;
            y -= 1.0;
            return y /= fSetMat;
        }
    };
    public static final Function Temp = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            return 0.0;
        }
    };
    public static final Function DB = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double salvage;
            double cost;
            double d = cost = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (cost < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double d2 = salvage = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (salvage < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (args[2] == null || args[3] == null) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double life = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double period = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (life < 0.0 || period < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (period - 1.0 > life) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double month = 12.0;
            if (args.length > 4) {
                month = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            }
            double rate = new BigDecimal(1.0 - Math.pow(salvage / cost, 1.0 / life)).setScale(3, 4).doubleValue();
            return FinanceFunctionImpl.db(cost, salvage, life, period, month, rate);
        }
    };
    public static final Function DDB = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double salvage;
            double cost;
            double d = cost = args[0] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (cost < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double d2 = salvage = args[1] == null ? 0.0 : NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (salvage < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (args[2] == null || args[3] == null) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double life = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex);
            double period = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            if (life < 0.0 || period < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (period > life) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double factor = 2.0;
            if (args.length > 4) {
                factor = NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex);
            }
            return FinanceFunctionImpl.ddb(cost, salvage, life, period, factor);
        }
    };
    public static final Function IPMT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double nper;
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double per = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (per > (nper = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double pv = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double fv = args.length > 4 && args[4] != null ? NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex) : 0.0;
            int type = args.length > 5 ? (int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex) : 0;
            return FinanceFunctionImpl.ipmt(rate, per, nper, pv, fv, type);
        }
    };
    public static final Function PPMT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double nper;
            double rate = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double per = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (per > (nper = NumericFunction.singleOperandEvaluate((ValueEval)args[2], (int)srcRowIndex, (int)srcColumnIndex))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double pv = NumericFunction.singleOperandEvaluate((ValueEval)args[3], (int)srcRowIndex, (int)srcColumnIndex);
            double fv = args.length > 4 && args[4] != null ? NumericFunction.singleOperandEvaluate((ValueEval)args[4], (int)srcRowIndex, (int)srcColumnIndex) : 0.0;
            int type = args.length > 5 ? (int)NumericFunction.singleOperandEvaluate((ValueEval)args[5], (int)srcRowIndex, (int)srcColumnIndex) : 0;
            return FinanceFunctionImpl.ppmt(rate, per, nper, pv, fv, type);
        }
    };
    public static final Function SLN = new FinanceFunction(){

        protected double evaluate(double cost, double salvage, double life, double arg3, boolean type) throws EvaluationException {
            if (life == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return (cost - salvage) / life;
        }
    };
    public static final Function SYD = new FinanceFunction(){

        protected double evaluate(double cost, double salvage, double life, double per, boolean type) throws EvaluationException {
            if (life <= 0.0 || per <= 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return (cost - salvage) * (life - per + 1.0) * 2.0 / (life * (life + 1.0));
        }
    };

    private static double getYearDiff(Date firstDate, Date secondDate, int basis) {
        SerialDate startDate = SerialDate.createInstance((Date)firstDate);
        SerialDate endDate = SerialDate.createInstance((Date)secondDate);
        double result = 0.0;
        int diff = 0;
        switch (basis) {
            case 0: {
                diff = SerialDateUtilities.dayCount30((SerialDate)startDate, (SerialDate)endDate);
                if (startDate.getYYYY() == endDate.getYYYY() && startDate.getMonth() == 2 && endDate.getMonth() != 2) {
                    diff = SerialDate.isLeapYear((int)startDate.getYYYY()) ? --diff : (diff -= 2);
                }
                result = (double)diff / 360.0;
                break;
            }
            case 1: {
                diff = SerialDateUtilities.dayCountActual((SerialDate)startDate, (SerialDate)endDate);
                if (SerialDate.isLeapYear((int)startDate.getYYYY())) {
                    result = (double)diff / 366.0;
                    break;
                }
                result = (double)diff / 365.0;
                break;
            }
            case 2: {
                diff = SerialDateUtilities.dayCountActual((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 360.0;
                break;
            }
            case 3: {
                diff = SerialDateUtilities.dayCountActual((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 365.0;
                break;
            }
            case 4: {
                diff = SerialDateUtilities.dayCount30E((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 360.0;
            }
        }
        return result;
    }

    private static double yearFraction(Date d0, Date d1, int basis) {
        SerialDate startDate = SerialDate.createInstance((Date)d0);
        SerialDate endDate = SerialDate.createInstance((Date)d1);
        double result = 0.0;
        int diff = 0;
        switch (basis) {
            case 0: {
                diff = SerialDateUtilities.dayCount30((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 360.0;
                break;
            }
            case 1: {
                int nFeb29s;
                int nYears;
                SerialDate tempDate1 = SerialDate.addYears((int)1, (SerialDate)startDate);
                if (endDate.compare(tempDate1) > 0) {
                    nYears = endDate.getYYYY() - startDate.getYYYY() + 1;
                    tempDate1 = SerialDate.createInstance((int)1, (int)1, (int)(endDate.getYYYY() + 1));
                    SerialDate tempDate2 = SerialDate.createInstance((int)1, (int)1, (int)startDate.getYYYY());
                    nFeb29s = tempDate1.compare(tempDate2) - 365 * nYears;
                } else {
                    nYears = 1;
                    nFeb29s = SerialDate.isLeapYear((int)startDate.getYYYY()) && startDate.getMonth() < 3 || SerialDate.isLeapYear((int)endDate.getYYYY()) && endDate.compare(SerialDate.createInstance((int)29, (int)2, (int)endDate.getYYYY())) >= 0 ? 1 : 0;
                }
                double peryear = 365.0 + (double)nFeb29s / (double)nYears;
                result = (double)endDate.compare(startDate) / peryear;
                break;
            }
            case 2: {
                diff = SerialDateUtilities.dayCountActual((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 360.0;
                break;
            }
            case 3: {
                diff = SerialDateUtilities.dayCountActual((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 365.0;
                break;
            }
            case 4: {
                diff = SerialDateUtilities.dayCount30E((SerialDate)startDate, (SerialDate)endDate);
                result = (double)diff / 360.0;
            }
        }
        return result;
    }

    private static int basis(int basis) throws EvaluationException {
        if (basis > 4 || basis < 0) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        return basis;
    }

    private static double coupdaybs(Date settle, Date maturi, int freq, int basis) throws EvaluationException {
        Date coupday = FinanceFunctionImpl.couppcd(settle, maturi, freq, basis);
        return UtilFns.dsm((Date)coupday, (Date)settle, (int)basis);
    }

    private static Date couppcd(Date settle, Date maturi, int frequency, int basis) {
        GregorianCalendar couppcd = new GregorianCalendar();
        GregorianCalendar settleD = new GregorianCalendar();
        settleD.setTime(settle);
        couppcd.setTime(maturi);
        couppcd.set(1, settleD.get(1));
        if (couppcd.after(settleD)) {
            couppcd.add(1, -1);
        }
        while (!couppcd.after(settleD)) {
            couppcd.add(2, frequency);
        }
        couppcd.add(2, -1 * frequency);
        return couppcd.getTime();
    }

    private static int frequency(int frequency) throws EvaluationException {
        if (frequency != 1 && frequency != 2 && frequency != 4) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        return 12 / frequency;
    }

    private static double coupdays(Date settle, Date maturi, int freq, int basis) throws EvaluationException {
        Date couppcd = FinanceFunctionImpl.couppcd(settle, maturi, freq, basis);
        Date coupncd = FinanceFunctionImpl.coupncd(couppcd, freq);
        return UtilFns.dsm((Date)couppcd, (Date)coupncd, (int)basis);
    }

    private static Date coupncd(Date coupday, int frequency) {
        GregorianCalendar coupncd = new GregorianCalendar();
        coupncd.setTime(coupday);
        coupncd.add(2, frequency);
        return coupncd.getTime();
    }

    private static double coupdaysnc(Date settle, Date maturi, int freq, int basis) throws EvaluationException {
        Date couppcd = FinanceFunctionImpl.couppcd(settle, maturi, freq, basis);
        Date coupncd = FinanceFunctionImpl.coupncd(couppcd, freq);
        double coupdaysnc = UtilFns.dsm((Date)settle, (Date)coupncd, (int)basis);
        return coupdaysnc;
    }

    private static double coupnum(Date settle, Date maturi, int freq, int basis) {
        Date couppcd = FinanceFunctionImpl.couppcd(settle, maturi, freq, basis);
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(couppcd);
        int couppcdY = gc.get(1);
        int couppcdM = gc.get(2);
        gc.setTime(maturi);
        int maturiY = gc.get(1);
        int maturiM = gc.get(2);
        return Math.floor(((maturiY - couppcdY) * 12 + maturiM - couppcdM) / freq);
    }

    private static double npv(double rate, double[] values) {
        double[] npv = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            npv[i] = values[i] / Math.pow(1.0 + rate, i + 1);
        }
        return UtilFns.getStats((double[])npv).getSum();
    }

    private static double price(Date settle, Date maturi, double rate, double yld, double redemp, int freq, int basis) throws EvaluationException {
        Date couppcd = FinanceFunctionImpl.couppcd(settle, maturi, FinanceFunctionImpl.frequency(freq), basis);
        Date coupncd = FinanceFunctionImpl.coupncd(couppcd, FinanceFunctionImpl.frequency(freq));
        double E = UtilFns.dsm((Date)couppcd, (Date)coupncd, (int)basis);
        double DSC = UtilFns.dsm((Date)settle, (Date)coupncd, (int)basis);
        double N = FinanceFunctionImpl.coupnum(settle, maturi, FinanceFunctionImpl.frequency(freq), basis);
        double A = UtilFns.dsm((Date)couppcd, (Date)settle, (int)basis);
        double price = redemp / Math.pow(1.0 + yld / (double)freq, N - 1.0 + DSC / E);
        double T1 = 100.0 * rate / (double)freq;
        double T2 = 1.0 + yld / (double)freq;
        double T3 = DSC / E;
        int i = 0;
        while ((double)i < N) {
            price += T1 / Math.pow(T2, (double)i + T3);
            ++i;
        }
        return price -= T1 * A / E;
    }

    private static double getYld(Date set, Date mat, double rate, double fPrice, double redemp, int freq, int basis) throws ArithmeticException, EvaluationException {
        double fPriceN = 0.0;
        double fYield1 = 0.0;
        double fYield2 = 1.0;
        double fPrice1 = FinanceFunctionImpl.price(set, mat, rate, fYield1, redemp, freq, basis);
        double fPrice2 = FinanceFunctionImpl.price(set, mat, rate, fYield2, redemp, freq, basis);
        double fYieldN = (fYield2 - fYield1) * 0.5;
        for (int nIter = 0; nIter < 100 && fPriceN != fPrice; ++nIter) {
            fPriceN = FinanceFunctionImpl.price(set, mat, rate, fYieldN, redemp, freq, basis);
            if (fPrice == fPrice1) {
                return fYield1;
            }
            if (fPrice == fPrice2) {
                return fYield2;
            }
            if (fPrice == fPriceN) {
                return fYieldN;
            }
            if (fPrice < fPrice2) {
                fPrice2 = FinanceFunctionImpl.price(set, mat, rate, fYield2 *= 2.0, redemp, freq, basis);
                fYieldN = (fYield2 - fYield1) * 0.5;
                continue;
            }
            if (fPrice < fPriceN) {
                fYield1 = fYieldN;
                fPrice1 = fPriceN;
            } else {
                fYield2 = fYieldN;
                fPrice2 = fPriceN;
            }
            fYieldN = fYield2 - (fYield2 - fYield1) * ((fPrice - fPrice2) / (fPrice1 - fPrice2));
        }
        if (Math.abs(fPrice - fPriceN) > fPrice / 100.0) {
            throw new ArithmeticException();
        }
        return fYieldN;
    }

    private static double db(double cost, double salvage, double life, double period, double month, double rate) {
        double db = cost * rate * month / 12.0;
        double d = cost * rate * month / 12.0;
        if (period > 1.0) {
            int i = 1;
            while ((double)i <= period - 1.0) {
                if ((double)i < life) {
                    db = (cost - d) * rate;
                    d += db;
                } else {
                    db = (cost - d) * rate * (12.0 - month) / 12.0;
                }
                ++i;
            }
        }
        return db;
    }

    private static double ddb(double cost, double salvage, double life, double period, double factor) {
        double d1 = factor * cost * Math.pow((life - factor) / life, period - 1.0) / life;
        double d2 = factor * cost * Math.pow((life - factor) / life, period - 1.0) / life - ((1.0 - Math.pow((life - factor) / life, period)) * cost - (cost - salvage));
        return Math.min(d1, d2);
    }

    private static double ppmt(double rate, double per, double nper, double pv, double fv, int type) {
        return FinanceFunctionImpl.pmt(rate, nper, pv, fv, type) - FinanceFunctionImpl.ipmt(rate, per, nper, pv, fv, type);
    }

    private static double pmt(double rate, double nper, double pv, double fv, int type) {
        double pmt = 0.0;
        if (rate == 0.0) {
            pmt = (fv + pv) / nper;
        } else {
            double term = Math.pow(1.0 + rate, nper);
            pmt = type == 1 ? (fv * rate / (term - 1.0) + pv * rate / (1.0 - 1.0 / term)) / (1.0 + rate) : fv * rate / (term - 1.0) + pv * rate / (1.0 - 1.0 / term);
        }
        return -pmt;
    }

    private static double ipmt(double rate, double per, double nper, double pv, double fv, int type) {
        double ipmt = 0.0;
        if (per == 1.0) {
            ipmt = type == 0 ? -pv : 0.0;
        } else {
            double pmt = FinanceFunctionImpl.pmt(rate, nper, pv, fv, type);
            if (type == 0) {
                ipmt = FinanceFunctionImpl.GetZw(rate, per - 1.0, pmt, pv, 0);
            } else if (type == 1) {
                ipmt = FinanceFunctionImpl.GetZw(rate, per - 2.0, pmt, pv, 1) - pmt;
            }
        }
        return ipmt * rate;
    }

    private static double GetZw(double rate, double nper, double pmt, double pv, int type) {
        double Zw = 0.0;
        if (rate == 0.0) {
            Zw = pv + pmt * nper;
        } else {
            double term = Math.pow(1.0 + rate, nper);
            Zw = (double)type > 0.0 ? pv * term + pmt * (1.0 + rate) * (term - 1.0) / rate : pv * term + pmt * (term - 1.0) / rate;
        }
        return -Zw;
    }
}

