/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.special.Erf;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.ComplexEx;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.NumericFunctionHelper;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.TextFunctionHelper;
import org.apache.poi.ss.formula.functions.UtilFns;

public class EngineeringFunctionImpl {
    private static final double THRESHOLD = 30.0;
    private static final double minE = 1.0E-10;
    private static final long iterateMax = 100L;
    public static final Function BESSELI = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            return NumericFunctionHelper.checkValue((double)EngineeringFunctionImpl.engineeringBesseli(x, n));
        }
    };
    public static final Function BESSELJ = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            return NumericFunctionHelper.checkValue((double)EngineeringFunctionImpl.engineeringBesselj(x, n));
        }
    };
    public static final Function BESSELK = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double result;
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (n < 0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (x == 0.0) {
                result = EngineeringFunctionImpl.BesselK0(x);
            } else if (x == 1.0) {
                result = EngineeringFunctionImpl.BesselK1(x);
            } else {
                double term = EngineeringFunctionImpl.BesselK0(x);
                result = EngineeringFunctionImpl.BesselK1(x);
                for (int i = 1; i < n; ++i) {
                    double temp = term + (double)(i * 2) / x * result;
                    term = result;
                    result = temp;
                }
            }
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function BESSELY = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double result;
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            int n = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            if (n < 0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            if (x == 0.0) {
                result = EngineeringFunctionImpl.BesselY0(x);
            } else if (x == 1.0) {
                result = EngineeringFunctionImpl.BesselY1(x);
            } else {
                double term = EngineeringFunctionImpl.BesselY0(x);
                result = EngineeringFunctionImpl.BesselY1(x);
                for (int i = 1; i < n; ++i) {
                    double temp = (double)(i * 2) / x * result - term;
                    term = result;
                    result = temp;
                }
            }
            return NumericFunctionHelper.checkValue((double)result);
        }
    };
    public static final Function BIN2DEC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            int num = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return EngineeringFunctionImpl.binToDec(Integer.toString(num));
        }
    };
    public static final Function BIN2HEX = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String bin = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToHex(EngineeringFunctionImpl.binToDec(bin), places));
        }
    };
    public static final Function BIN2OCT = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String bin = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToOct(EngineeringFunctionImpl.binToDec(bin), places));
        }
    };
    public static final Function COMPLEX = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            double real = TextFunctionHelper.evaluateDoubleArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            double imaginary = TextFunctionHelper.evaluateDoubleArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            String suffix = "i";
            if (args.length == 3) {
                suffix = TextFunctionHelper.evaluateStringArg((ValueEval)args[2], (int)srcCellRow, (int)srcCellCol);
            }
            if (Double.isNaN(real) || Double.isNaN(imaginary) || !"i".equals(suffix) && !"j".equals(suffix)) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return new StringEval(UtilFns.format((ComplexEx)new ComplexEx(real, imaginary, suffix)));
        }
    };
    public static final Function DEC2BIN = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            int dec = TextFunctionHelper.evaluateIntArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToBin(dec, places));
        }
    };
    public static final Function DEC2HEX = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            int dec = TextFunctionHelper.evaluateIntArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToHex(dec, places));
        }
    };
    public static final Function DEC2OCT = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            int dec = TextFunctionHelper.evaluateIntArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToOct(dec, places));
        }
    };
    public static final Function HEX2DEC = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String hex = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            return new NumberEval((double)EngineeringFunctionImpl.hexToDec(hex));
        }
    };
    public static final Function HEX2BIN = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String hex = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToBin((int)EngineeringFunctionImpl.hexToDec(hex), places));
        }
    };
    public static final Function HEX2OCT = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String hex = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToOct((int)EngineeringFunctionImpl.hexToDec(hex), places));
        }
    };
    public static final Function DELTA = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double n1 = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double n2 = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
            boolean result = false;
            if (n1 == n2) {
                result = true;
            }
            return (double)result;
        }
    };
    public static final Function ERF = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double lowerLimit = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            double upperLimit = 0.0;
            if (lowerLimit < 0.0 || upperLimit < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double erf = Erf.erf((double)lowerLimit);
            if (args.length == 2) {
                upperLimit = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex);
                erf = Erf.erf((double)upperLimit) - erf;
            }
            return erf;
        }
    };
    public static final Function ERFC = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double x = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            if (x < 0.0) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            double erfc = 1.0 - Erf.erf((double)x);
            return erfc;
        }
    };
    public static final Function GESTEP = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            double step;
            double num = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return num >= (step = NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcRowIndex, (int)srcColumnIndex)) ? 1.0 : 0.0;
        }
    };
    public static final Function IMABS = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return UtilFns.validateComplex((String)inum).abs();
        }
    };
    public static final Function IMAGINARY = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return UtilFns.validateComplex((String)inum).getImaginary();
        }
    };
    public static final Function IMARGUMENT = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            double real = c.getReal();
            double img = c.getImaginary();
            if (img == 0.0 && real == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return Math.atan2(img, real);
        }
    };
    public static final Function IMCONJUGATE = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.conjugate(), (String)c.getSuffix())));
        }
    };
    public static final Function IMCOS = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.cos(), (String)c.getSuffix())));
        }
    };
    public static final Function IMDIV = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum1 = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            String inum2 = TextFunctionHelper.evaluateStringArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c1 = UtilFns.validateComplex((String)inum1);
            ComplexEx c2 = UtilFns.validateComplex((String)inum2);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c1.divide((Complex)c2), (String)c1.getSuffix())));
        }
    };
    public static final Function IMEXP = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            String suffix = c.getSuffix();
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)new ComplexEx(Math.E, 0.0, suffix).pow((Complex)c), (String)suffix)));
        }
    };
    public static final Function IMLN = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.log(), (String)c.getSuffix())));
        }
    };
    public static final Function IMLOG10 = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            String suffix = c.getSuffix();
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.log().divide(new ComplexEx(10.0, 0.0, suffix).log()), (String)suffix)));
        }
    };
    public static final Function IMLOG2 = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            String suffix = c.getSuffix();
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.log().divide(new ComplexEx(2.0, 0.0, suffix).log()), (String)suffix)));
        }
    };
    public static final Function IMPOWER = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum1 = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            String inum2 = TextFunctionHelper.evaluateStringArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c1 = UtilFns.validateComplex((String)inum1);
            ComplexEx c2 = UtilFns.validateComplex((String)inum2);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c1.pow((Complex)c2), (String)c1.getSuffix())));
        }
    };
    public static final Function IMPRODUCT = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            ComplexEx[] c = EngineeringFunctionImpl.toComplexArray(args, srcCellRow, srcCellCol);
            Complex product = null;
            for (int i = 0; i < c.length - 1; ++i) {
                product = c[i].multiply((Complex)c[i + 1]);
            }
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)product, (String)UtilFns.validateComplex((String)TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol)).getSuffix())));
        }
    };
    public static final Function IMREAL = new NumericFunction(){

        public double eval(ValueEval[] args, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcRowIndex, (int)srcColumnIndex);
            return UtilFns.validateComplex((String)inum).getReal();
        }
    };
    public static final Function IMSIN = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.sin(), (String)c.getSuffix())));
        }
    };
    public static final Function IMSQRT = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String inum = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            ComplexEx c = UtilFns.validateComplex((String)inum);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)c.sqrt(), (String)c.getSuffix())));
        }
    };
    public static final Function IMSUB = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            ComplexEx[] complex = EngineeringFunctionImpl.toComplexArray(args, srcCellRow, srcCellCol);
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)complex[0].subtract((Complex)complex[1]), (String)complex[0].getSuffix())));
        }
    };
    public static final Function IMSUM = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            ComplexEx[] c = EngineeringFunctionImpl.toComplexArray(args, srcCellRow, srcCellCol);
            Complex sum = null;
            for (int i = 0; i < c.length - 1; ++i) {
                sum = c[i].add((Complex)c[i + 1]);
            }
            return new StringEval(UtilFns.format((ComplexEx)UtilFns.cToComplex((Complex)sum, (String)UtilFns.validateComplex((String)TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol)).getSuffix())));
        }
    };
    public static final Function OCT2BIN = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String oct = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToBin(EngineeringFunctionImpl.octToDec(oct), places));
        }
    };
    public static final Function OCT2DEC = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String oct = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            return new NumberEval((double)EngineeringFunctionImpl.octToDec(oct));
        }
    };
    public static final Function OCT2HEX = new TextFunction(){

        public ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String oct = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int places = 0;
            if (args.length == 2) {
                places = TextFunctionHelper.evaluateIntArg((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            return new StringEval(EngineeringFunctionImpl.decToHex(EngineeringFunctionImpl.octToDec(oct), places));
        }
    };

    private static long fac(long n) {
        long result = 1L;
        if (n <= 1L) {
            return 1L;
        }
        while (n >= 2L) {
            result *= n;
            --n;
        }
        return result;
    }

    private static double engineeringBesselj(double x, int n) throws EvaluationException {
        double result = 0.0;
        int k = 1;
        double absX = Math.abs(x);
        if (n < 0) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        if (absX < 30.0) {
            double Term;
            result = Term = Math.pow(x / 2.0, n) / (double)EngineeringFunctionImpl.fac(n);
            double upTerm = -(Math.pow(x, 2.0) / 4.0);
            do {
                Term = upTerm / (double)(k * (n + k)) * Term;
                result += Term;
            } while (Math.abs(Term) > 1.0E-10 && (long)(++k) < 100L);
        } else {
            result = Math.sqrt(2.0 / (Math.PI * absX)) * Math.cos(absX - (double)n * Math.PI / 2.0 - 0.7853981633974483);
            if (x < 0.0 && n % 2 == 1) {
                result *= -1.0;
            }
        }
        return result;
    }

    private static double BesselK0(double x) throws EvaluationException {
        double result;
        if (x <= 2.0) {
            double x2 = x * 0.5;
            double y = x2 * x2;
            Double[] para = new Double[]{new Double(x), new Double(0.0)};
            result = -1.0 * Math.log(x2) * EngineeringFunctionImpl.engineeringBesseli(x, 0) + (-0.57721566 + y * (0.4227842 + y * (0.23069756 + y * (0.0348859 + y * (0.00262698 + y * (1.075E-4 + y * 7.4E-6))))));
        } else {
            double y = 2.0 / x;
            result = Math.exp(-1.0 * x) / Math.sqrt(x) * (1.25331414 + y * (-0.07832358 + y * (0.02189568 + y * (-0.01062446 + y * (0.00587872 + y * (-0.0025154 + y * 5.3208E-4))))));
        }
        return result;
    }

    private static double BesselK1(double x) throws EvaluationException {
        double result;
        if (x <= 2.0) {
            double x2 = x * 0.5;
            double y = x2 * x2;
            Double[] para_for_i = new Double[]{new Double(x), new Double(1.0)};
            result = Math.log(x2) * EngineeringFunctionImpl.engineeringBesseli(x, 1) + (1.0 + y * (0.15443144 + y * (-0.67278579 + y * (-0.18156897 + y * (-0.01919402 + y * (-0.00110404 + y * -4.686E-5)))))) / x;
        } else {
            double y = 2.0 / x;
            result = Math.exp(-1.0 * x) / Math.sqrt(x) * (1.25331414 + y * (0.23498619 + y * (-0.0365562 + y * (0.01504268 + y * (-0.00780353 + y * (0.00325614 + y * -6.8245E-4))))));
        }
        return result;
    }

    public static double engineeringBesseli(double x, int n) throws EvaluationException {
        double result = 0.0;
        if (n < 0) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        double absX = Math.abs(x);
        if (absX < 30.0) {
            double Term;
            result = Term = Math.pow(x / 2.0, n) / (double)EngineeringFunctionImpl.fac(n);
            double upTerm = Math.pow(x, 2.0) / 4.0;
            int k = 1;
            do {
                Term = upTerm / (double)(k * (n + k)) * Term;
                result += Term;
            } while (Math.abs(Term) > 1.0E-10 && (long)(++k) < 100L);
        } else {
            result = Math.exp(x) / Math.sqrt(Math.PI * 2 * x);
            if (x < 0.0 && n % 2 == 1) {
                result *= -1.0;
            }
        }
        return result;
    }

    private static double BesselY0(double x) throws EvaluationException {
        double result;
        if (x < 8.0) {
            double y = x * x;
            double f1 = -2.957821389E9 + y * (7.062834065E9 + y * (-5.123598036E8 + y * (1.087988129E7 + y * (-86327.92757 + y * 228.4622733))));
            double f2 = 4.0076544269E10 + y * (7.452499648E8 + y * (7189466.438 + y * (47447.2647 + y * (226.1030244 + y))));
            Double[] para = new Double[]{new Double(x), new Double(0.0)};
            result = f1 / f2 + 0.636619772 * EngineeringFunctionImpl.engineeringBesselj(x, 0) * Math.log(x);
        } else {
            double z = 8.0 / x;
            double y = z * z;
            double x2 = x - 0.785398164;
            double f1 = 1.0 + y * (-0.001098628627 + y * (2.734510407E-5 + y * (-2.073370639E-6 + y * 2.093887211E-7)));
            double f2 = -0.01562499995 + y * (1.430488765E-4 + y * (-6.911147651E-6 + y * (7.621095161E-7 + y * -9.34945152E-8)));
            result = Math.sqrt(0.636619772 / x) * (Math.sin(x2) * f1 + z * Math.cos(x2) * f2);
        }
        return result;
    }

    private static double BesselY1(double x) throws EvaluationException {
        double result;
        if (x < 8.0) {
            double y = x * x;
            double f1 = x * (-4.900604943E12 + y * (1.27527439E12 + y * (-5.153438139E10 + y * (7.349264551E8 + y * (-4237922.726 + y * 8511.937935)))));
            double f2 = 2.49958057E13 + y * (4.244419664E11 + y * (3.733650367E9 + y * (2.245904002E7 + y * (102042.605 + y * (354.9632885 + y)))));
            Double[] para = new Double[]{new Double(x), new Double(1.0)};
            result = f1 / f2 + 0.636619772 * (EngineeringFunctionImpl.engineeringBesselj(x, 1) * Math.log(x) - 1.0 / x);
        } else {
            result = Math.sqrt(0.636619772 / x) * Math.sin(x - 2.356194491);
        }
        return result;
    }

    private static int binToDec(String bin) throws EvaluationException {
        int places = bin.length();
        if (places > 10) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        for (int i = 0; i < places; ++i) {
            if (bin.charAt(i) == '0' || bin.charAt(i) == '1') continue;
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        Integer result = Integer.valueOf(bin, 2);
        if (places == 10) {
            result = result - 1024;
        }
        return result;
    }

    private static String decToBin(int dec, int places) throws EvaluationException {
        if (dec < -512 || dec > 511) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        String result = Integer.toBinaryString(dec);
        if (dec < 0) {
            result = result.substring(result.length() - 10, result.length());
        }
        if (places != 0 && result.length() < 10) {
            result = UtilFns.padZero((String)result, (int)places);
        }
        return result;
    }

    private static String decToHex(int dec, int places) throws EvaluationException {
        String result = Integer.toHexString(dec).toUpperCase();
        if (dec < 0) {
            StringBuffer sf = new StringBuffer("FFFFFFFFFF");
            result = sf.replace(10 - result.length(), 10, result).toString();
        }
        if (places != 0 && result.length() < 10) {
            result = UtilFns.padZero((String)result, (int)places);
        }
        return result;
    }

    private static String decToOct(int dec, int places) throws EvaluationException {
        if (dec < -536870912 || dec > 0x1FFFFFFF) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        String result = Integer.toOctalString(dec);
        if (dec < 0) {
            result = result.substring(result.length() - 10, result.length());
        }
        if (places != 0 && result.length() < 10) {
            result = UtilFns.padZero((String)result, (int)places);
        }
        return result;
    }

    private static boolean isHex(String hex) {
        boolean result = true;
        for (int i = 0; i < hex.length(); ++i) {
            if (Character.isDigit(hex.charAt(i)) || hex.substring(i, i + 1).matches("[a-fA-F]")) continue;
            result = false;
        }
        return result;
    }

    private static long hexToDec(String hex) throws EvaluationException {
        int places = hex.length();
        if (places > 10) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        if (!EngineeringFunctionImpl.isHex(hex)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        Long result = Long.valueOf(hex, 16);
        if (result > Long.valueOf("7fffffffff", 16)) {
            result = result - Long.valueOf("10000000000", 16);
        }
        return result;
    }

    public static ComplexEx[] toComplexArray(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
        ComplexEx[] complex = new ComplexEx[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof ErrorEval) {
                throw new EvaluationException((ErrorEval)args[i]);
            }
            complex[i] = UtilFns.validateComplex((String)TextFunctionHelper.evaluateStringArg((ValueEval)args[i], (int)srcCellRow, (int)srcCellCol));
            if (complex[i].getSuffix().equals("k")) continue;
            for (int j = 0; j < i; ++j) {
                if (complex[j].getSuffix().equals("k") || complex[i].getSuffix().equals(complex[j].getSuffix())) continue;
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
        }
        return complex;
    }

    private static boolean isOct(String oct) {
        boolean result = true;
        for (int i = 0; i < oct.length(); ++i) {
            if (oct.substring(i, i + 1).matches("[0-7]")) continue;
            result = false;
        }
        return result;
    }

    private static int octToDec(String oct) throws EvaluationException {
        int places = oct.length();
        if (places > 10) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        if (!EngineeringFunctionImpl.isOct(oct)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        Integer result = Integer.valueOf(oct, 8);
        if (result > 0x1FFFFFFF) {
            result = result - 0x40000000;
        }
        return result;
    }
}

