/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula;

import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.SheetRegion;
import io.keikai.model.impl.sys.formula.FormulaEngineImpl;
import io.keikai.model.impl.sys.formula.ParsingBook;
import io.keikai.model.sys.dependency.Ref;
import io.keikai.model.sys.formula.FormulaEngine;
import io.keikai.model.sys.formula.FormulaExpression;
import io.keikai.model.sys.formula.FormulaParseContext;
import io.keikaiex.formula.XelContextHolder;
import java.util.Locale;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.Formula;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaTokenParser;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.TablePtg;
import org.apache.poi.ss.usermodel.ZssContext;
import org.zkoss.xel.XelContext;

public class FormulaEngineEx
extends FormulaEngineImpl
implements FormulaEngine {
    protected Object getXelContext() {
        return XelContextHolder.getXelContext();
    }

    protected void setXelContext(Object ctx) {
        XelContextHolder.setXelContext((XelContext)ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String renderFormula(ParsingBook parsingBook, String formula, Ptg[] tokens, boolean always) {
        ZssContext old = ZssContext.getThreadLocal();
        try {
            ZssContext zssContext = old == null ? new ZssContext(Locale.US, -1) : new ZssContext(Locale.US, old.getTwoDigitYearUpperBound());
            ZssContext.setThreadLocal((ZssContext)zssContext);
            String string = super.renderFormula(parsingBook, formula, tokens, always);
            return string;
        }
        finally {
            ZssContext.setThreadLocal((ZssContext)old);
        }
    }

    public Ptg[] parse(String formula, FormulaParsingWorkbook book, int sheetIndex, FormulaParseContext context) {
        SCell cell = context.getCell();
        return FormulaTokenParser.parse((String)formula, (FormulaParsingWorkbook)book, (int)sheetIndex, (Locale)context.getLocale(), (int)(cell == null ? -1 : cell.getRowIndex()), (int)(cell == null ? -1 : cell.getColumnIndex()), (FormulaType)FormulaEngineImpl.convertToPOIFormulaType((io.keikai.model.sys.formula.FormulaType)context.getFormulaType()));
    }

    public FormulaExpression movePtgs(FormulaExpression fe, SheetRegion region, int rowOffset, int columnOffset, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getMoveAdjuster(region, rowOffset, columnOffset);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    public FormulaExpression shrinkPtgs(FormulaExpression fe, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        SheetRegion neighbor;
        SSheet sheet = srcRegion.getSheet();
        int rowOffset = 0;
        int colOffset = 0;
        if (horizontal) {
            colOffset = -srcRegion.getColumnCount();
            int col = srcRegion.getLastColumn() + 1;
            int lastCol = sheet.getBook().getMaxColumnIndex();
            int row = srcRegion.getRow();
            int lastRow = srcRegion.getLastRow();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        } else {
            rowOffset = -srcRegion.getRowCount();
            int row = srcRegion.getLastRow() + 1;
            int lastRow = sheet.getBook().getMaxRowIndex();
            int col = srcRegion.getColumn();
            int lastCol = srcRegion.getLastColumn();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        }
        return this.movePtgs(fe, neighbor, rowOffset, colOffset, context);
    }

    public FormulaExpression extendPtgs(FormulaExpression fe, SheetRegion srcRegion, boolean horizontal, FormulaParseContext context) {
        SheetRegion neighbor;
        SSheet sheet = srcRegion.getSheet();
        int rowOffset = 0;
        int colOffset = 0;
        if (horizontal) {
            colOffset = srcRegion.getColumnCount();
            int col = srcRegion.getColumn();
            int lastCol = sheet.getBook().getMaxColumnIndex();
            int row = srcRegion.getRow();
            int lastRow = srcRegion.getLastRow();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        } else {
            rowOffset = srcRegion.getRowCount();
            int row = srcRegion.getRow();
            int lastRow = sheet.getBook().getMaxRowIndex();
            int col = srcRegion.getColumn();
            int lastCol = srcRegion.getLastColumn();
            neighbor = new SheetRegion(sheet, row, col, lastRow, lastCol);
        }
        return this.movePtgs(fe, neighbor, rowOffset, colOffset, context);
    }

    public FormulaExpression shiftPtgs(FormulaExpression fe, int rowOffset, int columnOffset, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getShiftAdjuster(rowOffset, columnOffset);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    public FormulaExpression transposePtgs(FormulaExpression fe, int rowOrigin, int columnOrigin, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getTransposeAdjuster(rowOrigin, columnOrigin);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    public FormulaExpression renameSheetPtgs(FormulaExpression fe, SBook targetBook, String oldSheetName, String newSheetName, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getRenameSheetAdjuster(targetBook, oldSheetName, newSheetName);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    public FormulaExpression renameNamePtgs(FormulaExpression fe, SBook targetBook, int sheetIndex, String oldName, String newName, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getRenameNameAdjuster(sheetIndex, oldName, newName);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    private FormulaExpression adjustPtgs(FormulaExpression fe, FormulaParseContext context, FormulaEngineImpl.FormulaAdjuster adjuster) {
        Ref[] refs;
        Ref[] refArray;
        Ref singleRef;
        if (fe.hasError()) {
            return fe;
        }
        SBook book = context.getBook();
        ParsingBook parsingBook = new ParsingBook(book);
        String sheetName = context.getSheetName();
        int contextSheetIndex = parsingBook.getExternalSheetIndex(null, sheetName);
        Ptg[] tokens = Formula.createX((Ptg[])fe.getPtgs()).getTokens(SpreadsheetVersion.EXCEL2007);
        boolean modified = adjuster.process(contextSheetIndex, tokens, parsingBook, context);
        Ref ref = singleRef = tokens.length == 1 ? this.toDependRef(context, parsingBook, tokens[0], 0) : null;
        if (singleRef == null) {
            refArray = null;
        } else if (singleRef.getType() == Ref.RefType.AREA || singleRef.getType() == Ref.RefType.CELL) {
            Ref[] refArray2 = new Ref[1];
            refArray = refArray2;
            refArray2[0] = singleRef;
        } else {
            refArray = refs = null;
        }
        if (modified) {
            String formula = this.renderFormula(parsingBook, null, tokens, true);
            return new FormulaEngineImpl.FormulaExpressionImpl(formula, tokens, refs, fe.isMultipleAreaFormula());
        }
        return fe;
    }

    public FormulaExpression renameTableNameTablePtgs(FormulaExpression fe, SBook book, String oldName, String newName, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getRenameTableAdjuster(oldName, newName);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    protected FormulaEngineImpl.FormulaAdjuster getRenameTableAdjuster(final String oldName, final String newName) {
        return new FormulaEngineImpl.FormulaAdjuster(){

            public boolean process(int contextSheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                for (Ptg ptg : tokens) {
                    TablePtg tbPtg;
                    if (!(ptg instanceof TablePtg) || !(tbPtg = (TablePtg)ptg).getTableName().equals(oldName)) continue;
                    tbPtg.setTableName(newName);
                }
                return true;
            }
        };
    }

    public FormulaExpression renameColumnNameTablePtgs(FormulaExpression fe, STable table, String oldName, String newName, FormulaParseContext context) {
        FormulaEngineImpl.FormulaAdjuster shiftAdjuster = this.getRenameColumnAdjuster(table.getName(), oldName, newName);
        return this.adjustPtgs(fe, context, shiftAdjuster);
    }

    protected FormulaEngineImpl.FormulaAdjuster getRenameColumnAdjuster(final String tableName, final String oldName, final String newName) {
        return new FormulaEngineImpl.FormulaAdjuster(){

            public boolean process(int contextSheetIndex, Ptg[] tokens, ParsingBook parsingBook, FormulaParseContext context) {
                for (Ptg ptg : tokens) {
                    String col1;
                    TablePtg tbPtg;
                    if (!(ptg instanceof TablePtg) || !(tbPtg = (TablePtg)ptg).getTableName().equalsIgnoreCase(tableName) || (col1 = tbPtg.getColumn1()) == null) continue;
                    if (col1.equalsIgnoreCase(oldName)) {
                        tbPtg.setColumn1(newName);
                        continue;
                    }
                    String col2 = tbPtg.getColumn2();
                    if (col2 == null || !col2.equalsIgnoreCase(oldName)) continue;
                    tbPtg.setColumn2(newName);
                }
                return true;
            }
        };
    }
}

