/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula;

import io.keikaiex.formula.XelContextHolder;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.xel.XelContext;

public class ELEvalFunction
implements Function,
FreeRefFunction,
Serializable {
    private static final long serialVersionUID = 8370499997232730816L;
    private final String _functionName;
    private static final Logger logger = LoggerFactory.getLogger(ELEvalFunction.class);

    public ELEvalFunction(String name) {
        this._functionName = name;
    }

    public boolean hasFunction() {
        XelContext ctx = XelContextHolder.getXelContext();
        if (ctx != null) {
            String tldFuncname = this._functionName.replace('.', '$');
            org.zkoss.xel.Function fn = ctx.getFunctionMapper().resolveFunction("keikai", tldFuncname);
            return fn != null;
        }
        return false;
    }

    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        XelContext ctx = XelContextHolder.getXelContext();
        if (ctx == null) {
            throw new NotImplementedException(this._functionName + ", not in zk context");
        }
        String tldFuncname = this._functionName.replace('.', '$');
        org.zkoss.xel.Function fn = ctx.getFunctionMapper().resolveFunction("keikai", tldFuncname);
        if (fn != null) {
            Class retType = fn.getReturnType();
            Class[] paramTypes = fn.getParameterTypes();
            try {
                if (ValueEval.class.isAssignableFrom(retType) && paramTypes.length == 3 && ValueEval[].class.isAssignableFrom(paramTypes[0]) && Integer.TYPE.equals(paramTypes[1]) && Integer.TYPE.equals(paramTypes[2])) {
                    return (ValueEval)fn.invoke(null, new Object[]{args, srcRowIndex, srcColumnIndex});
                }
                Object[] params = new Object[args.length];
                for (int j = 0; j < args.length; ++j) {
                    Object param;
                    Class paramType = paramTypes[j];
                    ValueEval ev = OperandResolver.getSingleValue((ValueEval)args[j], (int)srcRowIndex, (int)srcColumnIndex);
                    params[j] = param = this.coerceToObject(paramType, ev);
                }
                Object retValue = fn.invoke(null, params);
                return this.coerceToValueEval(retType, retValue);
            }
            catch (Exception e) {
                if (e instanceof EvaluationException) {
                    return ((EvaluationException)((Object)e)).getErrorEval();
                }
                if (e instanceof InvocationTargetException) {
                    Throwable te = ((InvocationTargetException)e).getTargetException();
                    if (te instanceof EvaluationException) {
                        return ((EvaluationException)te).getErrorEval();
                    }
                    logger.warn("cannot invoke " + this._functionName + " for " + te);
                    return ErrorEval.VALUE_INVALID;
                }
                return ErrorEval.VALUE_INVALID;
            }
        }
        return ErrorEval.NAME_INVALID;
    }

    private Object coerceToObject(Class<?> type, ValueEval value) throws EvaluationException {
        if (ValueEval.class.isAssignableFrom(type)) {
            return value;
        }
        if (String.class.isAssignableFrom(type)) {
            return OperandResolver.coerceValueToString((ValueEval)value);
        }
        if (Integer.TYPE.equals(type) || Integer.class.isAssignableFrom(type)) {
            return new Integer(OperandResolver.coerceValueToInt((ValueEval)value));
        }
        if (Short.TYPE.equals(type) || Short.class.isAssignableFrom(type)) {
            return new Short((short)OperandResolver.coerceValueToInt((ValueEval)value));
        }
        if (Long.TYPE.equals(type) || Long.class.isAssignableFrom(type)) {
            return new Long((long)Math.floor(OperandResolver.coerceValueToDouble((ValueEval)value)));
        }
        if (Byte.TYPE.equals(type) || Byte.class.isAssignableFrom(type)) {
            return new Byte((byte)OperandResolver.coerceValueToInt((ValueEval)value));
        }
        if (Double.TYPE.equals(type) || Double.class.isAssignableFrom(type)) {
            return new Double(OperandResolver.coerceValueToDouble((ValueEval)value));
        }
        if (Float.TYPE.equals(type) || Float.class.isAssignableFrom(type)) {
            return new Float(OperandResolver.coerceValueToDouble((ValueEval)value));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new BigDecimal(OperandResolver.coerceValueToDouble((ValueEval)value));
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return new BigInteger("" + (long)Math.floor(OperandResolver.coerceValueToDouble((ValueEval)value)));
        }
        if (Date.class.isAssignableFrom(type)) {
            return DateUtil.getJavaDate((double)OperandResolver.coerceValueToDouble((ValueEval)value));
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    private ValueEval coerceToValueEval(Class<?> type, Object value) throws EvaluationException {
        if (String.class.isAssignableFrom(type)) {
            return new StringEval((String)value);
        }
        if (Number.class.isAssignableFrom(type) || Integer.TYPE.equals(type) || Double.TYPE.equals(type) || Float.TYPE.equals(type) || Long.TYPE.equals(type) || Short.TYPE.equals(type) || Byte.TYPE.equals(type)) {
            return new NumberEval(((Number)value).doubleValue());
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return BoolEval.valueOf((boolean)((Boolean)value));
        }
        if (value instanceof ValueEval) {
            return (ValueEval)value;
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        return this.evaluate(args, ec.getRowIndex(), ec.getColumnIndex());
    }
}

