/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula;

import io.keikai.model.sys.EngineFactory;
import io.keikaiex.formula.XelContextHolder;
import java.util.Date;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.XelContext;

public class ELEval
implements FreeRefFunction {
    public static final FreeRefFunction instance = new ELEval();
    public static final String NAME = "ELEVAL";

    private ELEval() {
    }

    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length != 1) {
            return ErrorEval.NAME_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue((ValueEval)args[0], (int)ec.getRowIndex(), (int)ec.getColumnIndex());
            String expression = OperandResolver.coerceValueToString((ValueEval)ve);
            XelContext ctx = XelContextHolder.getXelContext();
            Object obj = Expressions.evaluate((XelContext)ctx, (String)expression, (Class)((Class)ctx.getAttribute("io.keikai.CellType")));
            if (obj == null) {
                return ErrorEval.NAME_INVALID;
            }
            if (obj instanceof String) {
                return new StringEval((String)obj);
            }
            if (obj instanceof Number) {
                return new NumberEval(((Number)obj).doubleValue());
            }
            if (obj instanceof Boolean) {
                return BoolEval.valueOf((boolean)((Boolean)obj));
            }
            if (obj instanceof Date) {
                return new NumberEval(EngineFactory.getInstance().getCalendarUtil().dateToDoubleValue((Date)obj));
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return ErrorEval.VALUE_INVALID;
    }
}

