/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.app.impl;

import io.keikai.api.model.Book;
import io.keikai.app.CollaborationInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollaborationInfoEx
implements CollaborationInfo,
Serializable {
    private static final long serialVersionUID = -6600058942955225868L;
    private static final String DEFAULT_USERNAME = "user";
    protected List<CollaborationInfo.CollaborationEventListener> eventListeners = new ArrayList<CollaborationInfo.CollaborationEventListener>();
    private Map<String, Set<String>> bookUsersRelationship = new HashMap<String, Set<String>>(10);
    private Map<String, String> userBookRelationship = new HashMap<String, String>(10);
    private int count = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelationship(String username, Book book) {
        if (book == null || username == null) {
            return;
        }
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            String bookName;
            Set<String> users;
            if (this.userBookRelationship.get(username) != null) {
                this.removeRelationship(username);
            }
            if ((users = this.bookUsersRelationship.get(bookName = book.getBookName())) == null) {
                users = new HashSet<String>(10);
                this.bookUsersRelationship.put(bookName, users);
            }
            users.add(username);
            this.userBookRelationship.put(username, bookName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRelationship(String username) {
        if (username == null) {
            return;
        }
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            String bookName = this.userBookRelationship.get(username);
            if (bookName == null) {
                return;
            }
            Set<String> users = this.bookUsersRelationship.get(bookName);
            users.remove(username);
            this.userBookRelationship.put(username, null);
            if (users.isEmpty()) {
                this.bookUsersRelationship.remove(bookName);
                for (CollaborationInfo.CollaborationEventListener listener : this.eventListeners) {
                    listener.onEvent(new CollaborationInfo.CollaborationEvent(CollaborationInfo.CollaborationEvent.Type.BOOK_EMPTY, (Object)bookName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsernameExist(String username) {
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            return this.userBookRelationship.containsKey(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUsername(String username, String oldUsername) {
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            if (this.userBookRelationship.containsKey(username)) {
                return false;
            }
            if (oldUsername == username) {
                return true;
            }
            if (oldUsername != null) {
                this.removeUsername(oldUsername);
            }
            this.userBookRelationship.put(username, null);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUsername(String username) {
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            if (!this.userBookRelationship.containsKey(username)) {
                return;
            }
            this.removeRelationship(username);
            this.userBookRelationship.remove(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getUsedUsernames(String bookName) {
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            return new HashSet<String>((Collection)this.bookUsersRelationship.get(bookName));
        }
    }

    public String getUsername(String originName) {
        CollaborationInfoEx collaborationInfoEx = this;
        synchronized (collaborationInfoEx) {
            String name;
            if (originName == null) {
                String name2;
                do {
                    if (this.count != 1 || this.isUsernameExist(DEFAULT_USERNAME)) continue;
                    ++this.count;
                    this.addUsername(DEFAULT_USERNAME, null);
                    return DEFAULT_USERNAME;
                } while (this.isUsernameExist(name2 = DEFAULT_USERNAME + this.count++));
                this.addUsername(name2, null);
                return name2;
            }
            if (this.addUsername(originName, null)) {
                return originName;
            }
            int i = 2;
            while (!this.addUsername(name = originName + " (" + i++ + ")", null)) {
            }
            return name;
        }
    }

    public void addEvent(CollaborationInfo.CollaborationEventListener listener) {
        this.eventListeners.add(listener);
    }

    class UserKey
    implements Serializable {
        private static final long serialVersionUID = -5602415951429601335L;
        private String sessionId;
        private String username;
        private Set<String> desktopIds = new HashSet<String>();

        UserKey() {
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public Set<String> getDesktopIds() {
            return this.desktopIds;
        }

        public void setDesktopIds(Set<String> desktopIds) {
            this.desktopIds = desktopIds;
        }
    }
}

