/* overflow.js

	Purpose:
		
	Description:
		
	History:
		Aug 9, 2013 Created by Pao Wang

Copyright (C) 2013 Potix Corporation. All Rights Reserved.
*/

(function () {
  // constant
  var NUM_CELL = 0;
  var STR_CELL = 1;
  var FORMULA_CELL = 2;
  var BLANK_CELL = 3;
  var BOOLEAN_CELL = 4;
  var ERROR_CELL = 5;
  var oCell = {};
  var OVERFLOW_PARTIAL_RIGHT_ALIGN = "zscell-overflow-partial-right-alignment-text";
  zk.override(zss.Cell.prototype, oCell, {
    /**
     * render a (cut) overflow text based on the complete text width instead of the cut width.
     * if textWidth <= cellWidth, no overflow
           * if textWidth > cellWidth &&  textWidth < availableSpace, overflow with cut text
           * if textWidth > availableSpace, overflow without cut
     */
    _processOverflow: function () {
      let self = this;
      // do it async.
      zkS.queueAsynctask(function () {
        if (!self.desktop) return;

        //ZSS-944: 90 degree text will not do overflow
        var rotate90 = self.rotate == 90 || self.rotate == -90; //ZSS-1020
        if (rotate90) return;
        var col = self.c;
        var rBorder = self.rborder;
        var $n = jq(self.$n());
        var cave = self.$n('cave');
        var $cave = jq(cave);
        var tn = self.getTextNode();
        var $tn = jq(tn);

        // clear previous width setting for measuring correctly
        self.setCaveWidth('');
        $tn.css('left', '');
        //clear existing overflow CSS because it might change
        $cave.removeClass(OVERFLOW_PARTIAL_RIGHT_ALIGN);
        $n.removeClass("zscell-overflow-b");
        $n.removeClass("zscell-overflow");
        var sheet = self.sheet;
        var custColWidth = sheet.custColWidth;
        var notxtwd = self._txtwd == undefined || self._txtwd < 0; //ZSS-1171
        var sw = notxtwd ? Math.max(sheet.custColWidth.getSize(self.c) - zk(self.$n()).padBorderWidth(), zkS.getTextWidth(self.getPureText(), tn)) : self._txtwd; // heavy duty (it's actually a function call from ZK widget), ZSS-1171
        var cellPad = sheet.cellPad;

        //ZSS-1171
        if (notxtwd) {
          self._txtwd = sw;
          sheet._sendOnTextWidth(self.r, col, sw);
        }

        // KEIKAI-271: we should consider merge cells case
        let cellWidth = custColWidth.getSize(self.c);
        if (self.isMerged()) {
          for (let s = self.c + 1; s <= self.merr; s++) {
            cellWidth += sheet.custColWidth.getSize(s);
          }
        }
        // skip to process overflow if current cell's width is enough
        // right grid line won't be removed if it's css has no zscell-overflow class
        if (sw <= cellWidth - cellPad) {
          return;
        }

        // apply overflow CSS and adjust a text width
        let hAlign = self.halign;
        if (hAlign == 'l') {
          //left alignment
          var availableSpace = self.getAvailableSpace(sw, function (cell) {
            return cell.nextSibling;
          }) - cellPad;

          // Do it into the end of the event loop for avoiding browser reflow.
          zkS.queueMicrotask(function () {
            self.setCaveWidth(jq.px0(availableSpace));
            self.visibleTextWidth = availableSpace;
            $n.addClass(rBorder ? "zscell-overflow-b" : "zscell-overflow");
          });
        } else if (hAlign == 'r') {
          //right alignment; ZSS-1338
          //count available space for overflow to the left-hand side cells
          let textWidth = sw;
          let availableSpace = self.getAvailableSpace(textWidth, function (cell) {
            return cell.previousSibling;
          });
          // Do it into the end of the event loop for avoiding browser reflow.
          zkS.queueMicrotask(function () {
            //make overflow
            if (availableSpace > textWidth) {
              //overflow without cut
              //right align already moves text left, only decide overflow here
              $n.addClass("zscell-overflow-b");
            } else if (availableSpace > cellWidth) {
              //cut overflow text
              $n.addClass("zscell-overflow-b");
              $cave.addClass(OVERFLOW_PARTIAL_RIGHT_ALIGN);
              var cellInnerWidth = cellWidth - self.sheet.cellPad * 2 - 1;
              $cave.css('left', jq.px(cellInnerWidth - availableSpace)); //shift for alignment
              self.setCaveWidth(jq.px0(availableSpace));
              self.visibleTextWidth = availableSpace;
              $tn.css('left', jq.px(availableSpace - textWidth)); //shift for cut text
            }
          });
        } else if (hAlign == 'c') {
          // center align
          let textWidth = sw,
            halfOverflowWidth = (textWidth - cellWidth) / 2,
            oneSideTextWidth = halfOverflowWidth + cellWidth,
            availableSpacePrev = self.getAvailableSpace(oneSideTextWidth, function (cell) {
              return cell.previousSibling;
            }),
            availableSpaceNext = self.getAvailableSpace(oneSideTextWidth, function (cell) {
              return cell.nextSibling;
            }) - cellPad,
            leftCutOffset = 0;
          // Do it into the end of the event loop for avoiding browser reflow.
          zkS.queueMicrotask(function () {
            $n.addClass(rBorder ? "zscell-overflow-b" : "zscell-overflow");
            // handle prev
            let cellInnerWidth = cellWidth - self.sheet.cellPad;
            if (availableSpacePrev <= oneSideTextWidth && availableSpacePrev >= cellInnerWidth) {
              // overflow and cut
              $cave.css('left', jq.px(cellInnerWidth - availableSpacePrev)); //shift for alignment
              leftCutOffset = availableSpacePrev - oneSideTextWidth;
              $tn.css('left', jq.px(leftCutOffset)); //shift for cut text
              availableSpacePrev += halfOverflowWidth; // assume left full text
            }
            // handle next
            let availableSpace = oneSideTextWidth < availableSpaceNext ? textWidth : availableSpaceNext + halfOverflowWidth;
            self.setCaveWidth(jq.px0(availableSpace + leftCutOffset));
            self.visibleTextWidth = availableSpace;
          });
        }
      });
    },
    /**
    * shrink a text's width cut by an adjacent text.
    * set width on .zscelltext or .zscelltext-real according to browser version
    * @param width string in pixel or empty string
    */
    setCaveWidth: function (widthPx) {
      jq(this.getTextNode()).css('width', widthPx);
    },
    /**
    * count available width for overflow by summing left/right adjacent cell width
    * getNextAdjacentCell: return a left/right adjacent cell upon right/left align
    */
    getAvailableSpace: function (textWidth, getNextAdjacentCell) {
      // KEIKAI-271: we should consider merge cells case here.
      let availableSpace = 0;
      if (this.isMerged()) {
        for (let s = this.c; s <= this.merr; s++) {
          availableSpace += this.sheet.custColWidth.getSize(s);
        }
      } else {
        availableSpace = this.sheet.custColWidth.getSize(this.c); //cell width as initial space
      }
      var cell = getNextAdjacentCell(this);
      while (cell && cell.cellType === BLANK_CELL && availableSpace < textWidth) {
        availableSpace += this.sheet.custColWidth.getSize(cell.c);
        cell = getNextAdjacentCell(cell);
      }
      return availableSpace - this.sheet.cellPad;
    },
    //		_onProcessOverflow: function (evt) { //ZSS-1338
    //			if (this.overflow) {
    //				var row = this.r,
    //					data = evt.data;
    //				if (data) {
    //					var rCol = data.col,
    //						tRow = data.tRow,
    //						bRow = data.bRow;
    //					if ((tRow == undefined && bRow == undefined) ||
    //						(tRow && bRow && row >= tRow && row <= bRow)) {
    //					    // KEIKAI-153
    //                        if (rCol - 1 == this.c) {
    //                            this._resetCache();
    //                            this.computeTextWidth();
    //                        }
    //						this._processOverflow(true);
    //					}
    //				}
    //				this.visibleTextWidth = null; //enforce re-calculating
    //                jq(this).trigger('waitAlign', [this]);
    //			}
    //		},
    update_: function (updateSrc) {
      //ZSS-1338
      oCell.update_.apply(this, arguments);
      if (this.overflow) {
        //render overflow earlier than right alignment to compute the text width
        this._processOverflow();
      }
      // only need to shift a text
      if (this.cellType == STR_CELL || this.cellType == FORMULA_CELL) {
        this.visibleTextWidth = null; //enforce re-calculating
        jq(this).trigger('waitAlign', [this]);
      }
    }
  });
})(); // end of topmost function