/* autoheight.js

	Purpose:
		
	Description:
		
	History:
		Mar 18, 2015 Created by JerryChen

Copyright (C) 2015 Potix Corporation. All Rights Reserved.
*/
//ZSS-958
(function () {
  var zssautoheightCell$overrode = {},
    zssautoheightRow$overrode = {},
    zssautoheightSSheetCtrl$overrode = {};
  let blankHeightCache = {};
  function getBlankCache(fn, fs) {
    return blankHeightCache[fn + '_' + fs];
  }
  function setBlankCache(fn, fs, v) {
    blankHeightCache[fn + '_' + fs] = v;
  }
  zk.override(zss.Cell.prototype, zssautoheightCell$overrode, {
    _getTextHeight0: function (fn, fs) {
      var cell = jq(this.$n()),
        rotate = this.rotate,
        textNode = this.getTextNode();

      //ZSS-1151: optimize
      if (textNode) {
        if (!textNode.textContent || textNode.textContent.trim().length == 0) {
          if (rotate == 90 || rotate == -90) {
            return 0;
          }
          // KEIKAI-168: cache blank cell height
          var v = getBlankCache(fn, fs);
          if (v !== undefined) {
            return v;
          }
        }
      } else {
        return 0;
      }
      var height;
      if (rotate == 90 || rotate == -90) {
        //ZSS-1020
        height = this._textWidth();
      } else {
        // KEIKAI-339, if latest browser we use canvas to calculate, otherwise,
        // still uses the old way to calculate.
        // KEIKAI-508: rollback to old implementation if text contains break line.
        // KEIKAI-529: wrap text doesn't work as expected -> use old implementation
        height = jq(textNode).hasClass('zscelltxt-wrap') || textNode.innerText.indexOf('\n') > -1 ? NaN : zkS.getTextHeight(textNode.textContent || '.', textNode);
        if (isNaN(height)) {
          // recalculate
          var real = jq(textNode.cloneNode(true)).css({
            'position': 'absolute',
            'left': '-10000px',
            'top': '-10000px',
            'height': '',
            'max-height': '999999px',
            'width': textNode.offsetWidth
          }).appendTo(this.cave);
          // KEIKAI-45: height would be null if the text is empty
          if (!textNode.textContent || textNode.textContent.trim().length == 0) {
            real.text('.');
            height = real.height();
            setBlankCache(fn, fs, height);
          } else {
            height = real.height();
          }
          real.remove();
        }
      }
      return height;
    },
    _saveNoneDefaultHeightCell: function () {
      var custRowHeight = this.sheet.custRowHeight,
        row = this.r;
      if (!custRowHeight.isDefaultSize(row) && !custRowHeight.isCustomSize(row)) {
        this.parent.addAutoHeightCell(this);
      }
    }
  });
  zk.override(zss.Row.prototype, zssautoheightRow$overrode, {
    $init: function (evt) {
      zssautoheightRow$overrode.$init.apply(this, arguments);
      this.autoHeightCells = [];
    },
    updateRowAutoHeight: function () {
      if (this.sheet.custRowHeight.isCustomSize(this.r)) {
        return;
      }
      var autoHeight = -1,
        autoHeightCells = this.autoHeightCells;
      if (autoHeightCells.length > 0) {
        var largestAutoHeight = this._largestAutoHeight || -1;
        if (largestAutoHeight == -1) {
          //enlarge height upon largest text height among wrapped cells
          var i = autoHeightCells.length;
          while (i--) {
            if (autoHeightCells[i] && !autoHeightCells[i].isMerged()) {
              //skip merged cell for wrap height
              autoHeight = Math.max(autoHeight, autoHeightCells[i].getTextHeight());
            }
          }
          this._largestAutoHeight = autoHeight;
        } else {
          // use cache
          autoHeight = Math.max(autoHeight, largestAutoHeight);
        }
      }
      const custRowHeight = this.sheet.custRowHeight;
      const meta = custRowHeight.getMeta(this.r);
      const rowHeight = meta ? meta[1] : custRowHeight.size;
      autoHeight = Math.max(autoHeight, this.sheet.custRowHeight.getDefaultSize());
      if (rowHeight == autoHeight) return; //equals to current row height, no need to change
      var CUSTOM = false;
      this.sheet._setRowHeight(this.r, autoHeight, true, false, false, this.zsh, CUSTOM);
    },
    updateAutoHeightDirty: function (oldCellHeight, newCellHeight) {
      if (this._largestAutoHeight == -1) {
        return;
      }
      var autoHeight = this._largestAutoHeight || this.sheet.custRowHeight.getDefaultSize();
      if (newCellHeight > autoHeight) {
        this._largestAutoHeight = newCellHeight;
      } else if (oldCellHeight == autoHeight) {
        /* could be the previous highest one */
        // KEIKAI-152: -1 means the rest cells in update iteration should not cache the auto height,
        // recalc the value until Row.updateRowAutoHeight to make sure all the effected cells are considered
        this._largestAutoHeight = -1;
      }
    },
    processCellAutoHeight: function (cell) {
      if (!this.sheet.custRowHeight.isCustomSize(this.r)) {
        this.addAutoHeightCell(cell);
        this.sheet.triggerAutoHeight(this.r);
      }
    },
    addAutoHeightCell: function (cell) {
      var autoHeightCells = this.autoHeightCells;
      if (!autoHeightCells.$contains(cell)) autoHeightCells.push(cell);
    },
    removeAutoHeightCell: function (cell) {
      var autoHeightCells = this.autoHeightCells;
      if (autoHeightCells.$contains(cell)) autoHeightCells.$remove(cell);
    }
  });
  zk.override(zss.SSheetCtrl.prototype, zssautoheightSSheetCtrl$overrode, {
    fireProcessAutoHeight_: function () {
      if (this._wgt.isSheetCSSReady()) {
        var r = this._autoHeightRange,
          block = this.activeBlock,
          //ZSS-1116
          ar = block.range; //ZSS-1116
        if (r != undefined) {
          var custRowHeight = this.custRowHeight,
            top = Math.max(r.tRow, ar.top),
            //ZSS-1116
            bottom = Math.min(r.bRow, ar.bottom),
            //ZSS-1116
            shouldPruneCell = false;
          for (var i = top; i <= bottom; i++) {
            if (!custRowHeight.isHidden.apply(custRowHeight, [i])) {
              const row = block.getRow(i);
              if (row) {
                // KEIKAI-298
                row.updateRowAutoHeight.apply(row);
              } else shouldPruneCell = true;
            }
          }
          if (shouldPruneCell) {
            var sheet = this.getSheetData().sheet,
              vr = zss.SSheetCtrl._getVisibleRange(this),
              vh = this.getVisibleHeight(vr);
            if (ar.bottom - vh > vr.bottom) block.pruneCell('south', vr, ar.bottom - vh - vr.bottom);
          }
          delete this._autoHeightRange;
        }
      } else {
        var self = this;
        setTimeout(function () {
          self.fireProcessAutoHeight_();
        }, 25);
      }
    },
    triggerAutoHeight: function (row) {
      var r = this._autoHeightRange = this._autoHeightRange || {};
      typeof r.tRow == 'undefined' ? r.tRow = row : r.tRow = Math.min(r.tRow, row);
      typeof r.bRow == 'undefined' ? r.bRow = row : r.bRow = Math.max(r.bRow, row);
    }
  });
})();