/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.json.JSONArray;
import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.SColor;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractChartAxisAdv;
import io.keikai.model.impl.AbstractSeriesAdv;
import io.keikai.model.impl.chart.AreaChartDataImpl;
import io.keikai.model.impl.chart.BarChartDataImpl;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.chart.GroupingChartDataImpl;
import io.keikai.model.impl.chart.LineChartDataImpl;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.util.Strings;
import io.keikaiex.ui.ZssCharts;
import io.keikaiex.ui.widget.WidgetCtrl;
import io.keikaiex.util.ChartsCustomizer;
import io.keikaiex.util.ChartsModelManager;
import io.keikaiex.util.HighchartsAxisHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.chart.Color;
import org.zkoss.chart.Legend;
import org.zkoss.chart.Marker;
import org.zkoss.chart.Point;
import org.zkoss.chart.Series;
import org.zkoss.chart.Title;
import org.zkoss.chart.Tooltip;
import org.zkoss.chart.XAxis;
import org.zkoss.chart.YAxis;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.options3D.Options3D;
import org.zkoss.chart.plotOptions.ColumnPlotOptions;
import org.zkoss.chart.plotOptions.PiePlotOptions;
import org.zkoss.chart.plotOptions.PlotOptions;
import org.zkoss.chart.plotOptions.SeriesPlotOptions;
import org.zkoss.json.JavaScriptValue;
import org.zkoss.lang.Library;

public class HighchartsHelper {
    private static final Logger logger = LoggerFactory.getLogger(HighchartsHelper.class);
    private static final String DOUGHNUT_INNER_SIZE = "80%";
    private static final ChartsModelManager chartsModelManager = new ChartsModelManager();

    public static ZssCharts createCharts(SChart chartInfo) {
        ZssCharts chart = new ZssCharts();
        HighchartsHelper.getMapper(chartInfo).doSetting(chart, chartInfo.getData());
        chart.setAnimation(false);
        chart.getNavigation().getButtonOptions().setEnabled(false);
        return chart;
    }

    private static TypeMapper getMapper(SChart.ChartType type) {
        try {
            return TypeMapper.valueOf(type.toString());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return TypeMapper.OTHER;
        }
    }

    private static TypeMapper getMapper(SChart chartInfo) {
        return HighchartsHelper.getMapper(chartInfo.getType());
    }

    public static void drawCharts(ZssCharts chart, SChart chartInfo) {
        HighchartsHelper.drawCharts(chart, chartInfo, false);
    }

    public static void drawCharts(ZssCharts chart, SChart chartInfo, boolean dataLabelsEnabled) {
        ChartsCustomizer chartsCustomizer;
        WidgetCtrl parent;
        AbstractChartAdv chartAdv = (AbstractChartAdv)chartInfo;
        if (chartInfo.isSparkline()) {
            HighchartsHelper.drawSparklineChart(chart, chartInfo);
        } else if (chartAdv.getChartData().size() > 1) {
            HighchartsHelper.drawComboChart(chart, chartInfo, dataLabelsEnabled);
        } else {
            ChartsModel model = chartsModelManager.getChartsModel(chartInfo);
            List seriesColors = ((AbstractChartAdv)chartInfo).getSeriesColors();
            if (!seriesColors.isEmpty()) {
                chart.setColors(((AbstractChartAdv)chartInfo).getSeriesColors().stream().map(c -> new Color(c.getHtmlColor())).collect(Collectors.toList()));
            }
            if (model != null) {
                HighchartsHelper.drawChartInner(chart, model, chartInfo, dataLabelsEnabled);
            }
        }
        String customizerClz = Library.getProperty((String)"io.keikai.chart.customizer.class");
        if (customizerClz != null) {
            try {
                ChartsCustomizer chartsCustomizer2 = (ChartsCustomizer)Class.forName(customizerClz).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (chartsCustomizer2 != null) {
                    chartsCustomizer2.customize(chart, chartInfo);
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if ((parent = (WidgetCtrl)chart.getParent()) != null && (chartsCustomizer = (ChartsCustomizer)parent.getSpreadsheet().getAttribute("io.keikai.chart.customizer.class")) != null) {
            chartsCustomizer.customize(chart, chartInfo);
        }
    }

    private static void drawChartInner(ZssCharts chart, ChartsModel model, SChart chartInfo, boolean dataLabelsEnabled) {
        HighchartsHelper.setChartTitle(chart, chartInfo);
        chart.setLegend(HighchartsHelper.getLegend(chartInfo));
        chart.setModel(model);
        int seriesSize = chart.getSeriesSize();
        for (int i = 0; i < seriesSize; ++i) {
            Series series = chart.getSeries(i);
            int pointsSize = series.getData().size();
            AbstractSeriesAdv seriesInfo = (AbstractSeriesAdv)((SGeneralChartData)chartInfo.getData()).getSeries(i);
            Map dpColor = seriesInfo.getDataPointColors();
            SColor defaultColor = seriesInfo.getDefaultColor();
            if (defaultColor != null) {
                series.setColor(defaultColor.getHtmlColor());
            }
            for (int j = 0; j < pointsSize; ++j) {
                SColor color = (SColor)dpColor.get(j);
                if (color == null) continue;
                series.getPoint(j).setColor(color.getHtmlColor());
            }
            if (!dataLabelsEnabled || !seriesInfo.isDataLabelsVisible()) continue;
            series.getDataLabels().setEnabled(true);
        }
        HighchartsAxisHelper.drawAxis(chart, chartInfo);
        YAxis yAxis = chart.getYAxis();
        XAxis xAxis = chart.getXAxis();
        SChart.ChartGrouping grouping = chartInfo.getGrouping();
        xAxis.setReversed(chart.isInverted());
        yAxis.setReversedStacks(grouping != SChart.ChartGrouping.STACKED && grouping != SChart.ChartGrouping.PERCENT_STACKED);
        yAxis.getTitle().setText("");
        xAxis.getTitle().setText("");
        PiePlotOptions options = chart.getPlotOptions().getPie();
        options.getDataLabels().setEnabled(false);
        options.setShowInLegend(true);
    }

    private static void drawComboChart(ZssCharts chart, SChart chartInfo, boolean dataLabelsEnabled) {
        int i;
        HighchartsHelper.setChartTitle(chart, chartInfo);
        AbstractChartAdv chartAdv = (AbstractChartAdv)chartInfo;
        List chartSeries = chartAdv.getChartData();
        boolean onlyVisible = !chartAdv.isPlotOnlyVisibleCells();
        for (i = chart.getSeriesSize() - 1; i >= 0; --i) {
            chart.getSeries(i).remove();
        }
        for (i = chart.getXAxisSize() - 1; i >= 0; --i) {
            chart.getXAxis(i).remove();
        }
        for (i = chart.getyAxisSize() - 1; i >= 0; --i) {
            chart.getYAxis(i).remove();
        }
        String[] categories = new String[]{};
        int num = 0;
        boolean containsBar = false;
        for (SChartData chartData : chartSeries) {
            int numCat;
            if (!(chartData instanceof GeneralChartDataImpl)) continue;
            GeneralChartDataImpl generalChartData = (GeneralChartDataImpl)chartData;
            SChart.ChartType type = generalChartData.getType();
            if (!containsBar && type == SChart.ChartType.BAR) {
                containsBar = true;
            }
            for (int j = 0; j < generalChartData.getNumOfSeries(); ++j) {
                SSeries sseries = generalChartData.getSeries(j);
                num = Math.max(num, sseries.getNumOfValue());
            }
            if (categories.length != 0 || (numCat = generalChartData.getNumOfCategory()) <= 0 || generalChartData.getCategoryAxis() == null) continue;
            categories = new String[numCat];
            for (int i2 = 0; i2 < numCat; ++i2) {
                categories[i2] = generalChartData.getCategory(i2).toString();
            }
        }
        HashMap<Long, Integer> xAxisMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> yAxisMap = new HashMap<Long, Integer>();
        HighchartsAxisHelper.prepareAxes(chart, chartAdv, containsBar, xAxisMap, yAxisMap);
        List seriesColors = ((AbstractChartAdv)chartInfo).getSeriesColors();
        int colorSize = seriesColors.size();
        ArrayList<Series> seriesArray = new ArrayList<Series>();
        HashSet<SChart.ChartType> visited = new HashSet<SChart.ChartType>();
        HighchartsAxisHelper.AxisRanger ranger = new HighchartsAxisHelper.AxisRanger();
        for (SChartData chartData : chartSeries) {
            if (!(chartData instanceof GeneralChartDataImpl)) continue;
            GeneralChartDataImpl data = (GeneralChartDataImpl)chartData;
            SChart.ChartType chartType = data.getType();
            SChartAxis xAxis = HighchartsHelper.getAxis(data, xAxisMap, chartAdv);
            SChartAxis yAxis = HighchartsHelper.getAxis(data, yAxisMap, chartAdv);
            int xAxisIndex = xAxis == null ? -1 : (Integer)xAxisMap.get(xAxis.getId());
            int yAxisIndex = yAxis == null ? -1 : (Integer)yAxisMap.get(yAxis.getId());
            for (int j = 0; j < data.getNumOfSeries(); ++j) {
                Series series;
                AbstractSeriesAdv sseries = (AbstractSeriesAdv)data.getSeries(j);
                if (chartType == null || (series = HighchartsHelper.getComboSeries(data, sseries, onlyVisible, categories, containsBar, num, xAxisIndex, yAxisIndex, ranger)) == null) continue;
                if (!visited.contains(chartType)) {
                    HighchartsHelper.getMapper(chartType).doSetting(chart, (SChartData)data);
                }
                visited.add(chartType);
                series.setZIndex(HighchartsHelper.getSeriesIndex(chartType));
                SColor defaultColor = sseries.getDefaultColor();
                if (defaultColor != null) {
                    series.setColor(defaultColor.getHtmlColor());
                } else if (colorSize != 0) {
                    String color = ((SColor)seriesColors.get(sseries.getOrder() % colorSize)).getHtmlColor();
                    series.setColor(color);
                }
                if (dataLabelsEnabled && sseries.isDataLabelsVisible()) {
                    series.getDataLabels().setEnabled(true);
                    if (yAxis != null && !Strings.isBlank((String)yAxis.getFormat())) {
                        JSONArray dataLabelArray = new JSONArray();
                        FormatEngineImpl formatEngine = new FormatEngineImpl();
                        FormatContext formatContext = new FormatContext();
                        for (Point p : series.getData()) {
                            dataLabelArray.add((Object)formatEngine.format(yAxis.getFormat(), (Object)p.getY(), formatContext, 0).getText());
                        }
                        String str = dataLabelArray.toJSONString();
                        series.getDataLabels().setFormatter(new JavaScriptValue("';;;;;if(!this.formatted) {this.formatted = " + str + ";}return this.formatted[this.point.index];;;'"));
                    }
                }
                seriesArray.add(series);
            }
        }
        chart.setLegend(HighchartsHelper.getLegend(chartInfo));
        for (Series s : seriesArray) {
            chart.addSeries(s);
        }
        HighchartsAxisHelper.drawAxisLabelTick(chart, chartInfo, xAxisMap, yAxisMap, ranger, containsBar);
        PiePlotOptions options = chart.getPlotOptions().getPie();
        options.getDataLabels().setEnabled(false);
    }

    private static void drawSparklineChart(ZssCharts chart, SChart chartInfo) {
        boolean hidden = chartInfo.getSheet().getRow(chartInfo.getAnchor().getRowIndex()).isHidden();
        chart.setVisible(!hidden);
        if (hidden) {
            return;
        }
        chart.setType(chartInfo.getType().name().toLowerCase());
        chart.setBorderWidth(0);
        chart.setMargin(new Integer[]{0, 0, 0, 0});
        chart.setStyle("overflow:visible");
        chart.setTitle("");
        chart.getCredits().setEnabled(false);
        chart.getExporting().setEnabled(false);
        chart.getLegend().setEnabled(false);
        Tooltip tooltip = chart.getTooltip();
        tooltip.setEnabled(false);
        if (!(chartInfo.getData() instanceof SGeneralChartData)) {
            return;
        }
        SGeneralChartData chartData = (SGeneralChartData)chartInfo.getData();
        AbstractChartAdv chartAdv = (AbstractChartAdv)chartInfo;
        SeriesPlotOptions seriesOpt = chart.getPlotOptions().getSeries();
        seriesOpt.setAnimation(false);
        seriesOpt.setLineWidth((Number)1);
        seriesOpt.setShadow(false);
        seriesOpt.setPointStart((Number)1);
        seriesOpt.getStates().getHover().setLineWidth((Number)1);
        seriesOpt.setColor(chartAdv.getSparklineSeriesColor().getHtmlColor());
        boolean isLineType = chartInfo.getType() == SChart.ChartType.LINE;
        for (int i = chart.getSeriesSize() - 1; i >= 0; --i) {
            chart.getSeries(i).remove();
        }
        SSeries sseries = chartData.getSeries(0);
        ArrayList<Point> points = new ArrayList<Point>();
        double high = Double.NEGATIVE_INFINITY;
        double low = Double.POSITIVE_INFINITY;
        boolean isWinLose = chartInfo.isWinloseSpark();
        if (isWinLose) {
            high = 1.0;
            low = -1.0;
        }
        for (int i = 0; i < sseries.getNumOfValue(); ++i) {
            Number num = ChartsModelManager.toNumber(sseries.getValue(i), 0);
            if (num == null) continue;
            double v = num.doubleValue();
            if (isWinLose) {
                if (v == 0.0) continue;
                v = v > 0.0 ? 1.0 : -1.0;
            } else {
                if (high < v) {
                    high = v;
                }
                if (low > v) {
                    low = v;
                }
            }
            Point point = new Point((Number)v);
            points.add(point);
        }
        if (isLineType) {
            Marker marker = seriesOpt.getMarker();
            marker.setRadius((Number)1);
            marker.getStates().getHover().setEnabled(false);
            if (chartAdv.isSparklineMarkerVisible()) {
                marker.setFillColor(chartAdv.getSparklineMarkerColor().getHtmlColor());
            } else {
                marker.setEnabled(false);
            }
        } else {
            if (isWinLose) {
                chart.getYAxis().setMin((Number)-1);
                chart.getYAxis().setMax((Number)1);
            }
            ColumnPlotOptions colOpt = chart.getPlotOptions().getColumn();
            colOpt.setNegativeColor(chartAdv.getSparklineNegativePointColor().getHtmlColor());
        }
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            Point point = (Point)points.get(i);
            SColor color = HighchartsHelper.getSparklinePointColor(chartAdv, i, size, point.getY().doubleValue(), high, low);
            if (color == null) continue;
            if (isLineType) {
                point.getMarker().setFillColor(color.getHtmlColor());
                continue;
            }
            point.setColor(color.getHtmlColor());
        }
        chart.getSeries(0).setData(points.toArray(new Point[0]));
        chart.setShowAxes(false);
    }

    private static SColor getSparklinePointColor(AbstractChartAdv chartAdv, int index, int size, double value, double high, double low) {
        if (chartAdv.isSparklineHighPointVisible() && value == high) {
            return chartAdv.getSparklineHighPointColor();
        }
        if (chartAdv.isSparklineLowPointVisible() && value == low) {
            return chartAdv.getSparklineLowPointColor();
        }
        if (chartAdv.isSparklineFirstPointVisible() && index == 0) {
            return chartAdv.getSparklineFirstPointColor();
        }
        if (chartAdv.isSparklineLastPointVisible() && index == size - 1) {
            return chartAdv.getSparklineLastPointColor();
        }
        if (chartAdv.isSparklineNegativePointVisible() && value < 0.0) {
            return chartAdv.getSparklineNegativePointColor();
        }
        return null;
    }

    private static String getChartType(SChart.ChartType type) {
        switch (type) {
            case AREA: {
                return "area";
            }
            case BAR: {
                return "bar";
            }
            case COLUMN: {
                return "column";
            }
            case BUBBLE: {
                return "bubble";
            }
            case DOUGHNUT: 
            case PIE: {
                return "pie";
            }
            case LINE: {
                return "line";
            }
            case OF_PIE: {
                return "ofpie";
            }
            case RADAR: {
                return "radar";
            }
            case SCATTER: {
                return "scatter";
            }
        }
        return "";
    }

    private static Legend getLegend(SChart chartInfo) {
        Legend legend = new Legend();
        SChart.ChartLegendPosition position = chartInfo.getLegendPosition();
        if (position == null) {
            legend.setEnabled(false);
        } else {
            String align = HighchartsHelper.getLegendHorizontalAlign(position);
            legend.setAlign(align);
            legend.setLayout(align.equals("center") ? "horizontal" : "vertical");
            legend.setVerticalAlign(HighchartsHelper.getLegendVerticalAlign(position));
        }
        return legend;
    }

    private static Series getComboSeries(GeneralChartDataImpl chartData, AbstractSeriesAdv sseries, boolean onlyVisible, String[] categories, boolean containsBar, int num, int xAxisIndex, int yAxisIndex, HighchartsAxisHelper.AxisRanger ranger) {
        SChart.ChartType chartType = chartData.getType();
        Series series = new Series();
        String name = ChartsModelManager.toSeriesName(sseries.getName(), sseries.getOrder());
        series.setName(name);
        series.setType(HighchartsHelper.getChartType(chartType));
        List valAxes = chartData.getValueAxes();
        long valAxId = -1L;
        if (valAxes != null && !valAxes.isEmpty()) {
            if (valAxes.size() > 1) {
                for (SChartAxis valAxe : valAxes) {
                    AbstractChartAxisAdv.Position position = ((AbstractChartAxisAdv)valAxe).getPosition();
                    if (AbstractChartAxisAdv.Position.BOTTOM.equals((Object)position)) continue;
                    valAxId = valAxe.getId();
                }
            } else {
                valAxId = ((SChartAxis)valAxes.get(0)).getId();
            }
        }
        switch (chartType) {
            case BAR: {
                Map dpColors = sseries.getDataPointColors();
                Number[] values = HighchartsHelper.getCategorySeriesValues((SSeries)sseries, num);
                ArrayList<Point> points = new ArrayList<Point>();
                SChart.ChartGrouping grouping = ((BarChartDataImpl)chartData).getGrouping();
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    if (onlyVisible && sseries.isXValueFomulaHidden(i)) continue;
                    Number v = values[i];
                    ranger.scan(valAxId, chartType, i, v, grouping);
                    Point point = new Point(v);
                    point.setName(HighchartsAxisHelper.getCategory((SGeneralChartData)chartData, i));
                    SColor color = (SColor)dpColors.get(i);
                    if (color != null) {
                        point.setColor(color.getHtmlColor());
                    }
                    points.add(point);
                }
                series.setData(points.toArray(new Point[0]));
                series.setXAxis(xAxisIndex);
                series.setYAxis(yAxisIndex);
                return series;
            }
            case AREA: 
            case COLUMN: 
            case LINE: {
                Map dpColors = sseries.getDataPointColors();
                Number[] values = HighchartsHelper.getCategorySeriesValues((SSeries)sseries, num);
                ArrayList<Point> points = new ArrayList();
                SChart.ChartGrouping grouping = ((GroupingChartDataImpl)chartData).getGrouping();
                int length = values.length;
                for (int i = 0; i < length; ++i) {
                    if (onlyVisible && sseries.isXValueFomulaHidden(i)) continue;
                    Number v = values[i];
                    Point point = containsBar ? new Point(v, (Number)i) : new Point(v);
                    point.setName(HighchartsAxisHelper.getCategory((SGeneralChartData)chartData, i));
                    ranger.scan(valAxId, chartType, i, v, grouping);
                    SColor color = (SColor)dpColors.get(i);
                    if (color != null) {
                        point.setColor(color.getHtmlColor());
                    }
                    points.add(point);
                }
                series.setData(points.toArray(new Point[0]));
                series.setXAxis(xAxisIndex);
                series.setYAxis(yAxisIndex);
                return series;
            }
            case DOUGHNUT: 
            case PIE: {
                series.setData(HighchartsHelper.getPieSeriesValues((SGeneralChartData)chartData, categories, onlyVisible, num, sseries));
                series.setXAxis(xAxisIndex);
                series.setYAxis(yAxisIndex);
                series.getPlotOptions().setShowInLegend(false);
                return series;
            }
            case SCATTER: {
                Point[] points = HighchartsHelper.getXySeriesValues(onlyVisible, sseries);
                series.setData(points);
                for (int i = 0; i < points.length; ++i) {
                    Point p = points[i];
                    ranger.scan(valAxId, chartType, p.getX() == null ? (Number)i : (Number)p.getX(), p.getY(), SChart.ChartGrouping.STANDARD);
                }
                series.setXAxis(xAxisIndex);
                series.setYAxis(yAxisIndex);
                return series;
            }
        }
        return null;
    }

    private static Number[] getCategorySeriesValues(SSeries sseries, int num) {
        Number[] numbers = new Number[num];
        for (int i = 0; i < num; ++i) {
            numbers[i] = ChartsModelManager.toNumber(sseries.getValue(i), 0);
        }
        return numbers;
    }

    private static Point[] getPieSeriesValues(SGeneralChartData chartData, String[] categories, boolean onlyVisible, int num, AbstractSeriesAdv sseries) {
        Map dpColors = sseries.getDataPointColors();
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < num; ++i) {
            String label = ".";
            if (onlyVisible) {
                if (sseries.isXValueFomulaHidden(i)) continue;
                if (!chartData.isCategoryHidden(i)) {
                    label = HighchartsAxisHelper.getCategory(chartData, i);
                }
            } else {
                label = HighchartsAxisHelper.getCategory(chartData, i);
            }
            Number val = ChartsModelManager.toNumber(sseries.getValue(i), 0);
            Point point = new Point(label, val);
            SColor color = (SColor)dpColors.get(i);
            if (color != null) {
                point.setColor(color.getHtmlColor());
            }
            points.add(point);
        }
        Point[] array = new Point[points.size()];
        return points.toArray(array);
    }

    private static Point[] getXySeriesValues(boolean onlyVisible, AbstractSeriesAdv sseries) {
        Map dpColors = sseries.getDataPointColors();
        ArrayList<Point> points = new ArrayList<Point>();
        int num = sseries.getNumOfYValue();
        boolean hasXValue = sseries.getNumOfValue() != 0;
        for (int i = 0; i < num; ++i) {
            SColor color;
            Object xval;
            if (onlyVisible && sseries.isYValueFomulaHidden(i)) continue;
            Point point = new Point(ChartsModelManager.toNumber(sseries.getYValue(i), 0));
            if (hasXValue && (xval = sseries.getValue(i)) instanceof Number) {
                point.setX((Number)xval);
            }
            if ((color = (SColor)dpColors.get(i)) != null) {
                point.setColor(color.getHtmlColor());
            }
            points.add(point);
        }
        Point[] array = new Point[points.size()];
        return points.toArray(array);
    }

    private static int getSeriesIndex(SChart.ChartType chartType) {
        switch (chartType) {
            case OF_PIE: {
                return 1;
            }
            case DOUGHNUT: {
                return 2;
            }
            case AREA: {
                return 3;
            }
            case BAR: {
                return 4;
            }
            case COLUMN: {
                return 5;
            }
            case LINE: {
                return 6;
            }
            case RADAR: {
                return 7;
            }
            case SCATTER: {
                return 8;
            }
            case BUBBLE: {
                return 9;
            }
            case SURFACE: {
                return 10;
            }
            case STOCK: {
                return 11;
            }
        }
        return 0;
    }

    private static String getLegendHorizontalAlign(SChart.ChartLegendPosition legendPosition) {
        if (legendPosition == SChart.ChartLegendPosition.TOP || legendPosition == SChart.ChartLegendPosition.BOTTOM) {
            return "center";
        }
        if (legendPosition == SChart.ChartLegendPosition.TOP_RIGHT) {
            return "right";
        }
        if (legendPosition != null) {
            return legendPosition.toString().toLowerCase();
        }
        return "right";
    }

    private static String getLegendVerticalAlign(SChart.ChartLegendPosition legendPosition) {
        if (legendPosition == SChart.ChartLegendPosition.LEFT || legendPosition == SChart.ChartLegendPosition.RIGHT) {
            return "middle";
        }
        if (legendPosition == SChart.ChartLegendPosition.TOP_RIGHT) {
            return "top";
        }
        if (legendPosition != null) {
            return legendPosition.toString().toLowerCase();
        }
        return "middle";
    }

    private static void setChartTitle(ZssCharts charts, SChart chartInfo) {
        AbstractChartAdv chartAdv = (AbstractChartAdv)chartInfo;
        String t = null;
        Title title = new Title();
        if (chartAdv.isShowTitle()) {
            t = chartInfo.getTitle();
            if (Boolean.TRUE.equals(chartAdv.isAutoTitleDeleted())) {
                if (Strings.isEmpty((String)t)) {
                    t = null;
                }
            } else {
                if (Strings.isEmpty((String)t)) {
                    t = HighchartsHelper.getFirstSeriesTitle(chartInfo);
                }
                if (Strings.isEmpty((String)t)) {
                    t = "Chart Title";
                }
            }
        }
        title.setAlign("center");
        title.setText(t);
        charts.setTitle(title);
    }

    private static String getFirstSeriesTitle(SChart chartInfo) {
        SGeneralChartData cd;
        SChartData firstData;
        List chartData = ((AbstractChartAdv)chartInfo).getChartData();
        if (chartData.size() == 1 && (firstData = (SChartData)chartData.get(0)) instanceof SGeneralChartData && ((cd = (SGeneralChartData)firstData).getType() == SChart.ChartType.PIE || cd.getNumOfSeries() == 1)) {
            return cd.getSeries(0).getName();
        }
        return null;
    }

    private static SChartAxis getAxis(GeneralChartDataImpl chartData, Map<Long, Integer> axisMap, AbstractChartAdv chartAdv) {
        long catAxId;
        SChartAxis catAxis = chartData.getCategoryAxis();
        if (catAxis != null && axisMap.containsKey(catAxId = catAxis.getId())) {
            return catAxis;
        }
        List valAxes = chartData.getValueAxes();
        if (valAxes != null) {
            for (SChartAxis valAxis : valAxes) {
                long valAxId = valAxis.getId();
                if (!axisMap.containsKey(valAxId)) continue;
                if (((AbstractChartAxisAdv)valAxis).isVisible()) {
                    return valAxis;
                }
                SChartAxis visibleAxis = HighchartsHelper.getVisibleAxis(chartAdv, valAxis);
                if (visibleAxis == null) continue;
                return visibleAxis;
            }
        }
        return null;
    }

    private static SChartAxis getVisibleAxis(AbstractChartAdv chartAdv, SChartAxis hiddenAxis) {
        ArrayList axes = new ArrayList();
        axes.addAll(chartAdv.getCategoryAxises());
        axes.addAll(chartAdv.getDateAxises());
        axes.addAll(chartAdv.getValueAxises());
        AbstractChartAxisAdv.Position position = ((AbstractChartAxisAdv)hiddenAxis).getPosition();
        for (SChartAxis axis : axes) {
            AbstractChartAxisAdv axisAdv = (AbstractChartAxisAdv)axis;
            if (!axisAdv.isVisible() || !axisAdv.getPosition().equals((Object)position)) continue;
            return axis;
        }
        return null;
    }

    private static enum TypeMapper {
        AREA("area", (chart, info) -> {
            if (info instanceof AreaChartDataImpl) {
                SChart.ChartGrouping grouping = ((AreaChartDataImpl)info).getGrouping();
                if (grouping == SChart.ChartGrouping.STACKED) {
                    chart.getPlotOptions().getArea().setStacking("normal");
                } else if (grouping == SChart.ChartGrouping.PERCENT_STACKED) {
                    chart.getPlotOptions().getArea().setStacking("percent");
                }
            }
            if (info.getChart().isThreeD()) {
                Options3D option = chart.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)6);
                option.setBeta((Number)6);
                option.setDepth((Number)50);
                option.setViewDistance((Number)25);
                chart.setOptions3D(option);
            }
        }),
        BAR("bar", (chart, info) -> {
            if (info instanceof BarChartDataImpl) {
                SChart.ChartGrouping grouping = ((BarChartDataImpl)info).getGrouping();
                if (grouping == SChart.ChartGrouping.STACKED) {
                    chart.getPlotOptions().getBar().setStacking("normal");
                } else if (grouping == SChart.ChartGrouping.PERCENT_STACKED) {
                    chart.getPlotOptions().getBar().setStacking("percent");
                }
            }
            if (info.getChart().isThreeD()) {
                Options3D option = chart.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)6);
                option.setBeta((Number)6);
                option.setDepth((Number)50);
                option.setViewDistance((Number)25);
                chart.setOptions3D(option);
            }
        }),
        COLUMN("column", (chart, info) -> {
            if (info instanceof BarChartDataImpl) {
                SChart.ChartGrouping grouping = ((BarChartDataImpl)info).getGrouping();
                if (grouping == SChart.ChartGrouping.STACKED) {
                    chart.getPlotOptions().getColumn().setStacking("normal");
                } else if (grouping == SChart.ChartGrouping.PERCENT_STACKED) {
                    chart.getPlotOptions().getColumn().setStacking("percent");
                }
            }
            if (info.getChart().isThreeD()) {
                Options3D option = chart.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)6);
                option.setBeta((Number)6);
                option.setDepth((Number)50);
                option.setViewDistance((Number)25);
                chart.setOptions3D(option);
            }
        }),
        BUBBLE("bubble"),
        DOUGHNUT("pie", (chart, info) -> {
            PlotOptions pOptions = chart.getPlotOptions();
            pOptions.getPie().setShowInLegend(true);
            pOptions.getPie().setInnerSize(HighchartsHelper.DOUGHNUT_INNER_SIZE);
            List colors = ((AbstractChartAdv)info.getChart()).getSeriesColors();
            if (!colors.isEmpty()) {
                pOptions.getPie().setColors(colors.stream().map(c -> new Color(c.getHtmlColor())).collect(Collectors.toList()));
            }
        }),
        LINE("line", (chart, info) -> {
            if (info instanceof LineChartDataImpl) {
                SChart.ChartGrouping grouping = ((LineChartDataImpl)info).getGrouping();
                if (grouping == SChart.ChartGrouping.STACKED) {
                    chart.getPlotOptions().getLine().setStacking("normal");
                } else if (grouping == SChart.ChartGrouping.PERCENT_STACKED) {
                    chart.getPlotOptions().getLine().setStacking("percent");
                }
            }
            if (info.getChart().isThreeD()) {
                Options3D option = chart.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)6);
                option.setBeta((Number)6);
                option.setDepth((Number)50);
                option.setViewDistance((Number)25);
                chart.setOptions3D(option);
            }
        }),
        OF_PIE("ofpie"),
        PIE("pie", (charts, info) -> {
            PlotOptions pOptions = charts.getPlotOptions();
            pOptions.getPie().setShowInLegend(true);
            List colors = ((AbstractChartAdv)info.getChart()).getSeriesColors();
            if (!colors.isEmpty()) {
                pOptions.getPie().setColors(colors.stream().map(c -> new Color(c.getHtmlColor())).collect(Collectors.toList()));
            }
            if (info.getChart().isThreeD()) {
                Options3D option = charts.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)50);
                option.setBeta((Number)0);
                pOptions.getPie().setDepth((Number)35);
                charts.setOptions3D(option);
            }
        }),
        RADAR("radar"),
        SCATTER("scatter", (chart, info) -> {
            if (info.getChart().isThreeD()) {
                Options3D option = chart.getOptions3D();
                option.setEnabled(true);
                option.setAlpha((Number)10);
                option.setBeta((Number)30);
                option.setDepth((Number)250);
                option.setViewDistance((Number)5);
                chart.setOptions3D(option);
            }
        }),
        SURFACE("surface"),
        OTHER("");

        String innerType;
        Setting setting;

        private TypeMapper(String innerType) {
            this.innerType = innerType;
        }

        private TypeMapper(String innerType, Setting setting) {
            this.innerType = innerType;
            this.setting = setting;
        }

        void doSetting(ZssCharts charts, SChartData info) {
            charts.setType(this.innerType);
            if (this.setting != null) {
                this.setting.doSetting(charts, info);
            }
        }

        static interface Setting {
            public void doSetting(ZssCharts var1, SChartData var2);
        }
    }
}

