/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.model.SChart;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.Widget;
import io.keikaiex.ui.ZssCharts;
import io.keikaiex.ui.widget.ChartsWidget;
import io.keikaiex.util.ChartsCustomizer;
import io.keikaiex.util.HighchartsHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartsHelper {
    public static final String CUSTOMIZER_ATTR_CLZ = "io.keikai.chart.customizer.class";
    private static final Logger logger = LoggerFactory.getLogger(ChartsHelper.class);

    public static List<ZssCharts> getAllCharts(Spreadsheet spreadsheet) {
        ArrayList<ZssCharts> zssCharts = new ArrayList<ZssCharts>();
        for (Widget clientWidget : spreadsheet.getClientWidgets()) {
            if (!(clientWidget instanceof ChartsWidget)) continue;
            zssCharts.add(((ChartsWidget)clientWidget).getChartComponent());
        }
        return zssCharts;
    }

    public static ZssCharts getChartsByName(Spreadsheet spreadsheet, String name) {
        for (Widget clientWidget : spreadsheet.getClientWidgets()) {
            ChartsWidget chartsWidget;
            if (!(clientWidget instanceof ChartsWidget) || !name.equals((chartsWidget = (ChartsWidget)clientWidget).getName())) continue;
            return chartsWidget.getChartComponent();
        }
        return null;
    }

    public static void updateChart(Spreadsheet spreadsheet, SChart sChart) {
        ChartsHelper.updateChart(spreadsheet, sChart, false);
    }

    public static void updateChart(Spreadsheet spreadsheet, SChart sChart, boolean dataLabelsEnabled) {
        if (sChart == null) {
            return;
        }
        ZssCharts zssCharts = ChartsHelper.getChartsByName(spreadsheet, sChart.getName());
        if (zssCharts == null) {
            return;
        }
        HighchartsHelper.drawCharts(zssCharts, sChart, dataLabelsEnabled);
    }

    public static void setCustomizer(Spreadsheet spreadsheet, ChartsCustomizer customizer) {
        spreadsheet.setAttribute(CUSTOMIZER_ATTR_CLZ, (Object)customizer);
    }
}

