/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.model.CellRegion;
import io.keikai.model.SAutoFilter;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.ZSMessagebox;
import io.keikai.ui.impl.ua.AbstractFilterHandler;
import io.keikaiex.ui.dialog.CustomFiltersCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class CustomFiltersHandler
extends AbstractFilterHandler {
    private static final long serialVersionUID = -6809662212020255159L;

    protected boolean processAction(UserActionContext ctx) {
        final Sheet sheet = ctx.getSheet();
        final SAutoFilter filter = this.getAutoFilter(ctx);
        final int index = (Integer)ctx.getData("field") - 1;
        SAutoFilter.FilterOp op = SAutoFilter.FilterOp.valueOf((String)((String)ctx.getData("op")));
        CustomFiltersCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = 1L;

            public void onEvent(DialogCallbackEvent event) {
                Object data = event.getData();
                if (data != null) {
                    String[] stringArray;
                    boolean isAnd = (Boolean)data.get(CustomFiltersCtrl.ARG_ANDOR);
                    SAutoFilter.FilterOp f1op = (SAutoFilter.FilterOp)data.get(CustomFiltersCtrl.ARG_F1_OP);
                    SAutoFilter.FilterOp f2op = (SAutoFilter.FilterOp)data.get(CustomFiltersCtrl.ARG_F2_OP);
                    Object f1val = data.get(CustomFiltersCtrl.ARG_F1_VAL);
                    Object f2val = data.get(CustomFiltersCtrl.ARG_F2_VAL);
                    Object f1display = data.get(CustomFiltersCtrl.ARG_F1_DISPLAY);
                    Object f2display = data.get(CustomFiltersCtrl.ARG_F2_DISPLAY);
                    if (f1op == SAutoFilter.FilterOp.none) {
                        ZSMessagebox.show((String)"Error in parse line", (String)"ZK Spreadsheet", (int)1, (String)"z-messagebox-icon z-messagebox-exclamation");
                        return;
                    }
                    f1op = CustomFiltersHandler.this.convertToNormalOp(f1op);
                    f2op = CustomFiltersHandler.this.convertToNormalOp(f2op);
                    String[] criteria1 = new String[]{f1op.name(), f1val == null ? "" : f1val.toString(), (String)f1display};
                    if (f2op == SAutoFilter.FilterOp.none) {
                        stringArray = null;
                    } else {
                        String[] stringArray2 = new String[3];
                        stringArray2[0] = f2op.name();
                        stringArray2[1] = f2val == null ? "" : f2val.toString();
                        stringArray = stringArray2;
                        stringArray2[2] = (String)f2display;
                    }
                    String[] criteria2 = stringArray;
                    CellRegion region = filter.getRegion();
                    Range range = Ranges.range((Sheet)sheet, (int)region.getRow(), (int)region.getColumn(), (int)region.getLastRow(), (int)region.getLastColumn());
                    range.enableAutoFilter(index + 1, isAnd ? Range.AutoFilterOperation.AND : Range.AutoFilterOperation.OR, (Object)criteria1, (Object)criteria2, Boolean.valueOf(true));
                }
            }
        }, filter, index, op);
        return true;
    }

    protected SAutoFilter.FilterOp convertToNormalOp(SAutoFilter.FilterOp op) {
        if (op == null) {
            return null;
        }
        switch (op) {
            case after: {
                return SAutoFilter.FilterOp.greaterThan;
            }
            case afterEq: {
                return SAutoFilter.FilterOp.greaterThanOrEqual;
            }
            case before: {
                return SAutoFilter.FilterOp.lessThan;
            }
            case beforeEq: {
                return SAutoFilter.FilterOp.lessThanOrEqual;
            }
        }
        return op;
    }
}

