/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.model.Book;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.model.SBook;
import io.keikai.ui.AuxAction;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.UserActionHandler;
import io.keikai.ui.event.CellSelectionAction;
import io.keikai.ui.event.CellSelectionUpdateEvent;
import io.keikai.ui.event.WidgetKeyEvent;
import io.keikai.ui.event.WidgetUpdateEvent;
import io.keikai.ui.impl.DefaultUserActionManagerCtrl;
import io.keikaiex.ui.dialog.HeaderSizeCtrl;
import io.keikaiex.ui.impl.ua.AbstractObjectHandler;
import io.keikaiex.ui.impl.ua.ApplyFilterHandler;
import io.keikaiex.ui.impl.ua.AutoFillHandler;
import io.keikaiex.ui.impl.ua.CleanFilterHandler;
import io.keikaiex.ui.impl.ua.CustomFiltersHandler;
import io.keikaiex.ui.impl.ua.CustomSortHandler;
import io.keikaiex.ui.impl.ua.DataValidationHandler;
import io.keikaiex.ui.impl.ua.DeleteChartHandler;
import io.keikaiex.ui.impl.ua.DeleteCommentHandler;
import io.keikaiex.ui.impl.ua.DeletePictureHandler;
import io.keikaiex.ui.impl.ua.EditCommentHandler;
import io.keikaiex.ui.impl.ua.FormatCellHandler;
import io.keikaiex.ui.impl.ua.HeaderSizeHandler;
import io.keikaiex.ui.impl.ua.HideSheetHandler;
import io.keikaiex.ui.impl.ua.HyperlinkHandler;
import io.keikaiex.ui.impl.ua.InsertChartHandler;
import io.keikaiex.ui.impl.ua.InsertCommentHandler;
import io.keikaiex.ui.impl.ua.InsertFunctionHandler;
import io.keikaiex.ui.impl.ua.InsertPictureHandler;
import io.keikaiex.ui.impl.ua.MergeCenterHandler;
import io.keikaiex.ui.impl.ua.MergeHandler;
import io.keikaiex.ui.impl.ua.MoveChartHandler;
import io.keikaiex.ui.impl.ua.MovePictureHandler;
import io.keikaiex.ui.impl.ua.PasteSpecialDialogHandler;
import io.keikaiex.ui.impl.ua.PasteSpecialHandler;
import io.keikaiex.ui.impl.ua.ProtectSheetAction;
import io.keikaiex.ui.impl.ua.ReapplyFilterHandler;
import io.keikaiex.ui.impl.ua.RichTextEditHandler;
import io.keikaiex.ui.impl.ua.ShiftCellHandler;
import io.keikaiex.ui.impl.ua.Top10FilterHandler;
import io.keikaiex.ui.impl.ua.UnhideSheetHandler;
import io.keikaiex.ui.impl.ua.UnmergeHandler;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.KeyEvent;

public class UserActionManagerCtrlImpl
extends DefaultUserActionManagerCtrl {
    private static final long serialVersionUID = 1L;
    private final Set<String> _interestedEvents = new LinkedHashSet<String>();

    public UserActionManagerCtrlImpl() {
        this._interestedEvents.add("onWidgetCtrlKey");
        this._interestedEvents.add("onWidgetUpdate");
        this._interestedEvents.add("onCellSelectionUpdate");
        this.initDefaultAuxHandlers();
    }

    private void initDefaultAuxHandlers() {
        String category = DefaultUserActionManagerCtrl.Category.AUXACTION.getName();
        this.registerHandler(category, AuxAction.PASTE_FORMULA.getAction(), (UserActionHandler)new PasteSpecialHandler(Range.PasteType.FORMULAS, Range.PasteOperation.NONE, false, false));
        this.registerHandler(category, AuxAction.PASTE_VALUE.getAction(), (UserActionHandler)new PasteSpecialHandler(Range.PasteType.VALUES, Range.PasteOperation.NONE, false, false));
        this.registerHandler(category, AuxAction.PASTE_ALL_EXPECT_BORDERS.getAction(), (UserActionHandler)new PasteSpecialHandler(Range.PasteType.ALL_EXCEPT_BORDERS, Range.PasteOperation.NONE, false, false));
        this.registerHandler(category, AuxAction.PASTE_TRANSPOSE.getAction(), (UserActionHandler)new PasteSpecialHandler(Range.PasteType.ALL, Range.PasteOperation.NONE, false, true));
        this.registerHandler(category, AuxAction.MERGE_AND_CENTER.getAction(), (UserActionHandler)new MergeCenterHandler());
        this.registerHandler(category, AuxAction.MERGE_ACROSS.getAction(), (UserActionHandler)new MergeHandler(true));
        this.registerHandler(category, AuxAction.MERGE_CELL.getAction(), (UserActionHandler)new MergeHandler(false));
        this.registerHandler(category, AuxAction.UNMERGE_CELL.getAction(), (UserActionHandler)new UnmergeHandler());
        this.registerHandler(category, AuxAction.FILTER.getAction(), (UserActionHandler)new ApplyFilterHandler());
        this.registerHandler(category, AuxAction.CLEAR_FILTER.getAction(), (UserActionHandler)new CleanFilterHandler());
        this.registerHandler(category, AuxAction.REAPPLY_FILTER.getAction(), (UserActionHandler)new ReapplyFilterHandler());
        this.registerHandler(category, AuxAction.PROTECT_SHEET.getAction(), (UserActionHandler)new ProtectSheetAction());
        this.registerHandler(category, AuxAction.INSERT_CHART.getAction(), (UserActionHandler)new AbstractObjectHandler(){
            private static final long serialVersionUID = -5783144640583968481L;

            protected boolean processAction(UserActionContext ctx) {
                return false;
            }
        });
        this.registerHandler(category, AuxAction.COLUMN_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.COLUMN, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.COLUMN_CHART_3D.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.COLUMN_3D, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.LINE_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.LINE, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.LINE_CHART_3D.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.LINE_3D, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.PIE_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.PIE, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.PIE_CHART_3D.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.PIE_3D, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.BAR_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.BAR, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.BAR_CHART_3D.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.BAR_3D, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.AREA_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.AREA, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.SCATTER_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.SCATTER, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.DOUGHNUT_CHART.getAction(), (UserActionHandler)new InsertChartHandler(Chart.Type.DOUGHNUT, Chart.Grouping.STANDARD, Chart.LegendPosition.RIGHT));
        this.registerHandler(category, AuxAction.INSERT_PICTURE.getAction(), (UserActionHandler)new InsertPictureHandler());
        this.registerHandler(category, AuxAction.ROW_HEIGHT.getAction(), (UserActionHandler)new HeaderSizeHandler(HeaderSizeCtrl.HeaderType.ROW));
        this.registerHandler(category, AuxAction.COLUMN_WIDTH.getAction(), (UserActionHandler)new HeaderSizeHandler(HeaderSizeCtrl.HeaderType.COLUMN));
        this.registerHandler(category, AuxAction.PASTE_SPECIAL.getAction(), (UserActionHandler)new PasteSpecialDialogHandler());
        this.registerHandler(category, AuxAction.CUSTOM_SORT.getAction(), (UserActionHandler)new CustomSortHandler());
        this.registerHandler(category, AuxAction.HYPERLINK.getAction(), (UserActionHandler)new HyperlinkHandler());
        this.registerHandler(category, AuxAction.FORMAT_CELL.getAction(), (UserActionHandler)new FormatCellHandler());
        this.registerHandler(category, AuxAction.DATA_VALIDATION.getAction(), (UserActionHandler)new DataValidationHandler());
        this.registerHandler(category, AuxAction.INSERT_FUNCTION.getAction(), (UserActionHandler)new InsertFunctionHandler());
        this.registerHandler(category, AuxAction.RICH_TEXT_EDIT.getAction(), (UserActionHandler)new RichTextEditHandler());
        this.registerHandler(category, AuxAction.HIDE_SHEET.getAction(), (UserActionHandler)new HideSheetHandler());
        this.registerHandler(category, AuxAction.UNHIDE_SHEET.getAction(), (UserActionHandler)new UnhideSheetHandler());
        this.registerHandler(category, AuxAction.INSERT_COMMENT.getAction(), (UserActionHandler)new InsertCommentHandler());
        this.registerHandler(category, AuxAction.EDIT_COMMENT.getAction(), (UserActionHandler)new EditCommentHandler());
        this.registerHandler(category, AuxAction.DELETE_COMMENT.getAction(), (UserActionHandler)new DeleteCommentHandler());
        this.registerHandler(category, AuxAction.CUSTOM_FILTERS.getAction(), (UserActionHandler)new CustomFiltersHandler());
        this.registerHandler(category, AuxAction.TOP10_FILTER.getAction(), (UserActionHandler)new Top10FilterHandler());
        AbstractObjectHandler folderhandler = new AbstractObjectHandler(){
            private static final long serialVersionUID = 2987372171521192422L;

            protected boolean processAction(UserActionContext ctx) {
                return false;
            }
        };
        this.registerHandler(category, AuxAction.OTHER_CHART.getAction(), (UserActionHandler)folderhandler);
        category = DefaultUserActionManagerCtrl.Category.KEYSTROKE.getName();
        this.registerHandler(category, "#del/picture", (UserActionHandler)new DeletePictureHandler());
        this.registerHandler(category, "#del/chart", (UserActionHandler)new DeleteChartHandler());
        category = DefaultUserActionManagerCtrl.Category.EVENT.getName();
        this.registerHandler(category, "onCellSelectionUpdate/move", (UserActionHandler)new ShiftCellHandler());
        this.registerHandler(category, "onCellSelectionUpdate/resize", (UserActionHandler)new AutoFillHandler());
        this.registerHandler(category, "onWidgetUpdate/move/picture", (UserActionHandler)new MovePictureHandler());
        this.registerHandler(category, "onWidgetUpdate/resize/picture", (UserActionHandler)new MovePictureHandler());
        this.registerHandler(category, "onWidgetUpdate/move/chart", (UserActionHandler)new MoveChartHandler());
        this.registerHandler(category, "onWidgetUpdate/resize/chart", (UserActionHandler)new MoveChartHandler());
    }

    public Set<String> getInterestedEvents() {
        LinkedHashSet<String> evts = new LinkedHashSet<String>();
        evts.addAll(super.getInterestedEvents());
        evts.addAll(this._interestedEvents);
        return evts;
    }

    protected boolean dispatchCellSelectionUpdateAction(UserActionContext ctx) {
        String action;
        CellSelectionUpdateEvent evt = (CellSelectionUpdateEvent)ctx.getEvent();
        if (evt.getAction() == CellSelectionAction.MOVE) {
            action = "onCellSelectionUpdate/move";
        } else if (evt.getAction() == CellSelectionAction.RESIZE) {
            action = "onCellSelectionUpdate/resize";
        } else {
            return false;
        }
        ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setAction(action);
        ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("source", (Object)new AreaRef(evt.getOrigRow(), evt.getOrigColumn(), evt.getOrigLastRow(), evt.getOrigLastColumn()));
        boolean r = false;
        for (UserActionHandler uac : this.getHandlerList(ctx.getCategory(), ctx.getAction())) {
            if (uac == null || !uac.isEnabled(ctx.getBook(), ctx.getSheet())) continue;
            r |= uac.process(ctx);
        }
        return r;
    }

    protected boolean dispatchWidgetKeyAction(UserActionContext ctx) {
        WidgetKeyEvent event = (WidgetKeyEvent)ctx.getEvent();
        Object action = ctx.getAction();
        if (event != null) {
            action = this.getAction((KeyEvent)event);
            if (Strings.isBlank((String)action)) {
                return false;
            }
            Object widgetData = event.getData();
            if (widgetData instanceof Picture) {
                action = (String)action + "/picture";
                ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("picture", widgetData);
            } else if (widgetData instanceof Chart) {
                action = (String)action + "/chart";
                ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("chart", widgetData);
            }
        }
        ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setAction((String)action);
        boolean r = false;
        for (UserActionHandler uac : this.getHandlerList(ctx.getCategory(), ctx.getAction())) {
            if (uac == null || !uac.isEnabled(ctx.getBook(), ctx.getSheet())) continue;
            r |= uac.process(ctx);
        }
        return r;
    }

    protected boolean dispatchWidgetUpdateAction(UserActionContext ctx) {
        WidgetUpdateEvent event = (WidgetUpdateEvent)ctx.getEvent();
        Object widgetData = event.getData();
        String action = "";
        ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("anchor", (Object)event.getSheetAnchor());
        if (widgetData instanceof Picture) {
            switch (event.getAction()) {
                case RESIZE: {
                    action = "onWidgetUpdate/resize/picture";
                    break;
                }
                case MOVE: {
                    action = "onWidgetUpdate/move/picture";
                }
            }
            ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("picture", widgetData);
        } else if (widgetData instanceof Chart) {
            switch (event.getAction()) {
                case RESIZE: {
                    action = "onWidgetUpdate/resize/chart";
                    break;
                }
                case MOVE: {
                    action = "onWidgetUpdate/move/chart";
                }
            }
            ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setData("chart", widgetData);
        }
        ((DefaultUserActionManagerCtrl.UserActionContextImpl)ctx).setAction(action);
        boolean r = false;
        for (UserActionHandler uac : this.getHandlerList(ctx.getCategory(), ctx.getAction())) {
            if (uac == null || !uac.isEnabled(ctx.getBook(), ctx.getSheet())) continue;
            r |= uac.process(ctx);
        }
        return r;
    }

    public void onEvent(Event event) throws Exception {
        SBook sbook;
        super.onEvent(event);
        String nm = event.getName();
        if (!this._interestedEvents.contains(nm)) {
            return;
        }
        Spreadsheet spreadsheet = (Spreadsheet)event.getTarget();
        Book book = spreadsheet.getBook();
        Sheet sheet = spreadsheet.getSelectedSheet();
        String action = "";
        AreaRef selection = spreadsheet.getSelection();
        HashMap extraData = new HashMap();
        AreaRef visibleSelection = new AreaRef(selection.getRow(), selection.getColumn(), Math.min(spreadsheet.getCurrentMaxVisibleRows(), selection.getLastRow()), Math.min(spreadsheet.getCurrentMaxVisibleColumns(), selection.getLastColumn()));
        CellSelectionType _selectionType = CellSelectionType.CELL;
        SBook sBook = sbook = book == null ? null : book.getInternalBook();
        if (sbook != null) {
            boolean wholeSheet;
            boolean wholeRow = selection.getColumn() == 0 && selection.getLastColumn() >= sbook.getMaxColumnIndex();
            boolean wholeColumn = selection.getRow() == 0 && selection.getLastRow() >= sbook.getMaxRowIndex();
            boolean bl = wholeSheet = wholeRow && wholeColumn;
            CellSelectionType cellSelectionType = wholeSheet ? CellSelectionType.ALL : (wholeRow ? CellSelectionType.ROW : (_selectionType = wholeColumn ? CellSelectionType.COLUMN : CellSelectionType.CELL));
        }
        if ("onWidgetCtrlKey".equals(nm)) {
            DefaultUserActionManagerCtrl.UserActionContextImpl ctx = new DefaultUserActionManagerCtrl.UserActionContextImpl(spreadsheet, event, book, sheet, visibleSelection, _selectionType, extraData, DefaultUserActionManagerCtrl.Category.KEYSTROKE.getName(), action);
            this.dispatchWidgetKeyAction((UserActionContext)ctx);
        } else if ("onWidgetUpdate".equals(nm)) {
            DefaultUserActionManagerCtrl.UserActionContextImpl ctx = new DefaultUserActionManagerCtrl.UserActionContextImpl(spreadsheet, event, book, sheet, visibleSelection, _selectionType, extraData, DefaultUserActionManagerCtrl.Category.EVENT.getName(), action);
            this.dispatchWidgetUpdateAction((UserActionContext)ctx);
        } else if ("onCellSelectionUpdate".equals(nm)) {
            DefaultUserActionManagerCtrl.UserActionContextImpl ctx = new DefaultUserActionManagerCtrl.UserActionContextImpl(spreadsheet, event, book, sheet, visibleSelection, _selectionType, extraData, DefaultUserActionManagerCtrl.Category.EVENT.getName(), action);
            this.dispatchCellSelectionUpdateAction((UserActionContext)ctx);
        }
    }
}

