/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl;

import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.CellRegion;
import io.keikai.model.SCell;
import io.keikai.model.SDataValidation;
import io.keikai.model.SSheet;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.sys.EngineFactory;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.sys.format.FormatEngine;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.ui.sys.DataValidationHandler;
import io.keikaiex.ui.ValidationHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.ZssContext;
import org.zkoss.json.JSONArray;
import org.zkoss.zk.ui.event.EventListener;

public class DataValidationHandlerImpl
implements DataValidationHandler {
    private static final long serialVersionUID = -474331142130548708L;

    public List<Map<String, Object>> loadDataValidtionJASON(Sheet sheet) {
        SSheet xsheet = ((SheetImpl)sheet).getNative();
        return this.convertDataValidationToJSON(xsheet, xsheet.getDataValidations());
    }

    private List<Map<String, Object>> convertDataValidationToJSON(SSheet sheet, List<SDataValidation> dvs) {
        if (dvs != null && !dvs.isEmpty()) {
            ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>(dvs.size());
            for (SDataValidation dv : dvs) {
                results.add(this.convertDataValidationToJSON(sheet, dv));
            }
            return results;
        }
        return null;
    }

    private Map<String, Object> convertDataValidationToJSON(SSheet sheet, SDataValidation dv) {
        ArrayList<Map<String, Integer>> addrmapary = new ArrayList<Map<String, Integer>>(dv.getRegions().size() * 4 / 3 + 1);
        for (CellRegion addr : dv.getRegions()) {
            int left = addr.getColumn();
            int right = addr.getLastColumn();
            int top = addr.getRow();
            int bottom = addr.getLastRow();
            HashMap<String, Integer> addrmap = new HashMap<String, Integer>();
            addrmap.put("left", left);
            addrmap.put("top", top);
            addrmap.put("right", right);
            addrmap.put("bottom", bottom);
            addrmapary.add(addrmap);
        }
        HashMap<String, Object> validMap = new HashMap<String, Object>();
        validMap.put("id", dv.getId());
        validMap.put("rangeList", addrmapary);
        if (dv.isShowInput()) {
            validMap.put("showPrompt", true);
            validMap.put("promptTitle", dv.getInputTitle());
            validMap.put("promptText", dv.getInputMessage());
        }
        JSONArray listAry = new JSONArray();
        if (dv.isInCellDropdown()) {
            if (dv.hasReferToRelativeCol() || dv.hasReferToRelativeRow()) {
                for (CellRegion addr : dv.getRegions()) {
                    int left = addr.getColumn();
                    int right = addr.getLastColumn();
                    int top = addr.getRow();
                    int bottom = addr.getLastRow();
                    for (int r = top; r <= bottom; ++r) {
                        for (int c = left; c <= right; ++c) {
                            ArrayList<Map<String, Integer>> addrmapary0 = new ArrayList<Map<String, Integer>>(2);
                            HashMap<String, Integer> addrmap = new HashMap<String, Integer>();
                            addrmap.put("left", c);
                            addrmap.put("top", r);
                            addrmap.put("right", c);
                            addrmap.put("bottom", r);
                            addrmapary0.add(addrmap);
                            String[] validationList = this.getValidationList(r, c, dv);
                            Map<String, Object> list = this.prepareList(validationList, addrmapary0, dv);
                            if (list != null) {
                                listAry.add(list);
                            }
                            ((AbstractDataValidationAdv)dv).addDependency(r, c);
                        }
                    }
                }
            } else {
                int right;
                CellRegion addr = (CellRegion)dv.getRegions().iterator().next();
                int left = addr.getColumn();
                String[] validationList = this.getValidationList(left, right = addr.getLastColumn(), dv);
                Map<String, Object> list = this.prepareList(validationList, addrmapary, dv);
                if (list != null) {
                    listAry.add(list);
                }
            }
            if (!listAry.isEmpty()) {
                validMap.put("showButton", true);
                validMap.put("lists", listAry);
            }
        }
        return validMap;
    }

    private Map<String, Object> prepareList(String[] validationList, List<Map<String, Integer>> addrmapary, SDataValidation dv) {
        if (validationList != null) {
            HashMap<String, Object> list = new HashMap<String, Object>();
            list.put("rangeList", addrmapary);
            JSONArray jsonAry = new JSONArray();
            for (String v : validationList) {
                jsonAry.add((Object)v);
            }
            list.put("validationList", jsonAry);
            return list;
        }
        return null;
    }

    private String[] getValidationList(int row, int col, SDataValidation dv) {
        LinkedList<String> list = new LinkedList<String>();
        if (dv.hasReferToCellList()) {
            FormatEngine fe = EngineFactory.getInstance().createFormatEngine();
            for (SCell cell : dv.getReferToCellList(row, col)) {
                FormatResult r = fe.format(cell, new FormatContext(ZssContext.getCurrent().getLocale()));
                list.add(r.getText());
            }
        } else {
            int s = dv.getNumOfValue1();
            if (dv.hasReferToCellList()) {
                return this.getValidationList(row, col, dv);
            }
            for (int i = 0; i < s; ++i) {
                Object val = dv.getValue1(i);
                list.add(val == null ? "" : val.toString());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public boolean validate(Sheet sheet, int row, int col, String editText, EventListener callback) {
        return new ValidationHelper().validate(sheet, row, col, editText, callback);
    }
}

