/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.model.SAutoFilter;
import io.keikai.model.STop10Filter;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.DialogCtrlBase;
import java.util.HashSet;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Spinner;
import org.zkoss.zul.Window;

public class Top10FilterCtrl
extends DialogCtrlBase {
    private static final long serialVersionUID = 2289298995088798124L;
    public static String URI = "~./zssex/dlg/top10Filter.zul";
    public static String ARG_TOPBOTTOM = "topbottom";
    public static String ARG_VALUE = "value";
    public static String ARG_ITEMSPERCENT = "itemspercent";
    protected ListModelList<TopBottom> topbottomModel;
    protected ListModelList<ItemsPercent> itemspercentModel;
    @Wire
    protected Button okBtn;
    @Wire
    protected Listbox topbottomListbox;
    @Wire
    protected Listbox itemspercentListbox;
    @Wire
    protected Spinner valueSpinner;

    public static String getLabel(Enum enum0) {
        return Labels.getLabel((String)("zssex.top10dlg." + enum0.name()));
    }

    public static void show(EventListener<DialogCallbackEvent> callback, SAutoFilter.NFilterColumn fc) {
        STop10Filter top10Filter = fc == null ? null : fc.getTop10Filter();
        Boolean isTop = top10Filter == null ? Boolean.TRUE.booleanValue() : top10Filter.isTop();
        Boolean isPercent = top10Filter == null ? Boolean.FALSE.booleanValue() : top10Filter.isPercent();
        Double value = top10Filter == null ? 10.0 : top10Filter.getValue();
        Map arg = Top10FilterCtrl.newArg(callback);
        arg.put(ARG_ITEMSPERCENT, isPercent);
        arg.put(ARG_TOPBOTTOM, isTop);
        arg.put(ARG_VALUE, value);
        Window comp = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        comp.doModal();
    }

    protected void init(boolean isTop, double value, boolean isPercent) {
        this.topbottomModel = new ListModelList(2);
        this.topbottomModel.add((Object)TopBottom.top);
        this.topbottomModel.add((Object)TopBottom.bottom);
        this.itemspercentModel = new ListModelList(2);
        this.itemspercentModel.add((Object)ItemsPercent.items);
        this.itemspercentModel.add((Object)ItemsPercent.percent);
        HashSet<TopBottom> topSet = new HashSet<TopBottom>();
        topSet.add(isTop ? TopBottom.top : TopBottom.bottom);
        this.topbottomModel.setSelection(topSet);
        this.topbottomListbox.setModel(this.topbottomModel);
        HashSet<ItemsPercent> itemSet = new HashSet<ItemsPercent>();
        itemSet.add(isPercent ? ItemsPercent.percent : ItemsPercent.items);
        this.itemspercentModel.setSelection(itemSet);
        this.itemspercentListbox.setModel(this.itemspercentModel);
        this.valueSpinner.setValue(Integer.valueOf((int)value));
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        Map arg = Executions.getCurrent().getArg();
        boolean isTop = (Boolean)arg.get(ARG_TOPBOTTOM);
        boolean isPercent = (Boolean)arg.get(ARG_ITEMSPERCENT);
        double val = (Double)arg.get(ARG_VALUE);
        this.init(isTop, val, isPercent);
    }

    @Listen(value="onOK=window; onClick=#okBtn;")
    public void onOK() {
        boolean isTop = this.topbottomModel.getSelection().iterator().next() == TopBottom.top;
        boolean isPercent = this.itemspercentModel.getSelection().iterator().next() == ItemsPercent.percent;
        double value = new Double(this.valueSpinner.getValue().intValue());
        this.postCallback(ON_OK, Top10FilterCtrl.newMap(Top10FilterCtrl.newEntry(ARG_TOPBOTTOM, isTop), Top10FilterCtrl.newEntry(ARG_ITEMSPERCENT, isPercent), Top10FilterCtrl.newEntry(ARG_VALUE, value)));
        this.detach();
    }

    @Listen(value="onCancel = window; onClick = #cancelBtn")
    public void onCancel() {
        this.detach();
        this.postCallback(ON_CANCEL, null);
    }

    public static enum ItemsPercent {
        items,
        percent;

    }

    public static enum TopBottom {
        top,
        bottom;

    }
}

