/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.dialog;

import io.keikai.ui.ZSMessagebox;
import io.keikaiex.ui.dialog.FormulaMetaInfo;
import io.keikaiex.ui.dialog.Formulas;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.dialog.impl.DialogCtrlBase;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zk.ui.select.annotation.Wire;
import org.zkoss.zul.Button;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Label;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.ListModelList;
import org.zkoss.zul.Listbox;
import org.zkoss.zul.Listcell;
import org.zkoss.zul.Listitem;
import org.zkoss.zul.ListitemRenderer;
import org.zkoss.zul.SimpleListModel;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Window;

public class InsertFormulaCtrl
extends DialogCtrlBase {
    private static final long serialVersionUID = 1L;
    public static String FORMULA = "formula";
    public static String URI = "~./zssex/dlg/insertFormulaDialog.zul";
    public static String ALL = "All";
    @Wire
    protected Div findArea;
    @Wire
    protected Textbox searchTextbox;
    @Wire
    protected Combobox categoryCombobox;
    @Wire
    protected Listbox functionListbox;
    @Wire
    protected Label expression;
    @Wire
    protected Label description;
    @Wire
    protected Button selectButton;
    @Wire
    protected Window _composeFormulaDialog;
    @Wire(value="#_composeFormulaDialog #formulaStart")
    protected Label formulaStart;
    @Wire(value="#_composeFormulaDialog #formulaEnd")
    protected Label formulaEnd;
    @Wire(value="#_composeFormulaDialog #composeFormulaTextbox")
    protected Textbox composeFormulaTextbox;
    protected LinkedHashMap<String, List<FormulaMetaInfo>> formulaInfos;

    public static void show(EventListener<DialogCallbackEvent> dialogEventListener) {
        Map arg = InsertFormulaCtrl.newArg(dialogEventListener);
        Window window = (Window)Executions.createComponents((String)URI, null, (Map)arg);
        window.doModal();
    }

    @Override
    public void doAfterCompose(Window comp) throws Exception {
        super.doAfterCompose(comp);
        this.formulaInfos = Formulas.getFormulaInfosByCategory();
        LinkedList<String> categoryArys = new LinkedList<String>();
        categoryArys.add(ALL);
        categoryArys.addAll(this.formulaInfos.keySet());
        this.categoryCombobox.setModel((ListModel)new ListModelList(categoryArys, false));
        this.categoryCombobox.setZclass("zss-combobox");
        this.categoryCombobox.addEventListener("onAfterRender", (EventListener)new SerializableEventListener(){
            private static final long serialVersionUID = -7846551679007392114L;

            public void onEvent(Event event) throws Exception {
                InsertFormulaCtrl.this.categoryCombobox.setSelectedIndex(0);
                InsertFormulaCtrl.this.initFunctionListboxByCategory();
            }
        });
        this.searchTextbox.setText(null);
        this.searchTextbox.focus();
        this.functionListbox.setItemRenderer(new ListitemRenderer(){

            public void render(Listitem item, Object data) throws Exception {
                item.setZclass("zss-listitem");
                FormulaMetaInfo info = (FormulaMetaInfo)data;
                Listcell cell = new Listcell();
                cell.setZclass("zss-listcell");
                cell.setLabel(info.getFunction());
                item.appendChild((Component)cell);
                item.setValue((Object)info);
                item.addEventListener("onDoubleClick", (EventListener)new SerializableEventListener<Event>(){
                    private static final long serialVersionUID = -6064484957416645205L;

                    public void onEvent(Event event) throws Exception {
                        InsertFormulaCtrl.this.openComposeFormulaDialog();
                    }
                });
            }

            public void render(Listitem item, Object data, int index) throws Exception {
                this.render(item, data);
            }
        });
    }

    @Listen(value="onSelect = #categoryCombobox")
    public void onSelect$categoryCombobox() {
        this.initFunctionListboxByCategory();
    }

    protected void initFunctionListboxByCategory() {
        String category = (String)this.categoryCombobox.getSelectedItem().getValue();
        if (category == null) {
            return;
        }
        List<FormulaMetaInfo> categoriedFunctions = this.formulaInfos.get(category);
        if (categoriedFunctions == null) {
            categoriedFunctions = new LinkedList<FormulaMetaInfo>();
            for (List<FormulaMetaInfo> infoAry : this.formulaInfos.values()) {
                categoriedFunctions.addAll(infoAry);
            }
        }
        this.functionListbox.setModel((ListModel)new SimpleListModel(categoriedFunctions));
        this.selectButton.setDisabled(true);
    }

    @Listen(value="onSelect = #functionListbox")
    public void selectFunction() {
        FormulaMetaInfo info = (FormulaMetaInfo)this.functionListbox.getSelectedItem().getValue();
        this.expression.setValue(info.getExpression());
        this.description.setValue(info.getDescription());
        this.selectButton.setDisabled(false);
    }

    @Listen(value="onClick = #selectButton")
    public void confirmSelection() {
        this.openComposeFormulaDialog();
    }

    protected void openComposeFormulaDialog() {
        Listitem item = this.functionListbox.getSelectedItem();
        if (item == null) {
            ZSMessagebox.show((String)Labels.getLabel((String)"zssex.dlg.insert_function.err.no_function_selected"));
            return;
        }
        FormulaMetaInfo info = (FormulaMetaInfo)item.getValue();
        if (info.getRequiredParameter() == 0) {
            this.formulaStart.setValue("=" + info.getFunction() + "(");
            this.insertFunction();
        } else {
            this.openComposeFormulaDialog((FormulaMetaInfo)item.getValue());
        }
    }

    protected List<FormulaMetaInfo> search(String keyword) {
        keyword = keyword.toLowerCase();
        LinkedList<FormulaMetaInfo> searchResult = new LinkedList<FormulaMetaInfo>();
        for (List<FormulaMetaInfo> infoAry : this.formulaInfos.values()) {
            for (FormulaMetaInfo info : infoAry) {
                if (!info.getFunction().toLowerCase().contains(keyword) && !info.getExpression().toLowerCase().contains(keyword) && !info.getDescription().toLowerCase().contains(keyword)) continue;
                searchResult.add(info);
            }
        }
        Collections.sort(searchResult, new Comparator<FormulaMetaInfo>(){

            @Override
            public int compare(FormulaMetaInfo o1, FormulaMetaInfo o2) {
                return o1.getFunction().compareTo(o2.getFunction());
            }
        });
        return searchResult;
    }

    @Listen(value="onChanging = #searchTextbox")
    public void startSearch(InputEvent event) {
        String keyword = event.getValue();
        if (keyword == null || "".equals(keyword)) {
            this.initFunctionListboxByCategory();
        } else {
            this.functionListbox.setModel((ListModel)new SimpleListModel(this.search(keyword)));
            this.selectButton.setDisabled(true);
        }
    }

    @Listen(value="onClick = #_composeFormulaDialog #insertBtn; onOK = #_composeFormulaDialog #composeFormulaTextbox")
    public void insertFunction() {
        this.postCallback(ON_OK, InsertFormulaCtrl.newMap(InsertFormulaCtrl.newEntry(FORMULA, this.formulaStart.getValue() + this.composeFormulaTextbox.getText() + this.formulaEnd.getValue())));
        this.detach();
    }

    protected void openComposeFormulaDialog(FormulaMetaInfo metainfo) {
        Events.sendEvent((String)"onOpen", (Component)this._composeFormulaDialog, (Object)metainfo);
        this.findArea.setVisible(false);
        this._composeFormulaDialog.setVisible(true);
    }
}

