/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui;

import io.keikaiex.ui.impl.BridgeFix;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.http.WebManager;
import org.zkoss.zk.ui.sys.WebAppCtrl;

public abstract class UpdateBridge
implements Serializable {
    private static final long serialVersionUID = -1023233887618980089L;
    protected final ServletContext _servletContext;
    protected final HttpServletRequest _request;
    protected final HttpServletResponse _response;
    protected final String _desktopId;

    public UpdateBridge(ServletContext servletContext, HttpServletRequest req, HttpServletResponse resp, String desktopId) {
        this._servletContext = servletContext;
        this._request = req;
        this._response = resp;
        this._desktopId = desktopId;
    }

    public boolean hasDesktop() {
        return UpdateBridge.findDesktopIfAny(this._servletContext, this._request, this._desktopId) != null;
    }

    public String process() {
        Desktop desktop = UpdateBridge.findDesktopIfAny(this._servletContext, this._request, this._desktopId);
        if (desktop == null) {
            throw new IllegalStateException("can't find zk desktop by id " + this._desktopId);
        }
        BridgeFix zbridge = new BridgeFix();
        zbridge.start(this._servletContext, this._request, this._response, desktop);
        try {
            String zkjs;
            this.process(desktop);
            String string = zkjs = zbridge.getResult();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        finally {
            zbridge.close();
        }
    }

    public static Desktop findDesktopIfAny(ServletContext ctx, HttpServletRequest request, String desktopId) {
        Session sess = WebManager.getSession((ServletContext)ctx, (HttpServletRequest)request, (boolean)false);
        if (sess != null) {
            Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktopIfAny(desktopId);
            return desktop;
        }
        return null;
    }

    public static Desktop findDesktop(ServletContext ctx, HttpServletRequest request, String desktopId) {
        Session sess = WebManager.getSession((ServletContext)ctx, (HttpServletRequest)request, (boolean)false);
        if (sess != null) {
            Desktop desktop = ((WebAppCtrl)sess.getWebApp()).getDesktopCache(sess).getDesktop(desktopId);
            return desktop;
        }
        return null;
    }

    protected abstract void process(Desktop var1) throws Exception;
}

