/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.model.sys;

import io.keikai.model.SBook;
import io.keikai.model.sys.dependency.Ref;
import io.keikaiex.model.sys.RowTracker;
import io.keikaiex.util.Interval;
import io.keikaiex.util.IntervalTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;

class SheetTracker
implements Serializable {
    private static final long serialVersionUID = 2067138994732600811L;
    private final IntervalTree<RowTracker> _sheetIntervalTree = new IntervalTree(Integer.MAX_VALUE);
    private final int _maxRowLimit;
    private final int _maxColLimit;
    private final SBook _book;

    SheetTracker(SBook book, int maxRowLimit, int maxColLimit) {
        this._maxRowLimit = maxRowLimit;
        this._maxColLimit = maxColLimit;
        this._book = book;
    }

    Interval<Ref> insertRef(Ref ref) {
        int[] lowhigh;
        if (ref instanceof AdjustableRef) {
            ref = ((AdjustableRef)ref).getInner();
        }
        if ((lowhigh = this.prepareSheetLowHigh(ref)) == null) {
            return null;
        }
        Interval<RowTracker> interval = new Interval<RowTracker>(lowhigh[0], lowhigh[1], new RowTracker(this._maxRowLimit, this._maxColLimit));
        Interval<RowTracker> intv = this._sheetIntervalTree.insertInterval(interval, null);
        RowTracker rowTracker = intv.getPayload();
        return rowTracker.insertRef(new AdjustableRef(intv, ref));
    }

    Interval<Ref> deleteRef(Ref ref) {
        Interval<RowTracker> intv = this.searchRowTracker(ref);
        if (intv == null) {
            return null;
        }
        RowTracker rowTracker = intv.getPayload();
        Interval<Ref> refIntv = rowTracker.deleteRef(ref);
        if (rowTracker.isEmpty()) {
            this._sheetIntervalTree.deleteInterval(intv, null);
        }
        return refIntv;
    }

    Interval<Ref> searchRef(Ref ref) {
        Interval<RowTracker> intv = this.searchRowTracker(ref);
        if (intv == null) {
            return null;
        }
        RowTracker rowTracker = intv.getPayload();
        return rowTracker.searchRef(ref);
    }

    Collection<Interval<Ref>> overlaps(Ref ref) {
        int[] lowhigh;
        int[] nArray;
        if (ref.getType() == Ref.RefType.BOOK) {
            int[] nArray2 = new int[2];
            nArray2[0] = 0;
            nArray = nArray2;
            nArray2[1] = Integer.MAX_VALUE;
        } else {
            nArray = lowhigh = this.prepareSheetLowHigh(ref);
        }
        if (lowhigh == null) {
            return null;
        }
        Interval<Object> interval = new Interval<Object>(lowhigh[0], lowhigh[1], null);
        Collection<Interval<Object>> intervals = this._sheetIntervalTree.overlaps(interval);
        LinkedHashSet<Interval<Ref>> results = new LinkedHashSet<Interval<Ref>>();
        for (Interval<Object> intv : intervals) {
            RowTracker rowTracker = intv.getPayload();
            results.addAll(rowTracker.overlaps(ref));
        }
        return results;
    }

    boolean isEmpty() {
        return this._sheetIntervalTree.isEmpty();
    }

    private int[] prepareSheetLowHigh(Ref ref) {
        int low;
        int n = ref instanceof AdjustableRef ? ref.getSheetIndex() : (low = ref.getSheetIndex() < 0 ? this._book.getSheetIndex(ref.getSheetName()) : ref.getSheetIndex());
        if (low < 0) {
            return null;
        }
        int high = ref instanceof AdjustableRef ? ref.getLastSheetIndex() : this._book.getSheetIndex(ref.getLastSheetName());
        return new int[]{low, high < 0 ? low : high};
    }

    Interval<RowTracker> searchRowTracker(Ref ref) {
        int[] lowhigh = this.prepareSheetLowHigh(ref);
        if (lowhigh == null) {
            return null;
        }
        Interval<RowTracker> interval = new Interval<RowTracker>(lowhigh[0], lowhigh[1], new RowTracker(this._maxRowLimit, this._maxColLimit));
        return this._sheetIntervalTree.searchInterval(interval);
    }

    void adjustSheetIndex(int index, int size) {
        Collection<Interval<Object>> results = this._sheetIntervalTree.overlaps(new Interval<Object>(index, Integer.MAX_VALUE, null));
        ArrayList<RowTracker> payloads = new ArrayList<RowTracker>(results.size());
        for (Interval<Object> interval : results) {
            payloads.add(interval.getPayload());
            this._sheetIntervalTree.deleteInterval(interval, null);
        }
        HashSet<Interval<Object>> skip = new HashSet<Interval<Object>>();
        for (Interval<Object> interval : results) {
            int high = interval.getHigh();
            if ((high += size) < index) {
                skip.add(interval);
                continue;
            }
            if (size > 0 && high < 0) {
                high = Integer.MAX_VALUE;
            }
            interval.setHigh(high);
            int low = interval.getLow();
            if (low < index) continue;
            if (size > 0 && (low += size) < 0) {
                skip.add(interval);
                continue;
            }
            if (low < index) {
                low = index;
            }
            interval.setLow(low);
        }
        Iterator iterator = payloads.iterator();
        for (Interval<Object> intv : results) {
            RowTracker payload = (RowTracker)iterator.next();
            if (skip.contains(intv)) continue;
            intv.setPayload(payload);
            this._sheetIntervalTree.insertInterval(intv, null);
        }
    }

    void moveSheetIndex(int oldIndex, int newIndex) {
        if (oldIndex == newIndex) {
            return;
        }
        int offset = oldIndex < newIndex ? -1 : 1;
        int low = oldIndex < newIndex ? oldIndex : newIndex;
        int high = oldIndex < newIndex ? newIndex : oldIndex;
        Collection<Interval<Object>> results = this._sheetIntervalTree.overlaps(new Interval<Object>(low, high, null));
        ArrayList<RowTracker> payloads = new ArrayList<RowTracker>(results.size());
        for (Interval<Object> intv : results) {
            payloads.add(intv.getPayload());
            this._sheetIntervalTree.deleteInterval(intv, null);
        }
        for (Interval<Object> intv : results) {
            int low0 = intv.getLow();
            int high0 = intv.getHigh();
            if (low0 == oldIndex) {
                if (low0 == high0) {
                    intv.setLow(newIndex);
                    intv.setHigh(newIndex);
                } else if (newIndex >= high0) {
                    intv.setLow(low0 + offset);
                    intv.setHigh(high0 + offset);
                }
            } else if (low0 >= low) {
                intv.setLow(low0 + offset);
            }
            if (high0 == oldIndex) {
                if (low0 == high0 || newIndex > low0) continue;
                intv.setLow(low0 + offset);
                continue;
            }
            if (high0 > high) continue;
            intv.setHigh(high0 + offset);
        }
        Iterator it = payloads.iterator();
        for (Interval<Object> intv : results) {
            RowTracker payload = (RowTracker)it.next();
            intv.setPayload(payload);
            this._sheetIntervalTree.insertInterval(intv, null);
        }
    }

    public String toString() {
        Collection<Interval<Object>> results = this._sheetIntervalTree.contained(new Interval<Object>(0, Integer.MAX_VALUE, null));
        return results.toString();
    }

    private static class AdjustableRef
    implements Ref,
    Serializable {
        private static final long serialVersionUID = -7386446308287331432L;
        protected Ref _inner;
        private Interval<RowTracker> _interval;

        AdjustableRef(Interval<RowTracker> interval, Ref inner) {
            this._interval = interval;
            this._inner = inner;
        }

        public Ref.RefType getType() {
            return this._inner.getType();
        }

        public String getBookName() {
            return this._inner.getBookName();
        }

        public String getSheetName() {
            return this._inner.getSheetName();
        }

        public String getLastSheetName() {
            return this._inner.getLastSheetName();
        }

        public int getRow() {
            return this._inner.getRow();
        }

        public int getColumn() {
            return this._inner.getColumn();
        }

        public int getLastRow() {
            return this._inner.getLastRow();
        }

        public int getLastColumn() {
            return this._inner.getLastColumn();
        }

        public int getSheetIndex() {
            return this._interval.getLow();
        }

        public int getLastSheetIndex() {
            return this._interval.getHigh();
        }

        Ref getInner() {
            return this._inner;
        }

        public String toString() {
            return "AdjustableRef(" + this.getSheetIndex() + ":" + this.getLastSheetIndex() + ")" + this._inner.toString();
        }

        public int hashCode() {
            return this._inner.hashCode();
        }

        public boolean equals(Object other) {
            return this._inner.equals(other);
        }
    }
}

