/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.model.sys;

import io.keikai.model.sys.dependency.Ref;
import io.keikaiex.util.Interval;
import io.keikaiex.util.IntervalTree;
import java.io.Serializable;
import java.util.Collection;

class ColTracker
implements Serializable {
    private static final long serialVersionUID = 759454443856972536L;
    private int _maxColLimit;
    private IntervalTree<Ref> _colIntervalTree;

    ColTracker(int maxColLimit) {
        this._maxColLimit = maxColLimit;
        this._colIntervalTree = new IntervalTree(maxColLimit);
    }

    Interval<Ref> insertRef(Ref ref) {
        Interval<Ref> interval = this.prepareKeyInterval(ref, ref);
        return this._colIntervalTree.insertInterval(interval, null);
    }

    Interval<Ref> deleteRef(Ref ref) {
        Interval<Ref> interval = this.prepareKeyInterval(ref, ref);
        return this._colIntervalTree.deleteInterval(interval, null);
    }

    Interval<Ref> searchRef(Ref ref) {
        Interval<Ref> interval = this.prepareKeyInterval(ref, null);
        return this._colIntervalTree.searchInterval(interval);
    }

    Collection<Interval<Ref>> overlaps(Ref ref) {
        Interval<Ref> interval = this.prepareKeyInterval(ref, null);
        return this._colIntervalTree.overlaps(interval);
    }

    boolean isEmpty() {
        return this._colIntervalTree.isEmpty();
    }

    private Interval<Ref> prepareKeyInterval(Ref ref, Ref payload) {
        int col1 = ref.getColumn();
        int col2 = ref.getLastColumn();
        return col1 <= 0 && col2 < 0 ? new Interval.InfiniteInterval<Ref>(this._maxColLimit, payload) : new Interval(col1, col2, payload);
    }
}

