/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import io.keikai.model.impl.sys.DateInputMask;
import java.util.Locale;
import org.apache.poi.ss.format.Formatters;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.usermodel.ZssContext;

public final class FunctionHelper {
    public static Object[] parseToDate(String txt) {
        ZssContext ctx = ZssContext.getCurrent();
        int twoDigitYearUpperBound = ctx.getTwoDigitYearUpperBound();
        Locale locale = ctx.getLocale();
        return new DateInputMask().parseDateInput(txt, locale);
    }

    private static boolean isStringFormat(String formatStr) {
        return "@".equals(formatStr);
    }

    public static Object[] editTextToValue(String txt, String formatStr) {
        if (txt != null) {
            if (formatStr != null && FunctionHelper.isStringFormat(formatStr)) {
                return new Object[]{CellType.STRING, txt};
            }
            if (txt.startsWith("=")) {
                if (txt.trim().length() > 1) {
                    return new Object[]{CellType.FORMULA, txt.substring(1)};
                }
                return new Object[]{CellType.STRING, txt};
            }
            if ("true".equalsIgnoreCase(txt) || "false".equalsIgnoreCase(txt)) {
                return new Object[]{CellType.BOOLEAN, Boolean.valueOf(txt)};
            }
            if (txt.startsWith("#")) {
                Object[] objectArray;
                byte err = FunctionHelper.getErrorCode(txt);
                if (err < 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = CellType.STRING;
                    objectArray = objectArray2;
                    objectArray2[1] = txt;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = CellType.ERROR;
                    objectArray = objectArray3;
                    objectArray3[1] = err;
                }
                return objectArray;
            }
            return FunctionHelper.parseEditTextToDoubleDateOrString(txt);
        }
        return null;
    }

    private static Object[] parseEditTextToDoubleDateOrString(String txt) {
        Locale locale = ZssContext.getCurrent().getLocale();
        char dot = Formatters.getDecimalSeparator((Locale)locale);
        char comma = Formatters.getGroupingSeparator((Locale)locale);
        Object txt0 = txt;
        if (dot != '.' || comma != ',') {
            int dotPos = txt.lastIndexOf(dot);
            txt0 = txt.replace(comma, ',');
            if (dotPos >= 0) {
                txt0 = ((String)txt0).substring(0, dotPos) + "." + ((String)txt0).substring(dotPos + 1);
            }
        }
        try {
            double val = Double.parseDouble((String)txt0);
            return new Object[]{CellType.NUMERIC, val};
        }
        catch (NumberFormatException ex) {
            return FunctionHelper.parseEditTextToDateOrString(txt);
        }
    }

    private static Object[] parseEditTextToDateOrString(String txt) {
        Object[] results = FunctionHelper.parseToDate(txt);
        if (results[0] instanceof String) {
            return new Object[]{CellType.STRING, results[0]};
        }
        return new Object[]{CellType.NUMERIC, results[0], results[1]};
    }

    private static byte getErrorCode(String errString) {
        if ("#NULL!".equals(errString)) {
            return FormulaError.NULL.getCode();
        }
        if ("#DIV/0!".equals(errString)) {
            return FormulaError.DIV0.getCode();
        }
        if ("#VALUE!".equals(errString)) {
            return FormulaError.VALUE.getCode();
        }
        if ("#REF!".equals(errString)) {
            return FormulaError.REF.getCode();
        }
        if ("#NAME?".equals(errString)) {
            return FormulaError.NAME.getCode();
        }
        if ("#NUM!".equals(errString)) {
            return FormulaError.NUM.getCode();
        }
        if ("#N/A".equals(errString)) {
            return FormulaError.NA.getCode();
        }
        return -1;
    }
}

