/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula.fn;

import io.keikaiex.formula.fn.FunctionHelper;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed3ArgFunction;
import org.apache.poi.ss.formula.functions.Function;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.TextFunctionHelper;
import org.apache.poi.ss.formula.functions.UtilFns;
import org.apache.poi.ss.usermodel.DateUtil;
import org.zkoss.xel.fn.CommonFns;

public class DateTimeFunctionImpl {
    public static final Function DATEVALUE = new TextFunction(){

        protected ValueEval evaluateFunc(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String txtDate = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            Object[] objs = FunctionHelper.parseToDate(txtDate);
            return new NumberEval(DateUtil.getExcelDate((Date)((Date)objs[0]), (boolean)false));
        }
    };
    public static final Function HOUR = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String txt = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            Object[] result = FunctionHelper.editTextToValue(txt, null);
            double time = result[1] instanceof Date ? DateUtil.getExcelDate((Date)((Date)result[1])) : (Double)result[1];
            return DateTimeFunctionImpl.argToCalendar(DateUtil.getJavaDate((double)time, (boolean)false)).get(11);
        }
    };
    public static final Function MINUTE = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String txt = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            Object[] result = FunctionHelper.editTextToValue(txt, null);
            double time = result[1] instanceof Date ? DateUtil.getExcelDate((Date)((Date)result[1])) : (Double)result[1];
            return DateTimeFunctionImpl.argToCalendar(DateUtil.getJavaDate((double)time, (boolean)false)).get(12);
        }
    };
    public static final Function SECOND = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            String txt = TextFunctionHelper.evaluateStringArg((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            Object[] result = FunctionHelper.editTextToValue(txt, null);
            double time = result[1] instanceof Date ? DateUtil.getExcelDate((Date)((Date)result[1])) : (Double)result[1];
            return DateTimeFunctionImpl.argToCalendar(DateUtil.getJavaDate((double)time, (boolean)false)).get(13);
        }
    };
    public static final Function WEEKDAY = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            double time = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            Calendar cal = DateTimeFunctionImpl.argToCalendar(DateUtil.getJavaDate((double)time, (boolean)false));
            int type = 1;
            if (args.length == 2) {
                type = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            }
            switch (type) {
                case 1: {
                    return new Integer(cal.get(7)).intValue();
                }
                case 2: {
                    return new Integer(DateTimeFunctionImpl.weekdayFromMonday(cal.get(7))).intValue();
                }
                case 3: {
                    return new Integer(DateTimeFunctionImpl.weekdayFromMonday(cal.get(7)) - 1).intValue();
                }
            }
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    };
    public static final Function EOMONTH = new NumericFunction(){

        protected double eval(ValueEval[] args, int srcCellRow, int srcCellCol) throws EvaluationException {
            double time = NumericFunction.singleOperandEvaluate((ValueEval)args[0], (int)srcCellRow, (int)srcCellCol);
            int moffset = (int)NumericFunction.singleOperandEvaluate((ValueEval)args[1], (int)srcCellRow, (int)srcCellCol);
            Calendar cal = DateTimeFunctionImpl.argToCalendar(DateUtil.getJavaDate((double)time, (boolean)false));
            int year = cal.get(1);
            int month = cal.get(2);
            int month0 = month + moffset;
            if (month0 >= 0) {
                year += month0 / 12;
                month = month0 % 12;
            } else {
                int yearOff = -(month0 + 1) / 12 + 1;
                year -= yearOff;
                month = (month0 + yearOff * 12) % 12;
            }
            Calendar newcal = Calendar.getInstance();
            newcal.set(1, year);
            newcal.set(2, month);
            newcal.set(5, 1);
            int lastday = newcal.getActualMaximum(5);
            newcal.set(5, lastday);
            newcal.set(11, 0);
            newcal.set(12, 0);
            newcal.set(13, 0);
            newcal.set(14, 0);
            return DateUtil.getExcelDate((Calendar)newcal, (boolean)false);
        }
    };
    public static final Function DATEDIF = new Fixed3ArgFunction(){

        public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
            double result;
            try {
                double d0 = this.evaluateToDate(arg0, srcRowIndex, srcColumnIndex);
                double d1 = this.evaluateToDate(arg1, srcRowIndex, srcColumnIndex);
                ValueEval ve = OperandResolver.getSingleValue((ValueEval)arg2, (int)srcRowIndex, (int)srcColumnIndex);
                String unit = OperandResolver.coerceValueToString((ValueEval)ve);
                result = this.evaluate(d0, d1, unit);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            return new NumberEval(result);
        }

        private double evaluateToDate(ValueEval arg, int srcRowIndex, int srcColumnIndex) throws EvaluationException {
            try {
                return TextFunctionHelper.evaluateDoubleArg((ValueEval)arg, (int)srcRowIndex, (int)srcColumnIndex);
            }
            catch (EvaluationException e) {
                String txtDate = TextFunctionHelper.evaluateStringArg((ValueEval)arg, (int)srcRowIndex, (int)srcColumnIndex);
                Object[] objs = FunctionHelper.parseToDate(txtDate);
                return DateUtil.getExcelDate((Date)((Date)objs[0]), (boolean)false);
            }
        }

        private double evaluate(double d0, double d1, String unit) throws EvaluationException {
            Calendar endDate;
            Calendar startDate = this.getDate(d0);
            if (startDate.after(endDate = this.getDate(d1))) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            switch (unit.toUpperCase()) {
                case "Y": {
                    int yearDiff = endDate.get(1) - startDate.get(1);
                    LocalDate adjDate = LocalDate.of(startDate.get(1) + yearDiff, startDate.get(2) + 1, startDate.get(5));
                    if (adjDate.isAfter(ChronoLocalDate.from(LocalDateTime.ofInstant(endDate.toInstant(), ZoneId.systemDefault()).toLocalDate()))) {
                        --yearDiff;
                    }
                    return yearDiff;
                }
                case "M": {
                    int yearDiff1 = endDate.get(1) - startDate.get(1);
                    int monthDiff = endDate.get(2) - startDate.get(2) + yearDiff1 * 12;
                    int dayDiff = endDate.get(5) - startDate.get(5);
                    if (dayDiff < 0) {
                        --monthDiff;
                    }
                    return monthDiff;
                }
                case "D": {
                    return d1 - d0;
                }
                case "MD": {
                    return endDate.get(5) - startDate.get(5);
                }
                case "YM": {
                    return endDate.get(2) - startDate.get(2);
                }
                case "YD": {
                    LocalDateTime adjEndDate = LocalDateTime.of(startDate.get(1), endDate.get(2) + 1, endDate.get(5), 0, 0);
                    return Duration.between(LocalDateTime.ofInstant(startDate.toInstant(), ZoneId.systemDefault()), adjEndDate).toDays();
                }
            }
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }

        private Calendar getDate(double date) {
            GregorianCalendar processedDate = new GregorianCalendar();
            processedDate.setTime(DateUtil.getJavaDate((double)date, (boolean)false));
            return processedDate;
        }
    };

    private static int weekdayFromMonday(int day) {
        if (day == 1) {
            return 7;
        }
        return day - 1;
    }

    public static Calendar argToCalendar(Object arg) {
        Calendar calendar = Calendar.getInstance();
        if (arg instanceof Date) {
            calendar.setTime((Date)arg);
            return calendar;
        }
        calendar.setTime(UtilFns.daysToDate((int)CommonFns.toNumber((Object)arg).intValue()));
        return calendar;
    }
}

