/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.formula;

import io.keikai.model.sys.formula.FunctionResolver;
import io.keikaiex.formula.DependencyTrackerEx;
import java.lang.reflect.Field;
import org.apache.poi.ss.formula.DependencyTracker;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelException;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.util.TaglibMapper;

public class FunctionResolverEx
implements FunctionResolver {
    public static String EL_FUNCTION_KEY = "";
    private static final Logger logger = LoggerFactory.getLogger(FunctionResolverEx.class);
    private static final String LEGACY_TAGLIB_KEY = "http://www.zkoss.org/zss/functions";
    private static final String TAGLIB_KEY = "http://www.keikai.io/kk/functions";
    private static FunctionMapper _mapper;
    private static UDFFinder _udffinder;
    private static boolean _fail;

    public UDFFinder getUDFFinder() {
        return _fail ? null : _udffinder;
    }

    public FunctionMapper getFunctionMapper() {
        return _fail ? null : _mapper;
    }

    public DependencyTracker getDependencyTracker() {
        return new DependencyTrackerEx();
    }

    static {
        _fail = false;
        if (_mapper == null) {
            Taglib taglib;
            String lib;
            int j;
            String[] libs;
            ClassLocator loc;
            TaglibMapper mapper = new TaglibMapper();
            String functions = Library.getProperty((String)LEGACY_TAGLIB_KEY);
            if (functions != null) {
                loc = new ClassLocator();
                libs = functions.split(",");
                for (j = 0; j < libs.length; ++j) {
                    lib = libs[j];
                    taglib = new Taglib("keikai", "http://www.zkoss.org/zss/functions/" + lib.trim());
                    try {
                        mapper.load(taglib, (Locator)loc);
                        continue;
                    }
                    catch (XelException ex) {
                        logger.info(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if ((functions = Library.getProperty((String)TAGLIB_KEY)) != null) {
                loc = new ClassLocator();
                libs = functions.split(",");
                for (j = 0; j < libs.length; ++j) {
                    lib = libs[j];
                    taglib = new Taglib("keikai", "http://www.keikai.io/kk/functions/" + lib.trim());
                    try {
                        mapper.load(taglib, (Locator)loc);
                        continue;
                    }
                    catch (XelException ex) {
                        logger.info(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            _mapper = mapper;
        }
        if (_udffinder == null) {
            try {
                Class<?> clazz = Class.forName("io.keikaiex.formula.ZKUDFFinder");
                Field field = clazz.getField("instance");
                _udffinder = (UDFFinder)field.get(null);
                clazz = Class.forName("io.keikaiex.formula.ELEval");
                field = clazz.getField("NAME");
                EL_FUNCTION_KEY = (String)field.get(null);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }
}

