/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikaiex.util.RBNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RBTree<K, V>
implements Serializable {
    private static final long serialVersionUID = 8257535496613634916L;
    private static final boolean LEFT = true;
    private static final boolean RIGHT = false;
    static final boolean _RED = true;
    private static final boolean _BLACK = false;
    private static final Stack _EMPTY_STACK = new Stack(Collections.EMPTY_LIST);
    RBNode<K, V> root;
    private int _length = 0;
    final Comparator<K> comparator;

    public RBTree(Comparator<K> comparator) {
        this.comparator = comparator;
    }

    RBNode<K, V> getRoot() {
        return this.root;
    }

    int size() {
        return this._length;
    }

    boolean isRed(RBNode<K, V> node) {
        return node != null && node.getColor();
    }

    public boolean isEmpty() {
        return this.root == null;
    }

    public RBNode<K, V> search(K key) {
        RBNode<K, V> x = this.root;
        while (x != null) {
            int cmp = this.comparator.compare(key, x.getKey());
            if (cmp == 0) {
                return x;
            }
            x = cmp < 0 ? x.getLeft() : x.getRight();
        }
        return null;
    }

    public RBNode<K, V> insert(RBNode<K, V> node, Object context) {
        RBNodeResult<K, V> result = this._insert0(node, context);
        Stack lineal = result.lineal;
        this.fixUp(lineal._inner);
        return result.node;
    }

    public RBNode<K, V> delete(K key, Object context) {
        if (key == null) {
            return null;
        }
        RBNodeResult<K, V> result = this._delete0(key, context);
        this.fixUp(result.lineal._inner);
        return result.node;
    }

    protected void insertDuplicate(RBNode<K, V> original, RBNode<K, V> newone, Object context) {
        original.setValue(newone.getValue());
    }

    protected void insertLeft(RBNode<K, V> parent, RBNode<K, V> child) {
        parent.setLeft(child);
    }

    protected void insertRight(RBNode<K, V> parent, RBNode<K, V> child) {
        parent.setRight(child);
    }

    protected void rightJumpUp(RBNode<K, V> g) {
        RBNode<K, V> p = g.getLeft();
        RBNode<K, V> n = p.getRight();
        p.setRight(n.getLeft());
        g.setLeft(n.getRight());
        n.setRight(g);
        n.setLeft(p);
    }

    protected void leftJumpUp(RBNode<K, V> g) {
        RBNode<K, V> p = g.getRight();
        RBNode<K, V> n = p.getLeft();
        p.setLeft(n.getRight());
        g.setRight(n.getLeft());
        n.setLeft(g);
        n.setRight(p);
    }

    protected void rotateRight(RBNode<K, V> g) {
        RBNode<K, V> p = g.getLeft();
        g.setLeft(p.getRight());
        p.setRight(g);
    }

    protected void rotateLeft(RBNode<K, V> g) {
        RBNode<K, V> p = g.getRight();
        g.setRight(p.getLeft());
        p.setLeft(g);
    }

    protected void fixUp(List<Traversal<K, V>> lineal) {
    }

    void replaceNode(RBNode<K, V> target, RBNode<K, V> substitute) {
        target.setKey(substitute.getKey());
        target.setValue(substitute.getValue());
    }

    boolean canDeleteNode(RBNode<K, V> node, Object context) {
        return true;
    }

    private <T> List<T> newList(T obj) {
        ArrayList<T> list = new ArrayList<T>(1);
        list.add(obj);
        return list;
    }

    private RBNodeResult<K, V> _insert0(RBNode<K, V> node, Object context) {
        K key = node.getKey();
        Stack lineal = new Stack(new ArrayList());
        RBNode<K, V> x = this.root;
        while (x != null) {
            int cmp = this.comparator.compare(key, x.getKey());
            if (cmp == 0) {
                this.insertDuplicate(x, node, context);
                return new RBNodeResult(lineal, x);
            }
            lineal.push(new Traversal<K, V>(x, cmp < 0));
            x = cmp < 0 ? x.getLeft() : x.getRight();
        }
        Traversal t = (Traversal)lineal.pop();
        this._insertNode(t, node);
        ++this._length;
        if (node == this.root) {
            return new RBNodeResult(lineal, this.root);
        }
        RBNode p = t.node;
        boolean pd = t.direction;
        while (p != null) {
            RBNode u;
            if (!this.isRed(p)) {
                return new RBNodeResult(lineal, node);
            }
            t = lineal.pop();
            RBNode g = t.node;
            boolean gd = t.direction;
            RBNode rBNode = u = gd ? g.getRight() : g.getLeft();
            if (this.isRed(u)) {
                p.setColor(false);
                u.setColor(false);
                g.setColor(true);
                node = g;
                this.fixUp(this.newList(new Traversal(g, gd)));
                t = lineal.pop();
                if (t != null) {
                    p = t.node;
                    pd = t.direction;
                    this.fixUp(this.newList(new Traversal(p, pd)));
                    continue;
                }
                p = null;
                continue;
            }
            if (!pd && gd) {
                g.setColor(true);
                node.setColor(false);
                this.rightJumpUp(g);
                break;
            }
            if (pd && !gd) {
                g.setColor(true);
                node.setColor(false);
                this.leftJumpUp(g);
                break;
            }
            if (pd) {
                p.setColor(false);
                g.setColor(true);
                this.rotateRight(g);
            } else {
                p.setColor(false);
                g.setColor(true);
                this.rotateLeft(g);
            }
            node = p;
            break;
        }
        this._insertNode(lineal.pop(), node);
        return new RBNodeResult(lineal, node);
    }

    private RBNodeResult<K, V> _delete0(K key, Object context) {
        Traversal t;
        RBNode replace;
        Stack lineal = new Stack(new ArrayList());
        RBNode<K, V> node = null;
        RBNode<K, V> node0 = null;
        RBNode<K, V> x = this.root;
        while (x != null) {
            int cmp = this.comparator.compare(key, x.getKey());
            if (cmp == 0) {
                if (!this.canDeleteNode(x, context)) {
                    return new RBNodeResult(lineal, x);
                }
                node0 = node = x;
                break;
            }
            lineal.push(new Traversal<K, V>(x, cmp < 0));
            x = cmp < 0 ? x.getLeft() : x.getRight();
        }
        if (node == null) {
            return new RBNodeResult(_EMPTY_STACK, node0);
        }
        if (node.getRight() != null) {
            lineal.push(new Traversal(node, false));
            for (x = node.getRight(); x != null; x = x.getLeft()) {
                lineal.push(new Traversal<K, V>(x, true));
            }
        } else {
            lineal.push(new Traversal(node, true));
            for (x = node.getLeft(); x != null; x = x.getRight()) {
                lineal.push(new Traversal<K, V>(x, false));
            }
        }
        RBNode rBNode = replace = (t = lineal.pop()) == null ? null : t.node;
        if (replace != node) {
            this.replaceNode(node, replace);
            node0 = node = replace;
        }
        RBNode<K, V> c = node.getRight() == null ? node.getLeft() : node.getRight();
        t = lineal.pop();
        this._insertNode(t, c);
        --this._length;
        if (this.isRed(node) || this.isRed(c) || this.root == c) {
            if (c != null) {
                c.setColor(false);
            }
            return new RBNodeResult(lineal, node0);
        }
        RBNode p = t.node;
        RBNode g = null;
        boolean pd = t.direction;
        boolean gd = false;
        node = c;
        while (p != null) {
            RBNode s;
            RBNode rBNode2 = s = pd ? p.getRight() : p.getLeft();
            if (this.isRed(s)) {
                p.setColor(true);
                s.setColor(false);
                g = s;
                gd = pd;
                if (pd) {
                    this.rotateLeft(p);
                    s = p.getRight();
                } else {
                    this.rotateRight(p);
                    s = p.getLeft();
                }
            }
            if (!(this.isRed(p) || this.isRed(s) || this.isRed(s.getLeft()) || this.isRed(s.getRight()))) {
                s.setColor(true);
                node = p;
                t = lineal.pop();
                if (t != null) {
                    p = t.node;
                    pd = t.direction;
                    continue;
                }
                p = null;
                continue;
            }
            if (this.isRed(p) && !this.isRed(s) && !this.isRed(s.getLeft()) && !this.isRed(s.getRight())) {
                s.setColor(true);
                p.setColor(false);
                node = p;
                break;
            }
            if (pd && !this.isRed(s.getRight())) {
                s.getLeft().setColor(p.getColor());
                p.setColor(false);
                node = s.getLeft();
                this.leftJumpUp(p);
                break;
            }
            if (!pd && !this.isRed(s.getLeft())) {
                s.getRight().setColor(p.getColor());
                p.setColor(false);
                node = s.getRight();
                this.rightJumpUp(p);
                break;
            }
            s.setColor(p.getColor());
            p.setColor(false);
            if (pd) {
                s.getRight().setColor(false);
                this.rotateLeft(p);
            } else {
                s.getLeft().setColor(false);
                this.rotateRight(p);
            }
            node = s;
            break;
        }
        if (g != null) {
            this._insertNode0(g, gd, node);
            node = g;
        }
        this._insertNode(lineal.pop(), node);
        return new RBNodeResult(lineal, node0);
    }

    void _insertNode(Traversal<K, V> t, RBNode<K, V> node) {
        if (t == null) {
            this.root = node;
            if (this.root != null) {
                this.root.setColor(false);
            }
        } else {
            this._insertNode0(t.node, t.direction, node);
        }
    }

    void _insertNode0(RBNode<K, V> p, boolean left, RBNode<K, V> node) {
        if (left) {
            this.insertLeft(p, node);
        } else {
            this.insertRight(p, node);
        }
    }

    private static class Stack<T> {
        final List<T> _inner;

        public Stack(List<T> inner) {
            this._inner = inner;
        }

        T pop() {
            return !this._inner.isEmpty() ? (T)this._inner.remove(this._inner.size() - 1) : null;
        }

        void push(T item) {
            this._inner.add(item);
        }

        public String toString() {
            return this._inner.toString();
        }
    }

    private static class RBNodeResult<K, V> {
        final Stack<Traversal<K, V>> lineal;
        final RBNode<K, V> node;

        RBNodeResult(Stack<Traversal<K, V>> lineal, RBNode<K, V> node) {
            this.lineal = lineal;
            this.node = node;
        }
    }

    static class Traversal<K, V> {
        final RBNode<K, V> node;
        final boolean direction;

        private Traversal(RBNode<K, V> node, boolean direction) {
            this.node = node;
            this.direction = direction;
        }

        public String toString() {
            return this.getClass().getName() + "(" + String.valueOf(this.node.getKey()) + ") -> " + (this.direction ? "LEFT" : "RIGHT");
        }
    }
}

