/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.json.JSONArray;
import io.keikai.model.SChart;
import io.keikai.model.SChartAxis;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractChartAxisAdv;
import io.keikai.model.impl.chart.CategoryAxisImpl;
import io.keikai.model.impl.chart.GeneralChartDataImpl;
import io.keikai.model.impl.sys.FormatEngineImpl;
import io.keikai.model.sys.format.FormatContext;
import io.keikai.model.util.Strings;
import io.keikai.ui.impl.JavaScriptValue;
import io.keikaiex.ui.ZssCharts;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.chart.Axis;
import org.zkoss.chart.Point;
import org.zkoss.chart.XAxis;
import org.zkoss.chart.YAxis;
import org.zkoss.json.JSONAware;

class HighchartsAxisHelper {
    private static final String X = "x";
    private static final String Y = "y";
    private static final String LOW = "low";
    private static final String HIGH = "high";
    private static final String HIGHEST = "highest";
    private static final String LOWEST = "lowest";
    private static final int CELL_WIDTH = 12;
    static final DecimalFormat format = new DecimalFormat("0E00");

    HighchartsAxisHelper() {
    }

    static void drawAxis(ZssCharts chart, SChart chartInfo) {
        switch (chartInfo.getType()) {
            case PIE: 
            case DOUGHNUT: 
            case BAR: 
            case COLUMN: 
            case LINE: 
            case AREA: {
                YAxis axis;
                if (chartInfo.getValueAxises().isEmpty() || chartInfo.getGrouping() == SChart.ChartGrouping.STACKED || chartInfo.getGrouping() == SChart.ChartGrouping.PERCENT_STACKED || (axis = chart.getYAxis()) == null) break;
                SChartAxis saxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                Map<String, Double> hlmap = HighchartsAxisHelper.getHighLow(chart, Y);
                if (hlmap.isEmpty() || !HighchartsAxisHelper.setupAxis((Axis)axis, saxis, hlmap.get(HIGHEST), hlmap.get(LOWEST))) break;
                HashMap<SChartAxis, AxisGetter> axisGetters = new HashMap<SChartAxis, AxisGetter>(2);
                axisGetters.put(saxis, HighchartsAxisHelper.getAxisGetter(Y));
                HighchartsAxisHelper.setupTooltip(chart, axisGetters, "\\'<span style=\"font-size: 10px\">\\' + this.key + \\'</span><br/><span style=\"color:\\' + this.series.color + \\'\">\\' + this.series.name + \\':</span><b>\\' + this.formatted[0][this.series.index][this.point.index] + \\'</b><br/>\\'");
                break;
            }
            case SCATTER: {
                int size = chartInfo.getValueAxises().size();
                XAxis zxaxis = chart.getXAxis();
                YAxis zyaxis = chart.getYAxis();
                boolean isYDid = false;
                boolean isXDid = false;
                HashMap<SChartAxis, AxisGetter> axisGetters = new HashMap<SChartAxis, AxisGetter>(2);
                if (chartInfo.getBarDirection() == SChart.BarDirection.HORIZONTAL) {
                    Map<String, Double> hlmap;
                    if (size > 0 && zyaxis != null) {
                        SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                        hlmap = HighchartsAxisHelper.getHighLow(chart, Y);
                        if (!hlmap.isEmpty() && (isYDid = HighchartsAxisHelper.setupAxis((Axis)zyaxis, yaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                            axisGetters.put(yaxis, HighchartsAxisHelper.getAxisGetter(Y));
                        }
                    }
                    if (size > 1 && zxaxis != null) {
                        SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                        hlmap = HighchartsAxisHelper.getHighLow(chart, X);
                        if (!hlmap.isEmpty() && (isXDid = HighchartsAxisHelper.setupAxis((Axis)zxaxis, xaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                            axisGetters.put(xaxis, HighchartsAxisHelper.getAxisGetter(X));
                        }
                    }
                } else {
                    Map<String, Double> hlmap;
                    if (size > 0 && zxaxis != null) {
                        SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                        hlmap = HighchartsAxisHelper.getHighLow(chart, X);
                        if (!hlmap.isEmpty() && (isXDid = HighchartsAxisHelper.setupAxis((Axis)zxaxis, xaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                            axisGetters.put(xaxis, HighchartsAxisHelper.getAxisGetter(X));
                        }
                    }
                    if (size > 1 && zyaxis != null) {
                        SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                        hlmap = HighchartsAxisHelper.getHighLow(chart, Y);
                        if (!hlmap.isEmpty() && (isYDid = HighchartsAxisHelper.setupAxis((Axis)zyaxis, yaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                            axisGetters.put(yaxis, HighchartsAxisHelper.getAxisGetter(Y));
                        }
                    }
                }
                if (axisGetters.size() <= 0) break;
                HighchartsAxisHelper.setupTooltip(chart, axisGetters, "\\'<span style=\"color:\\' + this.series.color + \\'\">\\' + this.series.name + \\'</span><br/>x: <b>\\' +" + (isXDid ? "this.formatted[0][this.series.index][this.point.index]" : "this.point.x") + "+\\'</b><br/>y: <b>\\' + " + (isYDid ? "this.formatted[1][this.series.index][this.point.index]" : "this.point.y") + "+\\'</b><br/>\\'");
                break;
            }
            case BUBBLE: {
                SChartAxis zaxis;
                Map<String, Double> hlmap;
                int size0 = chartInfo.getValueAxises().size();
                XAxis zxaxis0 = chart.getXAxis();
                YAxis zyaxis0 = chart.getYAxis();
                boolean isXDid0 = false;
                boolean isYDid0 = false;
                boolean isZDid0 = false;
                HashMap<SChartAxis, AxisGetter> axisGetters0 = new HashMap<SChartAxis, AxisGetter>(2);
                if (size0 > 0 && zxaxis0 != null) {
                    SChartAxis xaxis = (SChartAxis)chartInfo.getValueAxises().get(0);
                    hlmap = HighchartsAxisHelper.getHighLow(chart, X);
                    if (!hlmap.isEmpty() && (isXDid0 = HighchartsAxisHelper.setupAxis((Axis)zxaxis0, xaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                        axisGetters0.put(xaxis, HighchartsAxisHelper.getAxisGetter(X));
                    }
                }
                if (size0 > 1 && zyaxis0 != null) {
                    SChartAxis yaxis = (SChartAxis)chartInfo.getValueAxises().get(1);
                    hlmap = HighchartsAxisHelper.getHighLow(chart, LOW);
                    if (!hlmap.isEmpty() && (isYDid0 = HighchartsAxisHelper.setupAxis((Axis)zyaxis0, yaxis, hlmap.get(HIGHEST), hlmap.get(LOWEST)))) {
                        axisGetters0.put(yaxis, HighchartsAxisHelper.getAxisGetter(LOW));
                    }
                }
                if (size0 > 2 && (isZDid0 = (zaxis = (SChartAxis)chartInfo.getValueAxises().get(2)) != null && !Strings.isBlank((String)zaxis.getFormat()))) {
                    axisGetters0.put(zaxis, HighchartsAxisHelper.getAxisGetter(HIGH));
                }
                if (axisGetters0.size() <= 0) break;
                HighchartsAxisHelper.setupTooltip(chart, axisGetters0, "\\'<span style=\"color:\\' + this.series.color + \\'\">\\' + this.series.name + \\':</span><br/>(\\' +" + (isXDid0 ? "this.formatted[0][this.series.index][this.point.index]" : "this.point.x") + "+ \\', \\' + " + (isYDid0 ? "this.formatted[1][this.series.index][this.point.index]" : "this.point.y") + "+ \\'), Size:\\' + " + (isZDid0 ? "this.formatted[2][this.series.index][this.point.index]" : "this.point.z"));
                break;
            }
        }
    }

    static void drawAxisLabelTick(ZssCharts chart, SChart chartInfo, Map<Long, Integer> xAxisMap, Map<Long, Integer> yAxisMap, AxisRanger ranger, boolean containsBar) {
        List valAxes = chartInfo.getValueAxises();
        if (valAxes == null) {
            return;
        }
        boolean skipFormat = false;
        for (SChartAxis valAxis : valAxes) {
            double[] maxMin;
            int index;
            long id = valAxis.getId();
            XAxis axis = null;
            if (xAxisMap.containsKey(id)) {
                int index2 = xAxisMap.get(id);
                if (index2 < chart.getXAxisSize()) {
                    axis = chart.getXAxis(index2);
                    if (containsBar) {
                        skipFormat = true;
                    }
                }
            } else if (yAxisMap.containsKey(id) && (index = yAxisMap.get(id).intValue()) < chart.getyAxisSize()) {
                axis = chart.getYAxis(index);
            }
            if (axis == null || (maxMin = ranger.getMaxMin(id)) == null) continue;
            HighchartsAxisHelper.setupAxis((Axis)axis, valAxis, maxMin[0], maxMin[1], skipFormat);
        }
    }

    static String getCategory(SGeneralChartData chartData, int i) {
        return i < chartData.getNumOfCategory() ? chartData.getCategory(i).toString() : Integer.toString(i);
    }

    static void prepareAxes(ZssCharts chart, AbstractChartAdv chartInfo, boolean containsBar, Map<Long, Integer> xAxisMap, Map<Long, Integer> yAxisMap) {
        ArrayList axes = new ArrayList();
        axes.addAll(chartInfo.getCategoryAxises());
        axes.addAll(chartInfo.getDateAxises());
        axes.addAll(chartInfo.getValueAxises());
        int xAxisIndex = 0;
        int yAxisIndex = 0;
        for (SChartAxis chartAxis : axes) {
            YAxis axis;
            int index;
            AbstractChartAxisAdv chartAxisAdv = (AbstractChartAxisAdv)chartAxis;
            long id = chartAxis.getId();
            if (HighchartsAxisHelper.isXAxis(chartAxis)) {
                if (containsBar) {
                    index = yAxisIndex++;
                    axis = chart.getYAxis(index);
                    yAxisMap.put(id, index);
                } else {
                    index = xAxisIndex++;
                    axis = chart.getXAxis(index);
                    xAxisMap.put(id, index);
                }
                if (chartAxisAdv.getPosition() == AbstractChartAxisAdv.Position.TOP) {
                    axis.setOpposite(true);
                }
            } else {
                if (containsBar) {
                    index = xAxisIndex++;
                    axis = chart.getXAxis(index);
                    axis.setTickWidth((Number)0);
                    ((XAxis)axis).setLineWidth((Number)0);
                    xAxisMap.put(id, index);
                } else {
                    index = yAxisIndex++;
                    axis = chart.getYAxis(index);
                    yAxisMap.put(id, index);
                }
                if (chartAxisAdv.getPosition() == AbstractChartAxisAdv.Position.RIGHT) {
                    axis.setOpposite(true);
                }
            }
            axis.setReversed(false);
            axis.setReversedStacks(false);
            if (chartAxis instanceof CategoryAxisImpl) {
                for (SChartData chartData : chartInfo.getChartData()) {
                    GeneralChartDataImpl dataImpl;
                    SChartAxis catAxis;
                    if (!(chartData instanceof GeneralChartDataImpl) || (catAxis = (dataImpl = (GeneralChartDataImpl)chartData).getCategoryAxis()) == null || catAxis.getId() != id) continue;
                    int catNum = dataImpl.getNumOfCategory();
                    String[] categories = new String[catNum];
                    for (int i = 0; i < dataImpl.getNumOfCategory(); ++i) {
                        categories[i] = HighchartsAxisHelper.getCategory((SGeneralChartData)dataImpl, i);
                    }
                    axis.setCategories(categories);
                    axis.setType("category");
                }
            }
            axis.setVisible(chartAxisAdv.isVisible());
            axis.setTitle("");
            axis.setGridLineWidth((Number)(chartAxisAdv.hasMajorGridline() ? 1 : 0));
        }
    }

    private static Double number2Double(Number number, Double defaultValue) {
        if (number != null) {
            number.doubleValue();
        }
        return defaultValue;
    }

    private static AxisGetter getAxisGetter(String type) {
        if (X.equals(type)) {
            return new AxisGetter(){

                @Override
                public double getValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getX(), 0.0);
                }

                @Override
                public Double getNullableValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getX(), null);
                }
            };
        }
        if (Y.equals(type)) {
            return new AxisGetter(){

                @Override
                public double getValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getY(), 0.0);
                }

                @Override
                public Double getNullableValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getY(), null);
                }
            };
        }
        if (LOW.equals(type)) {
            return new AxisGetter(){

                @Override
                public double getValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getLow(), 0.0);
                }

                @Override
                public Double getNullableValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getLow(), null);
                }
            };
        }
        if (HIGH.equals(type)) {
            return new AxisGetter(){

                @Override
                public double getValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getHigh(), 0.0);
                }

                @Override
                public Double getNullableValue(Point p) {
                    return HighchartsAxisHelper.number2Double(p.getHigh(), null);
                }
            };
        }
        return null;
    }

    private static Map<String, Double> getHighLow(ZssCharts chart, String type) {
        double highest = -1.7976931348623157E308;
        double lowest = Double.MAX_VALUE;
        AxisGetter getter = HighchartsAxisHelper.getAxisGetter(type);
        int size = chart.getSeriesSize();
        for (int i = 0; i < size; ++i) {
            for (Point point : chart.getSeries(i).getData()) {
                Double value = getter.getNullableValue(point);
                if (value == null) continue;
                if (value > highest) {
                    highest = value;
                }
                if (!(value < lowest)) continue;
                lowest = value;
            }
        }
        if (Double.compare(highest, -1.7976931348623157E308) == 0 && Double.compare(lowest, Double.MAX_VALUE) == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Double> map = new HashMap<String, Double>(2);
        map.put(HIGHEST, highest);
        map.put(LOWEST, lowest);
        return map;
    }

    private static void setupTooltip(ZssCharts chart, Map<SChartAxis, AxisGetter> axisGetters, String pattern) {
        JSONArray axisLabelArray = new JSONArray();
        for (SChartAxis axis : axisGetters.keySet()) {
            AxisGetter getter = axisGetters.get(axis);
            FormatContext formatContext = new FormatContext();
            FormatEngineImpl formatEngine = new FormatEngineImpl();
            JSONArray seriesArray = new JSONArray();
            int size = chart.getSeriesSize();
            for (int i = 0; i < size; ++i) {
                JSONArray pointArray = new JSONArray();
                for (Point point : chart.getSeries(i).getData()) {
                    double value = getter.getValue(point);
                    pointArray.add((Object)formatEngine.format(axis.getFormat(), (Object)value, formatContext, 12).getText());
                }
                seriesArray.add((Object)pointArray);
            }
            axisLabelArray.add((Object)seriesArray);
        }
        String str = axisLabelArray.toJSONString();
        chart.getTooltip().addExtraAttr("formatter", (JSONAware)new JavaScriptValue("';;;;;if(!this.formatted) { this.formatted = " + str + ";} return " + pattern + ";;;'"));
    }

    static boolean isXAxis(SChartAxis axis) {
        if (axis == null) {
            return false;
        }
        AbstractChartAxisAdv.Position position = ((AbstractChartAxisAdv)axis).getPosition();
        if (position == null) {
            return axis.getType() == SChartAxis.SChartAxisType.CATEGORY;
        }
        return position == AbstractChartAxisAdv.Position.TOP || position == AbstractChartAxisAdv.Position.BOTTOM;
    }

    private static boolean setupAxis(Axis axis, SChartAxis saxis, double high, double low) {
        return HighchartsAxisHelper.setupAxis(axis, saxis, high, low, false);
    }

    private static boolean setupAxis(Axis axis, SChartAxis saxis, double high, double low, boolean skipFormat) {
        if (saxis != null && !Strings.isBlank((String)saxis.getFormat())) {
            double distance;
            boolean startFromZero;
            FormatContext formatContext = new FormatContext();
            FormatEngineImpl formatEngine = new FormatEngineImpl();
            ArrayList<Double> ticks = new ArrayList<Double>(10);
            if (high == low) {
                double range;
                if (high == 0.0) {
                    high = 1.0;
                    low = -1.0;
                } else if ((high += (range = high / 2.0)) < (low -= range)) {
                    double temp = low;
                    low = high;
                    high = temp;
                }
            }
            boolean bl = startFromZero = (low < 0.0 ? low / high : high / low) >= 1.2;
            if (low >= 0.0 && high > 0.0) {
                distance = startFromZero ? high : high - low;
            } else if (low < 0.0 && high < 0.0) {
                distance = startFromZero ? -low : high - low;
            } else {
                distance = high - low;
                startFromZero = false;
            }
            double size = distance / 8.0;
            if (size == 0.0) {
                size = high / 10.0;
            }
            size = HighchartsAxisHelper.normalize(size, distance, high, low, startFromZero);
            JSONArray axisLabelArray = new JSONArray();
            String sizeString = format.format(size);
            int dotIndex = sizeString.indexOf("E");
            int expIndex = 1;
            if (dotIndex > 0) {
                expIndex = Integer.parseInt(sizeString.substring(dotIndex + 1)) + 1;
            }
            double tick = (double)Double.valueOf(low / Math.pow(10.0, expIndex)).intValue() * Math.pow(10.0, expIndex);
            if (low >= 0.0) {
                if (low - size <= tick) {
                    if (low - size == tick || low == tick) {
                        tick -= size;
                    }
                    tick -= size;
                } else {
                    while (low > tick + size * 2.0 && low != tick + size * 3.0) {
                        tick += size;
                    }
                }
            } else {
                while (low < (tick -= size) + size) {
                }
            }
            if (tick < 0.0 && low >= 0.0 || low >= 0.0 && startFromZero) {
                tick = 0.0;
            }
            ticks.add(tick);
            axisLabelArray.add((Object)formatEngine.format(saxis.getFormat(), (Object)tick, formatContext, 12).getText());
            tick += size;
            while (tick <= high) {
                ticks.add(tick);
                axisLabelArray.add((Object)formatEngine.format(saxis.getFormat(), (Object)tick, formatContext, 12).getText());
                tick += size;
            }
            if (startFromZero && low < 0.0) {
                if (low < 0.0) {
                    while (tick <= 0.0) {
                        ticks.add(tick);
                        axisLabelArray.add((Object)formatEngine.format(saxis.getFormat(), (Object)tick, formatContext, 12).getText());
                        tick += size;
                    }
                }
            } else {
                ticks.add(tick);
                axisLabelArray.add((Object)formatEngine.format(saxis.getFormat(), (Object)tick, formatContext, 12).getText());
            }
            if (tick - size / 3.0 <= high || low < 0.0 && !startFromZero) {
                ticks.add(tick += size);
                axisLabelArray.add((Object)formatEngine.format(saxis.getFormat(), (Object)tick, formatContext, 12).getText());
            }
            String str = axisLabelArray.toJSONString();
            axis.setTickPositions(ticks);
            if (!skipFormat) {
                axis.getLabels().addExtraAttr("formatter", (JSONAware)new JavaScriptValue("';;;;;if(!this.formatted) { this.formatted = " + str + ";}return this.formatted[this.axis.tickPositions.indexOf(this.pos)];;;'"));
            }
            return true;
        }
        return false;
    }

    private static double normalize(double size, double distance, double high, double low, boolean startFromZero) {
        double exp10 = Math.log10(size);
        int exp = (int)Math.floor(exp10);
        double tens = Math.pow(10.0, exp);
        int num = (int)Math.floor(size / tens);
        switch (num) {
            case 0: 
            case 1: 
            case 2: {
                if (!startFromZero && (high > 0.0 && low >= 0.0 || high <= 0.0 && low < 0.0)) {
                    double div;
                    double stand;
                    if (low < 0.0) {
                        double high0 = high;
                        high = Math.abs(low);
                        low = Math.abs(high0);
                    }
                    String sizeString = format.format(high);
                    int dotIndex = sizeString.indexOf("E");
                    int expIndex = 1;
                    if (dotIndex > 0) {
                        expIndex = Integer.parseInt(sizeString.substring(dotIndex + 1));
                    }
                    if ((stand = low - (div = high - Math.pow(10.0, expIndex))) > 0.873015873015872 * Math.pow(10.0, expIndex)) {
                        num = 2;
                        break;
                    }
                    num = 5;
                    break;
                }
                num = tens <= 1.0 && distance > 1.0 || distance / (2.0 * tens) > 7.0 ? 5 : 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                num = distance / (5.0 * tens) > 9.0 ? 10 : 5;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                num = 10;
            }
        }
        return (double)num * tens;
    }

    private static class AxisRangeCache {
        private double min = Double.POSITIVE_INFINITY;
        private double max = Double.NEGATIVE_INFINITY;
        private Map<SChart.ChartType, Map<Number, Double>> stackedValues;

        private AxisRangeCache() {
        }

        void scan(SChart.ChartType chartType, Number index, Number value, SChart.ChartGrouping grouping) {
            if (index == null || value == null) {
                return;
            }
            double v = value.doubleValue();
            if (grouping == SChart.ChartGrouping.STACKED || grouping == SChart.ChartGrouping.PERCENT_STACKED) {
                Map map;
                if (this.stackedValues == null) {
                    this.stackedValues = new HashMap<SChart.ChartType, Map<Number, Double>>();
                }
                if ((map = this.stackedValues.computeIfAbsent(chartType, k -> new HashMap())).containsKey(index)) {
                    map.put(index, value.doubleValue() + (Double)map.get(index));
                } else {
                    map.put(index, value.doubleValue());
                }
            } else {
                if (v > this.max) {
                    this.max = v;
                }
                if (v < this.min) {
                    this.min = v;
                }
            }
        }

        double[] getMaxMin() {
            double[] dArray;
            if (this.stackedValues != null) {
                for (Map<Number, Double> m : this.stackedValues.values()) {
                    for (Double v : m.values()) {
                        if (v > this.max) {
                            this.max = v;
                        }
                        if (!(v < this.min)) continue;
                        this.min = v;
                    }
                }
                if (this.max > 0.0 && this.min > 0.0) {
                    this.min = 0.0;
                } else if (this.max < 0.0 && this.min < 0.0) {
                    this.max = 0.0;
                }
            }
            if (this.min > this.max) {
                dArray = null;
            } else {
                double[] dArray2 = new double[2];
                dArray2[0] = this.max;
                dArray = dArray2;
                dArray2[1] = this.min;
            }
            return dArray;
        }
    }

    static class AxisRanger {
        private final Map<Long, AxisRangeCache> cacheMap = new HashMap<Long, AxisRangeCache>();

        AxisRanger() {
        }

        void scan(long id, SChart.ChartType chartType, Number index, Number value, SChart.ChartGrouping grouping) {
            this.getCache(id).scan(chartType, index, value, grouping);
        }

        double[] getMaxMin(long id) {
            return this.getCache(id).getMaxMin();
        }

        private AxisRangeCache getCache(long id) {
            if (this.cacheMap.containsKey(id)) {
                return this.cacheMap.get(id);
            }
            AxisRangeCache cache = new AxisRangeCache();
            this.cacheMap.put(id, cache);
            return cache;
        }
    }

    private static interface AxisGetter {
        public double getValue(Point var1);

        public Double getNullableValue(Point var1);
    }
}

