/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.util;

import io.keikai.json.JSONValue;
import io.keikai.model.ErrorValue;
import io.keikai.model.SChart;
import io.keikai.model.chart.SChartData;
import io.keikai.model.chart.SGeneralChartData;
import io.keikai.model.chart.SSeries;
import java.io.Serializable;
import org.zkoss.chart.model.CategoryModel;
import org.zkoss.chart.model.ChartsModel;
import org.zkoss.chart.model.DefaultCategoryModel;
import org.zkoss.chart.model.DefaultPieModel;
import org.zkoss.chart.model.DefaultXYModel;
import org.zkoss.chart.model.DefaultXYZModel;
import org.zkoss.json.JSONAware;
import org.zkoss.lang.Objects;

public class ChartsModelManager {
    private final ModelSelector[] selectors = new ModelSelector[]{new PieModelSelector(), new CategoryModelSelector(), new XYModelSelector(), new XYZModelSelector()};

    public ChartsModel getChartsModel(SChart schart) {
        for (ModelSelector selector : this.selectors) {
            if (!selector.isSupported(schart.getType())) continue;
            return selector.toCharts(schart.getData());
        }
        return null;
    }

    private static Number toNonZeroNumber(Object obj, Integer defaultValue) {
        if (obj instanceof Number) {
            return (Number)obj;
        }
        if (obj instanceof String && !((String)obj).isEmpty() || obj instanceof ErrorValue) {
            return 0;
        }
        return defaultValue;
    }

    static Number toNumber(Object obj, Integer defaultValue) {
        return obj instanceof Number ? (Number)((Number)obj) : (Number)defaultValue;
    }

    static String toSeriesName(String name, int seriesIndex) {
        if (name == null || "".equals(name)) {
            return "Series" + (seriesIndex + 1);
        }
        return name;
    }

    private static class XYZModelSelector
    implements ModelSelector {
        private XYZModelSelector() {
        }

        @Override
        public boolean isSupported(SChart.ChartType type) {
            return SChart.ChartType.BUBBLE == type;
        }

        @Override
        public ChartsModel toCharts(SChartData chartData) {
            if (!(chartData instanceof SGeneralChartData)) {
                return null;
            }
            DefaultXYZModel model = new DefaultXYZModel();
            SGeneralChartData catData = (SGeneralChartData)chartData;
            SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
            if (serieses.length == 0) {
                return model;
            }
            for (int i = 0; i < serieses.length; ++i) {
                serieses[i] = catData.getSeries(i);
            }
            boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
            for (int i = 0; i < serieses.length; ++i) {
                String sname = ChartsModelManager.toSeriesName(serieses[i].getName(), i);
                int xValueCount = serieses[i].getNumOfValue();
                int s = Math.min(serieses[i].getNumOfYValue(), serieses[i].getNumOfZValue());
                if (xValueCount != 0) {
                    s = Math.min(xValueCount, s);
                }
                for (int j = 0; j < s; ++j) {
                    if (onlyVisible && (serieses[i].isYValueFomulaHidden(j) || serieses[i].isZValueFomulaHidden(j))) continue;
                    Number xval = ChartsModelManager.toNonZeroNumber(serieses[i].getValue(j), j);
                    Number yval = ChartsModelManager.toNonZeroNumber(serieses[i].getYValue(j), null);
                    Number zval = ChartsModelManager.toNonZeroNumber(serieses[i].getZValue(j), null);
                    if (yval == null || zval == null) continue;
                    model.addValue((Comparable)new ChartModelLabel(i, sname), xval, yval, zval);
                }
            }
            return model;
        }
    }

    private static class XYModelSelector
    implements ModelSelector {
        private XYModelSelector() {
        }

        @Override
        public boolean isSupported(SChart.ChartType type) {
            return SChart.ChartType.SCATTER == type;
        }

        @Override
        public ChartsModel toCharts(SChartData chartData) {
            if (!(chartData instanceof SGeneralChartData)) {
                return null;
            }
            DefaultXYModel model = new DefaultXYModel();
            SGeneralChartData catData = (SGeneralChartData)chartData;
            SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
            if (serieses.length == 0) {
                return model;
            }
            for (int i = 0; i < serieses.length; ++i) {
                serieses[i] = catData.getSeries(i);
            }
            boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
            for (int i = 0; i < serieses.length; ++i) {
                String sname = ChartsModelManager.toSeriesName(serieses[i].getName(), i);
                int valuesCount = serieses[i].getNumOfValue();
                int s = valuesCount == 0 ? Math.max(valuesCount, serieses[i].getNumOfYValue()) : Math.min(valuesCount, serieses[i].getNumOfYValue());
                for (int j = 0; j < s; ++j) {
                    if (onlyVisible && serieses[i].isYValueFomulaHidden(j)) continue;
                    Number xval = ChartsModelManager.toNonZeroNumber(serieses[i].getValue(j), j);
                    Number yval = ChartsModelManager.toNonZeroNumber(serieses[i].getYValue(j), null);
                    if (yval == null) continue;
                    model.addValue((Comparable)new ChartModelLabel(i, sname), xval, yval);
                }
            }
            return model;
        }
    }

    private class CategoryModelSelector
    implements ModelSelector {
        private CategoryModelSelector() {
        }

        @Override
        public boolean isSupported(SChart.ChartType type) {
            return SChart.ChartType.BAR == type || SChart.ChartType.COLUMN == type || SChart.ChartType.LINE == type || SChart.ChartType.AREA == type;
        }

        @Override
        public ChartsModel toCharts(SChartData chartData) {
            if (!(chartData instanceof SGeneralChartData)) {
                return null;
            }
            DefaultCategoryModel model = new DefaultCategoryModel();
            SGeneralChartData catData = (SGeneralChartData)chartData;
            SSeries[] serieses = new SSeries[catData.getNumOfSeries()];
            if (serieses.length == 0) {
                return model;
            }
            for (int i = 0; i < serieses.length; ++i) {
                serieses[i] = catData.getSeries(i);
            }
            int s = Math.max(catData.getNumOfCategory(), serieses[0].getNumOfValue());
            for (int i = 1; i < serieses.length; ++i) {
                s = Math.max(s, serieses[i].getNumOfValue());
            }
            SChart chart = chartData.getChart();
            boolean onlyVisible = chart.isPlotOnlyVisibleCells();
            boolean emptyAsGaps = chart.isEmptyAsGaps();
            boolean winlose = chart.isSparkline() && chart.isWinloseSpark();
            for (int i = 0; i < s; ++i) {
                SSeries sSeries;
                int valueCount;
                Object cat = ".";
                if (!onlyVisible || !catData.isCategoryHidden(i)) {
                    cat = catData.getCategory(i);
                }
                for (int j = 0; j < serieses.length && (valueCount = (sSeries = serieses[j]).getNumOfValue()) != i; ++j) {
                    if (onlyVisible && sSeries.isXValueFomulaHidden(i)) continue;
                    this.setModelValue((CategoryModel)model, serieses, cat, i, j, emptyAsGaps, winlose);
                }
            }
            return model;
        }

        private void setModelValue(CategoryModel model, SSeries[] serieses, Object category, int categoryIndex, int seriesIndex, boolean emptyAsGaps, boolean winlose) {
            Number val;
            String series = ChartsModelManager.toSeriesName(serieses[seriesIndex].getName(), seriesIndex);
            Object value = serieses[seriesIndex].getValue(categoryIndex);
            Number number = val = emptyAsGaps ? (Number)ChartsModelManager.toNonZeroNumber(value, null) : (Number)ChartsModelManager.toNumber(value, 0);
            if (winlose && val != null) {
                if (val.doubleValue() > 0.0) {
                    val = 1;
                } else if (val.doubleValue() < 0.0) {
                    val = -1;
                }
            }
            model.setValue((Comparable)new ChartModelLabel(seriesIndex, series), (Comparable)new ChartModelLabel(categoryIndex, category), val);
        }
    }

    private static class PieModelSelector
    implements ModelSelector {
        private PieModelSelector() {
        }

        @Override
        public boolean isSupported(SChart.ChartType type) {
            return SChart.ChartType.PIE == type || SChart.ChartType.DOUGHNUT == type;
        }

        @Override
        public ChartsModel toCharts(SChartData chartData) {
            if (!(chartData instanceof SGeneralChartData)) {
                return null;
            }
            DefaultPieModel model = new DefaultPieModel();
            SGeneralChartData catData = (SGeneralChartData)chartData;
            SSeries series1 = null;
            if (catData.getNumOfSeries() > 0) {
                series1 = catData.getSeries(0);
            }
            if (series1 == null) {
                return model;
            }
            int s = series1.getNumOfValue();
            boolean onlyVisible = chartData.getChart().isPlotOnlyVisibleCells();
            for (int i = 0; i < s; ++i) {
                Object label = ".";
                Object val = "";
                if (onlyVisible) {
                    if (series1.isXValueFomulaHidden(i)) continue;
                    if (!catData.isCategoryHidden(i)) {
                        label = catData.getCategory(i);
                    }
                    val = series1.getValue(i);
                } else {
                    label = catData.getCategory(i);
                    val = series1.getValue(i);
                }
                model.setValue((Comparable)new ChartModelLabel(i, label), ChartsModelManager.toNumber(val, 0));
            }
            return model;
        }
    }

    static interface ModelSelector {
        public boolean isSupported(SChart.ChartType var1);

        public ChartsModel toCharts(SChartData var1);
    }

    static class ChartModelLabel
    implements Serializable,
    Comparable<ChartModelLabel>,
    JSONAware {
        private static final long serialVersionUID = 1L;
        private final Integer index;
        private final Object label;

        ChartModelLabel(int index, Object label) {
            this.index = index;
            this.label = label;
        }

        public String toString() {
            return this.label == null ? "" : this.label.toString();
        }

        @Override
        public int compareTo(ChartModelLabel o) {
            int indexComp = this.index.compareTo(o.index);
            return indexComp != 0 ? indexComp : this.label.toString().compareTo(o.toString());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.index == null ? 0 : this.index.hashCode()) + (this.label == null ? 0 : this.label.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChartModelLabel other = (ChartModelLabel)obj;
            return Objects.equals((Object)this.index, (Object)other.index) && Objects.equals((Object)this.label, (Object)other.label);
        }

        public String toJSONString() {
            return JSONValue.toJSONString((Object)this.toString());
        }
    }
}

