/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.widget;

import io.keikai.api.AreaRef;
import io.keikai.model.SSheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.Widget;
import io.keikai.ui.sys.FreezeInfoLoader;
import io.keikai.ui.sys.SpreadsheetCtrl;
import io.keikai.ui.sys.WidgetHandler;
import io.keikaiex.ui.au.out.AuRedrawWidget;
import io.keikaiex.ui.widget.BaseWidget;
import io.keikaiex.ui.widget.ChartsWidget;
import io.keikaiex.ui.widget.Ghost;
import io.keikaiex.ui.widget.WidgetCtrl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.ui.Component;

public class DefaultWidgetHandler
implements WidgetHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private Spreadsheet _spreadsheet;
    private List<WidgetCtrl> _clientWidgets = new ArrayList<WidgetCtrl>();
    private List<WidgetCtrl> _nonClientWidgets = new ArrayList<WidgetCtrl>();
    private Ghost _ghost;
    private static String WIDGET_RES_PREFIX = "zsw_";

    public boolean addWidget(Widget widget) {
        WidgetCtrl ctrl;
        boolean r;
        if (!(widget instanceof BaseWidget)) {
            return false;
        }
        if (this._ghost == null) {
            this._ghost = this.newGhost();
            this._spreadsheet.appendChild((Component)this._ghost);
        }
        if (r = this._ghost.appendChild((Component)(ctrl = ((BaseWidget)widget).getCtrl()))) {
            ((BaseWidget)widget).setHandler0(this);
            this._nonClientWidgets.add(ctrl);
            if (!this._spreadsheet.isInvalidated()) {
                SSheet sheet = this._spreadsheet.getSelectedSSheet();
                SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this._spreadsheet.getExtraCtrl();
                AreaRef rect = spreadsheetCtrl.getVisibleArea();
                FreezeInfoLoader fil = spreadsheetCtrl.getFreezeInfoLoader();
                this.onLoadWidgetOnDemand((BaseWidget)widget, sheet, rect.getColumn() - fil.getColumnFreeze((Object)sheet) - 1, rect.getRow() - fil.getRowFreeze((Object)sheet) - 1, rect.getLastColumn(), rect.getLastRow());
            }
        }
        return r;
    }

    public void updateWidget(SSheet sheet, String widgetId) {
        if (this._spreadsheet.isInvalidated()) {
            for (WidgetCtrl ctrl : this._nonClientWidgets) {
                BaseWidget widget = ctrl.getWidget();
                if (!widget.getId().equals(widgetId) || !(widget instanceof ChartsWidget)) continue;
                ((ChartsWidget)widget).setInitWhenLoaded(true);
            }
        } else {
            for (WidgetCtrl ctrl : this._clientWidgets) {
                BaseWidget widget = ctrl.getWidget();
                if (!widget.getId().equals(widgetId) || !(widget instanceof BaseWidget)) continue;
                widget.invalidate();
            }
        }
    }

    public Spreadsheet getSpreadsheet() {
        return this._spreadsheet;
    }

    public boolean removeWidget(Widget widget) {
        boolean r;
        if (!(widget instanceof BaseWidget)) {
            return false;
        }
        if (((BaseWidget)widget).getHandler() != this) {
            return false;
        }
        WidgetCtrl ctrl = ((BaseWidget)widget).getCtrl();
        if (this._ghost == null) {
            this._ghost = this.newGhost();
            this._spreadsheet.appendChild((Component)this._ghost);
        }
        if (r = this._ghost.removeChild((Component)ctrl)) {
            ((BaseWidget)widget).setHandler0(null);
            ((BaseWidget)widget).setInClient(false);
            this._clientWidgets.remove((Object)ctrl);
            this._nonClientWidgets.remove((Object)ctrl);
        }
        return r;
    }

    public void init(Spreadsheet spreadsheet) {
        this._spreadsheet = spreadsheet;
    }

    public void onLoadOnDemand(SSheet sheet, int left, int top, int right, int bottom) {
        if (this._ghost == null) {
            return;
        }
        int size = this._nonClientWidgets.size();
        for (int i = size - 1; i >= 0; --i) {
            WidgetCtrl ctrl = this._nonClientWidgets.get(i);
            BaseWidget widget = ctrl.getWidget();
            this.onLoadWidgetOnDemand(widget, sheet, left, top, right, bottom);
        }
    }

    private boolean onLoadWidgetOnDemand(BaseWidget widget, SSheet sheet, int left, int top, int right, int bottom) {
        int r = widget.getRow();
        int c = widget.getColumn();
        int r2 = widget.getRow2();
        int c2 = widget.getColumn2();
        WidgetCtrl ctrl = widget.getCtrl();
        if (r2 >= top && r <= bottom && c2 >= left && c <= right) {
            this.redrawWidget(sheet.getId(), widget);
            if (!widget.isInClient()) {
                ChartsWidget chartsWidget;
                widget.setInClient(true);
                this._clientWidgets.add(ctrl);
                this._nonClientWidgets.remove((Object)ctrl);
                if (widget instanceof ChartsWidget && (chartsWidget = (ChartsWidget)widget).isInitWhenLoaded()) {
                    chartsWidget.invalidate();
                }
            }
            return true;
        }
        return false;
    }

    private void redrawWidget(String sheetid, BaseWidget widget) {
        WidgetCtrl ctrl = widget.getCtrl();
        String uuid = ctrl.getUuid();
        this._spreadsheet.response(WIDGET_RES_PREFIX + uuid, (AuResponse)new AuRedrawWidget(this._spreadsheet, sheetid, uuid));
    }

    public void invaliate() {
        for (WidgetCtrl ctrl : this._clientWidgets) {
            ctrl.getWidget().setInClient(false);
            this._nonClientWidgets.add(ctrl);
        }
        this._clientWidgets.clear();
    }

    private Ghost newGhost() {
        Ghost ghost = new Ghost();
        ghost.setAttribute("kkchildren", "");
        return ghost;
    }

    public List<Widget> getClientWidgets() {
        ArrayList<Widget> clientWidgets = new ArrayList<Widget>();
        for (WidgetCtrl ctrl : this._clientWidgets) {
            clientWidgets.add(ctrl.getWidget());
        }
        return clientWidgets;
    }
}

