/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractProtectedHandler;
import io.keikai.ui.impl.undo.CellStyleAction;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class TextRotationHandler
extends AbstractProtectedHandler {
    private static final long serialVersionUID = 5857878774051381278L;

    protected boolean processAction(UserActionContext ctx) {
        Integer orientation = Integer.parseInt((String)ctx.getData("orientation"));
        Sheet sheet = ctx.getSheet();
        AreaRef selection = ctx.getSelection();
        CellSelectionType type = ctx.getSelectionType();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)selection);
        if (range.isProtected()) {
            switch (type) {
                case ROW: {
                    if (range.getSheetProtection().isFormatRowsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
                case COLUMN: 
                case ALL: {
                    if (range.getSheetProtection().isFormatColumnsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
                case CELL: {
                    if (range.getSheetProtection().isFormatCellsAllowed()) break;
                    this.showProtectMessage();
                    return true;
                }
            }
        }
        switch (type) {
            case ROW: {
                range = range.toRowRange();
                break;
            }
            case COLUMN: {
                range = range.toColumnRange();
                break;
            }
            case ALL: {
                range = range.toColumnRange();
            }
        }
        selection = new AreaRef(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction((UndoableAction)new CellStyleAction(Labels.getLabel((String)"zss.undo.cellStyle"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), CellOperationUtil.getRotationApplier((short)orientation.shortValue())));
        return true;
    }
}

