/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.IllegalOpArgumentException;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.SheetOperationUtil;
import io.keikai.api.model.Sheet;
import io.keikai.model.InvalidModelOpException;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractSheetHandler;
import io.keikaiex.ui.dialog.PasswordCtrl;
import io.keikaiex.ui.dialog.ProtectSheetCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class ProtectSheetAction
extends AbstractSheetHandler {
    private static final long serialVersionUID = 3461410585095810994L;

    protected boolean processAction(UserActionContext ctx) {
        Sheet sheet = ctx.getSheet();
        final Range range = Ranges.range((Sheet)sheet);
        if (range.isSheetProtected()) {
            if (!SheetOperationUtil.unprotectSheet((Range)range, null)) {
                PasswordCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
                    private static final long serialVersionUID = -5447189387875752055L;

                    public void onEvent(DialogCallbackEvent event) throws Exception {
                        if (ProtectSheetCtrl.ON_OK.equals(event.getName())) {
                            try {
                                if (!SheetOperationUtil.unprotectSheet((Range)range, (String)((String)event.getData(ProtectSheetCtrl.ARG_PASSWORD)))) {
                                    ProtectSheetAction.this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.password_not_correct"));
                                }
                            }
                            catch (IllegalOpArgumentException x) {
                                ProtectSheetAction.this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_range_operation") + " : " + x.getMessage());
                            }
                            catch (InvalidModelOpException x) {
                                ProtectSheetAction.this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.illegal_range_operation") + " : " + x.getMessage());
                            }
                        }
                    }
                }, Labels.getLabel((String)"zssex.dlg.unprotectSheet.title"), Labels.getLabel((String)"zssex.dlg.unprotectSheet.hint"), "");
            }
        } else {
            ProtectSheetCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
                private static final long serialVersionUID = 2491792382934665898L;

                public void onEvent(DialogCallbackEvent event) throws Exception {
                    if (ProtectSheetCtrl.ON_OK.equals(event.getName())) {
                        Integer options = (Integer)event.getData(ProtectSheetCtrl.ARG_ALLOW_OPTIONS);
                        SheetOperationUtil.protectSheet((Range)range, (String)((String)event.getData(ProtectSheetCtrl.ARG_PASSWORD)), (boolean)ProtectSheetAction.this.isAllowed(options, 1024), (boolean)ProtectSheetAction.this.isAllowed(options, 16384), (boolean)ProtectSheetAction.this.isAllowed(options, 4), (boolean)ProtectSheetAction.this.isAllowed(options, 8), (boolean)ProtectSheetAction.this.isAllowed(options, 16), (boolean)ProtectSheetAction.this.isAllowed(options, 32), (boolean)ProtectSheetAction.this.isAllowed(options, 64), (boolean)ProtectSheetAction.this.isAllowed(options, 128), (boolean)ProtectSheetAction.this.isAllowed(options, 256), (boolean)ProtectSheetAction.this.isAllowed(options, 512), (boolean)ProtectSheetAction.this.isAllowed(options, 2048), (boolean)ProtectSheetAction.this.isAllowed(options, 4096), (boolean)ProtectSheetAction.this.isAllowed(options, 8192), (boolean)ProtectSheetAction.this.isAllowed(options, 1), (boolean)ProtectSheetAction.this.isAllowed(options, 2));
                    }
                }
            }, range.getSheetProtection());
        }
        return true;
    }

    protected boolean isAllowed(int options, int mask) {
        return (options & mask) != 0;
    }
}

