/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikaiex.ui.dialog.InsertHyperlinkCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class HyperlinkHandler
extends AbstractHandler {
    private static final long serialVersionUID = -1852968828824632170L;

    protected boolean processAction(UserActionContext ctx) {
        AreaRef selection;
        final Sheet sheet = ctx.getSheet();
        Range range = Ranges.range((Sheet)sheet, (int)(selection = ctx.getSelection()).getRow(), (int)selection.getColumn());
        if (range.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        Hyperlink link = range.getCellHyperlink();
        String display = link == null ? range.getCellFormatText() : link.getLabel();
        String address = link == null ? null : link.getAddress();
        Hyperlink.HyperlinkType type = link == null ? null : link.getType();
        InsertHyperlinkCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -3649564402999485961L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (InsertHyperlinkCtrl.ON_OK.equals(event.getName())) {
                    String label = (String)event.getData(InsertHyperlinkCtrl.ARG_DISPLAY);
                    String address = (String)event.getData(InsertHyperlinkCtrl.ARG_ADDRESS);
                    Hyperlink.HyperlinkType type = (Hyperlink.HyperlinkType)event.getData(InsertHyperlinkCtrl.ARG_LINKTYPE);
                    CellOperationUtil.applyHyperlink((Range)Ranges.range((Sheet)sheet, (AreaRef)selection), (Hyperlink.HyperlinkType)type, (String)address, (String)label);
                }
            }
        }, type, address, display, ctx.getSpreadsheet());
        return true;
    }

    public boolean isEnabled(Book book, Sheet sheet) {
        return book != null && sheet != null && (!sheet.isProtected() || Ranges.range((Sheet)sheet).getSheetProtection().isInsertHyperlinksAllowed());
    }
}

