/*
 * Decompiled with CFR 0.152.
 */
package io.keikaiex.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.Validation;
import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.SDataValidation;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.ZSMessagebox;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikaiex.ui.dialog.DataValidationCtrl;
import io.keikaiex.ui.dialog.FormatCellCtrl;
import io.keikaiex.ui.dialog.impl.DialogCallbackEvent;
import io.keikaiex.ui.impl.undo.DataValidationAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zkoss.util.resource.Labels;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.SerializableEventListener;

public class DataValidationHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = 1889483495942352074L;

    protected boolean processAction(final UserActionContext ctx) {
        final Sheet sheet = ctx.getSheet();
        final AreaRef selection = ctx.getSelection();
        Range range = Ranges.range((Sheet)sheet, (AreaRef)selection);
        final List validations = range.getValidations();
        this.validTableTotalRows(range);
        if (this.isOverlapped(range)) {
            String label = Labels.getLabel((String)"zssex.dlg.format.dataValidation.overlapMsg");
            ZSMessagebox.show((String)label, (String)"Keikai Spreadsheet", (int)3, (String)"z-messagebox-icon z-messagebox-information", (EventListener)new SerializableEventListener<Event>(){
                private static final long serialVersionUID = 2936000638773070248L;

                public void onEvent(Event event) throws Exception {
                    if (event.getData().equals(1)) {
                        DataValidationHandler.this.showValidationDialog(ctx, sheet, selection, validations);
                    }
                }
            });
        } else {
            this.showValidationDialog(ctx, sheet, selection, validations);
        }
        return true;
    }

    protected void validTableTotalRows(Range range) {
        int row1 = range.getRow();
        int row2 = range.getLastRow();
        int col1 = range.getColumn();
        int col2 = range.getLastColumn();
        SSheet sheet = range.getSheet().getInternalSheet();
        for (STable tb : sheet.getTables()) {
            if (tb.getTotalsRowCount() == 0) continue;
            CellRegion rgn = tb.getAllRegion().getRegion();
            int tc1 = rgn.getColumn();
            int tr2 = rgn.getLastRow();
            int tc2 = rgn.getLastColumn();
            if (tr2 < row1 || tr2 > row2 || tc2 < col1 || tc1 > col2) continue;
            throw new InvalidModelOpException("The operation cannot be applied on Table's totals row");
        }
    }

    protected boolean isOverlapped(Range range) {
        List validations = range.getInternalRange().getValidations();
        if (validations.size() >= 2) {
            return true;
        }
        if (validations.size() == 1) {
            Iterator validationIter = ((SDataValidation)validations.get(0)).getRegions().iterator();
            CellRegion cellRegion = new CellRegion(range.getRow(), range.getColumn(), range.getLastRow(), range.getLastColumn());
            ArrayList<CellRegion> remaining = new ArrayList<CellRegion>(2);
            remaining.add(cellRegion);
            while (validationIter.hasNext()) {
                CellRegion validationRegion = (CellRegion)validationIter.next();
                ArrayList tempRegion = new ArrayList(2);
                for (CellRegion remainingRegion : remaining) {
                    tempRegion.addAll(remainingRegion.diff(validationRegion.getOverlap(remainingRegion)));
                }
                remaining = tempRegion;
            }
            return remaining.size() > 0;
        }
        return false;
    }

    protected void showValidationDialog(final UserActionContext ctx, final Sheet sheet, final AreaRef selection, List<Validation> validations) {
        Validation validation = validations.size() > 0 ? validations.get(0) : null;
        DataValidationCtrl.show((EventListener<DialogCallbackEvent>)new SerializableEventListener<DialogCallbackEvent>(){
            private static final long serialVersionUID = -1058080304759009998L;

            public void onEvent(DialogCallbackEvent event) throws Exception {
                if (FormatCellCtrl.ON_OK.equals(event.getName())) {
                    Validation.ValidationType validationType = (Validation.ValidationType)event.getData(DataValidationCtrl.ARG_VALIDATION_TYPE_CODE);
                    Validation.OperatorType operatorType = (Validation.OperatorType)event.getData(DataValidationCtrl.ARG_OPERATOR_TYPE_CODE);
                    boolean ignoreBlank = (Boolean)event.getData(DataValidationCtrl.ARG_IGNORE_BLANK_CODE);
                    boolean inCellDropDown = (Boolean)event.getData(DataValidationCtrl.ARG_IN_CELL_DROPDOWN_CODE);
                    String param1 = (String)event.getData(DataValidationCtrl.ARG_PARAM1_CODE);
                    String param2 = (String)event.getData(DataValidationCtrl.ARG_PARAM2_CODE);
                    boolean isShowInput = (Boolean)event.getData(DataValidationCtrl.ARG_SHOW_INPUT_CODE);
                    String inputTitle = (String)event.getData(DataValidationCtrl.ARG_INPUT_TITLE_CODE);
                    String inputMessage = (String)event.getData(DataValidationCtrl.ARG_INPUT_MESSAGE_CODE);
                    boolean isShowError = (Boolean)event.getData(DataValidationCtrl.ARG_SHOW_ERROR_CODE);
                    Validation.AlertStyle alertStyle = (Validation.AlertStyle)event.getData(DataValidationCtrl.ARG_ALERT_STYLE_CODE);
                    String errorTitle = (String)event.getData(DataValidationCtrl.ARG_ERROR_TITLE_CODE);
                    String errorMessage = (String)event.getData(DataValidationCtrl.ARG_ERROR_MESSAGE_CODE);
                    UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
                    uam.doAction((UndoableAction)new DataValidationAction(Labels.getLabel((String)"zss.undo.insertComment"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), validationType, ignoreBlank, operatorType, inCellDropDown, param1, param2, isShowInput, inputTitle, inputMessage, isShowError, alertStyle, errorTitle, errorMessage));
                }
            }
        }, validation, ctx.getSpreadsheet());
    }
}

