import {ComponentElement} from '@plate/components/component-element';
import {HeaderFooterElement} from '@plate/components/header-footer-element';
import {HeadingElement} from '@plate/components/heading-element';
import {HighlightLeaf} from '@plate/components/highlight-leaf';
import {HrElement} from '@plate/components/hr-element';
import {MentionElement} from '@plate/components/mention-element';
import {ParagraphElement} from '@plate/components/paragraph-element';
import {RootElement} from '@plate/components/root-element';
import {SectionElement} from '@plate/components/section-element';
import {TableCellElement} from '@plate/components/table-cell-element';
import {TableElement} from '@plate/components/table-element';
import {TableRowElement} from '@plate/components/table-row-element';
import {ComponentPlugin} from '@plate/plugins/plate-component';
import {
    FooterPlugin,
    HeaderPlugin,
    PageBreakPlugin,
    PageNumberPlugin,
    RootPlugin,
    SectionPlugin
} from '@plate/plugins/plate-pagination';
import {withProps} from '@udecode/cn';
import {
    ItalicPlugin,
    StrikethroughPlugin,
    SubscriptPlugin,
    SuperscriptPlugin,
    UnderlinePlugin
} from '@udecode/plate-basic-marks/react';
import {NodeComponent, ParagraphPlugin, PlateElement, PlateLeaf} from '@udecode/plate-common/react';
import {HEADING_KEYS} from '@udecode/plate-heading';
import {HighlightPlugin} from '@udecode/plate-highlight/react';
import {HorizontalRulePlugin} from '@udecode/plate-horizontal-rule/react';
import {TableCellPlugin, TablePlugin, TableRowPlugin} from '@udecode/plate-table/react';

export const createPlateUI = (zclass: string): Record<string, NodeComponent> => {
    return {
        [ParagraphPlugin.key]: withProps(ParagraphElement, {className: `${zclass}-${ParagraphPlugin.key}`}),
        [HEADING_KEYS.h1]: withProps(HeadingElement, {variant: 'h1', className: `${zclass}-${HEADING_KEYS.h1}`}),
        [HEADING_KEYS.h2]: withProps(HeadingElement, {variant: 'h2', className: `${zclass}-${HEADING_KEYS.h2}`}),
        [HEADING_KEYS.h3]: withProps(HeadingElement, {variant: 'h3', className: `${zclass}-${HEADING_KEYS.h3}`}),
        [HEADING_KEYS.h4]: withProps(HeadingElement, {variant: 'h4', className: `${zclass}-${HEADING_KEYS.h4}`}),
        [HEADING_KEYS.h5]: withProps(HeadingElement, {variant: 'h5', className: `${zclass}-${HEADING_KEYS.h5}`}),
        [HEADING_KEYS.h6]: withProps(HeadingElement, {variant: 'h6', className: `${zclass}-${HEADING_KEYS.h6}`}),
        [TablePlugin.key]: withProps(TableElement, {className: `${zclass}-${TablePlugin.key}`}),
        [TableRowPlugin.key]: withProps(TableRowElement, {className: `${zclass}-${TableRowPlugin.key}`}),
        [TableCellPlugin.key]: withProps(TableCellElement, {className: `${zclass}-${TableCellPlugin.key}`}),
        [ComponentPlugin.key]: withProps(ComponentElement, {className: `${zclass}-${ComponentPlugin.key}`}),

        [RootPlugin.key]: withProps(RootElement, {className: `${zclass}-${RootPlugin.key}`}),
        [SectionPlugin.key]: withProps(SectionElement, {className: `${zclass}-${SectionPlugin.key}`}),
        [PageBreakPlugin.key]: withProps(PlateElement, {className: `${zclass}-${PageBreakPlugin.key}`}),
        [HeaderPlugin.key]: withProps(HeaderFooterElement, {className: `${zclass}-${HeaderPlugin.key}`}),
        [FooterPlugin.key]: withProps(HeaderFooterElement, {className: `${zclass}-${FooterPlugin.key}`}),
        [HorizontalRulePlugin.key]: withProps(HrElement, {className: `${zclass}-${HorizontalRulePlugin.key}`}),
        [PageNumberPlugin.key]: withProps(MentionElement, {className: `${zclass}-${PageNumberPlugin.key}`}),

        [ItalicPlugin.key]: withProps(PlateLeaf, {as: 'em', className: `${zclass}-${ItalicPlugin.key}`}),
        [StrikethroughPlugin.key]: withProps(PlateLeaf, {as: 's', className: `${zclass}-${StrikethroughPlugin.key}`}),
        [SubscriptPlugin.key]: withProps(PlateLeaf, {as: 'sub', className: `${zclass}-${SubscriptPlugin.key}`}),
        [SuperscriptPlugin.key]: withProps(PlateLeaf, {as: 'sup', className: `${zclass}-${SuperscriptPlugin.key}`}),
        [UnderlinePlugin.key]: withProps(PlateLeaf, {as: 'u', className: `${zclass}-${UnderlinePlugin.key}`}),
        [HighlightPlugin.key]: withProps(HighlightLeaf, {className: `${zclass}-${HighlightPlugin.key}`}),
    };
};
