import {ComponentPlugin} from '@plate/plugins/plate-component';
import {PaginationPlugin} from '@plate/plugins/plate-pagination';
import {AlignPlugin} from '@udecode/plate-alignment/react';
import {
    ItalicPlugin,
    StrikethroughPlugin,
    SubscriptPlugin,
    SuperscriptPlugin,
    UnderlinePlugin
} from '@udecode/plate-basic-marks/react';
import {ParagraphPlugin} from '@udecode/plate-common/react';
import {CsvPlugin} from '@udecode/plate-csv';
import {DocxPlugin} from '@udecode/plate-docx';
import {
    FontBackgroundColorPlugin,
    FontColorPlugin,
    FontFamilyPlugin,
    FontSizePlugin,
    FontWeightPlugin
} from '@udecode/plate-font/react';
import {HEADING_KEYS} from '@udecode/plate-heading';
import {HeadingPlugin} from '@udecode/plate-heading/react';
import {HighlightPlugin} from '@udecode/plate-highlight/react';
import {IndentPlugin} from '@udecode/plate-indent/react';
import {LineHeightPlugin} from '@udecode/plate-line-height/react';
import {MarkdownPlugin} from '@udecode/plate-markdown';
import {TablePlugin} from '@udecode/plate-table/react';

const PARAGRAPH_KEYS = [ParagraphPlugin.key,
    HEADING_KEYS.h1, HEADING_KEYS.h2, HEADING_KEYS.h3, HEADING_KEYS.h4, HEADING_KEYS.h5, HEADING_KEYS.h6];

export const plugins = [
    // Nodes
    ParagraphPlugin,
    HeadingPlugin,
    TablePlugin.configure({options: {enableMerging: true}}),
    ComponentPlugin,
    PaginationPlugin,

    // Paragraph Style
    AlignPlugin.configure({inject: {targetPlugins: PARAGRAPH_KEYS}}),
    IndentPlugin.configure({inject: {targetPlugins: PARAGRAPH_KEYS}}),
    LineHeightPlugin.configure({inject: {targetPlugins: PARAGRAPH_KEYS}}),

    // Marks
    ItalicPlugin,
    StrikethroughPlugin,
    SubscriptPlugin,
    SuperscriptPlugin,
    UnderlinePlugin,
    FontBackgroundColorPlugin,
    FontColorPlugin,
    FontFamilyPlugin,
    FontSizePlugin,
    FontWeightPlugin,
    HighlightPlugin,

    // Deserialization
    CsvPlugin,
    DocxPlugin,
    MarkdownPlugin,
];
